/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.github.os72.protocjar.Protoc;
import com.google.common.collect.Lists;
import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmDirective;
import com.neeve.adm.AdmDocumentation;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmFieldLookup;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModelElement;
import com.neeve.adm.AdmModelImport;
import com.neeve.adm.AdmPooledString;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmScopedType;
import com.neeve.adm.AdmSemanticType;
import com.neeve.adm.AdmType;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgBuildParameters;
import com.neeve.build.codegen.CgCodeSource;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlThrowable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class AdmModel
extends AdmModelElement {
    private static final ProductInfo PRODUCT_INFO = ManifestProductInfo.loadProductInfo((String)"nvx-rumi-adm");
    private static final String DIRECTIVE_ARGUMENT_CODE_SOURCE = "codeSource";
    private static final String APEX_STYLE = "apexStyle";
    private static final String DIRECTIVE_REWRITE_OUTPUT_MODEL_IMPORTS = "rewriteOutputModelImports";
    private static final boolean allowCircularReferences = XRuntime.getValue((String)"nv.adm.allowcircularrefs", (boolean)false);
    private static final Pattern JAVA_TYPE_IDENTIFIER_PATTERN = Pattern.compile("^([a-zA-Z_$][a-zA-Z\\d_$]*)$");
    private static final Pattern JAVA_MEMBER_IDENTIFIER_PATTERN = Pattern.compile("^([a-zA-Z_$][a-zA-Z\\d_$]*)$");
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
    private final File resolvedIdlTempDir;
    private final String namespace;
    private final String name;
    private final LinkedHashSet<AdmModelImport> imports;
    private final XLinkedHashMap<String, AdmModelImport> transitiveFieldImportModels;
    private final HashMap<String, AdmFactory> factories;
    private final HashMap<String, AdmEnumeration> enumerations;
    private final HashMap<String, AdmMessage> messages;
    private final HashMap<String, AdmSemanticType> semanticTypes;
    private final HashMap<String, AdmField> fields;
    private final HashMap<String, AdmEntity> entities;
    private final HashMap<String, AdmCollection> collections;
    private final HashMap<String, AdmPooledString> pooledStrings;
    private Filer filer;
    private List<File> externalProtoDirs;
    private File embeddedProtoDescriptor;
    private File admProtoDir;
    private File rogProtoDir;
    private String protobufOuterClassName;
    private File protobufIDLOutputDir;
    private boolean copyImportedProtos = false;
    private boolean useBundledProtoc = true;
    private String buildInfo;
    private AdmDocumentation documentation;
    private AdmFactory defaultFactory = null;
    private AdmEncodingType protoXbufGenCompatibility = AdmEncodingType.Protobuf;
    private AdmEntity.NullArrayElementPolicy nullEntityArrayFieldHandlingPolicy = AdmEntity.NullArrayElementPolicy.Ignore;
    private AdmEntity.NullArrayElementPolicy nullPrimitiveArrayFieldHandlingPolicy = AdmEntity.NullArrayElementPolicy.Throw;
    private boolean generateArrayGetterEmptyIfNull;
    private final CgBuildParameters directives = CgBuildParameters.newInstance().adoptParameters(DIRECTIVE_DEFINITIONS, null);
    private Document modelDocument;
    private URL documentURL;
    private CgSourceCodeErrorAggregator modelBuildErrorAggregator;
    static final HashSet<String> RESERVED_TYPE_NAMES = new HashSet();
    public static final String GENERATE_EMBEDDED_ENTITY_INTERFACES = "generateEmbeddedEntityInterfaces";
    public static final String GENERATE_EMBEDDED_ENTITIES_NON_FINAL = "generateEmbeddedEntitiesNonFinal";
    public static final String GENERATE_DEFAULT_GETTERS = "generateDefaultGetters";
    public static final String GENERATE_THROW_ON_UNSET_GETTERS = "generateThrowOnUnsetGetters";
    public static final String GENERATE_REQUIRED_FIELD_VALIDATORS = "generateRequiredFieldValidators";
    public static final String GENERATE_FLUENT_SETTERS = "generateFluentSetters";
    @Deprecated
    public static final String GENERATE_BUILDER_SETTERS = "generateBuilderSetters";
    public static final String GENERATE_FLUENT_INTERFACE_SETTERS = "generateBuilderInterfaceSetters";
    public static final String GENERATE_DEPRECATED_ACCESSORS = "generateDeprecatedAccessors";
    public static final String GENERATE_ALL_STRING_POOLABLE = "generateAllStringsPoolable";
    public static final String POOLED_STRING_FIELD_TYPE_NAME_SUFFIX_POLICY = "pooledStringFieldTypeNameSuffixPolicy";
    public static final String POOLED_STRING_FIELD_TYPE_NAME_SUFFIX = "pooledStringFieldTypeNameSuffix";
    public static final String NULL_ARRAY_ELEMENT_POLICY = "nullArrayElementPolicy";
    public static final String GENERATE_PROTOBUF_CLASSES = "generateProtobufClasses";
    public static final String DIRECTIVE_ENCODING_TYPE = "encodingType";
    public static final String DIRECTIVE_MODEL_BUNDLE_OUTPUT_DIR = "modelBundleOutputDir";
    public static final String DIRECTIVE_REQUIRE_EXPLICIT_COLLECTION_KEYS = "requireExplicitCollectionKeys";
    public static final String DIRECTIVE_ENABLE_TYPE_NAME_VALIDATION = "enableTypeNameValidation";
    public static final String DIRECTIVE_GENERATE_MESSAGE_FINALIZERS = "generateMessageFinalizers";
    public static final String DIRECTIVE_GENERATE_STATE_FINALIZERS = "generateStateFinalizers";
    public static final String DIRECTIVE_USE_IOBUFFER_FOR_MESSAGE_BACKING_STORAGE = "useIOBufferAsMessageBackingStorage";
    public static final String DIRECTIVE_USE_IOBUFFER_FOR_STATE_BACKING_STORAGE = "useIOBufferAsStateBackingStorage";
    public static final String DIRECTIVE_SERIALIZE_TO_DATA_PACKET = "serializeToDataPacket";
    public static final CgBuildParameters DIRECTIVE_DEFINITIONS = CgBuildParameters.newInstance().newParameter("apexStyle", "See APEX_STYLE for more details.", new Object[]{"true", "false"}, false, (Object)"false").putAdditionalData("hidden", (Object)"This directive is for internal use").putAdditionalData("transient", (Object)"This directive need not be persisted when saving model.").getParent().newParameter("generateEmbeddedEntityInterfaces", "Directive indicating that the generator should create interfaces for embedded entities.", new Object[]{"true", "false"}, false, (Object)"true").getParent().newParameter("generateEmbeddedEntitiesNonFinal", "Directive indicating that embedded entities should not be generated as final.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("generateDefaultGetters", "Directive indicating that default getters should be created.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("generateThrowOnUnsetGetters", "Directive indicating that a getXXXOrThrow method should be generated from which an ERogFieldNotSetException will be thrown if a call is made to a getter for which the hasXXX() counterpart returns false.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("generateRequiredFieldValidators", "Directive indicating that validator implementation should perform checks that required fields are set.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("generateFluentSetters".toString(), "Directive indicating that fluent setter should be generated.", new Object[]{"true", "false"}, false, (Object)"false").setAlias("generateBuilderSetters").getParent().newParameter("generateBuilderInterfaceSetters", "Directive indicating that builder styles setters should be generated.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("generateDeprecatedAccessors", "Directive indicating whether or not deprecated field accessors should be generated.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("generateAllStringsPoolable", "Directive indicating that all string fields should be generated as poolable types.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("pooledStringFieldTypeNameSuffixPolicy", "Directive indicating how to suffix pooled string types generated for String fields.", new Object[]{PooledStringFieldTypeNameSuffixPolicy.Always, PooledStringFieldTypeNameSuffixPolicy.OnConflict, PooledStringFieldTypeNameSuffixPolicy.None}, false, (Object)PooledStringFieldTypeNameSuffixPolicy.None).setArgumentValueConverter((CgBuildParameters.ArgumentValueConverter)new StringToPooledStringFieldTypeNameSuffixPolicyConverter()).getParent().newParameter("pooledStringFieldTypeNameSuffix", "Directive indicating the suffix to use for pooled string types generated from a String field's name.", new Class[]{String.class}, false, (Object)"String").getParent().newParameter("nullArrayElementPolicy", "Directive indicating how to handle null values passed into arrays for XBuf encoding.", new Object[]{AdmEntity.NullArrayElementPolicy.Throw, AdmEntity.NullArrayElementPolicy.Ignore, AdmEntity.NullArrayElementPolicy.IgnoreUnlessSupported}, false, null).setArgumentValueConverter((CgBuildParameters.ArgumentValueConverter)new StringToNullArrayElementPolicyConverter()).getParent().newParameter("generateProtobufClasses", "Directive indicating that the protobuf classes should be generated using the protoc code generator. This directive only applies to xbuf and xbuf2 encoding types.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("encodingType", "Encoding type to use when generating classes. Default is Xbuf.", new Object[]{AdmEncodingType.Xbuf, AdmEncodingType.Xbuf2, AdmEncodingType.Protobuf, AdmEncodingType.Json}, true, (Object)AdmEncodingType.Xbuf).setArgumentValueConverter(new CgBuildParameters.ArgumentValueConverter(){

        public Object convertValue(Object value) throws Exception {
            Object retVal = value;
            if (value != null && !(value instanceof AdmEncodingType)) {
                retVal = AdmEncodingType.valueOf(value.toString());
            }
            return retVal;
        }
    }).getParent().newParameter("modelBundleOutputDir", "Base output directory for outputting model and IDL file with all their dependencies.", new Class[]{File.class, String.class}, false, null).putAdditionalData("transient", (Object)"This directive need not be persisted when saving model.").setStringToFileConverter().getParent().newParameter("rewriteOutputModelImports", "Directive when set to true will rewrite import tags in output model XML to be full qualified classpath resource.", new Object[]{"true", "false"}, false, (Object)"true").putAdditionalData("hidden", (Object)"This directive is for internal use").putAdditionalData("transient", (Object)"This directive need not be persisted when saving model.").getParent().newParameter("requireExplicitCollectionKeys", "Directive indicating that map collection contained values must defined explicit isKey fields.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("generateMessageFinalizers", "Directive that determines whether to generate finalizers in generated message classes.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("generateStateFinalizers", "Directive that determines whether to generate finalizers in generated state classes.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("useIOBufferAsMessageBackingStorage", "Directive that determines whether to use direct native memory as the backing storage for generated message classes.", new Object[]{"true", "false"}, false, (Object)"true").getParent().newParameter("useIOBufferAsStateBackingStorage", "Directive that determines whether to use direct native memory as the backing storage for generated state classes.", new Object[]{"true", "false"}, false, (Object)"true").getParent().newParameter("serializeToDataPacket", "Directive that determines whether the to generate serializeToPacket such that it will serialize to a generic data packet.", new Object[]{"true", "false"}, false, (Object)"false").getParent().newParameter("enableTypeNameValidation", "Directive that enables type name validation to conform to Java Type Identifier Syntax.", new Object[]{"true", "false"}, false, (Object)"true").putAdditionalData("hidden", (Object)"This directive is for internal use").getParent();

    public AdmModel(String namespace, String name) {
        if (namespace == null) {
            throw new IllegalArgumentException("model namespace cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + name + "': Creating model (namespace=" + namespace + ")", Tracer.Level.DEBUG);
        }
        this.resolvedIdlTempDir = new File(System.getProperty("user.home") + File.separator + ".nvx" + File.separator + "1.9" + File.separator + "adm" + File.separator + "protoc" + File.separator + UUID.randomUUID().toString());
        this.namespace = namespace;
        this.name = name;
        this.imports = new LinkedHashSet();
        this.transitiveFieldImportModels = new XLinkedHashMap();
        this.factories = new HashMap();
        this.enumerations = new HashMap();
        this.messages = new HashMap();
        this.semanticTypes = new HashMap();
        this.fields = new HashMap();
        this.entities = new HashMap();
        this.collections = new HashMap();
        this.pooledStrings = new HashMap();
    }

    public AdmModel(String namespace, String name, Document modelDocument, URL documentURL, CgSourceCodeErrorAggregator modelBuildErrorAggregator) {
        this(namespace, name);
        this.modelDocument = modelDocument;
        this.documentURL = documentURL;
        this.modelBuildErrorAggregator = modelBuildErrorAggregator;
    }

    public AdmModel(String namespace) {
        this(namespace, null);
    }

    private final void setDirective(String key, Object value, CgCodeSource codeSource) {
        this.directives.newArgument(key, value).putAdditionalData(DIRECTIVE_ARGUMENT_CODE_SOURCE, (Object)codeSource);
    }

    private final boolean validateTypeNames(StringBuilder summary, CgSourceCodeErrorAggregator aggregator) {
        boolean valid = true;
        for (AdmFactory factory : this.factories.values()) {
            valid &= this.validateTypeName(factory.getName(), "factory name", factory, summary, aggregator);
        }
        for (AdmEnumeration enumeration : this.enumerations.values()) {
            valid &= this.validateTypeName(enumeration.getName(), "enum name", enumeration, summary, aggregator);
            for (AdmEnumeration.ConstEntry constEntry : enumeration.getConsts()) {
                valid &= this.validateTypeName(constEntry.getName(), "enum constant", constEntry, summary, aggregator);
            }
        }
        for (AdmField field : this.fields.values()) {
            valid &= this.validateFieldName(field, summary, aggregator);
        }
        for (AdmSemanticType semanticType : this.semanticTypes.values()) {
            valid &= this.validateTypeName(semanticType.getName(), "type name", semanticType, summary, aggregator);
        }
        for (AdmMessage message : this.messages.values()) {
            valid &= this.validateTypeName(message.getName(), "message name", message, summary, aggregator);
            for (AdmField field : message.getFields()) {
                valid &= this.validateFieldName(field, summary, aggregator);
            }
        }
        for (AdmEntity entity : this.entities.values()) {
            valid &= this.validateTypeName(entity.getName(), "entity name", entity, summary, aggregator);
            for (AdmField field : entity.getFields()) {
                valid &= this.validateFieldName(field, summary, aggregator);
            }
        }
        for (AdmCollection collection : this.collections.values()) {
            valid &= this.validateTypeName(collection.getName(), "collection name", collection, summary, aggregator);
        }
        return valid;
    }

    private final boolean validateTypeName(String typeName, String modelElementName, AdmModelElement modelElement, StringBuilder summary, CgSourceCodeErrorAggregator aggregator) {
        Matcher m = JAVA_TYPE_IDENTIFIER_PATTERN.matcher(typeName);
        boolean valid = m.matches();
        if (!valid) {
            summary.append("'").append(typeName).append("' is an invalid " + modelElementName + "; a valid java identifier is required. [");
            summary.append(modelElement.getCodeSource()).append("]\n");
            if (aggregator != null) {
                aggregator.add("'" + typeName + "' is an invalid " + modelElementName + "; a valid java identifier is required.", CgSourceCodeErrorAggregator.Severity.ERROR, modelElement.getCodeSource(), null);
            }
        }
        return valid;
    }

    private final boolean validateFieldName(AdmField field, StringBuilder summary, CgSourceCodeErrorAggregator aggregator) {
        Matcher m = JAVA_MEMBER_IDENTIFIER_PATTERN.matcher(field.getName());
        boolean valid = m.matches();
        if (!valid) {
            summary.append("'").append(field.getName()).append("' is an invalid field name; a valid java identifier is required. [");
            summary.append(field.getCodeSource()).append("]\n");
            if (aggregator != null) {
                aggregator.add("'" + field.getName() + "' is an invalid field name; a valid java identifier is required.", CgSourceCodeErrorAggregator.Severity.ERROR, field.getCodeSource(), null);
            }
        }
        return valid;
    }

    private final boolean checkImportsEncodingTypeCompatibility(StringBuilder summary, CgSourceCodeErrorAggregator aggregator) {
        boolean valid = true;
        AdmEncodingType thisEncodingType = (AdmEncodingType)((Object)this.directives.getValue(DIRECTIVE_ENCODING_TYPE));
        if (thisEncodingType != null) {
            for (AdmModelImport modelImport : this.imports) {
                AdmEncodingType importEncodingType;
                CgBuildParameters importDirectives = modelImport.getModel().directives;
                if (!importDirectives.getArguments().containsKey(DIRECTIVE_ENCODING_TYPE) || thisEncodingType == (importEncodingType = (AdmEncodingType)((Object)importDirectives.getValue(DIRECTIVE_ENCODING_TYPE)))) continue;
                StringBuilder sbMessage = new StringBuilder();
                sbMessage.append("Encoding type mismatch. Trying to import model with different encoding type:").append(" Expected ").append((Object)thisEncodingType).append(" but encountered ").append((Object)importEncodingType).append(" when importing ").append(modelImport.getModel().getFullName());
                summary.append("-").append((CharSequence)sbMessage).append("\n");
                if (aggregator == null) continue;
                aggregator.add(sbMessage.toString(), CgSourceCodeErrorAggregator.Severity.ERROR, modelImport.getCodeSource(), null);
                valid = false;
            }
        }
        return valid;
    }

    private final boolean checkForCycles(AdmEntity entity, HashSet<AdmType> alreadyChecked, StringBuilder summary, CgSourceCodeErrorAggregator aggregator) {
        return this.checkForCycles(entity, new HashSet<AdmType>(), new Stack<AdmField>(), alreadyChecked, summary, aggregator);
    }

    private final boolean checkForCycles(AdmEntity entity, HashSet<AdmType> typesInPath, Stack<AdmField> referenceStack, HashSet<AdmType> alreadyChecked, StringBuilder summary, CgSourceCodeErrorAggregator aggregator) {
        boolean cycleDetected = false;
        Iterator<AdmField> fieldIterator = entity.fields().values().iterator();
        typesInPath.add(entity);
        alreadyChecked.add(entity);
        block0: while (fieldIterator.hasNext()) {
            AdmField field = fieldIterator.next();
            if (!(field.getType() instanceof AdmEntity)) continue;
            if (typesInPath.contains((Object)field.getType())) {
                if (((Object)((Object)entity)).equals((Object)field.getType())) {
                    summary.append("-").append(field).append(" is a self reference");
                    summary.append(" [").append(field.getCodeSource()).append("]\n");
                    if (aggregator != null) {
                        aggregator.add(field + " is a self reference", CgSourceCodeErrorAggregator.Severity.ERROR, field.getCodeSource(), null);
                    }
                    cycleDetected = true;
                }
                for (AdmField ancestor : referenceStack) {
                    if (!((Object)((Object)ancestor.getType())).equals((Object)field.getType())) continue;
                    summary.append("-");
                    Iterator fi = referenceStack.subList(referenceStack.indexOf(ancestor), referenceStack.size()).iterator();
                    while (fi.hasNext()) {
                        summary.append(fi.next()).append("->");
                    }
                    summary.append(field);
                    summary.append(" [").append(field.getCodeSource()).append("]\n");
                    if (aggregator != null) {
                        fi = referenceStack.subList(referenceStack.indexOf(ancestor), referenceStack.size()).iterator();
                        String error = "Cycle Detected: ";
                        while (fi.hasNext()) {
                            error = error + fi.next() + "->";
                        }
                        error = error + field;
                        aggregator.add(error, CgSourceCodeErrorAggregator.Severity.ERROR, field.getCodeSource(), null);
                    }
                    cycleDetected = true;
                    continue block0;
                }
                continue;
            }
            if (alreadyChecked.contains((Object)field.getType())) continue;
            referenceStack.push(field);
            cycleDetected |= this.checkForCycles((AdmEntity)field.getType(), typesInPath, referenceStack, alreadyChecked, summary, aggregator);
            referenceStack.pop();
        }
        return cycleDetected;
    }

    private final void addTransitiveFieldTypeImports(AdmScopedType type) {
        if (type instanceof AdmEntity) {
            for (AdmField field : ((AdmEntity)type).fields().values()) {
                this.addTransitiveTypeImport(field.getType());
            }
        }
    }

    private final void addTransitiveTypeImport(AdmType type) {
        if ((type instanceof AdmScopedType || type instanceof AdmCollection) && type.getModel() != this) {
            this.transitiveFieldImportModels.put((Object)type.getModel().getFullName(), (Object)new AdmModelImport(this, type.getModel()));
        }
    }

    private final AdmFieldLookup lookupField(String fullName, boolean localOnly, AdmFieldLookup currentLookup) throws EAdmException {
        if (fullName == null) {
            throw new IllegalArgumentException("'fullName' cannot be null");
        }
        AdmFieldLookup lookup = currentLookup;
        if (lookup == null) {
            lookup = new AdmFieldLookup();
        }
        AdmField result = null;
        boolean fullQualifiedName = this.namespaceFromFullName(fullName) != null;
        boolean found = false;
        if (this.isOf(fullName) && (result = this.fields.get(this.nameFromFullName(fullName))) != null) {
            lookup.setField(result);
            found = true;
        }
        if (!(found || localOnly && !fullQualifiedName)) {
            for (AdmModelImport modelImport : this.imports) {
                if (found) {
                    AdmFieldLookup ambiguousResult = modelImport.getModel().lookupField(fullName, false);
                    if (ambiguousResult == null || lookup.getField() == ambiguousResult.getField() || ambiguousResult.getField().getModel().getFullName().equals(lookup.getField().getModel().getFullName())) continue;
                    throw new EAdmException("Ambiguous field name resolution " + fullName + " found in: " + lookup.getField().getModel().getFullName() + ", " + ambiguousResult.getField().getModel().getFullName());
                }
                modelImport.getModel().lookupField(fullName, false, lookup);
                if (lookup.getField() == null) continue;
                lookup.getImportPath().addFirst(modelImport);
                if (fullQualifiedName) break;
                found = true;
            }
        }
        if (lookup.getField() == null) {
            return null;
        }
        return lookup;
    }

    private final File generateOrResolveProtobufIDL(AdmEncodingType encodingType, File outdir, File importedIdlOutputFolder, File modelBundleOutputDirectory, boolean absolute, boolean skipExisting, boolean skipResolve) throws Exception {
        String idlFilename = this.getProtobufOuterClassName() + ".proto";
        File idlFile = null;
        try {
            Object target;
            if (!skipResolve) {
                idlFile = this.resolveImportedIdl(this.getNamespace(), this.getProtobufOuterClassName(), outdir, importedIdlOutputFolder);
            }
            if (idlFile == null || !skipExisting) {
                idlFile = this.generateProtobufIDL(encodingType, outdir, importedIdlOutputFolder, modelBundleOutputDirectory, absolute);
            } else if (modelBundleOutputDirectory != null && (encodingType == AdmEncodingType.Protobuf || encodingType == AdmEncodingType.Xbuf2 || encodingType == AdmEncodingType.Xbuf && this.protoXbufGenCompatibility == AdmEncodingType.Protobuf) && !((File)(target = UtlFile.newFileWithNamespace((File)modelBundleOutputDirectory, (String)this.getNamespace(), (String)(this.getProtobufOuterClassName() + ".proto")))).exists()) {
                if (!((File)target).getParentFile().exists()) {
                    ((File)target).getParentFile().mkdirs();
                }
                UtlFile.copyFile((File)idlFile, (File)target);
            }
            for (AdmModelImport modelImport : this.imports) {
                modelImport.getModel().generateOrResolveProtobufIDL(encodingType, outdir, importedIdlOutputFolder, modelBundleOutputDirectory, absolute, true, false);
            }
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create protobuf IDL file '" + idlFilename + "' [" + e.toString() + "]", e);
        }
        return idlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File generateProtobufIDL(AdmEncodingType encodingType, File outdir, File importedIdlOutputFolder, File modelBundleOutputDirectory, boolean absolute) throws Exception {
        File file;
        File idlFile;
        String idlFilename;
        block21: {
            File target;
            block22: {
                PrintWriter writer = null;
                idlFilename = this.getProtobufOuterClassName() + ".proto";
                idlFile = null;
                String idlOutputDir = absolute ? outdir.getAbsolutePath() : outdir + File.separator + this.getNamespace().replace(".", File.separator);
                String idlFullFilename = idlOutputDir + File.separator + idlFilename;
                idlFile = new File(idlFullFilename);
                if (!idlFile.exists()) {
                    idlFile.getParentFile().mkdirs();
                    idlFile.createNewFile();
                }
                writer = new PrintWriter(idlFullFilename);
                try {
                    writer.println("// *******************************************************************");
                    writer.println("// *** THIS FILE WAS GENERATED BY X PLATFORM CODE GENERATION TOOLS ***");
                    writer.println("// *** ON " + String.format("%-56s", dateFormat.format(new Date())) + "***");
                    writer.println("// *******************************************************************");
                    if (this.namespace != null) {
                        writer.println("package " + this.namespace + ";");
                    }
                    if (this.imports.size() > 0) {
                        String importPath;
                        AdmModel importedModel;
                        HashSet<String> included = new HashSet<String>();
                        writer.println("");
                        for (AdmModelImport modelImport : this.imports) {
                            importedModel = modelImport.getModel();
                            importPath = importedModel.getNamespace().replace(".", "/") + "/" + importedModel.getProtobufOuterClassName();
                            included.add(importPath);
                            if (this.tracer.debug) {
                                this.tracer.log("Adding import idl " + importPath, Tracer.Level.DEBUG);
                            }
                            writer.println("import \"" + importPath + ".proto\";");
                        }
                        for (AdmModelImport modelImport : this.transitiveFieldImportModels.values()) {
                            importedModel = modelImport.getModel();
                            importPath = importedModel.getNamespace().replace(".", "/") + "/" + importedModel.getProtobufOuterClassName();
                            if (!included.contains(importPath)) {
                                if (this.tracer.debug) {
                                    this.tracer.log("Adding transitively imported idl " + importPath, Tracer.Level.INFO);
                                }
                                writer.println("import \"" + importPath + ".proto\";");
                                continue;
                            }
                            if (!this.tracer.debug) continue;
                            this.tracer.log("Skipping transitively imported idl " + importPath + " (already declared)", Tracer.Level.INFO);
                        }
                    }
                    writer.println("import \"com/neeve/adm/types/protobuf/AdmTypes.proto\";");
                    Iterator<AdmEnumeration> enumIterator = this.enumerations.values().iterator();
                    while (enumIterator.hasNext()) {
                        writer.println("");
                        enumIterator.next().generateProtobufIDL(writer);
                    }
                    Iterator<AdmMessage> messageIterator = this.messages.values().iterator();
                    while (messageIterator.hasNext()) {
                        writer.println("");
                        messageIterator.next().generateProtobufIDL(writer, encodingType, this.protoXbufGenCompatibility);
                    }
                    Iterator<AdmEntity> entityIterator = this.entities.values().iterator();
                    while (entityIterator.hasNext()) {
                        writer.println("");
                        entityIterator.next().generateProtobufIDL(writer, encodingType, this.protoXbufGenCompatibility);
                    }
                    Iterator<AdmCollection> collIterator = this.collections.values().iterator();
                    while (collIterator.hasNext()) {
                        writer.println("");
                        collIterator.next().generateProtobufIDL(writer, encodingType);
                    }
                    file = idlFile;
                    writer.close();
                    if (this.protobufIDLOutputDir == null) break block21;
                    target = new File(this.protobufIDLOutputDir + File.separator + this.getNamespace().replace(".", File.separator), idlFile.getName());
                    if (target.getParentFile().exists()) break block22;
                    target.getParentFile().mkdirs();
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                        if (this.protobufIDLOutputDir != null) {
                            File target2 = new File(this.protobufIDLOutputDir + File.separator + this.getNamespace().replace(".", File.separator), idlFile.getName());
                            if (!target2.getParentFile().exists()) {
                                target2.getParentFile().mkdirs();
                            }
                            UtlFile.copyFile((File)idlFile, (File)target2);
                        }
                        if (modelBundleOutputDirectory != null && (encodingType == AdmEncodingType.Protobuf || encodingType == AdmEncodingType.Xbuf2 || encodingType == AdmEncodingType.Xbuf && this.protoXbufGenCompatibility == AdmEncodingType.Protobuf)) {
                            UtlFile.copyFileWithNamespaceToDirectory((File)idlFile, (File)modelBundleOutputDirectory, (String)this.getNamespace(), (String)idlFilename);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new EAdmException("Failed to create protobuf IDL file '" + idlFilename + "' [" + e.toString() + "]", e);
                    }
                }
            }
            UtlFile.copyFile((File)idlFile, (File)target);
        }
        if (modelBundleOutputDirectory != null && (encodingType == AdmEncodingType.Protobuf || encodingType == AdmEncodingType.Xbuf2 || encodingType == AdmEncodingType.Xbuf && this.protoXbufGenCompatibility == AdmEncodingType.Protobuf)) {
            UtlFile.copyFileWithNamespaceToDirectory((File)idlFile, (File)modelBundleOutputDirectory, (String)this.getNamespace(), (String)idlFilename);
        }
        return file;
    }

    private final Collection<File> recursivelyResolveImportIdl(AdmModel model, File outDir, File targetDir, Set<String> alreadyResolved) throws Exception {
        HashSet<File> rc = new HashSet<File>();
        this.tracer.log("Resolving imported idl for " + model.getNamespace().replace('.', '/') + "/" + model.getProtobufOuterClassName() + ".proto", Tracer.Level.DEBUG);
        File proto = this.resolveImportedIdl(model.getNamespace(), model.getProtobufOuterClassName(), outDir, targetDir);
        if (proto != null) {
            File importBaseDir = model.getBaseDirFromAbsolute(proto.getParentFile());
            this.tracer.log("Resolved '" + proto + "' base: '" + importBaseDir + "'", Tracer.Level.DEBUG);
            rc.add(importBaseDir);
            if (alreadyResolved == null) {
                alreadyResolved = new HashSet<String>();
            }
            rc.addAll(this.recursivelyResolveRawImportedIdl(proto, outDir, targetDir, alreadyResolved));
        } else {
            System.err.println("WARN: Couldn't find imported protobuf file: " + model.getNamespace().replace('.', '/') + "/" + model.getProtobufOuterClassName() + ".proto");
        }
        return rc;
    }

    private final Collection<File> recursivelyResolveRawImportedIdl(File protoImport, File outDir, File targetDir, Set<String> alreadyResolved) {
        HashSet<File> rc = new HashSet<File>();
        if (alreadyResolved == null) {
            alreadyResolved = new HashSet<String>();
        }
        IdlParser parsed = null;
        try {
            parsed = new IdlParser(protoImport);
            if (alreadyResolved.contains(parsed.qualifiedName)) {
                return rc;
            }
            alreadyResolved.add(parsed.qualifiedName);
            File importBaseDir = this.getBaseDirFromResourceDirectory(parsed.packageName, protoImport.getParentFile());
            this.tracer.log("Resolved raw imported idl from '" + protoImport + "' base: '" + importBaseDir + "'", Tracer.Level.DEBUG);
            rc.add(importBaseDir);
        }
        catch (Throwable thrown) {
            this.tracer.log("Failed to parse imported proto for " + protoImport + ": " + thrown.getMessage() + " " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
            return rc;
        }
        for (String nestedImport : parsed.imports) {
            if (nestedImport == null || nestedImport.startsWith("com/neeve/adm/types/protobuf/AdmTypes") || nestedImport.startsWith("google/protobuf/descriptor")) continue;
            int packageDelim = nestedImport.lastIndexOf("/");
            String importNamespace = "";
            String importModelName = "";
            if (packageDelim >= 0) {
                importNamespace = nestedImport.substring(0, packageDelim);
                importModelName = nestedImport.substring(packageDelim + 1);
                if (importModelName.endsWith(".proto")) {
                    importModelName = importModelName.substring(0, importModelName.length() - 6);
                }
            } else {
                importModelName = nestedImport;
            }
            try {
                File nestedProto = this.resolveImportedIdl(importNamespace, importModelName, outDir, targetDir);
                if (nestedProto != null) {
                    rc.addAll(this.recursivelyResolveRawImportedIdl(nestedProto, outDir, targetDir, alreadyResolved));
                    continue;
                }
                this.tracer.log("Failed to resolve raw imported idl from '" + nestedImport + "'", Tracer.Level.WARNING);
            }
            catch (Exception e) {
                this.tracer.log("Failed to resolved nested raw import proto '" + nestedImport + "': " + e.getMessage() + " " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File resolveImportedIdl(String namespace, String protobufOuterClassName, File outDir, File resolveDir) throws Exception {
        File resolved;
        String protoResourcePath;
        block39: {
            protoResourcePath = namespace.replace('.', '/') + "/" + protobufOuterClassName + ".proto";
            if (this.tracer.debug) {
                this.tracer.log("Resolving protobuf idl: " + protoResourcePath, Tracer.Level.DEBUG);
            }
            resolved = null;
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(protoResourcePath);
            if (url == null) {
                url = Thread.currentThread().getContextClassLoader().getResource(protoResourcePath);
            }
            if (url == null && this.externalProtoDirs != null) {
                for (File file : this.externalProtoDirs) {
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("External protodir '" + file + "' is not a directory");
                    }
                    resolved = new File(file, protoResourcePath);
                    if (resolved.exists()) continue;
                    resolved = null;
                }
            }
            if (resolved == null && url == null && this.filer != null) {
                FileObject proto = null;
                for (StandardLocation location : new StandardLocation[]{StandardLocation.SOURCE_PATH, StandardLocation.CLASS_PATH, StandardLocation.CLASS_OUTPUT}) {
                    if (resolved != null || url != null) break;
                    try {
                        proto = this.filer.getResource(location, namespace, protobufOuterClassName + ".proto");
                        if (proto == null) continue;
                        if (!(proto.toUri().isAbsolute() && !proto.toUri().getScheme().equals("file") || (resolved = AdmModel.toFile(proto)).exists())) {
                            resolved = null;
                            continue;
                        }
                        url = proto.toUri().toURL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (resolved == null && url == null && this.resolvedIdlTempDir.exists() && this.resolvedIdlTempDir.isDirectory() && !(resolved = new File(this.resolvedIdlTempDir, protoResourcePath)).exists()) {
                resolved = null;
            }
            if (outDir != null && resolved == null && url == null && !(resolved = new File(outDir, protoResourcePath)).exists()) {
                resolved = null;
            }
            if (url != null) {
                if (this.tracer.debug) {
                    this.tracer.log("Resolved protobuf idl: " + url, Tracer.Level.DEBUG);
                }
                if (!url.toURI().toString().contains(".jar!") && url.toURI().getScheme().equals("file")) {
                    resolved = new File(url.toURI());
                    if (!resolved.exists()) {
                        resolved = null;
                    }
                } else {
                    if (this.tracer.debug) {
                        this.tracer.log("Extracting protobuf idl: " + url + " to " + resolveDir, Tracer.Level.DEBUG);
                    }
                    if (resolveDir != null) {
                        resolved = new File(resolveDir, protoResourcePath);
                        try {
                            URLConnection c = url.openConnection();
                            long l = c.getLastModified();
                            boolean extract = true;
                            if (!resolved.exists()) {
                                resolved.getParentFile().mkdirs();
                                resolved.createNewFile();
                            } else {
                                if (this.tracer.debug) {
                                    this.tracer.log("Source idl last modified : " + new Date(l), Tracer.Level.DEBUG);
                                }
                                if (this.tracer.debug) {
                                    this.tracer.log("Target idl last modified : " + new Date(resolved.lastModified()), Tracer.Level.DEBUG);
                                }
                                if (resolved.lastModified() < l) {
                                    if (this.tracer.debug) {
                                        this.tracer.log("Overwriting stale idl " + resolved.toString() + "(" + new Date(resolved.lastModified()) + " older than " + new Date(l), Tracer.Level.DEBUG);
                                    }
                                    resolved.delete();
                                    for (int i = 0; resolved.exists() && i < 5; ++i) {
                                        Thread.sleep(1000L);
                                        resolved.delete();
                                    }
                                    resolved.createNewFile();
                                } else {
                                    extract = false;
                                }
                            }
                            if (!extract) break block39;
                            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(resolved));
                                 BufferedInputStream bis = new BufferedInputStream(url.openStream());){
                                int b;
                                while ((b = bis.read()) != -1) {
                                    bos.write(b);
                                }
                                bos.flush();
                            }
                            resolved.setLastModified(l);
                        }
                        catch (IOException ioe) {
                            throw new Exception("There was an error extracting proto file '" + url + "': " + ioe.getMessage(), ioe);
                        }
                    }
                }
            }
        }
        if (resolved == null) {
            this.tracer.log("Failed to resolve protobuf idl: " + protoResourcePath, Tracer.Level.WARNING);
        } else if (this.tracer.debug) {
            this.tracer.log("Resolved " + resolved, Tracer.Level.DEBUG);
        }
        return resolved;
    }

    private final File getBaseDirFromAbsolute(File outdir) throws EAdmException {
        return this.getBaseDirFromResourceDirectory(this.getNamespace(), outdir);
    }

    private final File getBaseDirFromResourceDirectory(String namespace, File directory) throws EAdmException {
        File baseDir = directory.getAbsoluteFile();
        StringTokenizer tok = new StringTokenizer(namespace, ".");
        int packageLevels = tok.countTokens();
        if (!baseDir.getAbsolutePath().endsWith(namespace.replace('.', File.separatorChar))) {
            throw new EAdmException("Output directory does not match namespace: " + baseDir + " doesn't correspond to " + namespace);
        }
        for (int i = 0; i < packageLevels; ++i) {
            baseDir = baseDir.getParentFile();
        }
        return baseDir;
    }

    private final ProtobufIDLGenerationInfo doProtobufIDLGeneration(AdmEncodingType encodingType, File outdir, boolean absolute) throws Exception {
        ProtobufIDLGenerationInfo ret = new ProtobufIDLGenerationInfo();
        ret.importedIdlOutputFolder = outdir;
        if (!this.copyImportedProtos) {
            File tempFile = File.createTempFile("admtemp", Long.toString(System.nanoTime()));
            tempFile.deleteOnExit();
            tempFile.delete();
            ret.importIdlTempFolder = new File(tempFile.getParentFile(), "adm" + Long.toString(System.nanoTime()));
            if (!ret.importIdlTempFolder.mkdirs()) {
                this.tracer.log("Failed to create temporary idl output folder: " + ret.importIdlTempFolder, Tracer.Level.WARNING);
            } else {
                ret.importedIdlOutputFolder = ret.importIdlTempFolder;
            }
        }
        File modelBundleOutputDirectory = (File)this.directives.getValue(DIRECTIVE_MODEL_BUNDLE_OUTPUT_DIR);
        ret.idlFullFilename = this.generateOrResolveProtobufIDL(encodingType, outdir, ret.importedIdlOutputFolder, modelBundleOutputDirectory, absolute, false, true).getAbsolutePath();
        return ret;
    }

    private final void resolveAndBundleCommonIDLFiles(File outDir) throws Exception {
        File modelBundleOutputDirectory = (File)this.directives.getValue(DIRECTIVE_MODEL_BUNDLE_OUTPUT_DIR);
        AdmEncodingType encodingType = (AdmEncodingType)((Object)this.directives.getValue(DIRECTIVE_ENCODING_TYPE));
        if (encodingType == AdmEncodingType.Xbuf && this.protoXbufGenCompatibility != AdmEncodingType.Protobuf) {
            return;
        }
        File googleDescriptorIDLFile = null;
        if (this.embeddedProtoDescriptor == null) {
            googleDescriptorIDLFile = this.resolveImportedIdl("google.protobuf", "descriptor", outDir, this.resolvedIdlTempDir);
            if (googleDescriptorIDLFile != null) {
                this.embeddedProtoDescriptor = this.getBaseDirFromResourceDirectory("google.protobuf", googleDescriptorIDLFile.getParentFile());
            } else {
                throw new Exception("Failed to resolve google.protobuf.descripto.proto");
            }
        }
        File admTypesProtoIDLFile = null;
        if (this.admProtoDir == null) {
            admTypesProtoIDLFile = this.resolveImportedIdl("com.neeve.adm.types.protobuf", "AdmTypes", outDir, this.resolvedIdlTempDir);
            if (admTypesProtoIDLFile != null) {
                this.admProtoDir = this.getBaseDirFromResourceDirectory("com.neeve.adm.types.protobuf", admTypesProtoIDLFile.getParentFile());
            } else {
                throw new Exception("Failed to resolve com.neeve.adm.types.protobuf.AdmTypes.proto");
            }
        }
        if (modelBundleOutputDirectory != null && (encodingType == AdmEncodingType.Protobuf || encodingType == AdmEncodingType.Xbuf2 || encodingType == AdmEncodingType.Xbuf && this.protoXbufGenCompatibility == AdmEncodingType.Protobuf)) {
            File admTypesTargetIDL;
            File descriptorTargetIDL = UtlFile.newFileWithNamespace((File)modelBundleOutputDirectory, (String)"google.protobuf", (String)"descriptor.proto");
            if (!descriptorTargetIDL.exists()) {
                if (!descriptorTargetIDL.getParentFile().exists()) {
                    descriptorTargetIDL.getParentFile().mkdirs();
                }
                UtlFile.copyFile((File)googleDescriptorIDLFile, (File)descriptorTargetIDL);
            }
            if (!(admTypesTargetIDL = UtlFile.newFileWithNamespace((File)modelBundleOutputDirectory, (String)"com.neeve.adm.types.protobuf", (String)"AdmTypes.proto")).exists()) {
                if (!admTypesTargetIDL.getParentFile().exists()) {
                    admTypesTargetIDL.getParentFile().mkdirs();
                }
                UtlFile.copyFile((File)admTypesProtoIDLFile, (File)admTypesTargetIDL);
            }
        }
    }

    private final void doProtobufGeneration(File baseDir, File outDir, boolean absolute) throws Exception {
        boolean useBundledProtoc;
        File resolved;
        this.resolveAndBundleCommonIDLFiles(outDir);
        if (this.embeddedProtoDescriptor == null) {
            resolved = this.resolveImportedIdl("google.protobuf", "descriptor", outDir, this.resolvedIdlTempDir);
            if (resolved != null) {
                this.embeddedProtoDescriptor = this.getBaseDirFromResourceDirectory("google.protobuf", resolved.getParentFile());
            } else {
                throw new Exception("Failed to resolve google.protobuf.descripto.proto");
            }
        }
        if (this.admProtoDir == null) {
            resolved = this.resolveImportedIdl("com.neeve.adm.types.protobuf", "AdmTypes", outDir, this.resolvedIdlTempDir);
            if (resolved != null) {
                this.admProtoDir = this.getBaseDirFromResourceDirectory("com.neeve.adm.types.protobuf", resolved.getParentFile());
            } else {
                throw new Exception("Failed to resolve com.neeve.adm.types.protobuf.AdmTypes.proto");
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Generating protobuf IDL to '" + outDir.getAbsolutePath() + "...", Tracer.Level.DEBUG);
        }
        ProtobufIDLGenerationInfo idlGenerationInfo = this.doProtobufIDLGeneration(AdmEncodingType.Protobuf, outDir, absolute);
        File importIdlTempFolder = idlGenerationInfo.importIdlTempFolder;
        File importedIdlOutputFolder = idlGenerationInfo.importedIdlOutputFolder;
        String idlFullFilename = idlGenerationInfo.idlFullFilename;
        LinkedList<String> command = new LinkedList<String>();
        boolean bl = useBundledProtoc = this.useBundledProtoc && XRuntime.getProps().getProperty("nvx.adm.codegen.protoc.path") == null;
        if (!useBundledProtoc) {
            String protocPath = XRuntime.getProps().getProperty("nvx.adm.codegen.protoc.path", null);
            command.add(protocPath == null ? "protoc" : protocPath + File.separator + "protoc");
        }
        command.add("--java_out=" + outDir.getAbsolutePath());
        HashSet<File> pathFiles = new HashSet<File>();
        if (absolute) {
            File absOutDir = new File(idlFullFilename).getParentFile();
            command.add("--proto_path=" + absOutDir.getAbsolutePath());
            pathFiles.add(absOutDir);
        }
        if (!pathFiles.contains(baseDir)) {
            command.add("--proto_path=" + baseDir.getAbsolutePath());
            pathFiles.add(baseDir);
        }
        if (!this.imports.isEmpty()) {
            HashSet alreadyResolved = new HashSet();
            for (AdmModelImport modelImport : this.imports) {
                for (File importDir : this.recursivelyResolveImportIdl(modelImport.getModel(), outDir, importedIdlOutputFolder, alreadyResolved)) {
                    if (pathFiles.contains(importDir)) continue;
                    command.add("--proto_path=" + importDir);
                    pathFiles.add(importDir);
                }
            }
        }
        if (this.externalProtoDirs != null) {
            for (File file : this.externalProtoDirs) {
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("External protodir '" + file + "' is not a directory");
                }
                if (pathFiles.contains(file)) continue;
                command.add("--proto_path=" + file.getAbsolutePath());
                pathFiles.add(file);
            }
        }
        if (this.embeddedProtoDescriptor != null && !pathFiles.contains(this.embeddedProtoDescriptor)) {
            command.add("--proto_path=" + this.embeddedProtoDescriptor.getAbsolutePath());
            pathFiles.add(this.embeddedProtoDescriptor);
        }
        if (this.admProtoDir != null && !pathFiles.contains(this.admProtoDir)) {
            command.add("--proto_path=" + this.admProtoDir.getAbsolutePath());
            pathFiles.add(this.admProtoDir);
        }
        if (this.rogProtoDir != null && !pathFiles.contains(this.rogProtoDir)) {
            command.add("--proto_path=" + this.rogProtoDir.getAbsolutePath());
            pathFiles.add(this.rogProtoDir);
        }
        command.add(idlFullFilename);
        if (this.tracer.debug) {
            StringBuilder protocCommand = new StringBuilder();
            for (String str : command) {
                protocCommand.append(str).append(" ");
            }
        }
        if (!useBundledProtoc) {
            String line;
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if (!this.tracer.debug) continue;
                this.tracer.log("[protoc output]" + line, Tracer.Level.DEBUG);
            }
        } else {
            int exitCode = Protoc.runProtoc((String[])command.toArray(new String[0]));
            if (exitCode != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String str : command) {
                    stringBuilder.append(str).append(" ");
                }
                this.tracer.log("protoc generation returned with error code " + exitCode + ". Command issued was:\n" + stringBuilder, Tracer.Level.SEVERE);
                if (this.modelBuildErrorAggregator != null) {
                    this.modelBuildErrorAggregator.add("protoc generation returned with error code " + exitCode + ". Command issued was:\n" + stringBuilder, CgSourceCodeErrorAggregator.Severity.ERROR, this.getCodeSource(), null);
                }
            }
        }
        if (absolute && this.namespace != null) {
            String idlName = this.getProtobufOuterClassName();
            File file = AdmModel.resolveAbsoluteClassFile(outDir, this.getNamespace(), idlName);
            UtlFile.copyFile((File)file, (File)AdmModel.resolveAbsoluteClassFile(outDir, null, idlName));
            file.delete();
        }
        if (importIdlTempFolder != null && importIdlTempFolder.exists()) {
            UtlFile.deleteDirectory((File)importIdlTempFolder);
        }
    }

    private final void generateProtobufClasses(File outdir, boolean absolute, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull) throws Exception {
        this.doProtobufGeneration(absolute ? this.getBaseDirFromAbsolute(outdir) : outdir, outdir, absolute);
        this.tracer.log("Generating class files (protobuf) to '" + outdir.getAbsolutePath() + "' (absolute=" + absolute + ")...", Tracer.Level.INFO);
        for (AdmFactory factory : this.factories.values()) {
            factory.generateClass(outdir, AdmEncodingType.Protobuf, absolute);
        }
        Iterator<AdmEnumeration> enumIterator = this.enumerations.values().iterator();
        while (enumIterator.hasNext()) {
            enumIterator.next().generateClass(outdir, absolute);
        }
        for (AdmCollection collection : this.collections.values()) {
            collection.generateInterface(outdir, absolute);
            collection.generateClass(outdir, AdmEncodingType.Protobuf, absolute);
        }
        for (AdmMessage message : this.messages.values()) {
            message.generateInterface(outdir, generateArrayGetterEmptyIfNull, absolute);
            message.generateClass(outdir, AdmEncodingType.Protobuf, absolute, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull);
        }
        for (AdmEntity entity : this.entities.values()) {
            if (!entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces()) {
                entity.generateInterface(outdir, generateArrayGetterEmptyIfNull, absolute);
            }
            entity.generateClass(outdir, AdmEncodingType.Protobuf, absolute, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull);
        }
    }

    private final void generateXbufClasses(File outdir, boolean absolute, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull) throws Exception {
        if (this.directives.getValueAsBoolean(GENERATE_PROTOBUF_CLASSES, Boolean.valueOf(false)).booleanValue()) {
            this.doProtobufGeneration(absolute ? this.getBaseDirFromAbsolute(outdir) : outdir, outdir, absolute);
        } else {
            this.resolveAndBundleCommonIDLFiles(outdir);
            if (this.tracer.debug) {
                this.tracer.log("Generating protobuf IDL to '" + outdir.getAbsolutePath() + "...", Tracer.Level.DEBUG);
            }
            this.doProtobufIDLGeneration(AdmEncodingType.Xbuf, outdir, absolute);
        }
        this.tracer.log("Generating class files (xbuf) to '" + outdir.getAbsolutePath() + "' (absolute=" + absolute + ", protoCompat=" + (Object)((Object)protoXbufGenCompatibility) + ")...", Tracer.Level.INFO);
        Iterator<AdmFactory> factoryIterator = this.factories.values().iterator();
        while (factoryIterator.hasNext()) {
            factoryIterator.next().generateClass(outdir, AdmEncodingType.Xbuf, absolute);
        }
        Iterator<AdmEnumeration> enumIterator = this.enumerations.values().iterator();
        while (enumIterator.hasNext()) {
            enumIterator.next().generateClass(outdir, absolute);
        }
        for (AdmCollection collection : this.collections.values()) {
            collection.generateInterface(outdir, absolute);
            collection.generateClass(outdir, AdmEncodingType.Xbuf, absolute);
        }
        for (AdmMessage message : this.messages.values()) {
            message.generateInterface(outdir, generateArrayGetterEmptyIfNull, absolute);
            message.generateClass(outdir, AdmEncodingType.Xbuf, absolute, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull);
        }
        for (AdmEntity entity : this.entities.values()) {
            if (!entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces()) {
                entity.generateInterface(outdir, generateArrayGetterEmptyIfNull, absolute);
            }
            entity.generateClass(outdir, AdmEncodingType.Xbuf, absolute, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull);
        }
    }

    private final void generateXbuf2Classes(File outdir, boolean absolute, boolean generateArrayGetterEmptyIfNull) throws Exception {
        if (this.directives.getValueAsBoolean(GENERATE_PROTOBUF_CLASSES, Boolean.valueOf(false)).booleanValue()) {
            this.doProtobufGeneration(absolute ? this.getBaseDirFromAbsolute(outdir) : outdir, outdir, absolute);
        } else {
            this.resolveAndBundleCommonIDLFiles(outdir);
            if (this.tracer.debug) {
                this.tracer.log("Generating protobuf IDL to '" + outdir.getAbsolutePath() + "...", Tracer.Level.DEBUG);
            }
            this.doProtobufIDLGeneration(AdmEncodingType.Xbuf2, outdir, absolute);
        }
        this.tracer.log("Generating class files (xbuf2) to '" + outdir.getAbsolutePath() + "' (absolute=" + absolute + ")...", Tracer.Level.INFO);
        Iterator<AdmFactory> factoryIterator = this.factories.values().iterator();
        while (factoryIterator.hasNext()) {
            factoryIterator.next().generateClass(outdir, AdmEncodingType.Xbuf2, absolute);
        }
        Iterator<AdmEnumeration> enumIterator = this.enumerations.values().iterator();
        while (enumIterator.hasNext()) {
            enumIterator.next().generateClass(outdir, absolute);
        }
        for (AdmCollection collection : this.collections.values()) {
            collection.generateInterface(outdir, absolute);
            collection.generateClass(outdir, AdmEncodingType.Xbuf2, absolute);
        }
        for (AdmMessage message : this.messages.values()) {
            message.generateInterface(outdir, generateArrayGetterEmptyIfNull, absolute);
            message.generateClass(outdir, AdmEncodingType.Xbuf2, absolute, null, generateArrayGetterEmptyIfNull);
        }
        for (AdmEntity entity : this.entities.values()) {
            if (!entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces()) {
                entity.generateInterface(outdir, generateArrayGetterEmptyIfNull, absolute);
            }
            entity.generateClass(outdir, AdmEncodingType.Xbuf2, absolute, null, generateArrayGetterEmptyIfNull);
        }
    }

    private final void generateJsonClasses(File outdir, boolean absolute, boolean generateArrayGetterEmptyIfNull) throws Exception {
        this.tracer.log("Generating class files (json) to '" + outdir.getAbsolutePath() + "' (absolute=" + absolute + ")...", Tracer.Level.INFO);
        for (AdmFactory factory : this.factories.values()) {
            factory.generateClass(outdir, AdmEncodingType.Json, absolute);
        }
        Iterator<AdmEnumeration> enumIterator = this.enumerations.values().iterator();
        while (enumIterator.hasNext()) {
            enumIterator.next().generateClass(outdir, absolute);
        }
        for (AdmCollection collection : this.collections.values()) {
            collection.generateInterface(outdir, absolute);
            collection.generateClass(outdir, AdmEncodingType.Json, absolute);
        }
        for (AdmMessage message : this.messages.values()) {
            message.generateInterface(outdir, generateArrayGetterEmptyIfNull, absolute);
            message.generateClass(outdir, AdmEncodingType.Json, absolute, null, generateArrayGetterEmptyIfNull);
        }
        for (AdmEntity entity : this.entities.values()) {
            if (!entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces()) {
                entity.generateInterface(outdir, generateArrayGetterEmptyIfNull, absolute);
            }
            entity.generateClass(outdir, AdmEncodingType.Json, absolute, null, generateArrayGetterEmptyIfNull);
        }
    }

    final void setProtobufOuterClassName(String protoBufOuterClassName) {
        this.protobufOuterClassName = protoBufOuterClassName;
    }

    final void setCopyImportedProtosToOutputDir(boolean copyImportedProtos) {
        this.copyImportedProtos = copyImportedProtos;
    }

    final AdmEntity.NullArrayElementPolicy getNullEntityArrayFieldHandlingPolicy() {
        return this.nullEntityArrayFieldHandlingPolicy;
    }

    final AdmEntity.NullArrayElementPolicy getNullPrimitiveArrayFieldHandlingPolicy() {
        return this.nullPrimitiveArrayFieldHandlingPolicy;
    }

    static final File resolveAbsoluteClassFile(File baseDir, String namespace, String classname) throws Exception {
        StringBuilder sb = new StringBuilder(baseDir.getCanonicalPath());
        sb.append(File.separator);
        if (namespace != null) {
            StringTokenizer tokenizer = new StringTokenizer(namespace, ".");
            while (tokenizer.hasMoreTokens()) {
                sb.append(tokenizer.nextToken());
                sb.append(File.separator);
            }
        }
        sb.append(classname);
        sb.append(".java");
        return new File(sb.toString());
    }

    public final String getProtobufOuterClassName() {
        if (this.protobufOuterClassName != null) {
            return this.protobufOuterClassName;
        }
        String str = this.getName() != null ? this.getName() : "model";
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(str, "_");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            sb.append(token.substring(0, 1).toUpperCase());
            if (token.length() <= 1) continue;
            sb.append(token.substring(1, token.length()));
        }
        return sb.toString();
    }

    public final void setProtoXbufGenerationCompatibility(AdmEncodingType encoding) {
        this.protoXbufGenCompatibility = encoding;
    }

    public final void setGenerateArrayGetterReturnEmptyIfNull(boolean val) {
        this.generateArrayGetterEmptyIfNull = val;
    }

    @Deprecated
    public final void setProtobufIDLOutputDir(String dir) {
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Setting additional protobuf IDL directory to '" + dir + "'", Tracer.Level.DEBUG);
        }
        if (dir == null) {
            this.protobufIDLOutputDir = null;
        } else {
            this.protobufIDLOutputDir = new File(dir);
            if (!this.protobufIDLOutputDir.isDirectory()) {
                this.protobufIDLOutputDir = null;
                throw new IllegalArgumentException("not a directory");
            }
        }
    }

    public final String getProtobufIDLOutputDir() {
        return this.protobufIDLOutputDir == null ? null : this.protobufIDLOutputDir.getAbsolutePath();
    }

    public boolean isCopyImportedProtosToOutputDir() {
        return this.copyImportedProtos;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final String getName() {
        return this.name;
    }

    public final String getFullName() {
        return this.namespace + "." + this.name;
    }

    public final String getFullName(boolean useFilename) {
        if (!useFilename) {
            return this.getFullName();
        }
        if (this.documentURL == null) {
            throw new IllegalStateException("Model filename should be used but none was supplied in constructor.");
        }
        String fileSegment = this.documentURL.getFile().substring(this.documentURL.getFile().lastIndexOf(47) + 1);
        String fileName = fileSegment;
        int lastDotIdx = fileName.lastIndexOf(46);
        if (lastDotIdx > -1) {
            fileName = fileSegment.substring(0, lastDotIdx);
        }
        return this.namespace + "." + fileName;
    }

    public final String nameFromFullName(String fullname) {
        int index = fullname.lastIndexOf(".");
        return index == -1 ? fullname : fullname.substring(index + 1, fullname.length());
    }

    public final String namespaceFromFullName(String fullname) {
        int index = fullname.lastIndexOf(".");
        return index == -1 ? null : fullname.substring(0, index);
    }

    public final boolean isOf(String fullname) {
        int index = fullname.lastIndexOf(".");
        return index == -1 || fullname.substring(0, index).compareToIgnoreCase(this.getNamespace()) == 0;
    }

    public final String toTypeString(AdmType type) {
        if (type instanceof AdmEnumeration) {
            return "Enumeration";
        }
        if (type instanceof AdmMessage) {
            return "Message";
        }
        if (type instanceof AdmEntity) {
            return "Entity";
        }
        if (type instanceof AdmCollection) {
            return "Collection";
        }
        if (type instanceof AdmPooledString) {
            return "PooledString";
        }
        return "Unknown";
    }

    public final boolean validateModel(StringBuilder summary) {
        return this.validateModel(summary, null);
    }

    public final boolean validateModel(StringBuilder summary, CgSourceCodeErrorAggregator aggregator) {
        boolean valid = true;
        try {
            this.directives.validate();
        }
        catch (CgBuildParameters.AdmParametersException ex) {
            CgBuildParameters.AdmParameter parameter = ex.getParameter();
            StringBuilder directivesErrSb = new StringBuilder();
            directivesErrSb.append("Error validating directives");
            if (parameter != null) {
                directivesErrSb.append(" for parameter '").append(parameter.getName()).append("'");
            }
            directivesErrSb.append(": ").append(ex.getMessage());
            summary.append("-").append((CharSequence)directivesErrSb).append("\n");
            if (aggregator != null) {
                aggregator.add(directivesErrSb.toString(), CgSourceCodeErrorAggregator.Severity.ERROR, null, null);
            }
            valid = false;
        }
        for (AdmEntity entity : this.entities.values()) {
            valid &= entity.validate(summary, aggregator);
        }
        for (AdmMessage message : this.messages.values()) {
            valid &= message.validate(summary, aggregator);
        }
        if (!allowCircularReferences) {
            HashSet<AdmType> alreadyChecked = new HashSet<AdmType>();
            for (AdmEntity entity : this.entities.values()) {
                valid &= !this.checkForCycles(entity, alreadyChecked, summary, aggregator);
            }
            for (AdmMessage message : this.messages.values()) {
                valid &= !this.checkForCycles(message, alreadyChecked, summary, aggregator);
            }
        }
        valid &= this.checkImportsEncodingTypeCompatibility(summary, aggregator);
        if (this.getBooleanDirective(DIRECTIVE_ENABLE_TYPE_NAME_VALIDATION)) {
            valid &= this.validateTypeNames(summary, aggregator);
        }
        return valid;
    }

    public final void validateFactoryNameIsNotDuplicate(AdmFactory factory) throws EAdmException {
        if (factory == null) {
            throw new IllegalArgumentException("specified factory cannot be null");
        }
        String fullname = factory.getFullName();
        AdmType type = this.getType(fullname);
        if (type == null) {
            AdmFactory dupfactory = this.getFactoryGlobal(fullname);
            if (dupfactory != null) {
                throw new EAdmException("Two factories have the same name [" + fullname + "]", factory.getCodeSource());
            }
        } else {
            throw new EAdmException("The " + this.toTypeString(type) + " type and a factory have the same name [" + fullname + "]", factory.getCodeSource());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void validateTypeNameIsNotDuplicate(AdmType type) throws EAdmException {
        if (type == null) {
            throw new IllegalArgumentException("specified type cannot be null");
        }
        String fullname = type.getFullName();
        AdmType duptype = this.getType(fullname);
        if (duptype == null) {
            AdmFactory factory = this.getFactoryGlobal(fullname);
            if (factory == null) return;
            String message = "The " + this.toTypeString(type) + " type and a factory have the same name [" + fullname + "]";
            if (this.modelBuildErrorAggregator == null) throw new EAdmException(message, type.getCodeSource());
            this.modelBuildErrorAggregator.add(message, CgSourceCodeErrorAggregator.Severity.ERROR, type.getCodeSource(), null);
            return;
        } else {
            String message = "Two types (" + this.toTypeString(type) + " and " + this.toTypeString(duptype) + ") have the same name [" + fullname + "]";
            if (this.modelBuildErrorAggregator == null) throw new EAdmException(message, type.getCodeSource());
            this.modelBuildErrorAggregator.add(message, CgSourceCodeErrorAggregator.Severity.ERROR, type.getCodeSource(), null);
        }
    }

    @Deprecated
    public final void setExternalProtoDir(String dir) {
        this.tracer.log("ADM Model '" + this.name + "': Setting external proto directory to '" + dir + "'", Tracer.Level.DEBUG);
        if (dir == null) {
            this.externalProtoDirs = null;
        } else {
            File externalProtoDir = new File(dir);
            if (!externalProtoDir.isDirectory()) {
                throw new IllegalArgumentException("not a directory");
            }
            this.setExternalProtoDirs(Arrays.asList(externalProtoDir));
        }
    }

    public final void setExternalProtoDirs(List<File> dirs) {
        this.tracer.log("ADM Model '" + this.name + "': Setting external proto paths to '" + dirs + "'", Tracer.Level.DEBUG);
        this.externalProtoDirs = dirs;
    }

    public final List<File> getExternalProtoDirs() {
        return this.externalProtoDirs;
    }

    @Deprecated
    public final void addImport(AdmModel model) throws Exception {
        this.addImport(new AdmModelImport(this, model));
    }

    public final void addImport(AdmModelImport modelImport) {
        if (modelImport == null) {
            throw new IllegalArgumentException("imported model cannot be null");
        }
        if (modelImport.getParentModel() != this) {
            throw new IllegalArgumentException("This model is not the owner of import");
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Adding import '" + modelImport.getModel().getName() + "'", Tracer.Level.DEBUG);
        }
        this.imports.add(modelImport);
    }

    public final int getImportCount() {
        return this.imports.size();
    }

    @Deprecated
    public final Collection<AdmModel> getImports() {
        ArrayList<AdmModel> retVal = new ArrayList<AdmModel>(this.imports.size());
        for (AdmModelImport modelImport : this.imports) {
            retVal.add(modelImport.getModel());
        }
        return retVal;
    }

    public final Collection<AdmModelImport> getModelImports() {
        return this.imports;
    }

    public final void addFactory(String name, AdmFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException("factory name cannot be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (this.getNamespace() != null && !this.getNamespace().equalsIgnoreCase(factory.getNamespace())) {
            throw new IllegalArgumentException("factory '" + factory.getName() + " namespace ('" + factory.getNamespace() + "' is not the same as the namespace of the model it is being added to ('" + this.getNamespace() + "')");
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Adding factory '" + factory.getName() + "'", Tracer.Level.DEBUG);
        }
        this.factories.put(name, factory);
    }

    public final AdmFactory getFactoryLocal(String name) {
        if (name == null) {
            throw new IllegalArgumentException("factory name cannot be null");
        }
        return this.factories.get(name);
    }

    public final int getFactoryLocalCount() {
        return this.factories.size();
    }

    public final AdmFactory getFactoryLocalById(int id) {
        for (AdmFactory factory : this.factories.values()) {
            if (factory.getId() != id) continue;
            return factory;
        }
        return null;
    }

    public final AdmFactory getDefaultFactory() {
        return this.defaultFactory;
    }

    public final void setDefaultFactory(AdmFactory factory) {
        this.defaultFactory = factory;
        this.addFactory(factory.getName(), factory);
    }

    public final AdmFactory getFactoryGlobal(String fullname) {
        AdmFactory factory;
        block3: {
            block2: {
                if (fullname == null) {
                    throw new IllegalArgumentException("factory name cannot be null");
                }
                factory = null;
                if (!this.isOf(fullname)) break block2;
                factory = this.getFactoryLocal(this.nameFromFullName(fullname));
                break block3;
            }
            if (this.namespaceFromFullName(fullname) == null) break block3;
            Iterator iterator = this.imports.iterator();
            while (iterator.hasNext() && (factory = ((AdmModelImport)((Object)iterator.next())).getModel().getFactoryGlobal(fullname)) == null) {
            }
        }
        return factory;
    }

    public final Collection<AdmFactory> getFactories() {
        return this.factories.values();
    }

    public final void addEnumeration(String name, AdmEnumeration enumeration) {
        if (name == null) {
            throw new IllegalArgumentException("enumeration name cannot be null");
        }
        if (enumeration == null) {
            throw new IllegalArgumentException("enumeration cannot be null");
        }
        if (enumeration.getModel() != null && enumeration.getModel() != this) {
            throw new IllegalArgumentException("enumeration '" + enumeration.getName() + "' is already in a model (existing='" + enumeration.getModel().getName() + ", this=" + this.getName() + ")");
        }
        if (this.getNamespace() != null && !this.getNamespace().equalsIgnoreCase(enumeration.getNamespace())) {
            throw new IllegalArgumentException("enumeration '" + enumeration.getName() + " namespace ('" + enumeration.getNamespace() + "' is not the same as the namespace of the model it is being added to ('" + this.getNamespace() + "')");
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Adding enumeration '" + enumeration.getName() + "'", Tracer.Level.DEBUG);
        }
        this.enumerations.put(name, enumeration);
        enumeration.setModel(this);
    }

    public final AdmEnumeration getEnumeration(String name) {
        if (name == null) {
            throw new IllegalArgumentException("enumeration name cannot be null");
        }
        return this.enumerations.get(name);
    }

    public final int getEnumerationCount() {
        return this.enumerations.size();
    }

    public final Collection<AdmEnumeration> getEnumerations() {
        return this.enumerations.values();
    }

    public final void addSemanticType(AdmSemanticType type) throws EAdmException {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (type.getName() == null) {
            throw new IllegalArgumentException("type name cannot be null");
        }
        if (this.semanticTypes.containsKey(type.getName())) {
            if (this.semanticTypes.get(type.getName()) == type) {
                return;
            }
            throw new EAdmException("type '" + type.getName() + "' is already in model (existing='" + this.fields.get(type.getName()) + ", this=" + (Object)((Object)type) + ")", this.getCodeSource());
        }
        if (type.getModel() != this) {
            throw new EAdmException("field '" + type.getName() + " namespace ('" + type.getModel().getNamespace() + "' is not the same as the namespace of the model it is being added to ('" + this.getNamespace() + "')", type.getCodeSource());
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Adding semantic type '" + type.getName() + "'", Tracer.Level.DEBUG);
        }
        this.semanticTypes.put(type.getName(), type);
        this.addTransitiveTypeImport(type.getBaseType());
    }

    public final AdmSemanticType getSemanticType(String fullname) {
        AdmSemanticType type;
        block3: {
            if (fullname == null) {
                throw new IllegalArgumentException("type name cannot be null");
            }
            if (this.isOf(fullname)) {
                return this.semanticTypes.get(this.nameFromFullName(fullname));
            }
            type = null;
            if (this.namespaceFromFullName(fullname) == null) break block3;
            Iterator iterator = this.imports.iterator();
            while (iterator.hasNext() && (type = ((AdmModelImport)((Object)iterator.next())).getModel().getSemanticType(fullname)) == null) {
            }
        }
        return type;
    }

    public final int getSemanticTypeCount() {
        return this.semanticTypes.size();
    }

    public final Collection<AdmSemanticType> getSemanticTypes() {
        return this.semanticTypes.values();
    }

    public final void addField(AdmField field) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (field.getName() == null) {
            throw new IllegalArgumentException("field name cannot be null");
        }
        if (this.fields.containsKey(field.getName())) {
            if (this.fields.get(field.getName()) == field) {
                return;
            }
            throw new IllegalArgumentException("field '" + field.getName() + "' is already in model (existing='" + this.fields.get(field.getName()) + ", this=" + field + ")");
        }
        if (this.getNamespace() != null && !this.getNamespace().equalsIgnoreCase(field.getNamespace())) {
            throw new IllegalArgumentException("field '" + field.getName() + " namespace ('" + field.getNamespace() + "' is not the same as the namespace of the model it is being added to ('" + this.getNamespace() + "')");
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Adding field '" + field.getName() + "'", Tracer.Level.DEBUG);
        }
        this.fields.put(field.getName(), field);
    }

    @Deprecated
    public final AdmField getField(String fullname) {
        AdmField field;
        block3: {
            if (fullname == null) {
                throw new IllegalArgumentException("field name cannot be null");
            }
            if (this.isOf(fullname)) {
                return this.fields.get(this.nameFromFullName(fullname));
            }
            field = null;
            if (this.namespaceFromFullName(fullname) == null) break block3;
            Iterator iterator = this.imports.iterator();
            while (iterator.hasNext() && (field = ((AdmModelImport)((Object)iterator.next())).getModel().getField(fullname)) == null) {
            }
        }
        return field;
    }

    public final AdmFieldLookup lookupField(String fullName, boolean localOnly) throws EAdmException {
        return this.lookupField(fullName, localOnly, null);
    }

    public final int getFieldCount() {
        return this.fields.size();
    }

    public final Collection<AdmField> getFields() {
        return this.fields.values();
    }

    public final void addPooledString(AdmPooledString pooledType) {
        if (pooledType == null) {
            throw new IllegalArgumentException("pooled string type cannot be null");
        }
        if (pooledType.getName() == null) {
            throw new IllegalArgumentException("pooled string type cannot be null");
        }
        if (this.getNamespace() != null && !this.getNamespace().equalsIgnoreCase(pooledType.getNamespace())) {
            throw new IllegalArgumentException("pooled string '" + pooledType.getName() + " namespace ('" + pooledType.getNamespace() + "' is not the same as the namespace of the model it is being added to ('" + this.getNamespace() + "')");
        }
        if (this.pooledStrings.containsKey(pooledType.getFullName()) && this.pooledStrings.get(pooledType.getName()) != null) {
            return;
        }
        AdmType existing = this.getType(pooledType.getName());
        if (existing != null && !(existing instanceof AdmPrimitive)) {
            throw new IllegalArgumentException("pooled string type name of '" + pooledType.getName() + "' conflicts with an already defined " + existing.getName());
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Adding Pooled String '" + pooledType.getName() + "'", Tracer.Level.DEBUG);
        }
        this.pooledStrings.put(pooledType.getName(), pooledType);
        pooledType.setModel(this);
    }

    public final AdmPooledString getPooledString(String fullname) {
        AdmPooledString pooledString;
        block3: {
            if (fullname == null) {
                throw new IllegalArgumentException("pooled string name cannot be null");
            }
            if (this.isOf(fullname)) {
                return this.pooledStrings.get(this.nameFromFullName(fullname));
            }
            pooledString = null;
            if (this.namespaceFromFullName(fullname) == null) break block3;
            Iterator iterator = this.imports.iterator();
            while (iterator.hasNext() && (pooledString = ((AdmModelImport)((Object)iterator.next())).getModel().getPooledString(fullname)) == null) {
            }
        }
        return pooledString;
    }

    public final int getPooledStringCount() {
        return this.pooledStrings.size();
    }

    public final Collection<AdmPooledString> getPooledStrings() {
        return this.pooledStrings.values();
    }

    public final void addMessage(String name, AdmMessage message) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("message name cannot be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        if (message.getModel() != null && message.getModel() != this) {
            throw new IllegalArgumentException("message '" + message.getName() + "' is already in a model (existing='" + message.getModel().getName() + ", this=" + this.getName() + ")");
        }
        if (this.getNamespace() != null && !this.getNamespace().equalsIgnoreCase(message.getNamespace())) {
            throw new IllegalArgumentException("message '" + message.getName() + " namespace ('" + message.getNamespace() + "' is not the same as the namespace of the model it is being added to ('" + this.getNamespace() + "')");
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Adding message '" + message.getName() + "'", Tracer.Level.DEBUG);
        }
        this.messages.put(name, message);
        message.setModel(this);
        this.addTransitiveFieldTypeImports(message);
    }

    public final AdmMessage getMessage(String name) {
        if (name == null) {
            throw new IllegalArgumentException("message name cannot be null");
        }
        return this.messages.get(name);
    }

    public final int getMessageCount() {
        return this.messages.size();
    }

    public final Collection<AdmMessage> getMessages() {
        return this.messages.values();
    }

    public final void addEntity(String name, AdmEntity entity) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("entity name cannot be null");
        }
        if (entity == null) {
            throw new IllegalArgumentException("entity cannot be null");
        }
        if (entity.getModel() != null && entity.getModel() != this) {
            throw new IllegalArgumentException("entity '" + entity.getName() + "' is already in a model (existing='" + entity.getModel().getName() + ", this=" + this.getName() + ")");
        }
        if (this.getNamespace() != null && !this.getNamespace().equalsIgnoreCase(entity.getNamespace())) {
            throw new IllegalArgumentException("entity '" + entity.getName() + " namespace ('" + entity.getNamespace() + "' is not the same as the namespace of the model it is being added to ('" + this.getNamespace() + "')");
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Adding entity '" + entity.getName() + "'", Tracer.Level.DEBUG);
        }
        this.entities.put(name, entity);
        entity.setModel(this);
        this.addTransitiveFieldTypeImports(entity);
    }

    public final AdmEntity getEntity(String name) {
        if (name == null) {
            throw new IllegalArgumentException("entity name cannot be null");
        }
        return this.entities.get(name);
    }

    public final int getEntityCount() {
        return this.entities.size();
    }

    public final Collection<AdmEntity> getEntities() {
        return this.entities.values();
    }

    public final void addCollection(String name, AdmCollection collection) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("collection name cannot be null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("collection cannot be null");
        }
        if (collection.getModel() != null && collection.getModel() != this) {
            throw new IllegalArgumentException("collection '" + collection.getName() + "' is already in a model (existing='" + collection.getModel().getName() + ", this=" + this.getName() + ")");
        }
        if (this.getNamespace() != null && !this.getNamespace().equalsIgnoreCase(collection.getNamespace())) {
            throw new IllegalArgumentException("collection '" + collection.getName() + " namespace ('" + collection.getNamespace() + "' is not the same as the namespace of the model it is being added to ('" + this.getNamespace() + "')");
        }
        if (this.tracer.debug) {
            this.tracer.log("ADM Model '" + this.name + "': Adding collection '" + collection.getName() + "'", Tracer.Level.DEBUG);
        }
        this.collections.put(name, collection);
        collection.setModel(this);
    }

    public final AdmCollection getCollection(String name) {
        if (name == null) {
            throw new IllegalArgumentException("collection name cannot be null");
        }
        return this.collections.get(name);
    }

    public final int getCollectionCount() {
        return this.collections.size();
    }

    public final Collection<AdmCollection> getCollections() {
        return this.collections.values();
    }

    public final AdmType lookupType(String typeName, boolean localOnly) throws EAdmException {
        if (typeName == null) {
            throw new IllegalArgumentException("'fullName' cannot be null");
        }
        boolean fullQualifiedName = this.namespaceFromFullName(typeName) != null;
        AdmType type = AdmPrimitive.toPrimitiveType(typeName);
        if (type == null) {
            AdmSemanticType semanticType;
            String name;
            if (this.isOf(typeName) && (type = this.getEnumeration(name = this.nameFromFullName(typeName))) == null && (type = this.getMessage(name)) == null && (type = this.getEntity(name)) == null && (type = this.getCollection(name)) == null && (type = this.getPooledString(typeName)) == null && (semanticType = this.getSemanticType(typeName)) != null) {
                type = semanticType.getBaseType();
            }
            if (type == null && (!localOnly || fullQualifiedName)) {
                for (AdmModelImport modelImport : this.imports) {
                    if (type != null) {
                        AdmType duplicateType = modelImport.getModel().getType(typeName);
                        if (duplicateType != null && type != duplicateType) {
                            throw new EAdmException("Ambiguous type resolution '" + typeName + "' found in : " + type.getModel().getFullName() + ", " + duplicateType.getModel().getFullName());
                        }
                    } else {
                        type = modelImport.getModel().lookupType(typeName, false);
                    }
                    if (type == null || !fullQualifiedName) continue;
                    break;
                }
            }
        }
        return type;
    }

    @Deprecated
    public final AdmType getType(String typeName) {
        AdmType type;
        block3: {
            block4: {
                AdmSemanticType semanticType;
                if (typeName == null) {
                    throw new IllegalArgumentException("type name cannot be null");
                }
                type = AdmPrimitive.toPrimitiveType(typeName);
                if (type != null) break block3;
                if (!this.isOf(typeName)) break block4;
                String name = this.nameFromFullName(typeName);
                type = this.getEnumeration(name);
                if (type != null || (type = this.getMessage(name)) != null || (type = this.getEntity(name)) != null || (type = this.getCollection(name)) != null || (type = this.getPooledString(typeName)) != null || (semanticType = this.getSemanticType(typeName)) == null) break block3;
                type = semanticType.getBaseType();
                break block3;
            }
            if (this.namespaceFromFullName(typeName) != null) {
                AdmModelImport modelImport;
                Iterator iterator = this.imports.iterator();
                while (iterator.hasNext() && (type = (modelImport = (AdmModelImport)((Object)iterator.next())).getModel().getType(typeName)) == null) {
                }
            }
        }
        return type;
    }

    private static File toFile(FileObject fileObject) {
        URI srcUri = fileObject.toUri();
        File outdir = null;
        outdir = !srcUri.isAbsolute() ? new File(srcUri.toString()) : new File(srcUri);
        return outdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateClasses(Filer filer, javax.lang.model.element.Element ... elements) throws Exception {
        if (filer == null) {
            throw new IllegalArgumentException("output directory cannot be null");
        }
        try {
            StringBuilder errors = new StringBuilder();
            if (!this.validateModel(errors)) {
                throw new EAdmException("Model contains validation errors: " + errors.toString());
            }
            for (AdmPooledString stringType : this.pooledStrings.values()) {
                stringType.generateClasses(filer, elements);
            }
            Iterator<AdmFactory> factoryIterator = this.factories.values().iterator();
            while (factoryIterator.hasNext()) {
                factoryIterator.next().generateClass(filer, elements);
            }
            Iterator<AdmEnumeration> enumIterator = this.enumerations.values().iterator();
            while (enumIterator.hasNext()) {
                enumIterator.next().generateClass(filer, elements);
            }
            for (AdmCollection collection : this.collections.values()) {
                collection.generateInterface(filer, elements);
                collection.generateClass(filer, elements);
            }
            for (AdmMessage message : this.messages.values()) {
                message.generateInterface(filer, elements);
                message.generateClass(filer, elements);
            }
            for (AdmEntity entity : this.entities.values()) {
                if (!entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces()) {
                    entity.generateInterface(filer, new javax.lang.model.element.Element[0]);
                }
                entity.generateClass(filer, elements);
            }
        }
        finally {
            try {
                UtlFile.deleteDirectory((File)this.resolvedIdlTempDir);
            }
            catch (Throwable e) {
                this.tracer.log("Failed to delete resolved IDL temp dir (" + this.resolvedIdlTempDir + "): " + e.getMessage() + " " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void generateClasses(File outdir, boolean absolute) throws Exception {
        if (outdir == null) {
            throw new IllegalArgumentException("output directory cannot be null");
        }
        try {
            AdmEncodingType encodingType = (AdmEncodingType)((Object)this.directives.getValue(DIRECTIVE_ENCODING_TYPE));
            StringBuilder errors = new StringBuilder();
            if (!this.validateModel(errors, this.modelBuildErrorAggregator)) {
                throw new EAdmException("Model contains validation errors: " + errors.toString(), this.modelBuildErrorAggregator);
            }
            for (AdmPooledString stringType : this.pooledStrings.values()) {
                stringType.generateClasses(outdir, absolute);
            }
            switch (encodingType) {
                case Xbuf: {
                    this.generateXbufClasses(outdir, absolute, this.protoXbufGenCompatibility, this.generateArrayGetterEmptyIfNull);
                    return;
                }
                case Xbuf2: {
                    this.generateXbuf2Classes(outdir, absolute, this.generateArrayGetterEmptyIfNull);
                    return;
                }
                case Protobuf: {
                    this.generateProtobufClasses(outdir, absolute, this.protoXbufGenCompatibility, this.generateArrayGetterEmptyIfNull);
                    return;
                }
                case Json: {
                    this.generateJsonClasses(outdir, absolute, this.generateArrayGetterEmptyIfNull);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("unknown encoding type '" + (Object)((Object)encodingType) + "'");
                }
            }
        }
        finally {
            try {
                UtlFile.deleteDirectory((File)this.resolvedIdlTempDir);
            }
            catch (Throwable e) {
                this.tracer.log("Failed to delete resolved IDL temp dir (" + this.resolvedIdlTempDir + "): " + e.getMessage() + " " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
            }
        }
    }

    public final void generateClasses(File outdir, AdmEncodingType encodingType, boolean absolute) throws Exception {
        this.directives.newArgument(DIRECTIVE_ENCODING_TYPE, (Object)encodingType);
        this.generateClasses(outdir, absolute);
    }

    public final void generateClasses(File outdir) throws Exception {
        this.generateClasses(outdir, false);
    }

    public final void generateClasses(File outdir, AdmEncodingType encodingType) throws Exception {
        this.directives.newArgument(DIRECTIVE_ENCODING_TYPE, (Object)encodingType);
        this.generateClasses(outdir, false);
    }

    public final void dump() {
        Iterator modelIterator = this.imports.iterator();
        while (modelIterator.hasNext()) {
            ((AdmModelImport)((Object)modelIterator.next())).getModel().dump();
            System.out.println("");
        }
        System.out.println(this.getNamespace() + " {");
        System.out.println("   Factories {");
        for (AdmFactory factory : this.factories.values()) {
            System.out.println("   ..." + factory.getName() + " [id=" + factory.getId() + "]");
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Enumerations {");
        for (AdmEnumeration enumeration : this.enumerations.values()) {
            System.out.println("   ..." + enumeration.getName());
            Iterator<AdmEnumeration.ConstEntry> constIterator = enumeration.constIterator();
            while (constIterator.hasNext()) {
                AdmEnumeration.ConstEntry constEntry = constIterator.next();
                System.out.println("   ......[" + constEntry.name + "," + constEntry.value + "]");
            }
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Types {");
        for (AdmSemanticType type : this.semanticTypes.values()) {
            System.out.println("   ..." + type.getName() + " [base=" + type.getBaseType().getQualifiedName(this) + "]");
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Fields {");
        for (AdmField field : this.fields.values()) {
            String origin = "";
            if (field.isImported()) {
                origin = ", originModel=" + field.getOriginModel().getFullName();
            }
            System.out.println("   ..." + field.getName() + " [type=" + field.getQualifiedSemanticTypeName(this) + ", id=" + field.getId() + origin + "]");
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Messages {");
        for (AdmMessage message : this.messages.values()) {
            System.out.println("   ..." + message.getName() + " [parent=" + (Object)((Object)message.getParent()) + ", factory=" + message.getFactory().getName() + "]");
            for (AdmField field : message.fields().values()) {
                String origin = "";
                if (field.isImported()) {
                    origin = ", originModel=" + field.getOriginModel().getFullName();
                }
                System.out.println("   ......" + field.getName() + " [type=" + field.getQualifiedSemanticTypeName(this) + ", isKey=" + field.isKey() + ", id= " + field.getId() + origin + "]");
            }
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Entities {");
        for (AdmEntity entity : this.entities.values()) {
            System.out.println("   ..." + entity.getName() + " [parent=" + (Object)((Object)entity.getParent()) + ", factory=" + entity.getFactory().getName() + ", isRoot=" + entity.isRoot() + "]");
            for (AdmField field : entity.fields().values()) {
                String origin = "";
                if (field.isImported()) {
                    origin = ", originModel=" + field.getOriginModel().getFullName();
                }
                System.out.println("   ......" + field.getName() + " [type=" + field.getQualifiedSemanticTypeName(this) + ", isKey=" + field.isKey() + ", id= " + field.getId() + origin + "]");
            }
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Collections {");
        for (AdmCollection collection : this.collections.values()) {
            System.out.println("   ..." + collection.getName() + " [factory=" + collection.getFactory().getName() + ", is=" + (Object)((Object)collection.getType()) + ", contains=" + collection.getContains().getFullName() + "]");
        }
        System.out.println("   }");
        System.out.println("}");
        System.out.println("");
    }

    public boolean isUseBundledProtoc() {
        return this.useBundledProtoc;
    }

    public void setUseBundledProtoc(boolean useBundledProtoc) {
        this.useBundledProtoc = useBundledProtoc;
    }

    public void setBuildInfo(String buildInfo) {
        this.buildInfo = buildInfo;
    }

    public String getBuildInfo() {
        return this.buildInfo;
    }

    public void setDocumentation(AdmDocumentation doc) {
        this.documentation = doc;
    }

    public AdmDocumentation getDocumentation() {
        return this.documentation;
    }

    public void setDirectives(Map<String, AdmDirective> directives) {
        if (directives == null) {
            return;
        }
        AdmDirective apexStyleDirective = directives.get(APEX_STYLE);
        if (apexStyleDirective != null && Boolean.valueOf(apexStyleDirective.getValueAsString(null)).booleanValue()) {
            this.setDirective(GENERATE_EMBEDDED_ENTITY_INTERFACES, "true", null);
            this.setDirective(GENERATE_DEFAULT_GETTERS, "true", null);
            this.setDirective(GENERATE_THROW_ON_UNSET_GETTERS, "true", null);
            this.setDirective(GENERATE_REQUIRED_FIELD_VALIDATORS, "true", null);
            this.setDirective(GENERATE_FLUENT_SETTERS, "true", null);
        }
        if (directives.containsKey(GENERATE_BUILDER_SETTERS) && !directives.containsKey(GENERATE_FLUENT_SETTERS)) {
            System.err.println("WARNING: The 'generateBuilderSetters' directive has been deprecated in favor of 'generateFluentSetters' ");
            AdmDirective builderSettersDirective = directives.get(GENERATE_BUILDER_SETTERS);
            this.setDirective(GENERATE_FLUENT_SETTERS, builderSettersDirective.getValue(), builderSettersDirective.getCodeSource());
        }
        for (Map.Entry<String, AdmDirective> entry : directives.entrySet()) {
            if (entry.getKey().equals(GENERATE_BUILDER_SETTERS)) continue;
            this.setDirective(entry.getKey(), entry.getValue().getValue(), entry.getValue().getCodeSource());
        }
        AdmDirective nullArrayElementPolicyDirective = directives.get(NULL_ARRAY_ELEMENT_POLICY);
        if (nullArrayElementPolicyDirective != null && nullArrayElementPolicyDirective.getValue() != null) {
            this.nullEntityArrayFieldHandlingPolicy = this.nullPrimitiveArrayFieldHandlingPolicy = AdmEntity.NullArrayElementPolicy.valueOf(nullArrayElementPolicyDirective.getValueAsString(null));
        }
    }

    public boolean getBooleanDirective(String directiveName) {
        return this.directives.getValueAsBoolean(directiveName, Boolean.valueOf(false));
    }

    public String getStringDirective(String directiveName) {
        return this.directives.getValueAsString(directiveName, null);
    }

    public PooledStringFieldTypeNameSuffixPolicy getPooledStringFieldTypeNameSuffixPolicy() {
        return (PooledStringFieldTypeNameSuffixPolicy)((Object)this.directives.getValue(POOLED_STRING_FIELD_TYPE_NAME_SUFFIX_POLICY));
    }

    public String getPooledStringSuffix() {
        String suffixDirective = (String)this.directives.getValue(POOLED_STRING_FIELD_TYPE_NAME_SUFFIX);
        if (suffixDirective == null) {
            return "String";
        }
        return suffixDirective;
    }

    public static String getAdmVersion() {
        return PRODUCT_INFO.getComponentVersionString();
    }

    public final Document getModelDocument() {
        ArrayList<Node> elementsToRemove;
        Document clonedDocument;
        if (this.modelDocument == null) {
            throw new IllegalStateException("Model " + this.getFullName() + " is not initialized with Document instance.");
        }
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer tx = tfactory.newTransformer();
            DOMSource source = new DOMSource(this.modelDocument);
            DOMResult result = new DOMResult();
            tx.transform(source, result);
            clonedDocument = (Document)result.getNode();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error cloning model document", ex);
        }
        Element modelElement = clonedDocument.getDocumentElement();
        modelElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        modelElement.setAttribute("namespace", this.getNamespace());
        Node firstNode = modelElement.getChildNodes().item(0);
        if (this.directives.getValueAsBoolean(DIRECTIVE_REWRITE_OUTPUT_MODEL_IMPORTS, Boolean.valueOf(true)).booleanValue()) {
            NodeList importElements = modelElement.getElementsByTagName("import");
            elementsToRemove = new ArrayList<Node>();
            for (int i = 0; i < importElements.getLength(); ++i) {
                elementsToRemove.add(importElements.item(i));
            }
            for (Node node : elementsToRemove) {
                modelElement.removeChild(node);
            }
            ArrayList<Element> newImportElements = new ArrayList<Element>();
            for (AdmModelImport modelImport : this.getModelImports()) {
                Element importElement = clonedDocument.createElement("import");
                importElement.setAttribute("model", "/" + modelImport.getModel().getFullName(true).replace('.', '/') + ".xml");
                newImportElements.add(importElement);
            }
            for (Element importElement : Lists.reverse(newImportElements)) {
                if (firstNode.getNodeName().equals("documentation")) {
                    if (modelElement.getChildNodes().getLength() > 1) {
                        modelElement.insertBefore(importElement, modelElement.getChildNodes().item(1));
                        continue;
                    }
                    modelElement.insertBefore(importElement, modelElement.getChildNodes().item(0));
                    continue;
                }
                modelElement.insertBefore(importElement, modelElement.getFirstChild());
            }
        }
        NodeList directivesElements = clonedDocument.getElementsByTagName("directives");
        elementsToRemove = new ArrayList();
        for (int i = 0; i < directivesElements.getLength(); ++i) {
            elementsToRemove.add(directivesElements.item(i));
        }
        for (Node node : elementsToRemove) {
            modelElement.removeChild(node);
        }
        Element directivesElement = clonedDocument.createElement("directives");
        for (Map.Entry entry : this.directives.getParameters().entrySet()) {
            if (((CgBuildParameters.AdmParameter)entry.getValue()).getAdditionalData().containsKey("transient")) continue;
            Element directiveElement = clonedDocument.createElement((String)entry.getKey());
            String strValue = ((CgBuildParameters.AdmParameter)entry.getValue()).getValueAsString(null);
            if (strValue == null) continue;
            Text value = clonedDocument.createTextNode(strValue);
            directiveElement.appendChild(value);
            directivesElement.appendChild(directiveElement);
        }
        if (directivesElement.hasChildNodes()) {
            if (modelElement.getChildNodes().getLength() > 0) {
                if (firstNode.getNodeName().equals("documentation")) {
                    if (modelElement.getChildNodes().getLength() > 1) {
                        modelElement.insertBefore(directivesElement, modelElement.getChildNodes().item(1));
                    } else {
                        modelElement.insertBefore(directivesElement, modelElement.getChildNodes().item(0));
                    }
                } else {
                    modelElement.insertBefore(directivesElement, modelElement.getFirstChild());
                }
            } else {
                modelElement.appendChild(directivesElement);
            }
        }
        return clonedDocument;
    }

    public final CgSourceCodeErrorAggregator getModelBuildErrorAggregator() {
        return this.modelBuildErrorAggregator;
    }

    static {
        RESERVED_TYPE_NAMES.add("Boolean");
        RESERVED_TYPE_NAMES.add("Byte");
        RESERVED_TYPE_NAMES.add("Character");
        RESERVED_TYPE_NAMES.add("Class");
        RESERVED_TYPE_NAMES.add("ClassLoader");
        RESERVED_TYPE_NAMES.add("ClassValue");
        RESERVED_TYPE_NAMES.add("Compiler");
        RESERVED_TYPE_NAMES.add("Double");
        RESERVED_TYPE_NAMES.add("Enum");
        RESERVED_TYPE_NAMES.add("Float");
        RESERVED_TYPE_NAMES.add("InheritableThreadLocal");
        RESERVED_TYPE_NAMES.add("Integer");
        RESERVED_TYPE_NAMES.add("Long");
        RESERVED_TYPE_NAMES.add("Math");
        RESERVED_TYPE_NAMES.add("Number");
        RESERVED_TYPE_NAMES.add("Object");
        RESERVED_TYPE_NAMES.add("Package");
        RESERVED_TYPE_NAMES.add("Process");
        RESERVED_TYPE_NAMES.add("ProcessBuilder");
        RESERVED_TYPE_NAMES.add("Runtime");
        RESERVED_TYPE_NAMES.add("RuntimePermission");
        RESERVED_TYPE_NAMES.add("SecurityManager");
        RESERVED_TYPE_NAMES.add("Short");
        RESERVED_TYPE_NAMES.add("StackTraceElement");
        RESERVED_TYPE_NAMES.add("StrictMath");
        RESERVED_TYPE_NAMES.add("String");
        RESERVED_TYPE_NAMES.add("StringBuffer");
        RESERVED_TYPE_NAMES.add("StringBuilder");
        RESERVED_TYPE_NAMES.add("System");
        RESERVED_TYPE_NAMES.add("Thread");
        RESERVED_TYPE_NAMES.add("ThreadGroup");
        RESERVED_TYPE_NAMES.add("ThreadLocal");
        RESERVED_TYPE_NAMES.add("Throwable");
        RESERVED_TYPE_NAMES.add("Void");
        for (AdmPrimitive.Type type : AdmPrimitive.Type.values()) {
            RESERVED_TYPE_NAMES.add(type.getJavaTypeName());
        }
    }

    private class IdlParser {
        String qualifiedName;
        String packageName;
        String modelName;
        HashSet<String> imports = new HashSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IdlParser(File idlFile) throws IOException {
            this.modelName = idlFile.getName();
            if (this.modelName.endsWith(".proto")) {
                this.modelName = this.modelName.substring(0, this.modelName.length() - 6);
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(idlFile));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("package")) {
                        this.packageName = line.substring("package".length());
                        this.packageName = this.packageName.trim();
                        this.packageName = this.packageName.substring(0, this.packageName.length() - 1);
                        continue;
                    }
                    if (!line.startsWith("import")) continue;
                    String importName = line.substring("import".length());
                    importName = importName.trim();
                    importName = importName.substring(0, importName.length() - 1);
                    while (importName.startsWith("\"") && importName.endsWith("\"")) {
                        importName = importName.substring(1, importName.length() - 1);
                    }
                    this.imports.add(importName);
                }
            }
            if (this.packageName == null) {
                this.packageName = "";
                this.qualifiedName = this.modelName;
            } else {
                this.qualifiedName = this.packageName + "." + this.modelName;
            }
            AdmModel.this.tracer.log("Parsed import idl '" + idlFile + "' qualifiedName: " + this.qualifiedName + ", imports: " + this.imports, Tracer.Level.DEBUG);
        }
    }

    private final class ProtobufIDLGenerationInfo {
        File importIdlTempFolder;
        File importedIdlOutputFolder;
        String idlFullFilename;

        private ProtobufIDLGenerationInfo() {
        }
    }

    public static enum PooledStringFieldTypeNameSuffixPolicy {
        Always,
        OnConflict,
        None;

    }

    private static final class StringToNullArrayElementPolicyConverter
    implements CgBuildParameters.ArgumentValueConverter {
        private StringToNullArrayElementPolicyConverter() {
        }

        public Object convertValue(Object value) throws Exception {
            Object retVal = value;
            if (value != null && !(value instanceof AdmEntity.NullArrayElementPolicy)) {
                retVal = AdmEntity.NullArrayElementPolicy.valueOf(value.toString());
            }
            return retVal;
        }
    }

    private static final class StringToPooledStringFieldTypeNameSuffixPolicyConverter
    implements CgBuildParameters.ArgumentValueConverter {
        private StringToPooledStringFieldTypeNameSuffixPolicyConverter() {
        }

        public Object convertValue(Object value) throws Exception {
            Object retVal = value;
            if (value != null && !(value instanceof PooledStringFieldTypeNameSuffixPolicy)) {
                retVal = PooledStringFieldTypeNameSuffixPolicy.valueOf(value.toString());
            }
            return retVal;
        }
    }
}

