/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmJsonGenerator;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmPooledString;
import com.neeve.adm.AdmProtobufGenerator;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.AdmString;
import com.neeve.adm.AdmTransactionalType;
import com.neeve.adm.AdmType;
import com.neeve.adm.AdmXbuf2Generator;
import com.neeve.adm.AdmXbufGenerator;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.util.UtlLinkedHashMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class AdmEntity
extends AdmTransactionalType {
    private final LinkedHashMap<String, AdmEntity> inlines = new LinkedHashMap();
    private final LinkedHashMap<String, AdmField> fields = new LinkedHashMap();
    private final HashSet<AdmCollection.Type> containedInSet = new HashSet();
    private final AdmType parent;
    private boolean containsChildren;
    private boolean isRoot;
    private boolean isEmbedded;
    private boolean isPojoShadow;
    private String pojoClassname;
    private FieldOrderingPolicy fieldOrderingPolicy;

    public AdmEntity(AdmModel model, String namespace, String name, AdmType parent, AdmFactory factory, int id, boolean transactional, FieldOrderingPolicy fieldOrderingPolicy) throws EAdmException {
        super(model, namespace, name, factory, id, transactional);
        this.parent = parent;
        if (parent != null) {
            throw new IllegalArgumentException("entity inheritence is currently not supported");
        }
        this.fieldOrderingPolicy = fieldOrderingPolicy == null ? FieldOrderingPolicy.FixedLengthFirst : fieldOrderingPolicy;
    }

    public AdmEntity(AdmModel model, String namespace, String name, AdmType parent, AdmFactory factory, int id, boolean transactional) throws EAdmException {
        this(model, namespace, name, parent, factory, id, transactional, null);
    }

    final void generateProtobufIDL(PrintWriter writer, AdmEncodingType encodingType, AdmEncodingType protoXbufGenCompatibility) throws EAdmException {
        try {
            switch (encodingType) {
                case Protobuf: 
                case Xbuf: 
                case Xbuf2: {
                    new AdmProtobufGenerator().generateProtobufIDL(this, protoXbufGenCompatibility, writer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown encoding type '" + (Object)((Object)encodingType) + "'");
                }
            }
        }
        catch (RuntimeException re) {
            throw new EAdmException("Error generating protobuf IDL for '" + this.getFullName() + "': ", re);
        }
    }

    final void generateInterface(boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) throws Exception {
        try {
            codeBuilder.header().appendln("/**");
            codeBuilder.header().appendln(" * ******************************************************************");
            codeBuilder.header().appendln(" * *** THIS FILE IS GENERATED BY X PLATFORM CODE GENERATION TOOLS ***");
            codeBuilder.header().appendln(" * ******************************************************************");
            codeBuilder.header().append(" */");
            codeBuilder.packageName(this.getNamespace());
            new AdmGenerator().generateInterface(this, generateArrayGetterEmptyIfNull, codeBuilder);
        }
        catch (Exception e) {
            throw new EAdmException("Error generating interface for '" + this.getFullName() + "': ", e);
        }
    }

    final void generateInterface(File baseOutDir, boolean generateArrayGetterEmptyIfNull, boolean absolute) throws Exception {
        if (!this.getGenerateEmbeddedEntityInterfaces() && this.isEmbedded()) {
            throw new IllegalStateException("interfaces are not generated for embedded entities");
        }
        File file = AdmModel.resolveAbsoluteClassFile(baseOutDir, absolute ? null : this.getNamespace(), AdmEntity.interfaceName(this));
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        try {
            AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
            this.generateInterface(generateArrayGetterEmptyIfNull, codeBuilder);
            codeBuilder.write(file);
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create entity interface file '" + file.getPath() + "' [" + e.toString() + "]");
        }
    }

    final void validateFieldCanBeAdded(AdmField field, boolean fromInline) throws EAdmException {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (field.getName() == null) {
            throw new IllegalArgumentException("field must have a name before being added to a message type");
        }
        if (this.getField(field.getName()) != null) {
            throw new EAdmException("duplicate field '" + field.getName() + "' in '" + this.getName() + "'", this.getCodeSource());
        }
        if (this.isEmbedded()) {
            if (field.getType() instanceof AdmEntity && !((AdmEntity)field.getType()).isEmbedded()) {
                throw new EAdmException("an entity designated as a field ('" + this.getName() + "') cannot contain other entities that are not declared as embedded, but field '" + field.getName() + "' is a non embedded entity ('" + field.getType().getName() + "')", this.getCodeSource());
            }
            if (field.getType() instanceof AdmCollection) {
                throw new EAdmException("an entity designated as a field ('" + this.getName() + "') cannot contain collections, but field '" + field.getName() + "' is a collection type ('" + field.getType().getName() + "')", this.getCodeSource());
            }
        }
        if (this.isMessage() && field.getType() instanceof AdmEntity && !((AdmEntity)field.getType()).isEmbedded()) {
            throw new EAdmException("Message '" + this.getName() + "' cannot declare a non embedded nested field, but field '" + field.getName() + "' is a non embedded entity '(" + field.getType().getName() + "')", this.getCodeSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void generateInterface(Filer filer, Element ... elements) throws Exception {
        JavaFileObject jfo = filer.createSourceFile(AdmEntity.interfaceName(this), elements);
        try {
            AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
            try (Writer writer = jfo.openWriter();){
                this.generateInterface(false, codeBuilder);
                codeBuilder.write(writer);
            }
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create entity interface file '" + jfo.toUri() + "' [" + e.toString() + "]", this.getCodeSource());
        }
    }

    final void generateClass(AdmSourceCodeBuilder codeBuilder, AdmEncodingType encodingType, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull) throws Exception {
        codeBuilder.header().appendln("/**");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().appendln(" * *** THIS FILE IS GENERATED BY X PLATFORM CODE GENERATION TOOLS ***");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().append(" */");
        codeBuilder.packageName(this.getNamespace());
        switch (encodingType) {
            case Xbuf: {
                new AdmXbufGenerator().generateClass(this, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull, codeBuilder);
                break;
            }
            case Xbuf2: {
                new AdmXbuf2Generator().generateClass(this, generateArrayGetterEmptyIfNull, codeBuilder);
                break;
            }
            case Protobuf: {
                new AdmProtobufGenerator().generateClass(this, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull, codeBuilder);
                break;
            }
            case Json: {
                new AdmJsonGenerator().generateClass(this, generateArrayGetterEmptyIfNull, codeBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown encoding type '" + (Object)((Object)encodingType) + "'");
            }
        }
    }

    final void generateClass(File baseOutDir, AdmEncodingType encodingType, boolean absolute, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull) throws Exception {
        File file = AdmModel.resolveAbsoluteClassFile(baseOutDir, absolute ? null : this.getNamespace(), this.getName());
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        try {
            AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
            this.generateClass(codeBuilder, encodingType, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull);
            codeBuilder.write(file);
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create entity class file '" + file.getPath() + "' [" + e.toString() + "]", (Throwable)e, this.getCodeSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void generateClass(Filer filer, Element ... elements) throws Exception {
        JavaFileObject jfo = filer.createSourceFile(this.getName(), elements);
        try {
            AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
            try (Writer writer = jfo.openWriter();){
                this.generateClass(codeBuilder, AdmEncodingType.Xbuf, null, false);
                codeBuilder.write(writer);
            }
        }
        catch (Exception e) {
            throw new EAdmException("Failed to create entity class file '" + jfo.toUri() + "' [" + e.toString() + "]", (Throwable)e, this.getCodeSource());
        }
    }

    public final NullArrayElementPolicy getNullEntityArrayElementPolicy() {
        return this.getModel().getNullEntityArrayFieldHandlingPolicy();
    }

    public final NullArrayElementPolicy getNullPrimitiveArrayElementPolicy() {
        return this.getModel().getNullPrimitiveArrayFieldHandlingPolicy();
    }

    public void setAsRoot() throws EAdmException {
        if (this.isEmbedded()) {
            throw new EAdmException("embedded entities cannot be designated as root", this.getCodeSource());
        }
        this.isRoot = true;
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public final boolean containsChildren() {
        return this.containsChildren;
    }

    @Deprecated
    public void setAsField() {
        this.setAsEmbedded();
    }

    @Deprecated
    public final boolean isField() {
        return this.isEmbedded();
    }

    public void setAsEmbedded() {
        if (this.isRoot()) {
            throw new IllegalStateException("root entities cannot be embedded");
        }
        this.isEmbedded = true;
    }

    public final boolean isEmbedded() {
        return this.isEmbedded;
    }

    public final void setAsPojoShadow(String classname) {
        if (classname == null) {
            throw new IllegalArgumentException("POJO class name cannot be null");
        }
        this.isPojoShadow = true;
        this.pojoClassname = classname;
    }

    public final boolean isPojoShadow() {
        return this.isPojoShadow;
    }

    public final String pojoClassname() {
        return this.pojoClassname;
    }

    public boolean isMessage() {
        return false;
    }

    public final boolean isFinal() {
        return !this.isEmbedded || !this.getGenerateEmbeddedEntitiesNonFinal();
    }

    public final AdmType getParent() {
        return this.parent;
    }

    public final AdmEntity addField(AdmField field) throws EAdmException {
        this.validateFieldCanBeAdded(field, true);
        this.containsChildren |= field.getType() instanceof AdmCollection || field.getType() instanceof AdmEntity && !((AdmEntity)field.getType()).isEmbedded();
        this.fields.put(field.getName(), field);
        return this;
    }

    public final AdmField getField(String name) {
        if (name == null) {
            throw new IllegalArgumentException("field name cannot be null");
        }
        return this.fields.get(name);
    }

    public final Collection<AdmField> getFields() {
        return this.fields.values();
    }

    public final AdmEntity inline(AdmEntity inline) throws EAdmException {
        if (inline == null) {
            throw new IllegalArgumentException("inlined entity cannot be null");
        }
        if (inline.getFullName() == null) {
            throw new IllegalArgumentException("inline entity must have a name before being added to a entity type");
        }
        if (this.inlines.get(inline.getFullName()) != null) {
            return this;
        }
        if (!inline.isEmbedded()) {
            throw new EAdmException("'" + this.getName() + "' can't inline type '" + inline.getName() + "', only embedded entities can be inlined.", this.getCodeSource());
        }
        this.inlines.put(inline.getFullName(), inline);
        return this;
    }

    public final Collection<AdmEntity> getInlined() {
        return new HashSet<AdmEntity>(this.inlines.values());
    }

    public final AdmField findKey(Class<?> type) {
        for (AdmField field : this.fields.values()) {
            if (!field.isKey()) continue;
            if (type.isInstance((Object)field.getType())) {
                return field;
            }
            if (type != AdmString.class || !(field.getType() instanceof AdmPooledString)) continue;
            return field;
        }
        return null;
    }

    public final Map<String, AdmField> fields() {
        return this.fields;
    }

    public final AdmEntity setContainedIn(AdmCollection.Type collectionType) {
        this.containedInSet.add(collectionType);
        return this;
    }

    public final Set<AdmCollection.Type> containedInSet() {
        return this.containedInSet;
    }

    public final FieldOrderingPolicy fieldOrderingPolicy() {
        return this.fieldOrderingPolicy;
    }

    public boolean validate(StringBuilder summary, CgSourceCodeErrorAggregator aggregator) {
        boolean valid = true;
        XIntLinkedHashMap fieldsById = new XIntLinkedHashMap();
        UtlLinkedHashMap entityFieldsByType = new UtlLinkedHashMap();
        for (AdmField field : this.fields().values()) {
            if (fieldsById.containsKey((int)field.getId())) {
                AdmField existing = (AdmField)fieldsById.get((int)field.getId());
                if (!existing.isPinned() || !field.isPinned()) {
                    summary.append("-Conflicting field ids in '").append(this.getFullName()).append("': fields '");
                    summary.append(field.getName()).append("' and field '").append(((AdmField)fieldsById.get((int)field.getId())).getName()).append("' ");
                    summary.append("both have a field id of '").append(field.getId()).append("'").append("\n");
                    summary.append(field.getCodeSource());
                    if (aggregator != null) {
                        aggregator.add("Conflicting field ids in " + this.getFullName() + ": fields '" + field.getName() + "' and '" + ((AdmField)fieldsById.get((int)field.getId())).getName() + "' both have a field id of '" + field.getId() + "'", CgSourceCodeErrorAggregator.Severity.ERROR, field.getCodeSource(), null);
                    }
                    valid = false;
                }
            } else {
                fieldsById.put((int)field.getId(), (Object)field);
            }
            if (field.isEmbedded()) continue;
            if (!entityFieldsByType.containsKey((Object)field.getType().getFullName())) {
                entityFieldsByType.put((Object)field.getType().getFullName(), (Object)field);
                continue;
            }
            summary.append("-Duplicate entity fields of the same type '").append(this.getFullName()).append("': fields '");
            summary.append(field.getName()).append("' and field '").append(((AdmField)fieldsById.get((int)field.getId())).getName()).append("' ");
            summary.append("are both of type '").append(field.getType().getFullName()).append("'. An entity cannot have two non embedded entity fields of the same type.").append("\n");
            summary.append(field.getCodeSource());
            if (aggregator != null) {
                aggregator.add("Duplicate entity fields of the same type in " + this.getFullName() + ": fields '" + field.getName() + "' and '" + ((AdmField)fieldsById.get((int)field.getId())).getName() + "' are both of type '" + field.getType().getFullName() + "'. An entity cannot have two non embedded entity fields of the same type.", CgSourceCodeErrorAggregator.Severity.ERROR, field.getCodeSource(), null);
            }
            valid = false;
        }
        return valid;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getNamespace() + "." + this.getName() + ", id: " + this.getId() + ", embedded: " + this.isEmbedded() + ", numFields=" + this.fields.size() + ", fieldOrder=" + (Object)((Object)this.fieldOrderingPolicy) + "]";
    }

    public static enum NullArrayElementPolicy {
        Throw,
        Ignore,
        IgnoreUnlessSupported;

    }

    public static enum FieldOrderingPolicy {
        FixedLengthFirst,
        AsBuilt,
        ByFieldId,
        OptimizeForSpeed;

    }
}

