/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmByte;
import com.neeve.adm.AdmChar;
import com.neeve.adm.AdmDeprecation;
import com.neeve.adm.AdmDouble;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmFloat;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmInteger;
import com.neeve.adm.AdmJsonGenerator;
import com.neeve.adm.AdmLong;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmProtobufGenerator;
import com.neeve.adm.AdmShort;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.AdmString;
import com.neeve.adm.AdmTransactionalType;
import com.neeve.adm.AdmType;
import com.neeve.adm.AdmXbuf2Generator;
import com.neeve.adm.AdmXbufGenerator;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgCodeSource;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public final class AdmCollection
extends AdmTransactionalType {
    private final Type type;
    private final AdmEntity contains;
    final AdmField keyField;
    final AdmType keyType;

    @Deprecated
    public AdmCollection(AdmModel model, String namespace, String name, Type type, AdmEntity contains, AdmFactory factory, int id, boolean transactional) throws EAdmException {
        this(model, namespace, name, type, contains, factory, id, transactional, null);
    }

    public AdmCollection(AdmModel model, String namespace, String name, Type type, AdmEntity contains, AdmFactory factory, int id, boolean transactional, CgCodeSource codeSource) throws EAdmException {
        super(model, namespace, name, factory, id, transactional);
        this.setCodeSource(codeSource);
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.contains = contains;
        if (this.contains.isEmbedded()) {
            throw new EAdmException("type ('" + this.contains.getName() + "') contained in a collection cannot be designated as 'embedded'", this.getCodeSource());
        }
        this.type = type;
        if (type == Type.StringMap) {
            this.keyType = AdmPrimitive.toPrimitiveType(AdmPrimitive.Type.String);
            this.keyField = contains.findKey(((Object)((Object)new AdmString())).getClass());
            if (this.keyField != null) {
                this.keyField.setUsedAsKey();
            }
        } else if (type == Type.ByteMap) {
            this.keyType = AdmPrimitive.toPrimitiveType(AdmPrimitive.Type.Byte);
            this.keyField = contains.findKey(((Object)((Object)new AdmByte())).getClass());
            if (this.keyField != null) {
                this.keyField.setUsedAsKey();
            }
        } else if (type == Type.CharMap) {
            this.keyType = AdmPrimitive.toPrimitiveType(AdmPrimitive.Type.Char);
            this.keyField = contains.findKey(((Object)((Object)new AdmChar())).getClass());
            if (this.keyField != null) {
                this.keyField.setUsedAsKey();
            }
        } else if (type == Type.ShortMap) {
            this.keyType = AdmPrimitive.toPrimitiveType(AdmPrimitive.Type.Short);
            this.keyField = contains.findKey(((Object)((Object)new AdmShort())).getClass());
            if (this.keyField != null) {
                this.keyField.setUsedAsKey();
            }
        } else if (type == Type.IntMap) {
            this.keyType = AdmPrimitive.toPrimitiveType(AdmPrimitive.Type.Integer);
            this.keyField = contains.findKey(((Object)((Object)new AdmInteger())).getClass());
            if (this.keyField != null) {
                this.keyField.setUsedAsKey();
            }
        } else if (type == Type.LongMap) {
            this.keyType = AdmPrimitive.toPrimitiveType(AdmPrimitive.Type.Long);
            this.keyField = contains.findKey(((Object)((Object)new AdmLong())).getClass());
            if (this.keyField != null) {
                this.keyField.setUsedAsKey();
            }
        } else if (type == Type.FloatMap) {
            this.keyType = AdmPrimitive.toPrimitiveType(AdmPrimitive.Type.Float);
            this.keyField = contains.findKey(((Object)((Object)new AdmFloat())).getClass());
            if (this.keyField != null) {
                this.keyField.setUsedAsKey();
            }
        } else if (type == Type.DoubleMap) {
            this.keyType = AdmPrimitive.toPrimitiveType(AdmPrimitive.Type.Double);
            this.keyField = contains.findKey(((Object)((Object)new AdmDouble())).getClass());
            if (this.keyField != null) {
                this.keyField.setUsedAsKey();
            }
        } else {
            this.keyType = null;
            this.keyField = null;
        }
        if (this.keyType != null && this.keyField == null && model.getBooleanDirective("requireExplicitCollectionKeys")) {
            String keyFieldName = AdmGenerator.getImplicitKeyFieldNameFor(this.getKeyType());
            throw new EAdmException("No field of type '" + this.getKeyType().getName() + "' that is marked isKey=\"true\" found in '" + contains.getJavaTypeName() + "'. A key field '" + keyFieldName + "' has been added implicitly, but to avoid compatibility problems as the model evolves it is strongly recommended  that the key field be defined explicitly. NOTE: Changing the key field in '" + contains.getJavaTypeName() + "' used asKey can cause existing state to become unrecoverable. To remain compatible with a previous implicitly generated key field id, add the same field name/id as returned by the previously generated source's " + AdmGenerator.fieldGetterMethodName(keyFieldName) + "FieldId() method.", this.getCodeSource());
        }
        this.contains.setContainedIn(type);
    }

    final void generateProtobufIDL(PrintWriter writer, AdmEncodingType encodingType) {
        switch (encodingType) {
            case Protobuf: {
                new AdmProtobufGenerator().generateProtobufIDL(this, writer);
                break;
            }
            case Xbuf: 
            case Xbuf2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown encoding type '" + (Object)((Object)encodingType) + "'");
            }
        }
    }

    final void generateInterface(AdmSourceCodeBuilder codeBuilder) throws Exception {
        codeBuilder.header().appendln("/**");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().appendln(" * *** THIS FILE IS GENERATED BY X PLATFORM CODE GENERATION TOOLS ***");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().append(" */");
        codeBuilder.packageName(this.getNamespace());
        new AdmGenerator().generateInterface(this, codeBuilder);
    }

    final void generateInterface(File baseOutDir, boolean absolute) throws Exception {
        File file = AdmModel.resolveAbsoluteClassFile(baseOutDir, absolute ? null : this.getNamespace(), AdmCollection.interfaceName(this));
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
        try {
            this.generateInterface(codeBuilder);
            codeBuilder.write(file);
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create collection interface file '" + file.getPath() + "' [" + e.toString() + "]", this.getCodeSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void generateInterface(Filer filer, Element ... elements) throws Exception {
        JavaFileObject jfo = filer.createSourceFile(AdmCollection.interfaceName(this), elements);
        AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
        try (Writer writer = jfo.openWriter();){
            this.generateInterface(codeBuilder);
            codeBuilder.write(writer);
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create factory class file '" + jfo.toUri() + "' [" + e.toString() + "]", this.getCodeSource());
        }
    }

    final void generateClass(AdmSourceCodeBuilder codeBuilder, AdmEncodingType encodingType) throws Exception {
        codeBuilder.header().appendln("/**");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().appendln(" * *** THIS FILE IS GENERATED BY X PLATFORM CODE GENERATION TOOLS ***");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().append(" */");
        codeBuilder.packageName(this.getNamespace());
        switch (encodingType) {
            case Xbuf: {
                new AdmXbufGenerator().generateClass(this, codeBuilder);
                break;
            }
            case Xbuf2: {
                new AdmXbuf2Generator().generateClass(this, codeBuilder);
                break;
            }
            case Protobuf: {
                new AdmProtobufGenerator().generateClass(this, codeBuilder);
                break;
            }
            case Json: {
                new AdmJsonGenerator().generateClass(this, codeBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown encoding type '" + (Object)((Object)encodingType) + "'");
            }
        }
        codeBuilder.last().appendln("}");
    }

    final void generateClass(File baseOutDir, AdmEncodingType encodingType, boolean absolute) throws Exception {
        File file = AdmModel.resolveAbsoluteClassFile(baseOutDir, absolute ? null : this.getNamespace(), this.getName());
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        try {
            AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
            this.generateClass(codeBuilder, encodingType);
            codeBuilder.write(file);
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create collection class file '" + file.getPath() + "' [" + e.toString() + "]", this.getCodeSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void generateClass(Filer filer, Element ... elements) throws Exception {
        JavaFileObject jfo = filer.createSourceFile(this.getName(), elements);
        try {
            AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
            try (Writer writer = jfo.openWriter();){
                this.generateClass(codeBuilder, AdmEncodingType.Xbuf);
                codeBuilder.write(writer);
            }
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create factory class file '" + jfo.toUri() + "' [" + e.toString() + "]", this.getCodeSource());
        }
    }

    public final Type getType() {
        return this.type;
    }

    public final AdmEntity getContains() {
        return this.contains;
    }

    public final AdmType getKeyType() {
        return this.keyType;
    }

    public final AdmField getKeyField() {
        return this.keyField;
    }

    @Override
    public final AdmDeprecation getDeprecation() {
        if (super.isDeprecated()) {
            return super.getDeprecation();
        }
        return this.getContains().getDeprecation();
    }

    @Override
    public boolean isDeprecated() {
        return super.isDeprecated() || this.getContains().isDeprecated();
    }

    public static enum Type {
        List,
        Queue,
        ByteMap,
        CharMap,
        ShortMap,
        IntMap,
        LongMap,
        FloatMap,
        DoubleMap,
        StringMap;

    }
}

