/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.test.unit;

import com.neeve.test.UnitTest;
import com.neeve.tools.StatsDumpTool;
import com.neeve.util.UtlFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class StatsDumpToolTest
extends UnitTest {
    private File txnLogDir;
    private String[] toolArgs;

    @Before
    public final void extractStatsDump() throws IOException {
        this.txnLogDir = new File(StatsDumpToolTest.getTestbedRoot(), "rdat");
        File txnLog = new File(this.txnLogDir, "statsdumptest.log");
        File statsDumpOutFile = new File(this.txnLogDir, "statsdumptest.out");
        this.toolArgs = new String[]{"-a", txnLog.getAbsolutePath(), "-o", statsDumpOutFile.getAbsolutePath()};
        UtlFile.copyToFile((InputStream)StatsDumpToolTest.getResourceAsStream("testHeartbeatLoggingServer-heartbeats.log"), (File)txnLog);
        UtlFile.copyToFile((InputStream)StatsDumpToolTest.getResourceAsStream("testHeartbeatLoggingServer-heartbeats.metadata"), (File)new File(this.txnLogDir, "statsdumptest.metadata"));
        UtlFile.copyToFile((InputStream)StatsDumpToolTest.getResourceAsStream("testHeartbeatLoggingServer-heartbeats.factories"), (File)new File(this.txnLogDir, "statsdumptest.factories"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testDumpTool() throws Exception {
        StatsDumpTool tool = new StatsDumpTool();
        tool.run(this.toolArgs);
        BufferedReader expected = new BufferedReader(new InputStreamReader(StatsDumpToolTest.getResourceAsStream("statsdumptest.out")));
        BufferedReader actual = new BufferedReader(new InputStreamReader(new FileInputStream(new File(this.txnLogDir, "statsdumptest.out"))));
        try {
            int line = 1;
            while (true) {
                String expectedLine = expected.readLine();
                String actualLine = actual.readLine();
                Assert.assertEquals((String)("Stats output diverges at line " + line), (Object)expectedLine, (Object)actualLine);
                if (expectedLine == null) {
                    actualLine = actual.readLine();
                    if (actualLine != null) {
                        Assert.fail((String)("Actual Stats output has additional lines: " + actualLine));
                    }
                    break;
                }
                ++line;
            }
        }
        finally {
            expected.close();
            actual.close();
        }
    }

    private static final InputStream getResourceAsStream(String path) {
        InputStream inputStream = StatsDumpToolTest.class.getResourceAsStream(path);
        if (path == null) {
            throw new IllegalStateException("Resource not found: " + path);
        }
        return inputStream;
    }
}

