/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.client.link.ClientLinkManager;
import com.neeve.client.link.ClientLinkManagerEvent;
import com.neeve.client.link.EClientLinkNotPresentException;
import com.neeve.client.link.IClientLinkManagerEventHandler;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkOpTimeoutException;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.link.LnkSTRContainer;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.Close;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.tools.interactive.commands.Dependees;
import com.neeve.tools.interactive.commands.Dependents;
import com.neeve.tools.interactive.commands.EnqueData;
import com.neeve.tools.interactive.commands.EnqueType;
import com.neeve.tools.interactive.commands.Flush;
import com.neeve.tools.interactive.commands.Join;
import com.neeve.tools.interactive.commands.Leave;
import com.neeve.tools.interactive.commands.Links;
import com.neeve.tools.interactive.commands.Open;
import com.neeve.tools.interactive.commands.Roots;
import com.neeve.tools.interactive.commands.StartRead;
import com.neeve.tools.interactive.commands.StartStats;
import com.neeve.tools.interactive.commands.Stats;
import com.neeve.tools.interactive.commands.StopRead;
import com.neeve.tools.interactive.commands.StopStats;

public final class ClientLinkTool
extends ClientLinkManager {
    private final InteractiveTool interactiveTool;
    private final ILnkEventHandler linkEventHandler;

    private ClientLinkTool(String name) throws Exception {
        super(name);
        this.setEventHandler(new ClientLinkManagerEventHandler());
        this.initFromRepository(null);
        this.interactiveTool = new InteractiveTool();
        this.linkEventHandler = new LinkEventHandler();
        this.interactiveTool.registerCommand((Command)new Links((LnkContainer)this));
        this.interactiveTool.registerCommand((Command)new Roots(this));
        this.interactiveTool.registerCommand((Command)new Dependees(this));
        this.interactiveTool.registerCommand((Command)new Dependents(this));
        this.interactiveTool.registerCommand((Command)new Open(this, new Links((LnkContainer)this)));
        this.interactiveTool.registerCommand((Command)new Join((LnkContainer)this, this.linkEventHandler));
        this.interactiveTool.registerCommand((Command)new Leave((LnkContainer)this));
        this.interactiveTool.registerCommand((Command)new StartRead((LnkContainer)this));
        this.interactiveTool.registerCommand((Command)new StopRead((LnkContainer)this));
        this.interactiveTool.registerCommand((Command)new EnqueType((LnkSTRContainer)this));
        this.interactiveTool.registerCommand((Command)new EnqueData((LnkSTRContainer)this));
        this.interactiveTool.registerCommand((Command)new Flush((LnkSTRContainer)this));
        this.interactiveTool.registerCommand((Command)new Close((LnkContainer)this, new Links((LnkContainer)this)));
        this.interactiveTool.registerCommand((Command)new Stats());
        this.interactiveTool.registerCommand((Command)new StartStats());
        this.interactiveTool.registerCommand((Command)new StopStats());
        this.interactiveTool.registerCommand((Command)new Run());
    }

    protected final void run() throws Exception {
        Thread.currentThread().setName("ClientLinkTool Main");
        this.interactiveTool.run();
    }

    public static void main(String[] args) {
        if (args.length <= 1) {
            try {
                new ClientLinkTool(args.length == 1 ? args[0] : "default").run();
            }
            catch (EClientLinkNotPresentException e) {
                System.out.println(e.toString());
            }
            catch (Throwable e) {
                System.out.println("Unhandled fault [" + e + ", " + e.toString() + "]");
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage: ClientLinkTool [name]");
        }
    }

    private final class LinkEventHandler
    implements ILnkEventHandler {
        private LinkEventHandler() {
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            System.out.println("Client Link Event\n{\n type=" + type + "\n data=" + data + "\n source='" + ((ILnkPeerEndpoint)ep).getName() + "'\n}");
        }
    }

    private final class ClientLinkManagerEventHandler
    implements IClientLinkManagerEventHandler {
        private ClientLinkManagerEventHandler() {
        }

        @Override
        public final void onEvent(ClientLinkManager manager, ClientLinkManagerEvent event, Object data) {
            System.out.println("Client Link Manager Event\n{\n type=" + (Object)((Object)event) + "\n data=" + data + "\n source='" + manager.getName() + "'\n}");
        }
    }

    private final class Run
    extends Command {
        private Run() {
        }

        private void processRun(int timeout) {
            System.out.println("Running [" + timeout + "ms]...");
            try {
                ClientLinkTool.this.run(timeout, null);
            }
            catch (ELnkOpTimeoutException eLnkOpTimeoutException) {
            }
            catch (ELnkException eLnkException) {
                // empty catch block
            }
            System.out.println("Done.");
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: run <timeout>");
            } else {
                this.processRun(Integer.parseInt(args[0]));
            }
        }

        public final void help() {
            System.out.println("run <timeout>");
            System.out.println("  Run the tool for a specified amount of time (in milliseconds)");
        }

        public final String[] keywords() {
            return new String[]{"run"};
        }
    }
}

