/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.aep.test.unit.generated.xbuf.ForwarderMessage1;
import com.neeve.aep.test.unit.generated.xbuf.ForwarderMessage2;
import com.neeve.aep.test.unit.generated.xbuf.ReceiverMessage1;
import com.neeve.aep.test.unit.generated.xbuf.ReceiverMessage2;
import com.neeve.lang.XString;
import com.neeve.rog.IRogMessage;
import com.neeve.server.app.annotations.AppHAPolicy;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.test.unit.AbstractAepServerTest;
import com.neeve.server.test.unit.AbstractAepServerTestApp;
import com.neeve.server.test.unit.ChannelJoin;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class SrvAepMessagingTest
extends AbstractAepServerTest {
    @Test
    public final void testPriorityInjectionForwarderAdaptiveBatch() throws Throwable {
        ReceiverApp receiver = SrvAepMessagingTest.createApp("testSenderForwarderAdaptiveBatchTimeoutReceiver", "standalone", ReceiverApp.class);
        HashMap<String, String> overrides = new HashMap<String, String>();
        overrides.put("adaptiveCommitBatchCeiling", "64");
        DelayedPriorityInjectionForwarderApp forwarder = SrvAepMessagingTest.createApp("testSenderForwarderAdaptiveBatchTimeoutForwarder", "standalone", DelayedPriorityInjectionForwarderApp.class, overrides);
        forwarder.injectMessage(forwarder.populateMessage((IRogMessage)ForwarderMessage1.create()));
        forwarder.waitForTransactionStability(2);
        receiver.waitForTransactionStability(2);
        Assert.assertTrue((String)"Receiver didn't receive message in allotted time", (boolean)receiver.waitForMessages(10, 1));
        this.assertSentAndReceivedMessageEqual(forwarder, receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWaypointListenerExceptions() throws Throwable {
        MessageWaypointListenerRegistry.registerMessageWaypointListener((MessageWaypointListener)new MessageWaypointListener(){

            public void onWaypoint(MessageWaypointListener.Waypoint waypoint, MessageWaypointListener.MessagingDirection direction, Object message) {
                System.out.println("Waypoint " + waypoint + " (" + direction + "): " + message);
                throw new RuntimeException("Intentional Exception on Waypoint " + waypoint + " (" + direction + "): (should be caught and ignored)");
            }
        });
        try {
            ReceiverApp receiver = SrvAepMessagingTest.createApp("testWaypointListenerExceptions-receiver", "standalone", ReceiverApp.class);
            HashMap<String, String> overrides = new HashMap<String, String>();
            overrides.put("adaptiveCommitBatchCeiling", "64");
            DelayedPriorityInjectionForwarderApp forwarder = SrvAepMessagingTest.createApp("testWaypointListenerExceptions-forwarder", "standalone", DelayedPriorityInjectionForwarderApp.class, overrides);
            forwarder.injectMessage(forwarder.populateMessage((IRogMessage)ForwarderMessage1.create()));
            forwarder.waitForTransactionStability(2);
            receiver.waitForTransactionStability(2);
            Assert.assertTrue((String)"Receiver didn't receive message in allotted time", (boolean)receiver.waitForMessages(10, 1));
            this.assertSentAndReceivedMessageEqual(forwarder, receiver);
        }
        finally {
            MessageWaypointListenerRegistry.registerMessageWaypointListener(null);
        }
    }

    @Test
    public void testMessageKeyValidation() throws Throwable {
        KeyValidationSenderApp sender = SrvAepMessagingTest.createApp("testMessageKeyValidation-sender", "standalone", KeyValidationSenderApp.class);
        KeyValidationForwarderApp forwarder = SrvAepMessagingTest.createApp("testMessageKeyValidation-forwarder", "standalone", KeyValidationForwarderApp.class);
        KeyValidationReceiverApp receiver = SrvAepMessagingTest.createApp("testMessageKeyValidation-receiver", "standalone", KeyValidationReceiverApp.class);
        String expectedErrorContent = "Empty key level detected in key";
        try {
            ForwarderMessage1 invalidSend = ForwarderMessage1.create();
            invalidSend.setMessageKey("/InvalidEmptyLevel//");
            sender.sendMessage("ForwarderChannel1@aeptest1", (IRogMessage)invalidSend);
            Assert.fail((String)"send should have failed");
        }
        catch (RuntimeException e) {
            System.out.println("Got expected send failure: " + e.getMessage());
            Assert.assertTrue((String)("Wrong error thrown from key validation. Expected '" + expectedErrorContent + "' but was: " + e.getMessage()), (e.getMessage().indexOf(expectedErrorContent) >= 0 ? 1 : 0) != 0);
        }
        sender.sendMessage("ForwarderChannel1@aeptest1", (IRogMessage)ForwarderMessage1.create());
        sender.sendMessage("ForwarderChannel1@aeptest1", (IRogMessage)ForwarderMessage1.create());
        if (!forwarder.waitForMessages(10, 2)) {
            Assert.assertEquals((String)"Forwarder got wrong number of messages", (long)2L, (long)forwarder.receivedMessageCount);
        }
        if (!receiver.waitForMessages(10, 2)) {
            Assert.assertEquals((String)"Receiver got wrong number of messages", (long)1L, (long)receiver.receivedMessageCount);
        }
    }

    static {
        System.setProperty("store.clustering.enabled", "false");
        System.setProperty("nv.sma.validatemessagekey", "true");
        System.setProperty("nv.sma.maxresolvedkeylength", "100");
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    @ChannelJoin(value={"ReceiverChannel1@aeptest1"})
    public static final class KeyValidationReceiverApp
    extends AbstractAepServerTestApp {
        @AppInjectionPoint
        public void onEngineInjected(AepEngine engine) {
            engine.registerFactory((Object)new Factory());
            super.setAepEngine(engine);
        }

        @EventHandler
        public void onReceiverMessage1(ReceiverMessage1 message) {
            System.out.println(new Date() + " Receiver Received message");
            this.recordReceipt((IRogMessage)message);
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    @ChannelJoin(value={"ForwarderChannel1@aeptest1"})
    public static final class KeyValidationForwarderApp
    extends AbstractAepServerTestApp {
        @AppInjectionPoint
        public void onEngineInjected(AepEngine engine) {
            engine.registerFactory((Object)new Factory());
            super.setAepEngine(engine);
        }

        @EventHandler
        public void onForwarder2Message(ForwarderMessage1 message) {
            System.out.println(new Date() + " Forwarder Received message");
            this.recordReceipt((IRogMessage)message);
            ReceiverMessage1 forward = ReceiverMessage1.create();
            forward.setIntField(1);
            if (this.receivedMessageCount >= 1) {
                XString topicTooLong = XString.create((int)150, (boolean)true);
                forward.setMessageKeyAsRaw(topicTooLong);
                this.sendMessage("ReceiverChannel1@aeptest1", (IRogMessage)forward);
            } else {
                this.sendMessage("ReceiverChannel1@aeptest1", (IRogMessage)forward);
            }
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static final class KeyValidationSenderApp
    extends AbstractAepServerTestApp {
        @AppInjectionPoint
        public void onEngineInjected(AepEngine engine) {
            engine.registerFactory((Object)new Factory());
            super.setAepEngine(engine);
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    @ChannelJoin(value={"ForwarderChannel1@aeptest1", "ForwarderChannel2@aeptest1"})
    public static final class DelayedPriorityInjectionForwarderApp
    extends AbstractAepServerTestApp {
        ScheduledExecutorService timer = Executors.newScheduledThreadPool(1);
        volatile int numSent = 0;

        @AppInjectionPoint
        public void onEngineInjected(AepEngine engine) {
            this.timer.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    this.injectMessage((IRogMessage)ForwarderMessage2.create(), false, -1);
                }
            }, 0L, 1L, TimeUnit.SECONDS);
            super.setAepEngine(engine);
            engine.registerFactory((Object)new Factory());
        }

        @EventHandler
        public void onForwarder1Message(ForwarderMessage1 message) {
            System.out.println(new Date() + " FORWARDER Received message");
            this.recordReceipt((IRogMessage)message);
        }

        @EventHandler
        public void onForwarder2Message(ForwarderMessage2 message) {
            while (this.numSent < this.receivedMessageCount) {
                ReceiverMessage1 outbound = ReceiverMessage1.create();
                outbound.setIntField(++this.numSent);
                System.out.println(new Date() + " FORWARDER Sending receiver message: " + this.numSent);
                this.sendMessage("ReceiverChannel1@aeptest1", (IRogMessage)outbound);
            }
        }

        @Override
        public void cleanup() {
            this.timer.shutdown();
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    @ChannelJoin(value={"ReceiverChannel1@aeptest1", "ReceiverChannel2@aeptest1"})
    public static final class ReceiverApp
    extends AbstractAepServerTestApp {
        @AppInjectionPoint
        public void onEngineInjected(AepEngine engine) {
            engine.registerFactory((Object)new Factory());
            super.setAepEngine(engine);
        }

        @EventHandler
        public void onForwarder2Message(ReceiverMessage1 message) {
            System.out.println(new Date() + " RECEIVER Received message");
            this.recordReceipt((IRogMessage)message);
        }

        @EventHandler
        public void onForwarder2Message(ReceiverMessage2 message) {
            System.out.println(new Date() + " RECEIVER Received message");
            this.recordReceipt((IRogMessage)message);
        }
    }
}

