/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.controller;

import com.neeve.util.UtlEnv;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.lang.SystemUtils;

class SrvControllerFileSystemAccessor {
    private static final boolean DISABLE_JDK7_FILE_STORES = UtlEnv.getValue((String)"nv.server.disablejdk7filestats", (boolean)false);
    private static final Method fileStore_getTotalSpace;
    private static final Method fileStore_getUsableSpace;
    private static final FileRoot[] jdk7FileSystemRoots;
    private static final FileRoot[] jdk6FileSystemRoots;

    SrvControllerFileSystemAccessor() {
    }

    static final boolean areEnhandedFileSystemRootsAvailable() {
        return jdk7FileSystemRoots != null;
    }

    static final FileRoot[] getEnhancedFileRootsIfAvailable() {
        return jdk7FileSystemRoots != null ? jdk7FileSystemRoots : jdk6FileSystemRoots;
    }

    static final FileRoot[] getStandardFileRoots() {
        return jdk6FileSystemRoots;
    }

    public static final void main(String[] args) {
        System.out.println("Roots:");
        for (FileRoot root : SrvControllerFileSystemAccessor.getEnhancedFileRootsIfAvailable()) {
            System.out.println("  " + root);
        }
    }

    static {
        Class<?> fileStoreClass = null;
        Method fileStore_getTotalSpaceAttempt = null;
        Method fileStore_getUsableSpaceAttempt = null;
        ArrayList<JDK7FileRoot> fileStores = null;
        try {
            fileStoreClass = Class.forName("java.nio.file.FileStore");
            fileStore_getTotalSpaceAttempt = fileStoreClass.getMethod("getTotalSpace", new Class[0]);
            fileStore_getUsableSpaceAttempt = fileStoreClass.getMethod("getUsableSpace", new Class[0]);
        }
        catch (Throwable throwable) {
            fileStores = null;
        }
        if (fileStore_getTotalSpaceAttempt != null && fileStore_getUsableSpaceAttempt != null) {
            fileStore_getTotalSpace = fileStore_getTotalSpaceAttempt;
            fileStore_getUsableSpace = fileStore_getUsableSpaceAttempt;
        } else {
            fileStore_getTotalSpace = null;
            fileStore_getUsableSpace = null;
        }
        if (!DISABLE_JDK7_FILE_STORES && fileStore_getTotalSpaceAttempt != null && fileStore_getUsableSpaceAttempt != null) {
            try {
                Class<?> fileSystemClass = Class.forName("java.nio.file.FileSystem");
                Class<?> fileSystemsClass = Class.forName("java.nio.file.FileSystems");
                Object defaultFileSystem = fileSystemsClass.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
                if (defaultFileSystem == null) {
                    throw new Exception("Could load default file system");
                }
                Iterable fileStoresIterable = (Iterable)fileSystemClass.getMethod("getFileStores", new Class[0]).invoke(defaultFileSystem, new Object[0]);
                fileStores = new ArrayList<JDK7FileRoot>();
                for (Object fileStore : fileStoresIterable) {
                    JDK7FileRoot root = new JDK7FileRoot(fileStore);
                    root.getPath();
                    root.getTotalSpace();
                    root.getUsableSpace();
                    root.getFreeSpace();
                    if (root.getTotalSpace() <= 0L) continue;
                    fileStores.add(root);
                }
            }
            catch (Throwable throwable) {
                fileStores = null;
            }
        }
        if (fileStores != null) {
            jdk7FileSystemRoots = new FileRoot[fileStores.size()];
            for (int i = 0; i < fileStores.size(); ++i) {
                SrvControllerFileSystemAccessor.jdk7FileSystemRoots[i] = (FileRoot)fileStores.get(i);
            }
        } else {
            jdk7FileSystemRoots = null;
        }
        File[] roots = File.listRoots();
        jdk6FileSystemRoots = new FileRoot[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            SrvControllerFileSystemAccessor.jdk6FileSystemRoots[i] = new JDK6FileRoot(roots[i]);
        }
    }

    private static class JDK7FileRoot
    implements FileRoot {
        final Object fileStore;
        final String rootPath;

        JDK7FileRoot(Object fileStore) {
            int lastClose;
            int lastOpen;
            this.fileStore = fileStore;
            String path = fileStore.toString();
            this.rootPath = SystemUtils.IS_OS_WINDOWS ? ((lastOpen = path.lastIndexOf("(")) < (lastClose = path.lastIndexOf(")")) ? path.substring(lastOpen + 1, lastClose) + "\\" : path) : path.split(" ")[0];
        }

        @Override
        public String getPath() {
            return this.rootPath;
        }

        @Override
        public long getTotalSpace() {
            try {
                return (Long)fileStore_getTotalSpace.invoke(this.fileStore, new Object[0]);
            }
            catch (Throwable thrown) {
                return -1L;
            }
        }

        @Override
        public long getUsableSpace() {
            try {
                return (Long)fileStore_getUsableSpace.invoke(this.fileStore, new Object[0]);
            }
            catch (Throwable thrown) {
                return -1L;
            }
        }

        @Override
        public long getFreeSpace() {
            return this.getUsableSpace();
        }

        public String toString() {
            return "[" + this.fileStore.toString() + "] [root=" + this.getPath() + ", total=" + this.getTotalSpace() + ", usable=" + this.getUsableSpace() + ", free=" + this.getFreeSpace() + "]";
        }
    }

    private static class JDK6FileRoot
    implements FileRoot {
        private final File root;

        JDK6FileRoot(File root) {
            this.root = root;
        }

        @Override
        public String getPath() {
            return this.root.getPath();
        }

        @Override
        public long getTotalSpace() {
            return this.root.getTotalSpace();
        }

        @Override
        public long getUsableSpace() {
            return this.root.getUsableSpace();
        }

        @Override
        public long getFreeSpace() {
            return this.root.getFreeSpace();
        }

        public String toString() {
            return "[" + this.root.toString() + "] [root=" + this.getPath() + ", total=" + this.getTotalSpace() + ", usable=" + this.getUsableSpace() + ", free=" + this.getFreeSpace() + "]";
        }
    }

    public static interface FileRoot {
        public String getPath();

        public long getTotalSpace();

        public long getUsableSpace();

        public long getFreeSpace();
    }
}

