/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.controller;

import com.neeve.aep.AepBusManager;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.AepEventDispatcher;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepClientConnectedEvent;
import com.neeve.aep.event.AepClientDisconnectedEvent;
import com.neeve.aep.event.AepClientPacketEvent;
import com.neeve.aep.event.AepUnhandledMessageEvent;
import com.neeve.ci.XRuntime;
import com.neeve.cli.annotations.Argument;
import com.neeve.cli.annotations.Command;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogMessage;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.annotations.AppCommandHandlerContainersAccessor;
import com.neeve.server.app.annotations.AppEventHandlerAccessor;
import com.neeve.server.app.annotations.AppEventHandlerContainersAccessor;
import com.neeve.server.app.annotations.AppInitializer;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.app.annotations.AppVersion;
import com.neeve.server.controller.SrvController;
import com.neeve.server.controller.SrvControllerAdminClient;
import com.neeve.server.controller.SrvControllerAdminSmaClientContext;
import com.neeve.server.controller.SrvControllerObject;
import com.neeve.server.mon.SrvMonFactory;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.alert.SrvMonAlertFactory;
import com.neeve.server.mon.cnc.ISrvMonXvmRequest;
import com.neeve.server.mon.cnc.ISrvMonXvmResponse;
import com.neeve.server.mon.cnc.SrvMonCncFactory;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.common.ISrvMonEvent;
import com.neeve.server.mon.common.SrvMonCommonFactory;
import com.neeve.server.mon.lifecycle.SrvMonLifecycleFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageViewFactory;
import com.neeve.trace.Tracer;
import com.neeve.trace.TracerRegistry;
import com.neeve.util.UtlGc;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@AppVersion(value=1)
public final class SrvControllerAdminApp
extends SrvControllerObject {
    private final Map<MessageChannel, SrvControllerAdminClient> clients;
    private final IEventHandler eventHandler = new AdminAppEventHandler();
    private final AppAdminCommandHandlers appAdminCommandHandlers = new AppAdminCommandHandlers();
    private final ServerAdminCommandHandlers serverAdminCommandHandlers = new ServerAdminCommandHandlers();
    private SrvAppLoader loader;
    private SrvControllerAdminSmaClientContext smaClientContext;
    private AepEngine engine;
    private SrvController controller;
    private Tracer packetTracer;

    public SrvControllerAdminApp() {
        this.clients = new HashMap<MessageChannel, SrvControllerAdminClient>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onClientPacket(AepClientPacketEvent packetEvent) {
        SrvControllerAdminClient client;
        MessageChannel channel = packetEvent.getClient();
        Map<MessageChannel, SrvControllerAdminClient> map = this.clients;
        synchronized (map) {
            client = this.clients.get(channel);
        }
        PktPacket packet = packetEvent.getPacket();
        if (this.packetTracer.debug) {
            this.packetTracer.log("[PTRACE.APP." + this.loader.getAppName() + "<-] " + packet.getHeader(), Tracer.Level.DEBUG);
        }
        if (client != null) {
            client.onAdminPacket(packet);
        } else {
            this.tracer.log("Received packet " + packet + " from an unknown client [" + channel.getName() + "]. Dropping packet...", Tracer.Level.WARNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onClientConnected(AepClientConnectedEvent clientConnectedEvent) {
        MessageChannel channel = clientConnectedEvent.getClient();
        this.tracer.log("Admin client '" + channel + "' has connected.", Tracer.Level.INFO);
        Map<MessageChannel, SrvControllerAdminClient> map = this.clients;
        synchronized (map) {
            SrvControllerAdminClient client = new SrvControllerAdminClient(this.controller, this.engine, channel);
            this.clients.put(channel, client);
            this.controller.onClientConnect(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onClientDisconnected(AepClientDisconnectedEvent clientDisconnectedEvent) {
        SrvControllerAdminClient client;
        MessageChannel channel = clientDisconnectedEvent.getClient();
        Map<MessageChannel, SrvControllerAdminClient> map = this.clients;
        synchronized (map) {
            client = this.clients.remove(channel);
        }
        boolean graceful = true;
        for (AepBusManager bm : this.engine.getBusManagers()) {
            if (!bm.getBusBinding().getName().startsWith("client-")) continue;
            if (this.tracer.debug) {
                this.tracer.log("Flushing admin client bus on app client disconnect", Tracer.Level.DEBUG);
            }
            try {
                bm.getBusBinding().flush(null);
            }
            catch (Exception e) {
                graceful = false;
                if (!this.tracer.fine) continue;
                this.tracer.log("Error flushing admin client bus on client disconnect " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.FINE);
            }
        }
        if (client != null) {
            block11: {
                try {
                    client.close();
                }
                catch (Exception e) {
                    graceful = false;
                    if (!this.tracer.fine) break block11;
                    this.tracer.log("Error flushing admin client bus on client disconnect " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.FINE);
                }
            }
            this.controller.onClientDisconnect(client);
            this.tracer.log("Admin client '" + channel + "' has disconnected" + (graceful ? "." : " (ungracefully)."), Tracer.Level.INFO);
        } else {
            this.tracer.log("Received a disconnect for non-connected admin client " + channel + ".", Tracer.Level.WARNING);
        }
    }

    @AppInjectionPoint
    public final void setAppLoader(SrvAppLoader loader) {
        this.loader = loader;
        this.smaClientContext = new SrvControllerAdminSmaClientContext(loader);
        this.controller = SrvController.getInstance(loader.getServerDescriptor());
    }

    @AppInitializer
    public final void init() {
        this.controller = SrvController.getInstance(this.loader.getServerDescriptor());
        this.packetTracer = this.controller.getPacketTracer();
    }

    @AppEventHandlerAccessor
    public final IEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @AppCommandHandlerContainersAccessor
    final void addCommandHandlerContainers(Set<Object> containers) {
        containers.add(this.appAdminCommandHandlers);
        containers.add(this.serverAdminCommandHandlers);
        containers.add(this.smaClientContext);
    }

    @AppEventHandlerContainersAccessor
    final void addEventHandlerContainers(Set<Object> containers) {
        containers.add(this.appAdminCommandHandlers);
        containers.add(this.serverAdminCommandHandlers);
        containers.add(this.smaClientContext);
    }

    @AppInjectionPoint
    public final void setAppEngineDescriptor(AepEngineDescriptor descriptor) throws Exception {
        descriptor.setAdministrative(true);
        if (XRuntime.getValue((String)"nv.server.adminappmultiplexsends", (boolean)true)) {
            descriptor.setSequenceUnsolicitedWithSolicitedSends(true);
            if (descriptor.getEventMultiplexerProperties().getProperty("maxFeederConcurrency") == null) {
                descriptor.getEventMultiplexerProperties().setProperty("maxFeederConcurrency", XRuntime.getValue((String)"nv.server.admin.app.maxFeederConcurrency", (String)"32"));
            }
        }
        this.smaClientContext.onAdminAppEngineDecriptorInjected(descriptor);
    }

    @AppInjectionPoint
    public final void setAppEngine(AepEngine engine) {
        this.engine = engine;
        this.engine.getEventDispatcher().setDefaultHandlerDispatchPolicy(AepEventDispatcher.DefaultHandlerDispatchPolicy.DispatchAlways);
        this.engine.setMessageSendExceptionHandlingPolicy(AepEngine.MessageSendExceptionHandlingPolicy.LogExceptionAndContinue);
        engine.registerMessageFactory((MessageViewFactory)new SrvMonCommonFactory());
        engine.registerMessageFactory((MessageViewFactory)new SrvMonCncFactory());
        engine.registerMessageFactory((MessageViewFactory)new SrvMonFactory());
        engine.registerMessageFactory((MessageViewFactory)new SrvMonAlertFactory());
        engine.registerMessageFactory((MessageViewFactory)new SrvMonLifecycleFactory());
        this.smaClientContext.onAdminAppEngineInjected(engine);
        if (this.tracer.getLevel().val <= Tracer.Level.CONFIG.val) {
            this.tracer.log(engine.getDescriptor().toString(), Tracer.Level.CONFIG);
            this.tracer.log("Admin App Buses {", Tracer.Level.CONFIG);
            Iterator busManagers = engine.getBusManagers().iterator();
            while (busManagers.hasNext()) {
                MessageBusDescriptor busDescriptor = ((AepBusManager)busManagers.next()).getBusDescriptor();
                try {
                    this.tracer.log("..." + busDescriptor.getName() + ": " + busDescriptor.getProviderConfigAsAddressDescriptor().toFullString(), Tracer.Level.CONFIG);
                }
                catch (Throwable thrown) {
                    this.tracer.log("..." + busDescriptor.getName() + ": Provider address error: " + thrown.getMessage(), Tracer.Level.WARNING);
                }
            }
            this.tracer.log("}", Tracer.Level.INFO);
        }
    }

    final void publishTraceRecord(SrvMonTraceRecord traceRecord) {
        if (this.smaClientContext != null) {
            this.smaClientContext.publishTraceRecord(traceRecord);
        } else {
            traceRecord.dispose();
        }
    }

    final void publishHeartbeat(SrvMonHeartbeatMessage heartbeat) {
        if (this.smaClientContext != null) {
            this.smaClientContext.publishHeartbeat(heartbeat);
        } else {
            heartbeat.dispose();
        }
    }

    final <RequestType extends IRogMessage & ISrvMonEvent> void publishEvent(RequestType event) {
        if (this.smaClientContext != null) {
            this.smaClientContext.publishEvent(event, true, false);
        } else {
            event.dispose();
        }
    }

    @EventHandler
    public final void onUnhandledMessageEvent(AepUnhandledMessageEvent event) {
        this.tracer.log("Received unhandled admin request: " + event.getTriggeringMessage(), Tracer.Level.WARNING);
    }

    private final class ServerAdminCommandHandlers {
        private ServerAdminCommandHandlers() {
        }

        @Command(name="get_admin_compat_level", hidden=true, displayName="Get XVM Compatibility Level", group={"XVM", "Internal"}, description="Gets the xvm admin compatibility level. This can be used by admin clients to determine if the xvm supports certain operations.")
        final String getAdminCompatLevel() {
            return "5";
        }

        @Command(name="set_trace_level", displayName="Set Trace Level", group={"XVM"}, description="Changes the level of a trace logger")
        final String setTraceLevel(@Argument(position=1, name="loggerName", required=true, description="The name of the trace logger whose level is to be changed.") String loggerName, @Argument(position=2, name="loggerLevel", required=true, description="The new level.") Tracer.Level level) throws Exception {
            SrvControllerAdminApp.this.tracer.log("Changing the level of the '" + loggerName + " trace logger to '" + level + "'...", Tracer.Level.INFO);
            Tracer tracer = TracerRegistry.getInstance().get(loggerName);
            if (tracer != null) {
                tracer.setLevel(level);
                return "Set level of '" + loggerName + " trace logger to '" + level + "'.";
            }
            return "Trace logger '" + loggerName + "' not found.";
        }

        @Command(name="xvm_stop", aliases={"stop"}, displayName="Stop XVM", group={"XVM"}, description="Triggers a graceful shutdown of the xvm")
        final void stopServer() throws Exception {
            SrvControllerAdminApp.this.controller.stop(false);
        }

        @Command(name="xvm_restart", aliases={"restart"}, displayName="Restart XVM", group={"XVM"}, description="Triggers a graceful restart of the xvm")
        final void restartServer() throws Exception {
            SrvControllerAdminApp.this.controller.doRestart();
        }

        @Command(name="xvm_kill", aliases={"kill"}, displayName="Kill XVM", group={"XVM"}, description="Triggers an ungraceful, hard shutdown of the xvm")
        final void killServer() throws Exception {
            SrvControllerAdminApp.this.controller.doKill();
        }

        @Command(name="xvm_threaddump", aliases={"threaddump"}, displayName="Trigger Thread Dump", group={"XVM"}, description="Triggers a thread dump for the xvm")
        final void threadDump() throws Exception {
            SrvControllerAdminApp.this.tracer.log("Generating thread dump (requested by admin app...", Tracer.Level.INFO);
            StringBuilder sb = new StringBuilder();
            UtlThread.triggerThreadDump((Appendable)sb);
            SrvControllerAdminApp.this.tracer.log(sb.toString(), Tracer.Level.INFO);
        }

        @Command(name="xvm_dumpprocessorlayout", aliases={"dumpprocessorlayout"}, displayName="Dump Processor Layout", group={"XVM"}, description="Dumps the cpu processor layout")
        final void dumpProcessorLayout() throws Exception {
            SrvControllerAdminApp.this.tracer.log("Dumping Processor Layout (requested by admin app...", Tracer.Level.INFO);
            StringBuilder sb = new StringBuilder();
            UtlThread.dumpProcessorLayout((Appendable)sb);
            SrvControllerAdminApp.this.tracer.log(sb.toString(), Tracer.Level.INFO);
        }

        @Command(name="xvm_affinitydump", aliases={"affinitydump"}, displayName="Trigger Affinity Dump", group={"XVM"}, description="Triggers a dump of thread affinities")
        final void affinityDump() throws Exception {
            SrvControllerAdminApp.this.tracer.log("Triggering Affinity dump (requested by admin app...", Tracer.Level.INFO);
            StringBuilder sb = new StringBuilder();
            UtlThread.dumpAffinitizationState((Appendable)sb, (String)"  ");
            SrvControllerAdminApp.this.tracer.log(sb.toString(), Tracer.Level.INFO);
        }

        @Command(name="xvm_gc", aliases={"gc"}, displayName="Trigger GC", group={"XVM"}, description="Triggers a full gc for the vm")
        final void runGC() throws Exception {
            SrvControllerAdminApp.this.tracer.log("Triggering full GC (requested by admin app...", Tracer.Level.INFO);
            Runtime.getRuntime().gc();
            SrvControllerAdminApp.this.tracer.log("GC complete.", Tracer.Level.INFO);
        }
    }

    private final class AppAdminCommandHandlers {
        private AppAdminCommandHandlers() {
        }

        @Command(name="app_ping", hidden=true, displayName="Ping", group={"App", "Internal"}, description="Ping an app to determine if it is loaded into the xvm.")
        final boolean ping(@Argument(position=1, name="appName", required=true, description="The name of the app to ping.") String appName) {
            return SrvControllerAdminApp.this.controller.getAppManager().isAppLoaded(appName);
        }

        @Command(name="app_list", hidden=true, displayName="List", group={"App", "Internal"}, description="Lists the apps configured for the xvm. The list is a comma separate string of app names.")
        final String listApps() throws Exception {
            Iterator<String> iterator = SrvControllerAdminApp.this.controller.getAppManager().listApps().iterator();
            StringBuilder sb = new StringBuilder();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        @Command(name="app_install", hidden=true, displayName="Install App...", group={"App", "Internal"}, description="Installs an application in the xvm")
        final void installApp(@Argument(position=1, name="appName", required=true, description="The name of the app to install.") String appName, @Argument(position=2, name="artifactDir", required=true, description="The location of the directory containing the jars for the application") String artifactDir) throws Exception {
            SrvControllerAdminApp.this.controller.getAppManager().installApp(appName, new File(artifactDir));
        }

        @Command(name="app_setver", hidden=true, displayName="Set App Version...", group={"App", "Internal"}, description="Sets the version of an application")
        final void setAppVersion(@Argument(position=1, name="appName", required=true, description="The application whose current version is to be set.") String appName, @Argument(position=2, name="versionStr", required=true, description="The location of the directory containing the jars ") String versionStr) throws Exception {
            SrvControllerAdminApp.this.controller.getAppManager().setAppVersion(appName, versionStr.compareToIgnoreCase("latest") == 0 ? 0 : Integer.valueOf(versionStr));
        }

        @Command(name="app_load", displayName="Load App...", group={"App"}, description="Loads an application.")
        final void loadApp(@Argument(position=1, name="appName", required=true, description="The name of the app to load.") String appName) throws Exception {
            if (SrvControllerAdminApp.this.controller.getAppManager().getAppLoader(appName) != null) {
                throw new Exception("app '" + appName + "' is already loaded");
            }
            UtlGc.runGc();
            SrvControllerAdminApp.this.controller.getAppManager().loadApp(appName);
        }

        @Command(name="app_start", displayName="Start App...", group={"App"}, description="Starts an application.")
        final void startApp(@Argument(position=1, name="appName", required=true, description="The name of the app to start.") String appName, @Argument(position=2, name="async", required=false, defaultValue="false", description="Indicates whether to wait or nor to wait for the start to complete. If async start is elected, then the start is initiated in the background using a separate thread.") boolean async) throws Exception {
            if (SrvControllerAdminApp.this.controller.getAppManager().getAppLoader(appName) == null) {
                throw new Exception("app '" + appName + "' is not loaded");
            }
            SrvControllerAdminApp.this.controller.getAppManager().startApp(appName, async);
        }

        @Command(name="app_stop", displayName="Stop App...", group={"App"}, description="Stops an application.")
        final void stopApp(@Argument(position=1, name="appName", required=true, description="The name of the app to stop.") String appName) throws Exception {
            if (SrvControllerAdminApp.this.controller.getAppManager().getAppLoader(appName) == null) {
                throw new Exception("app '" + appName + "' is not loaded");
            }
            SrvControllerAdminApp.this.controller.getAppManager().stopApp(appName);
        }

        @Command(name="app_unload", displayName="Unload App...", group={"App"}, description="Unloads an application.")
        final void unloadApp(@Argument(position=1, name="appName", required=true, description="The name of the app to unload.") String appName) throws Exception {
            if (!SrvControllerAdminApp.this.controller.getAppManager().isAppLoaded(appName)) {
                throw new Exception("app '" + appName + "' is not loaded");
            }
            SrvControllerAdminApp.this.controller.getAppManager().unloadApp(appName);
            UtlGc.runGc();
        }

        @Command(name="app_set_message_handling_policy", displayName="Set Message Handling Policy", group={"App"}, description="Changes an application's message handling policy.")
        final void setAppMessageHandlingPolicy(@Argument(position=1, name="appName", required=true, description="The name on which to change the message handling policy.") String appName, @Argument(position=2, name="newPolicy", required=true, description="The new message policy.") AepEngine.MessageHandlingPolicy policy) throws Exception {
            if (!SrvControllerAdminApp.this.controller.getAppManager().isAppLoaded(appName)) {
                throw new Exception("app '" + appName + "' is not loaded");
            }
            SrvControllerAdminApp.this.controller.getAppManager().setAppMessageHandlingPolicy(appName, policy);
        }
    }

    private final class AdminAppEventHandler
    implements IEventHandler {
        private AdminAppEventHandler() {
        }

        public final void onEvent(Event event) {
            switch (event.getType()) {
                case 503: {
                    SrvControllerAdminApp.this.onClientPacket((AepClientPacketEvent)event);
                    break;
                }
                case 501: {
                    SrvControllerAdminApp.this.onClientConnected((AepClientConnectedEvent)event);
                    break;
                }
                case 502: {
                    SrvControllerAdminApp.this.onClientDisconnected((AepClientDisconnectedEvent)event);
                    break;
                }
            }
        }
    }

    static interface AdminClientContext {
        public <RequestType extends IRogMessage & ISrvMonXvmRequest, ResponseType extends IRogMessage & ISrvMonXvmResponse> void sendResponse(RequestType var1, ResponseType var2);

        public <RequestType extends IRogMessage & ISrvMonXvmRequest> void sendErrorResponse(RequestType var1, Exception var2);

        public boolean publishHeartbeat(SrvMonHeartbeatMessage var1);

        public boolean publishTraceRecord(SrvMonTraceRecord var1);

        public <RequestType extends IRogMessage & ISrvMonEvent> boolean publishEvent(RequestType var1, boolean var2, boolean var3);

        public void flush();

        public Stats getStats();

        public String getName();

        public String getClientName(ISrvMonXvmRequest var1);

        public static interface Stats {
            public AdminClientContext getClient();

            public long getResponsesSent();

            public long getResponsesDropped();

            public long getEventsSent();

            public long getEventsDropped();

            public long getHeartbeatsSent();

            public long getHeartbeatsDropped();

            public long getTracesSent();

            public long getTracesDropped();

            public long getFlushesScheduled();

            public long getFlushesExecuted();

            public int getOutboundQueueCapacity();

            public int getOutboundQueueCount();

            public int getOutboundQueueSize();

            public long getOutboundQueueFlushCount();

            public long getOutboundQueueFlushSize();
        }
    }
}

