/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class StoShortFieldTest
extends UnitTest {
    private final void validate(StoShortField field, String name, ByteBuffer buffer, short val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.SHORT), (Object)((Object)field.getType()));
        Assert.assertEquals((long)field.getValue(), (long)val);
    }

    private final void cloneAndValidate(StoShortField field, String name, short val) {
        StoShortField clone = (StoShortField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoShortField.getSerializedLength(null, 0), (long)2L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoShortField.put(buffer, 5, (short)19804);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoShortField.get(buffer, 5), (long)19804L);
        this.validate(buffer, 0, 100, 100);
        StoShortField.put(buffer, 5, (short)19564);
        Assert.assertEquals((long)StoShortField.get(buffer, 5), (long)19564L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoShortField field = StoShortField.create(null);
        this.validate(field, null, null, (short)0);
        this.cloneAndValidate(field, null, (short)0);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoShortField field = StoShortField.create("name");
        this.validate(field, "name", null, (short)0);
        this.cloneAndValidate(field, "name", (short)0);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoShortField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoShortField field = StoShortField.create(null);
        field.setValue((short)19804);
        this.validate(field, null, null, (short)19804);
        this.cloneAndValidate(field, null, (short)19804);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoShortField field = StoShortField.create("name");
        field.setValue((short)19804);
        this.validate(field, "name", null, (short)19804);
        this.cloneAndValidate(field, "name", (short)19804);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoShortField field = StoShortField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, (short)0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (short)0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoShortField field = StoShortField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, (short)0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (short)0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoShortField field = StoShortField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((short)19804);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, (short)19804);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoShortField field = StoShortField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((short)19804);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, (short)19804);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoShortField field = StoShortField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((short)19804);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoShortField field = StoShortField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((short)19804);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, (short)19804);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoShortField field = StoShortField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue((short)19804);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, (short)19804);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoShortField field = StoShortField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue((short)19804);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, (short)19804);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoShortField field = StoShortField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue((short)19804);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoShortField field = StoShortField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue((short)19804);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, (short)19804);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoShortField field = StoShortField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((short)19804);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoShortField.get(buffer, field.shiftForHeader(45)), (long)19804L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoShortField field = StoShortField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((short)19804);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, (short)19804);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoShortField.get(buffer, field.shiftForHeader(52)), (long)19804L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue((short)19804);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoShortField field2 = (StoShortField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoShortField field1 = StoShortField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue((short)19804);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoShortField field2 = (StoShortField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue((short)19804);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoShortField field2 = (StoShortField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoShortField field1 = StoShortField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue((short)19804);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoShortField field2 = (StoShortField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", (short)19804);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue((short)19804);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoShortField field2 = (StoShortField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoShortField field3 = (StoShortField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, (short)19804);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, (short)19804);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoShortField field1 = StoShortField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue((short)7682);
        field1.setBackingBuffer(buffer1, 89);
        this.validate(buffer1, 0, 100, 100);
        StoShortField field2 = (StoShortField)StoField.create(buffer1, 89);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoShortField field3 = (StoShortField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, (short)7682);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", (short)7682);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoShortField field2 = (StoShortField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, (short)0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoShortField field2 = (StoShortField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 25);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoShortField.create("name").contentsEquals(StoShortField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoShortField.create(null).contentsEquals(StoShortField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoShortField.create("name1").contentsEquals(StoShortField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        StoShortField field2 = StoShortField.create(null);
        field1.setValue((short)100);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        StoShortField field2 = StoShortField.create(null);
        field2.setValue((short)100);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        StoShortField field2 = StoShortField.create(null);
        field1.setValue((short)67);
        field2.setValue((short)178);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        StoShortField field2 = StoShortField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoShortField field1 = StoShortField.create("name");
        StoShortField field2 = StoShortField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoShortField field1 = StoShortField.create(null);
        StoShortField field2 = StoShortField.create(null);
        field1.setValue((short)42);
        field2.setValue((short)42);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoShortField field1 = StoShortField.create("name");
        StoShortField field2 = StoShortField.create("name");
        field1.setValue((short)66);
        field2.setValue((short)66);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

