/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoBooleanArrayField;
import com.neeve.sto.StoBooleanField;
import com.neeve.sto.StoByteArrayField;
import com.neeve.sto.StoByteField;
import com.neeve.sto.StoCompoundField;
import com.neeve.sto.StoDoubleArrayField;
import com.neeve.sto.StoDoubleField;
import com.neeve.sto.StoField;
import com.neeve.sto.StoFieldContainer;
import com.neeve.sto.StoFloatArrayField;
import com.neeve.sto.StoFloatField;
import com.neeve.sto.StoIntArrayField;
import com.neeve.sto.StoIntField;
import com.neeve.sto.StoLongArrayField;
import com.neeve.sto.StoLongField;
import com.neeve.sto.StoShortArrayField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoStringArrayField;
import com.neeve.sto.StoStringField;
import com.neeve.sto.StoTypeFactory;
import com.neeve.sto.StoTypeFactoryRegistry;
import com.neeve.sto.test.unit.StoBooleanArrayFieldTest;
import com.neeve.sto.test.unit.StoByteArrayFieldTest;
import com.neeve.sto.test.unit.StoDoubleArrayFieldTest;
import com.neeve.sto.test.unit.StoFloatArrayFieldTest;
import com.neeve.sto.test.unit.StoIntArrayFieldTest;
import com.neeve.sto.test.unit.StoLongArrayFieldTest;
import com.neeve.sto.test.unit.StoShortArrayFieldTest;
import com.neeve.sto.test.unit.StoStringArrayFieldTest;
import com.neeve.sto.test.unit.StoStringFieldTest;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class StoCompoundFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    static final String uniqueFieldName(StoFieldContainer container) {
        String name = null;
        if (random.nextInt() % 2 == 0) {
            while (container.get(name = StoStringFieldTest.createString()) != null) {
            }
        }
        return name;
    }

    private static final StoFieldContainer populateContainer(StoFieldContainer container, boolean nested) {
        StoBooleanField booleanField = StoBooleanField.create(StoCompoundFieldTest.uniqueFieldName(container));
        booleanField.setValue(random.nextBoolean());
        container.append(booleanField);
        StoByteField byteField = StoByteField.create(StoCompoundFieldTest.uniqueFieldName(container));
        byteField.setValue((byte)random.nextInt(127));
        container.append(byteField);
        StoShortField shortField = StoShortField.create(StoCompoundFieldTest.uniqueFieldName(container));
        shortField.setValue((short)random.nextInt(Short.MAX_VALUE));
        container.append(shortField);
        StoIntField intField = StoIntField.create(StoCompoundFieldTest.uniqueFieldName(container));
        intField.setValue(random.nextInt());
        container.append(intField);
        StoLongField longField = StoLongField.create(StoCompoundFieldTest.uniqueFieldName(container));
        longField.setValue(random.nextLong());
        container.append(longField);
        StoFloatField floatField = StoFloatField.create(StoCompoundFieldTest.uniqueFieldName(container));
        floatField.setValue(random.nextFloat());
        container.append(floatField);
        StoDoubleField doubleField = StoDoubleField.create(StoCompoundFieldTest.uniqueFieldName(container));
        doubleField.setValue(random.nextDouble());
        container.append(doubleField);
        StoStringField stringField = StoStringField.create(StoCompoundFieldTest.uniqueFieldName(container));
        stringField.setValue(StoStringFieldTest.createString());
        container.append(stringField);
        StoBooleanArrayField booleanArrayField = StoBooleanArrayField.create(StoCompoundFieldTest.uniqueFieldName(container));
        booleanArrayField.setValue(StoBooleanArrayFieldTest.createArray(10));
        container.append(booleanArrayField);
        StoByteArrayField byteArrayField = StoByteArrayField.create(StoCompoundFieldTest.uniqueFieldName(container));
        byteArrayField.setValue(StoByteArrayFieldTest.createArray(6));
        container.append(byteArrayField);
        StoShortArrayField shortArrayField = StoShortArrayField.create(StoCompoundFieldTest.uniqueFieldName(container));
        shortArrayField.setValue(StoShortArrayFieldTest.createArray(2));
        container.append(shortArrayField);
        StoIntArrayField intArrayField = StoIntArrayField.create(StoCompoundFieldTest.uniqueFieldName(container));
        intArrayField.setValue(StoIntArrayFieldTest.createArray(14));
        container.append(intArrayField);
        StoLongArrayField longArrayField = StoLongArrayField.create(StoCompoundFieldTest.uniqueFieldName(container));
        longArrayField.setValue(StoLongArrayFieldTest.createArray(7));
        container.append(longArrayField);
        StoFloatArrayField floatArrayField = StoFloatArrayField.create(StoCompoundFieldTest.uniqueFieldName(container));
        floatArrayField.setValue(StoFloatArrayFieldTest.createArray(1));
        container.append(floatArrayField);
        StoDoubleArrayField doubleArrayField = StoDoubleArrayField.create(StoCompoundFieldTest.uniqueFieldName(container));
        doubleArrayField.setValue(StoDoubleArrayFieldTest.createArray(23));
        container.append(doubleArrayField);
        StoStringArrayField stringArrayField = StoStringArrayField.create(StoCompoundFieldTest.uniqueFieldName(container));
        stringArrayField.setValue(StoStringArrayFieldTest.createArray(11));
        container.append(stringArrayField);
        if (!nested) {
            StoCompoundField compoundField = StoCompoundField.create(StoCompoundFieldTest.uniqueFieldName(container));
            compoundField.setValue(StoCompoundFieldTest.createContainer(true));
            container.append(compoundField);
        }
        return container;
    }

    static final StoFieldContainer createContainer(boolean nested) {
        return StoCompoundFieldTest.populateContainer(StoFieldContainer.create(), nested);
    }

    private final void validate(StoCompoundField field, String name, ByteBuffer buffer, StoFieldContainer val, boolean same) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.COMPOUND), (Object)((Object)field.getType()));
        if (val == null) {
            Assert.assertNull(field.getValue());
        } else if (same) {
            Assert.assertSame(field.getValue(), (Object)val);
        } else {
            Assert.assertTrue((boolean)((StoFieldContainer)field.getValue()).contentsEquals(val));
        }
    }

    private final void cloneAndValidate(StoCompoundField field, String name, StoFieldContainer val) {
        StoCompoundField clone = (StoCompoundField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val, false);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    private final int expectedSerializedLength(StoFieldContainer container) {
        int len = 8;
        if (container != null) {
            len += container.getSerializedLength();
        }
        return len;
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoCompoundField.getSerializedLength(null), (long)this.expectedSerializedLength(null));
        StoFieldContainer container = StoFieldContainer.create();
        Assert.assertEquals((long)StoCompoundField.getSerializedLength(container), (long)this.expectedSerializedLength(container));
        container = StoCompoundFieldTest.createContainer(false);
        Assert.assertEquals((long)StoCompoundField.getSerializedLength(container), (long)this.expectedSerializedLength(container));
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container1 = StoCompoundFieldTest.createContainer(false);
        StoFieldContainer container2 = StoCompoundFieldTest.createContainer(false);
        Assert.assertEquals((long)StoCompoundField.put(buffer, 5, container1), (long)this.expectedSerializedLength(container1));
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertEquals((long)StoCompoundField.getSerializedLength(buffer, 5), (long)this.expectedSerializedLength(container1));
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertTrue((boolean)StoCompoundField.get(buffer, 5).contentsEquals(container1));
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertEquals((long)StoCompoundField.put(buffer, 5, container2), (long)this.expectedSerializedLength(container2));
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertTrue((boolean)StoCompoundField.get(buffer, 5).contentsEquals(container2));
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoCompoundField field = StoCompoundField.create(null);
        this.validate(field, null, null, null, true);
        this.cloneAndValidate(field, null, null);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoCompoundField field = StoCompoundField.create("name");
        this.validate(field, "name", null, null, true);
        this.cloneAndValidate(field, "name", null);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertTrue((boolean)StoCompoundField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoCompoundField field = StoCompoundField.create(null);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        this.validate(field, null, null, container, true);
        this.cloneAndValidate(field, null, container);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoCompoundField field = StoCompoundField.create("name");
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        this.validate(field, "name", null, container, true);
        this.cloneAndValidate(field, "name", container);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoCompoundField field = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, buffer, null, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, null);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoCompoundField field = StoCompoundField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", buffer, null, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", null);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoCompoundField field = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, buffer, container, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoCompoundField field = StoCompoundField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", buffer, container, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoCompoundField field = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, null, container, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoCompoundField field = StoCompoundField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", null, container, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoCompoundField field = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 10240, 10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, buffer, container, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoCompoundField field = StoCompoundField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 10240, 10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", buffer, container, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoCompoundField field = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 10240, 10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        this.validate(buffer, 0, 10240, 10240);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, null, container, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoCompoundField field = StoCompoundField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 10240, 10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        this.validate(buffer, 0, 10240, 10240);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", null, container, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoCompoundField field = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, null, container, true);
        this.validate(buffer, 0, 10240, 10240);
        ByteBuffer buffer1 = ((ByteBuffer)buffer.position(45).limit(45 + field.getLength())).slice();
        Assert.assertTrue((boolean)StoFieldContainer.create((ByteBuffer)buffer1.position(field.shiftForHeader(0) + 4 + 4)).contentsEquals(container));
        this.cloneAndValidate(field, null, container);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoCompoundField field = StoCompoundField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field.setValue(container);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", null, container, true);
        this.validate(buffer, 0, 10240, 10240);
        ByteBuffer buffer1 = ((ByteBuffer)buffer.position(52).limit(52 + field.getLength())).slice();
        Assert.assertTrue((boolean)StoFieldContainer.create((ByteBuffer)buffer1.position(field.shiftForHeader(0) + 4 + 4)).contentsEquals(container));
        this.cloneAndValidate(field, "name", container);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field1.setValue(container);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundField field2 = (StoCompoundField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field2, null, container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoCompoundField field1 = StoCompoundField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field1.setValue(container);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundField field2 = (StoCompoundField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field2, "name", container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field1.setValue(container);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundField field2 = (StoCompoundField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 10240, 10240);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field2, null, container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoCompoundField field1 = StoCompoundField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field1.setValue(container);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundField field2 = (StoCompoundField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 10240, 10240);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field2, "name", container);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field1.setValue(container);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 10240, 10240);
        StoCompoundField field2 = (StoCompoundField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 10240, 10240);
        ByteBuffer buffer2 = ByteBuffer.allocate(10240);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 10240, 10240);
        StoCompoundField field3 = (StoCompoundField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 10240, 10240);
        this.validate(field3, null, buffer2, container, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 10240, 10240);
        this.cloneAndValidate(field3, null, container);
        this.validate(buffer2, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoCompoundField field1 = StoCompoundField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(10240);
        StoFieldContainer container = StoCompoundFieldTest.createContainer(false);
        field1.setValue(container);
        field1.setBackingBuffer(buffer1, 89);
        this.validate(buffer1, 0, 10240, 10240);
        StoCompoundField field2 = (StoCompoundField)StoField.create(buffer1, 89);
        this.validate(buffer1, 0, 10240, 10240);
        ByteBuffer buffer2 = ByteBuffer.allocate(10240);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 10240, 10240);
        StoCompoundField field3 = (StoCompoundField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 10240, 10240);
        this.validate(field3, "name", buffer2, container, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 10240, 10240);
        this.cloneAndValidate(field3, "name", container);
        this.validate(buffer2, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetUserTypeValueDeserialize() throws Exception {
        StoTypeFactoryRegistry.getInstance().registerTypeFactory(new UserTypeFactory());
        StoCompoundField field1 = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        UserType userType = new UserType();
        field1.setValue(userType);
        field1.setBackingBuffer(buffer, 42);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundField field2 = (StoCompoundField)StoField.create(buffer, 42);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertTrue((boolean)(field2.getValue() instanceof UserType));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field2, null, userType);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoCompoundField field2 = (StoCompoundField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoCompoundField field2 = (StoCompoundField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 65);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoCompoundField.create("name").contentsEquals(StoCompoundField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoCompoundField.create(null).contentsEquals(StoCompoundField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoCompoundField.create("name1").contentsEquals(StoCompoundField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        StoCompoundField field2 = StoCompoundField.create(null);
        field1.setValue(StoCompoundFieldTest.createContainer(false));
        field2.setValue(null);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        StoCompoundField field2 = StoCompoundField.create(null);
        field1.setValue(null);
        field2.setValue(StoCompoundFieldTest.createContainer(false));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffLengths() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        StoCompoundField field2 = StoCompoundField.create(null);
        field1.setValue(StoCompoundFieldTest.createContainer(false));
        field2.setValue(StoCompoundFieldTest.createContainer(true));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        StoCompoundField field2 = StoCompoundField.create(null);
        field1.setValue(StoCompoundFieldTest.createContainer(false));
        field2.setValue(StoCompoundFieldTest.createContainer(false));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        StoCompoundField field2 = StoCompoundField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoCompoundField field1 = StoCompoundField.create("name");
        StoCompoundField field2 = StoCompoundField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoCompoundField field1 = StoCompoundField.create(null);
        StoCompoundField field2 = StoCompoundField.create(null);
        field1.setValue(StoCompoundFieldTest.createContainer(false));
        field2.setValue((StoFieldContainer)((StoFieldContainer)field1.getValue()).clone());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoCompoundField field1 = StoCompoundField.create("name");
        StoCompoundField field2 = StoCompoundField.create("name");
        field1.setValue(StoCompoundFieldTest.createContainer(false));
        field2.setValue((StoFieldContainer)((StoFieldContainer)field1.getValue()).clone());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    private static final class UserType
    extends StoFieldContainer {
        UserType() {
            StoCompoundFieldTest.populateContainer(this, false);
        }

        UserType(ByteBuffer buffer, boolean attach) {
            super(buffer, attach);
        }

        @Override
        public final short getTypeFactoryId() {
            return UserTypeFactory.ID;
        }

        @Override
        public final short getTypeId() {
            return UserTypeFactory.ID_Object;
        }
    }

    private static final class UserTypeFactory
    implements StoTypeFactory {
        static short ID = 1;
        static short ID_Object = 1;

        private UserTypeFactory() {
        }

        @Override
        public short getTfid() {
            return ID;
        }

        @Override
        public StoFieldContainer createCompoundType(short id, ByteBuffer buffer, boolean attach) {
            Assert.assertEquals((long)id, (long)ID_Object);
            return new UserType(buffer, attach);
        }

        @Override
        public StoFieldContainer createCompoundType(short id, ByteBuffer buffer) {
            return this.createCompoundType(id, buffer, true);
        }

        @Override
        public StoFieldContainer[] createCompoundArrayType(short id, int len) {
            Assert.assertEquals((long)id, (long)ID_Object);
            return new UserType[len];
        }
    }
}

