/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoStringField;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoStringArrayField
extends StoVariableLengthField<String[]> {
    private StoStringArrayField(String name) {
        super(StoField.Type.STRING_ARRAY, name);
    }

    private StoStringArrayField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoStringArrayField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(String[] val) {
        return StoStringArrayField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, String[] val) {
        StoStringArrayField.put(buffer, offset, val);
    }

    @Override
    protected final String[] deserialize(ByteBuffer buffer, int offset) {
        return StoStringArrayField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(String[] val1, String[] val2) {
        return Arrays.equals(val1, val2);
    }

    @Override
    protected final String[] clone(String[] val) {
        return Arrays.copyOf(val, val.length);
    }

    @Override
    protected final String toString(String[] val) {
        return Arrays.toString(val);
    }

    public static StoStringArrayField create(String name) {
        return new StoStringArrayField(name);
    }

    public static StoStringArrayField create(ByteBuffer buffer, int bufferOffset) {
        return new StoStringArrayField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        int numElements = StoShortField.get(buffer, offset);
        int len = 2;
        for (int i = 0; i < numElements; ++i) {
            len += StoStringField.getSerializedLength(buffer, offset + len);
        }
        return len;
    }

    public static int getSerializedLength(String[] val) {
        int len = 2;
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                len += StoStringField.getSerializedLength(val[i]);
            }
        }
        return len;
    }

    public static int put(ByteBuffer buffer, int offset, String[] val) {
        StoShortField.put(buffer, offset, (short)(val == null ? 0 : (val.length == 0 ? -1 : val.length)));
        int len = 2;
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                len += StoStringField.put(buffer, offset + len, val[i]);
            }
        }
        return len;
    }

    public static String[] get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            String[] val = new String[len];
            int proclen = 2;
            for (int i = 0; i < val.length; ++i) {
                val[i] = StoStringField.get(buffer, offset + proclen);
                proclen += StoStringField.getSerializedLength(buffer, offset + proclen);
            }
            return val;
        }
        if (len < 0) {
            return new String[0];
        }
        return null;
    }
}

