/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.types;

import com.neeve.pkt.PktBody;
import com.neeve.pkt.types.PktBodyText;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;

public final class PktBodyCompressedText
extends PktBodyText {
    private PktBodyCompressedText(Properties props, boolean direct) {
        super(263, props, direct);
    }

    public static PktBody create(Properties props) {
        return new PktBodyCompressedText(props, false);
    }

    public static PktBody create() {
        return PktBodyCompressedText.create(null);
    }

    @Override
    protected final int toBackingBuffer(byte[] text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream compresser = new DeflaterOutputStream(baos);
        try {
            compresser.write(text, 0, text.length);
            compresser.finish();
            compresser.flush();
            byte[] compressed = baos.toByteArray();
            this.buffer.putFrom(this.TEXT_POS, compressed, 0, compressed.length);
            int n = compressed.length;
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                compresser.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected final byte[] fromBackingBuffer(int textLen) {
        byte[] compressed = new byte[textLen];
        this.buffer.getTo(this.TEXT_POS, compressed, 0, textLen);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InflaterOutputStream decompresser = new InflaterOutputStream(baos);
        try {
            decompresser.write(compressed, 0, compressed.length);
            decompresser.finish();
            decompresser.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                decompresser.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

