/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.test.unit.PktTestHelper;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.test.UnitTest;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class PktPacketTest
extends UnitTest {
    @BeforeClass
    public static void createPacketTypeConfigFiles() {
        PktTestHelper.loadPacketTypes();
        PktFactory.getInstance().getTracer().setLevel(Tracer.Level.OFF);
    }

    @Test
    public void testCreatedPacketHasNullIOBuffers() {
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        Assert.assertNull((Object)packet.getHeader().getBuffer().getIOBuffer());
        Assert.assertNull((Object)packet.getBody().getBuffer().getIOBuffer());
    }

    @Test
    public void testTagSet() {
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        for (int i = 0; i < 5; ++i) {
            Object tag = new Object();
            packet.setTag(i, tag);
            Assert.assertTrue((packet.getTag(i) == tag ? 1 : 0) != 0);
        }
        try {
            packet.setTag(5, new Object());
            PktPacketTest.testFailure((String)"A tag with id=MAX_TAG_COUNT succeeded!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSerializationPolicyValidSet() {
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        PktTestHelper.checkPoliciesInPacket(packet, 1, 1);
        packet.setSerializationPolicy(2);
        PktTestHelper.checkPoliciesInPacket(packet, 2, 1);
        packet.setSerializationPolicy(3);
        PktTestHelper.checkPoliciesInPacket(packet, 3, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSerializationPolicySetInvalid_SetDefault() {
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        packet.setSerializationPolicy(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSerializationPolicySetInvalid_SetInvalid() {
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        packet.setSerializationPolicy(4);
    }

    @Test
    public void testDeserializationPolicyValidSet() {
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        PktTestHelper.checkPoliciesInPacket(packet, 1, 1);
        packet.setDeserializationPolicy(2);
        PktTestHelper.checkPoliciesInPacket(packet, 1, 2);
        packet.setDeserializationPolicy(3);
        PktTestHelper.checkPoliciesInPacket(packet, 1, 3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeserializationPolicySetInvalid_SetDefault() {
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        packet.setDeserializationPolicy(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeserializationPolicySetInvalid_SetInvalid() {
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        packet.setDeserializationPolicy(4);
    }

    @Test
    public void testForkOnFreshlyCreatedPacket() {
        PktPacket packet = PktFactory.getInstance().createPacketNonPooled(257);
        Assert.assertNull((Object)packet.getHeader().getBuffer().getIOBuffer());
        Assert.assertNull((Object)packet.getBody().getBuffer().getIOBuffer());
        PktPacket forked = packet.forkNonPooled();
        Assert.assertTrue((packet != forked ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader() != forked.getHeader() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertNull((Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertFalse((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        Assert.assertTrue((packet.getBody() != forked.getBody() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertNull((Object)forked.getBody().getBuffer().getIOBuffer());
        Assert.assertFalse((boolean)forked.getBody().getBuffer().isCopyOnWrite());
        packet.getHeader().setFlow(1);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)packet.getHeader().getBuffer().getIOBuffer());
        Assert.assertNull((Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertFalse((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        forked.getHeader().setFlow(1);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)packet.getHeader().getBuffer().getIOBuffer());
        Assert.assertNotNull((Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertTrue((packet.getHeader().getBuffer().getIOBuffer() != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        ((PktBodyData)packet.getBody()).setBufferLength(128);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)packet.getBody().getBuffer().getIOBuffer());
        Assert.assertNull((Object)forked.getBody().getBuffer().getIOBuffer());
        Assert.assertFalse((boolean)forked.getBody().getBuffer().isCopyOnWrite());
        ((PktBodyData)forked.getBody()).setBufferLength(128);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)packet.getBody().getBuffer().getIOBuffer());
        Assert.assertNotNull((Object)forked.getBody().getBuffer().getIOBuffer());
        Assert.assertTrue((packet.getBody().getBuffer().getIOBuffer() != forked.getBody().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)forked.getBody().getBuffer().isCopyOnWrite());
    }

    @Test
    public void testForkOnPacketWithHeaderBufferNoBodyBuffer_UpdateSourceThenForked() {
        PktPacket packet = PktFactory.getInstance().createPacketNonPooled(257);
        Assert.assertNull((Object)packet.getHeader().getBuffer().getIOBuffer());
        Assert.assertNull((Object)packet.getBody().getBuffer().getIOBuffer());
        packet.getHeader().setFlow(1);
        PktPacket forked = packet.forkNonPooled();
        Assert.assertTrue((packet != forked ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader() != forked.getHeader() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertSame((Object)packet.getHeader().getBuffer().getIOBuffer(), (Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertTrue((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        Assert.assertTrue((packet.getBody() != forked.getBody() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertNull((Object)forked.getBody().getBuffer().getIOBuffer());
        Assert.assertFalse((boolean)forked.getBody().getBuffer().isCopyOnWrite());
        packet.getHeader().setFlow(2);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer().getIOBuffer() != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)packet.getHeader().getBuffer().isCopyOnWrite());
        Assert.assertTrue((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        IOBuffer buffer = forked.getHeader().getBuffer().getIOBuffer();
        forked.getHeader().setFlow(2);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer().getIOBuffer() != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((buffer != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
    }

    @Test
    public void testForkOnPacketWithHeaderBufferNoBodyBuffer_UpdateForkedThenSource() {
        PktPacket packet = PktFactory.getInstance().createPacketNonPooled(257);
        Assert.assertNull((Object)packet.getHeader().getBuffer().getIOBuffer());
        Assert.assertNull((Object)packet.getBody().getBuffer().getIOBuffer());
        packet.getHeader().setFlow(1);
        PktPacket forked = packet.forkNonPooled();
        Assert.assertTrue((packet != forked ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader() != forked.getHeader() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertSame((Object)packet.getHeader().getBuffer().getIOBuffer(), (Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertTrue((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        Assert.assertTrue((packet.getBody() != forked.getBody() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertNull((Object)forked.getBody().getBuffer().getIOBuffer());
        Assert.assertFalse((boolean)forked.getBody().getBuffer().isCopyOnWrite());
        forked.getHeader().setFlow(1);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer().getIOBuffer() != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        Assert.assertTrue((boolean)packet.getHeader().getBuffer().isCopyOnWrite());
        IOBuffer packetBuffer = packet.getHeader().getBuffer().getIOBuffer();
        packet.getHeader().setFlow(2);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer().getIOBuffer() != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packetBuffer != packet.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)packet.getHeader().getBuffer().isCopyOnWrite());
    }

    @Test
    public void testForkOnPacketWithHeaderBufferAndBodyBuffer_UpdateSourceThenForked() {
        PktPacket packet = PktFactory.getInstance().createPacketNonPooled(257);
        Assert.assertNull((Object)packet.getHeader().getBuffer().getIOBuffer());
        Assert.assertNull((Object)packet.getBody().getBuffer().getIOBuffer());
        packet.getHeader().setFlow(1);
        ((PktBodyData)packet.getBody()).setBufferLength(128);
        PktPacket forked = packet.forkNonPooled();
        Assert.assertTrue((packet != forked ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader() != forked.getHeader() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertSame((Object)packet.getHeader().getBuffer().getIOBuffer(), (Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertTrue((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        Assert.assertTrue((packet.getBody() != forked.getBody() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)forked.getBody().getBuffer().getIOBuffer());
        Assert.assertTrue((boolean)forked.getBody().getBuffer().isCopyOnWrite());
        Assert.assertSame((Object)packet.getBody().getBuffer().getIOBuffer(), (Object)forked.getBody().getBuffer().getIOBuffer());
        packet.getHeader().setFlow(2);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer().getIOBuffer() != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)packet.getHeader().getBuffer().isCopyOnWrite());
        Assert.assertTrue((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        IOBuffer buffer = forked.getHeader().getBuffer().getIOBuffer();
        forked.getHeader().setFlow(3);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer().getIOBuffer() != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((buffer != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        ((PktBodyData)packet.getBody()).getBuffer().putInt(0, 0);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getBody().getBuffer().getIOBuffer() != forked.getBody().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)packet.getBody().getBuffer().isCopyOnWrite());
        Assert.assertTrue((boolean)forked.getBody().getBuffer().isCopyOnWrite());
        buffer = forked.getBody().getBuffer().getIOBuffer();
        forked.getBody().getBuffer().putInt(0, 0);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getBody().getBuffer().getIOBuffer() != forked.getBody().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((buffer != forked.getBody().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)forked.getBody().getBuffer().isCopyOnWrite());
    }

    @Test
    public void testForkOnPacketWithHeaderBufferAndBodyBuffer_UpdateForkedThenSource() {
        PktPacket packet = PktFactory.getInstance().createPacketNonPooled(257);
        Assert.assertNull((Object)packet.getHeader().getBuffer().getIOBuffer());
        Assert.assertNull((Object)packet.getBody().getBuffer().getIOBuffer());
        packet.getHeader().setFlow(1);
        ((PktBodyData)packet.getBody()).setBufferLength(128);
        PktPacket forked = packet.forkNonPooled();
        Assert.assertTrue((packet != forked ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader() != forked.getHeader() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertSame((Object)packet.getHeader().getBuffer().getIOBuffer(), (Object)forked.getHeader().getBuffer().getIOBuffer());
        Assert.assertTrue((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        Assert.assertTrue((packet.getBody() != forked.getBody() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)forked.getBody().getBuffer().getIOBuffer());
        Assert.assertTrue((boolean)forked.getBody().getBuffer().isCopyOnWrite());
        Assert.assertSame((Object)packet.getBody().getBuffer().getIOBuffer(), (Object)forked.getBody().getBuffer().getIOBuffer());
        forked.getHeader().setFlow(2);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer().getIOBuffer() != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)forked.getHeader().getBuffer().isCopyOnWrite());
        Assert.assertTrue((boolean)packet.getHeader().getBuffer().isCopyOnWrite());
        IOBuffer buffer = packet.getHeader().getBuffer().getIOBuffer();
        packet.getHeader().setFlow(3);
        Assert.assertTrue((packet.getHeader().getBuffer() != forked.getHeader().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getHeader().getBuffer().getIOBuffer() != forked.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((buffer != packet.getHeader().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)packet.getHeader().getBuffer().isCopyOnWrite());
        ((PktBodyData)forked.getBody()).getBuffer().putInt(0, 0);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getBody().getBuffer().getIOBuffer() != forked.getBody().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)forked.getBody().getBuffer().isCopyOnWrite());
        Assert.assertTrue((boolean)packet.getBody().getBuffer().isCopyOnWrite());
        buffer = packet.getBody().getBuffer().getIOBuffer();
        packet.getBody().getBuffer().putInt(0, 0);
        Assert.assertTrue((packet.getBody().getBuffer() != forked.getBody().getBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((packet.getBody().getBuffer().getIOBuffer() != forked.getBody().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertTrue((buffer != packet.getBody().getBuffer().getIOBuffer() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)packet.getBody().getBuffer().isCopyOnWrite());
    }

    private final void updatePacket(PktPacket packet, int val) {
        PktBuffer buffer = packet.getBody().getBuffer();
        buffer.setLength(0);
        for (int j = 0; j < 100; ++j) {
            buffer.putInt(j * 4, val);
        }
    }

    private final void validatePacket(PktPacket packet, int val) {
        PktBuffer buffer = packet.getBody().getBuffer();
        for (int k = 0; k < 10; ++k) {
            Assert.assertEquals((long)val, (long)buffer.getInt(k * 4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForkStress_UpdateForkAndHandoffForkedToSeparateThread() throws Exception {
        int i;
        Random random = new Random(System.currentTimeMillis());
        final class QueueElement {
            final PktPacket packet;
            final int val;

            QueueElement(PktPacket packet, int val) {
                this.packet = packet;
                this.val = val;
            }
        }
        final ArrayDeque<QueueElement> queue = new ArrayDeque<QueueElement>();
        final AtomicInteger queueCount = new AtomicInteger(0);
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                for (int j = 0; j < 10000000; ++j) {
                    QueueElement element;
                    while (queueCount.get() == 0) {
                    }
                    ArrayDeque arrayDeque = queue;
                    synchronized (arrayDeque) {
                        element = (QueueElement)queue.poll();
                    }
                    queueCount.decrementAndGet();
                    PktPacketTest.this.validatePacket(element.packet, element.val);
                    element.packet.dispose();
                    if (j % 100000 != 0) continue;
                    System.out.println("<-- (" + j + "," + queueCount.get() + ")");
                }
            }
        };
        thread.start();
        try {
            for (i = 0; i < 10000000 && thread.isAlive(); ++i) {
                while (queueCount.get() > 1000) {
                }
                int val = random.nextInt(100);
                this.updatePacket(packet, val);
                ArrayDeque<QueueElement> arrayDeque = queue;
                synchronized (arrayDeque) {
                    queue.offer(new QueueElement(packet.fork(), val));
                }
                queueCount.incrementAndGet();
                this.validatePacket(packet, val);
                if (i % 100000 != 0) continue;
                System.out.println("--> (" + i + "," + queueCount.get() + ")");
            }
        }
        finally {
            thread.join();
        }
        Assert.assertEquals((long)10000000L, (long)i);
    }

    private final void testConcurrentSerialization(boolean emptyPacket, boolean serializeWithoutMagic1, boolean serializeWithoutMagic2) throws Exception {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        if (!emptyPacket) {
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            for (int j = 0; j < 100; ++j) {
                buffer.putInt(857237);
            }
            buffer.flip();
            packet.getBody().deserialize(buffer, buffer.remaining());
        }
        SerializerThread serializer1 = new SerializerThread(packet, emptyPacket ? 0 : 857237, serializeWithoutMagic1);
        SerializerThread serializer2 = new SerializerThread(packet, emptyPacket ? 0 : 857237, serializeWithoutMagic2);
        serializer1.start();
        serializer2.start();
        serializer1.join();
        serializer2.join();
        Assert.assertNull((Object)serializer1.result());
        Assert.assertNull((Object)serializer2.result());
    }

    @Test
    public void testConcurrentSerialization_BothThreadsSerializeWithMagic_EmptyPacket() throws Exception {
        this.testConcurrentSerialization(true, false, false);
    }

    @Test
    public void testConcurrentSerialization_BothThreadsSerializeWithMagic_NonEmptyPacket() throws Exception {
        this.testConcurrentSerialization(false, false, false);
    }

    @Test
    public void testConcurrentSerialization_OneThreadSerializeWithoutMagic_NonEmptyPacket() throws Exception {
        this.testConcurrentSerialization(false, true, false);
    }

    @Test
    public void testConcurrentSerialization_BothThreadsSerializeWithoutMagic_NonEmptyPacket() throws Exception {
        this.testConcurrentSerialization(false, true, true);
    }

    private final class SerializerThread
    extends Thread {
        private final PktPacket packet;
        private final int packetVal;
        private final boolean serializeWithoutMagic;
        private final IOBuffer buffer;
        private final ByteBuffer byteBuffer;
        private final PktSerializable.SerializeContext serializeContext;
        private final PktSerializable.DeserializeContext deserializeContext;
        private Throwable result;

        SerializerThread(PktPacket packet, int packetVal, boolean serializeWithoutMagic) {
            this.packet = packet;
            this.packetVal = packetVal;
            this.serializeWithoutMagic = serializeWithoutMagic;
            this.buffer = IOBuffer.create((int)1024, (boolean)false);
            this.byteBuffer = this.buffer.getBufferUnsafe();
            this.serializeContext = PktSerializable.SerializeContext.create().setPolicy(1).addBuffer(this.buffer).setSerializeWithoutMagic(serializeWithoutMagic);
            this.deserializeContext = PktSerializable.DeserializeContext.create().setPolicy(1).setBuffer(this.buffer.getBuffer());
        }

        final Throwable result() {
            return this.result;
        }

        @Override
        public final void run() {
            Tracer tracer = Tracer.get((String)"nv.pkt");
            for (int i = 0; i < 1000000; ++i) {
                try {
                    this.packet.serialize(this.serializeContext, null);
                    if (this.serializeWithoutMagic) {
                        PktHeader.restoreClearedMagic(this.byteBuffer, 0);
                    }
                    this.serializeContext.flipBuffers();
                    PktPacket deserialized = PktFactory.getInstance().createPacket(this.deserializeContext);
                    if (this.packetVal > 0) {
                        PktPacketTest.this.validatePacket(deserialized, this.packetVal);
                    }
                    this.serializeContext.compactBuffers();
                    if (i % 1000 != 0) continue;
                    System.out.println("count=" + i);
                    continue;
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder("***** ERROR (tid=").append(Thread.currentThread().getId()).append(") [serializeWithoutMagic=").append(this.serializeWithoutMagic).append(", i=").append(i).append("] ******").append("\n").append(UtlThrowable.prepareStackTrace((Throwable)e));
                    System.out.println(sb.toString());
                    this.result = e;
                    break;
                }
            }
        }
    }
}

