/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlPool;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class PktIOBufferTest
extends UnitTest {
    private Random random = new Random(System.currentTimeMillis());

    @Test
    public void testDirectVsHeapCreation() {
        IOBuffer buffer1 = IOBuffer.create((int)1, (boolean)false);
        Assert.assertFalse((boolean)buffer1.isNative());
        Assert.assertFalse((boolean)buffer1.getBufferUnsafe().isDirect());
        buffer1.dispose();
        IOBuffer buffer2 = IOBuffer.create((int)1, (boolean)true);
        Assert.assertTrue((boolean)buffer2.isNative());
        Assert.assertTrue((boolean)buffer2.getBufferUnsafe().isDirect());
        Assert.assertNotSame((Object)buffer1, (Object)buffer2);
        Assert.assertNotSame((Object)buffer1.getPool(), (Object)buffer2.getPool());
    }

    public void testNegativeLengthOnCreate(boolean direct) {
        IOBuffer.create((int)-1, (boolean)direct);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeLengthOnCreate_Direct() {
        this.testNegativeLengthOnCreate(true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeLengthOnCreate_Heap() {
        this.testNegativeLengthOnCreate(false);
    }

    public void testNegativeLengthOnAdjustHighwater(boolean direct) {
        IOBuffer.create((int)1, (boolean)direct).adjustHighwater(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeLengthOnAdjustHighwater_Direct() {
        this.testNegativeLengthOnAdjustHighwater(true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeLengthOnAdjustHighwater_Heap() {
        this.testNegativeLengthOnAdjustHighwater(false);
    }

    public void testHighwaterExceedCapacityOnAdjustHighwater(boolean direct) {
        IOBuffer.create((int)1, (boolean)direct).adjustHighwater(IOBuffer.smallestSlabSize() + 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHighwaterExceedCapacityOnAdjustHighwater_Direct() {
        this.testHighwaterExceedCapacityOnAdjustHighwater(true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHighwaterExceedCapacityOnAdjustHighwater_Heap() {
        this.testHighwaterExceedCapacityOnAdjustHighwater(false);
    }

    private void testRoundToSlab(boolean direct) {
        for (int i = 0; i < IOBuffer.numSlabs(); ++i) {
            Assert.assertEquals((long)((int)((double)IOBuffer.smallestSlabSize() * Math.pow(2.0, i))), (long)IOBuffer.create((int)((int)((double)IOBuffer.smallestSlabSize() * (i == 0 ? 0.0 : Math.pow(2.0, i - 1))) + 1), (boolean)direct).getBufferUnsafe().capacity());
            Assert.assertEquals((long)((int)((double)IOBuffer.smallestSlabSize() * Math.pow(2.0, i))), (long)IOBuffer.create((int)((int)((double)IOBuffer.smallestSlabSize() * Math.pow(2.0, i)) - 1), (boolean)direct).getBufferUnsafe().capacity());
            Assert.assertEquals((long)((int)((double)IOBuffer.smallestSlabSize() * Math.pow(2.0, i))), (long)IOBuffer.create((int)((int)((double)IOBuffer.smallestSlabSize() * Math.pow(2.0, i))), (boolean)direct).getBufferUnsafe().capacity());
        }
    }

    @Test
    public void testRoundToSlab_Direct() {
        this.testRoundToSlab(true);
    }

    @Test
    public void testRoundToSlab_Heap() {
        this.testRoundToSlab(false);
    }

    private void testMarkersOnCreate(boolean direct) {
        for (int i = 0; i < IOBuffer.numSlabs(); ++i) {
            int slabSize = (int)((double)IOBuffer.smallestSlabSize() * Math.pow(2.0, i));
            int size = (int)((double)IOBuffer.smallestSlabSize() * (i == 0 ? 0.0 : Math.pow(2.0, i - 1))) + 1;
            IOBuffer buffer = IOBuffer.create((int)size, (boolean)direct);
            Assert.assertEquals((long)size, (long)buffer.getHighwater());
            Assert.assertEquals((long)size, (long)buffer.getLength());
            Assert.assertEquals((long)buffer.getLength(), (long)buffer.getBufferUnsafe().limit());
            Assert.assertEquals((long)slabSize, (long)buffer.getCapacity());
            Assert.assertEquals((long)buffer.getCapacity(), (long)buffer.getBufferUnsafe().capacity());
            size = (int)((double)IOBuffer.smallestSlabSize() * Math.pow(2.0, i)) - 1;
            buffer = IOBuffer.create((int)size, (int)(size / 2), (boolean)direct);
            Assert.assertEquals((long)(size / 2), (long)buffer.getHighwater());
            Assert.assertEquals((long)size, (long)buffer.getLength());
            Assert.assertEquals((long)buffer.getLength(), (long)buffer.getBufferUnsafe().limit());
            Assert.assertEquals((long)slabSize, (long)buffer.getCapacity());
            Assert.assertEquals((long)buffer.getCapacity(), (long)buffer.getBufferUnsafe().capacity());
            size = (int)((double)IOBuffer.smallestSlabSize() * Math.pow(2.0, i));
            buffer = IOBuffer.create((int)size, (int)(size / 3), (boolean)direct);
            Assert.assertEquals((long)(size / 3), (long)buffer.getHighwater());
            Assert.assertEquals((long)size, (long)buffer.getLength());
            Assert.assertEquals((long)buffer.getLength(), (long)buffer.getBufferUnsafe().limit());
            Assert.assertEquals((long)slabSize, (long)buffer.getCapacity());
            Assert.assertEquals((long)buffer.getCapacity(), (long)buffer.getBufferUnsafe().capacity());
        }
    }

    @Test
    public void testMarkersOnCreate_Direct() {
        this.testMarkersOnCreate(true);
    }

    @Test
    public void testMarkersOnCreate_Heap() {
        this.testMarkersOnCreate(false);
    }

    private void testDifferentSizeButSameSlabUseSamePool(boolean direct) {
        UtlPool pool1 = IOBuffer.create((int)(IOBuffer.smallestSlabSize() / 2), (boolean)direct).getPool();
        UtlPool pool2 = IOBuffer.create((int)(IOBuffer.smallestSlabSize() / 3), (boolean)direct).getPool();
        Assert.assertSame((Object)pool1, (Object)pool2);
    }

    @Test
    public void testDifferentSizeButSameSlabUseSamePool_Direct() {
        this.testDifferentSizeButSameSlabUseSamePool(true);
    }

    @Test
    public void testDifferentSizeButSameSlabUseSamePool_Heap() {
        this.testDifferentSizeButSameSlabUseSamePool(false);
    }

    private void testDifferentSlabsUseDifferentPools(boolean direct) {
        UtlPool pool1 = IOBuffer.create((int)IOBuffer.smallestSlabSize(), (boolean)direct).getPool();
        UtlPool pool2 = IOBuffer.create((int)(IOBuffer.smallestSlabSize() + 1), (boolean)direct).getPool();
        Assert.assertNotSame((Object)pool1, (Object)pool2);
    }

    @Test
    public void testDifferentSlabsUseDifferentPools_Direct() {
        this.testDifferentSlabsUseDifferentPools(true);
    }

    @Test
    public void testDifferentSlabsUseDifferentPools_Heap() {
        this.testDifferentSlabsUseDifferentPools(false);
    }

    private void testLifecycle(boolean direct) {
        IOBuffer buffer = IOBuffer.create((int)1, (boolean)direct);
        Assert.assertEquals((long)1L, (long)buffer.getOwnerCount());
        UtlPool pool = buffer.getPool();
        Assert.assertNotNull((Object)pool);
        long gets = pool.stats().gets();
        long puts = pool.stats().puts();
        buffer.acquire();
        Assert.assertEquals((long)2L, (long)buffer.getOwnerCount());
        Assert.assertSame((Object)pool, (Object)buffer.getPool());
        Assert.assertEquals((long)gets, (long)pool.stats().gets());
        Assert.assertEquals((long)puts, (long)pool.stats().puts());
        buffer.dispose();
        Assert.assertEquals((long)1L, (long)buffer.getOwnerCount());
        Assert.assertSame((Object)pool, (Object)buffer.getPool());
        Assert.assertEquals((long)gets, (long)pool.stats().gets());
        Assert.assertEquals((long)puts, (long)pool.stats().puts());
        int newLimit = buffer.getCapacity() * 2 / 3;
        buffer.adjustHighwater(newLimit);
        Assert.assertEquals((long)newLimit, (long)buffer.getLength());
        Assert.assertEquals((long)buffer.getLength(), (long)buffer.getBufferUnsafe().limit());
        buffer.getBufferUnsafe().limit(newLimit + 1);
        buffer.getBufferUnsafe().put(0, (byte)46);
        buffer.getBufferUnsafe().put(newLimit / 2 - 1, (byte)102);
        buffer.getBufferUnsafe().put(newLimit / 2 + 1, (byte)103);
        buffer.getBufferUnsafe().put(newLimit - 1, (byte)-43);
        buffer.getBufferUnsafe().put(newLimit, (byte)-56);
        Assert.assertEquals((long)46L, (long)buffer.getBufferUnsafe().get(0));
        Assert.assertEquals((long)102L, (long)buffer.getBufferUnsafe().get(newLimit / 2 - 1));
        Assert.assertEquals((long)103L, (long)buffer.getBufferUnsafe().get(newLimit / 2 + 1));
        Assert.assertEquals((long)-43L, (long)buffer.getBufferUnsafe().get(newLimit - 1));
        Assert.assertEquals((long)-56L, (long)buffer.getBufferUnsafe().get(newLimit));
        buffer.adjustHighwater(newLimit / 2);
        Assert.assertEquals((long)newLimit, (long)buffer.getHighwater());
        Assert.assertEquals((long)newLimit, (long)buffer.getLength());
        Assert.assertEquals((long)buffer.getLength(), (long)buffer.getBufferUnsafe().limit());
        buffer.dispose();
        Assert.assertEquals((long)0L, (long)buffer.getOwnerCount());
        Assert.assertSame((Object)pool, (Object)buffer.getPool());
        Assert.assertEquals((long)gets, (long)pool.stats().gets());
        Assert.assertEquals((long)(puts + 1L), (long)pool.stats().puts());
        Assert.assertEquals((long)0L, (long)buffer.getBufferUnsafe().get(0));
        Assert.assertEquals((long)0L, (long)buffer.getBufferUnsafe().get(newLimit / 2 - 1));
        Assert.assertEquals((long)0L, (long)buffer.getBufferUnsafe().get(newLimit / 2 + 1));
        Assert.assertEquals((long)0L, (long)buffer.getBufferUnsafe().get(newLimit - 1));
        buffer.getBufferUnsafe().limit(newLimit + 1);
        Assert.assertEquals((long)-56L, (long)buffer.getBufferUnsafe().get(newLimit));
        IOBuffer buffer1 = IOBuffer.create((int)1, (boolean)direct);
        Assert.assertEquals((long)1L, (long)buffer1.getOwnerCount());
        Assert.assertSame((Object)buffer, (Object)buffer1);
        Assert.assertSame((Object)pool, (Object)buffer1.getPool());
        Assert.assertEquals((long)(gets + 1L), (long)pool.stats().gets());
        Assert.assertEquals((long)(puts + 1L), (long)pool.stats().puts());
        Assert.assertEquals((long)1L, (long)buffer1.getHighwater());
    }

    @Test
    public void testLifecycle_Direct() {
        this.testLifecycle(true);
    }

    @Test
    public void testLifecycle_Heap() {
        this.testLifecycle(false);
    }

    private void initWithRandom(byte[] val) {
        for (int i = 0; i < val.length; ++i) {
            val[i] = (byte)this.random.nextInt(256);
        }
    }

    private void testStress(boolean direct) {
        int i;
        byte[][] vals = new byte[10000][IOBuffer.smallestSlabSize()];
        for (int i2 = 0; i2 < 10000; ++i2) {
            this.initWithRandom(vals[i2]);
        }
        IOBuffer[] buffers = new IOBuffer[10000];
        for (i = 0; i < buffers.length; ++i) {
            buffers[i] = IOBuffer.create((int)IOBuffer.smallestSlabSize(), (boolean)direct);
            buffers[i].getBufferUnsafe().put(vals[i]);
        }
        for (i = 0; i < buffers.length; ++i) {
            for (int j = 0; j < vals[i].length; ++j) {
                Assert.assertEquals((long)vals[i][j], (long)buffers[i].getBufferUnsafe().get(j));
            }
        }
    }

    @Test
    public void testStress_Direct() {
        this.testStress(true);
    }

    @Test
    public void testStress_Heap() {
        this.testStress(false);
    }
}

