/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

public final class PktConstants {
    public static final int SERIALIZE_POLICY_DEFAULT = 0;
    public static final int SERIALIZE_POLICY_HEADER_COPY_BODY_COPY = 1;
    public static final int SERIALIZE_POLICY_HEADER_COPY_BODY_ATTACH = 2;
    public static final int SERIALIZE_POLICY_HEADER_ATTACH_BODY_ATTACH = 3;
    private static final String[] serializationPolicyStrs = new String[]{"default", "hdrbodycopy", "hdrcopybodyattch", "hdrbodyattch"};
    public static final int DESERIALIZE_POLICY_DEFAULT = 0;
    public static final int DESERIALIZE_POLICY_HEADER_COPY_BODY_COPY = 1;
    public static final int DESERIALIZE_POLICY_HEADER_COPY_BODY_SLICE = 2;
    public static final int DESERIALIZE_POLICY_HEADER_SLICE_BODY_SLICE = 3;
    private static final String[] deserializationPolicyStrs = new String[]{"default", "hdrbodycopy", "hdrcopybodyslice", "hdrbodyslice"};

    public static String serializationPolicyToStr(int policy) {
        try {
            return serializationPolicyStrs[policy];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("specified serialization policy is invalid");
        }
    }

    public static int serializationPolicyFromStr(String policyStr) {
        for (int i = 0; i < serializationPolicyStrs.length; ++i) {
            if (serializationPolicyStrs[i].compareToIgnoreCase(policyStr) != 0) continue;
            return i;
        }
        throw new IllegalArgumentException("specified serialization policy str is invalid");
    }

    public static String deserializationPolicyToStr(int policy) {
        try {
            return deserializationPolicyStrs[policy];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("specified deserialization policy is invalid");
        }
    }

    public static int deserializationPolicyFromStr(String policyStr) {
        for (int i = 0; i < deserializationPolicyStrs.length; ++i) {
            if (deserializationPolicyStrs[i].compareToIgnoreCase(policyStr) != 0) continue;
            return i;
        }
        throw new IllegalArgumentException("specified deserialization policy str is invalid");
    }
}

