/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.test.unit;

import com.neeve.link.ELnkDescriptorFormatException;
import com.neeve.link.ELnkEndpointClassInstantiateException;
import com.neeve.link.ELnkEndpointClassLoadException;
import com.neeve.link.ELnkInvalidLinkTypeException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkServerEndpoint;
import com.neeve.link.LnkFactory;
import com.neeve.link.test.unit.LnkTestCepVlt13;
import com.neeve.link.test.unit.LnkTestSepVlt13;
import com.neeve.link.test.unit.LnkTestTypes;
import com.neeve.test.UnitTest;
import org.junit.BeforeClass;
import org.junit.Test;

public final class LnkFactoryTest
extends UnitTest {
    @BeforeClass
    public static void createLinkTypeConfigFiles() {
        LnkTestTypes.load();
    }

    @Test
    public void test1() {
        try {
            LnkFactory.getInstance().createClientEndpoint("invlt", null);
            LnkFactoryTest.testFailure((String)"'invlt' passed as a link descriptor");
        }
        catch (ELnkDescriptorFormatException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test2() {
        try {
            LnkFactory.getInstance().createServerEndpoint("invlt", null);
            LnkFactoryTest.testFailure((String)"'invlt' passed as a link descriptor");
        }
        catch (ELnkDescriptorFormatException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test3() {
        try {
            LnkFactory.getInstance().createClientEndpoint("invlt://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test4() {
        try {
            LnkFactory.getInstance().createServerEndpoint("invlt://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test5() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt0://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test6() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt0://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test7() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt1://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test8() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt1://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test9() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt2://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an valid link type but invalid classname!");
        }
        catch (ELnkEndpointClassLoadException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test10() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt2://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test11() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt3://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test12() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt3://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test13() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt4://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test14() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt4://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an valid link type but invalid classname!");
        }
        catch (ELnkEndpointClassLoadException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test15() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt5://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test16() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt5://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an invalid link type!");
        }
        catch (ELnkInvalidLinkTypeException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test17() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt6://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an valid link type but invalid classname!");
        }
        catch (ELnkEndpointClassLoadException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test18() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt6://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an valid link type but invalid classname!");
        }
        catch (ELnkEndpointClassLoadException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test19() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt7://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an valid link type but class missing create method!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test20() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt7://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an valid link type but class missing create method!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test21() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt8://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an valid link type but create method signature incorrect!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test22() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt8://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an valid link type but create method signature incorrect!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test23() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt9://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an valid link type but create method returns null!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test24() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt9://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an valid link type but create method returns null!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test25() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt10://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an valid link type but create method threw exception!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test26() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt10://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an valid link type but create method threw exception!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test27() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt11://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an valid link type but create method threw error!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test28() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt11://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an valid link type but create method threw error!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test29() {
        try {
            LnkFactory.getInstance().createClientEndpoint("vlt12://addr", null);
            LnkFactoryTest.testFailure((String)"Client endpoint returned for an valid link type but create method returned an invalid object type!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test30() {
        try {
            LnkFactory.getInstance().createServerEndpoint("vlt12://addr", null);
            LnkFactoryTest.testFailure((String)"Server endpoint returned for an valid link type but create method returned an invalid object type!");
        }
        catch (ELnkEndpointClassInstantiateException e) {
            LnkFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test31() {
        try {
            String str;
            ILnkClientEndpoint cep = LnkFactory.getInstance().createClientEndpoint("vlt13://addr", null);
            if (!(cep instanceof LnkTestCepVlt13)) {
                LnkFactoryTest.testFailure((String)("Instantiated incorrect class [" + cep + "]"));
            }
            if ((str = ((LnkTestCepVlt13)cep).toString()).compareTo("vlt13addr") != 0) {
                LnkFactoryTest.testFailure((String)("Descriptor was not parsed correctly. Should be 'vlt3addr'. Was '" + str + "'"));
            }
            LnkFactoryTest.testSuccess((String)"Successfully parsed descriptor and created client endpoint");
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void test32() {
        try {
            String str;
            ILnkServerEndpoint sep = LnkFactory.getInstance().createServerEndpoint("vlt13://addr", null);
            if (!(sep instanceof LnkTestSepVlt13)) {
                LnkFactoryTest.testFailure((String)("Instantiated incorrect class [" + sep + "]"));
            }
            if ((str = ((LnkTestSepVlt13)sep).toString()).compareTo("vlt13addr") != 0) {
                LnkFactoryTest.testFailure((String)("Descriptor was not parsed correctly. Should be 'vlt3addr'. Was '" + str + "'"));
            }
            LnkFactoryTest.testSuccess((String)"Successfully parsed descriptor and created server endpoint");
        }
        catch (Exception e) {
            LnkFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }
}

