/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxNwAcceptReadyEvent;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.emx.test.unit.EmxNwLnkClientEndpointTest;
import com.neeve.emx.test.unit.EmxNwLnkEndpointTest;
import org.junit.Assume;
import org.junit.Test;

public final class EmxNwLnkServerEndpointTest
extends EmxNwLnkEndpointTest {
    static IEmxNwLnkPeerEndpoint accept(IEmxNwLnkServerEndpoint sep, EmxNwLnkOpWaitCond waitCond) throws Exception {
        return sep.accept(waitCond);
    }

    static IEmxNwAcceptReadyEvent prepareNwAcceptReadyEvent(IEmxNwLnkServerEndpoint sep) throws Exception {
        IEmxNwLnkPeerEndpoint pep;
        EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
        do {
            if ((pep = EmxNwLnkServerEndpointTest.accept(sep, waitCond)) == null) continue;
            pep.close();
        } while (pep != null);
        return (IEmxNwAcceptReadyEvent)waitCond.list().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAccept(IEmxNwLnkServerEndpoint sep, String desc, boolean exppep, Exception exp) throws Exception {
        IEmxNwLnkPeerEndpoint pep;
        block12: {
            pep = null;
            try {
                boolean gotpep;
                EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
                pep = EmxNwLnkServerEndpointTest.accept(sep, waitCond);
                boolean bl = gotpep = pep != null;
                if (gotpep == exppep && exp == null) {
                    if (pep == null && waitCond.list().size() == 0) {
                        EmxNwLnkServerEndpointTest.testFailure((String)"Accept returned 'accept pending' but has not set any wait condition!");
                    }
                    EmxNwLnkServerEndpointTest.testSuccess((String)("Successfully accepted through server endpoint [desc=" + desc + "]"));
                    break block12;
                }
                if (exp != null) {
                    if (exppep) {
                        throw new InternalError("Cannot expect to accept a PEP and have accept throw an exception!");
                    }
                    if (gotpep) {
                        EmxNwLnkServerEndpointTest.testFailure((String)("Server endpoint accept [desc=" + desc + "] reported 'accept success' when it should have failed! [exp=" + exp.getClass().getName() + "]"));
                    } else {
                        EmxNwLnkServerEndpointTest.testFailure((String)("Server endpoint accept [desc=" + desc + "] reported 'accept pending' when it should have failed! [exp=" + exp.getClass().getName() + "]"));
                    }
                    break block12;
                }
                if (exp != null) break block12;
                if (!gotpep) {
                    EmxNwLnkServerEndpointTest.testFailure((String)("Server endpoint accept [desc=" + desc + "] reported 'accept pending' when it should have reported 'accept success'!"));
                    break block12;
                }
                EmxNwLnkServerEndpointTest.testFailure((String)("Server endpoint accept [desc=" + desc + "] reported 'accept success' when it should have reported 'accept pending'!"));
            }
            catch (Exception e) {
                block13: {
                    try {
                        if (exp != null && exp.getClass().isInstance(e)) {
                            EmxNwLnkServerEndpointTest.testSuccess((String)("Server endpoint accept [desc=" + desc + "] successfully threw exception [" + e.toString() + "]"));
                            break block13;
                        }
                        EmxNwLnkServerEndpointTest.testFailure((String)("Server endpoint accept [desc=" + desc + "] threw incorrect exception [exp=" + (exp != null ? exp.getClass().getName() : "null") + " actual=" + e.toString() + "]"));
                    }
                    catch (Throwable throwable) {
                        EmxNwLnkServerEndpointTest.testClose(pep, null);
                        throw throwable;
                    }
                }
                EmxNwLnkServerEndpointTest.testClose(pep, null);
            }
        }
        EmxNwLnkServerEndpointTest.testClose(pep, null);
    }

    private void testCreateDiffLocalAddr(EmxFactory.EmxImpl impl, String desc1, String desc2) throws Exception {
        IEmxNwLnkServerEndpoint sep1 = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc1, null);
        IEmxNwLnkServerEndpoint sep2 = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc2, null);
        EmxNwLnkServerEndpointTest.testClose(sep1, null);
        EmxNwLnkServerEndpointTest.testClose(sep2, null);
    }

    private void testCreateSameLocalAddr(EmxFactory.EmxImpl impl, String desc1, String desc2) throws Exception {
        IEmxNwLnkServerEndpoint sep1 = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc1, null);
        try {
            IEmxNwLnkServerEndpoint sep2 = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc2, null);
            sep2.close();
        }
        catch (EEmxException e) {
            EmxNwLnkServerEndpointTest.testSuccess((String)("Server endpoint creation with already assigned local address successfully threw exception [" + e.toString() + "]"));
        }
        EmxNwLnkServerEndpointTest.testClose(sep1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAccept(EmxFactory.EmxImpl impl, String desc, boolean exppep, Exception exp) throws Exception {
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        try {
            this.testAccept(sep, desc, exppep, exp);
            if (exp != null) {
                this.testAccept(sep, desc, exppep, exp);
            }
        }
        finally {
            EmxNwLnkServerEndpointTest.testClose(sep, null);
        }
    }

    private void testAcceptFailFailFail(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        this.testAccept(sep, desc, false, null);
        this.testAccept(sep, desc, false, null);
        this.testAccept(sep, desc, false, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
    }

    private void testAcceptFailFailSuccess(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        this.testAccept(sep, desc, false, null);
        this.testAccept(sep, desc, false, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
    }

    private void testAcceptFailSuccessFail(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        this.testAccept(sep, desc, false, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        this.testAccept(sep, desc, false, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
    }

    private void testAcceptFailSuccessSuccess(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        this.testAccept(sep, desc, false, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
    }

    private void testAcceptSuccessFailFail(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        this.testAccept(sep, desc, false, null);
        this.testAccept(sep, desc, false, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
    }

    private void testAcceptSuccessFailSuccess(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        this.testAccept(sep, desc, false, null);
        cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
    }

    private void testAcceptSuccessSuccessFail(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        this.testAccept(sep, desc, false, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
    }

    private void testAcceptSuccessSuccessSuccess(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
    }

    private void testAcceptAfterClose(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
        this.testAccept(sep, desc, false, (Exception)((Object)new EEmxInvalidStateException("", "")));
    }

    private void testCloseAfterSuccessfulAccept(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        this.testAccept(sep, desc, true, null);
        EmxNwLnkServerEndpointTest.testClose(sep, null);
    }

    private void testCloseAfterClose(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkServerEndpoint cep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkServerEndpointTest.testClose(cep, null);
        EmxNwLnkServerEndpointTest.testClose(cep, null);
    }

    @Test
    public void testCreateInvalidDescContent() {
        try {
            this.testCreateInvalidDescContent(1, EmxFactory.EmxImpl.NIO, "tcp://1.0.0.0:4400");
            this.testCreateInvalidDescContent(1, EmxFactory.EmxImpl.NIO, "tcp://localhost:-1");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateValidDescContent() {
        try {
            this.testCreateValidDescContent(1, EmxFactory.EmxImpl.NIO, "tcp://0.0.0.0:0");
            this.testCreateValidDescContent(1, EmxFactory.EmxImpl.NIO, "tcp://0.0.0.0:4400");
            this.testCreateValidDescContent(1, EmxFactory.EmxImpl.NIO, "tcp://localhost:0");
            this.testCreateValidDescContent(1, EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateDiffLocalAddr() {
        try {
            this.testCreateDiffLocalAddr(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400", "tcp://localhost:4401");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateSameLocalAddr() {
        try {
            this.testCreateSameLocalAddr(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400", "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testPropsSet() {
        Assume.assumeFalse((System.getProperty("os.name", "").toLowerCase().indexOf("win") >= 0 ? 1 : 0) != 0);
        try {
            this.testTCPAndSocketPropsOnEndpoint(1, EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptNoClient() {
        try {
            this.testAccept(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400", false, null);
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptFailFailFail() {
        try {
            this.testAcceptFailFailFail(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptFailFailSuccess() {
        try {
            this.testAcceptFailFailSuccess(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptFailSuccessFail() {
        try {
            this.testAcceptFailSuccessFail(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptFailSuccessSuccess() {
        try {
            this.testAcceptFailSuccessSuccess(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptSuccessFailFail() {
        try {
            this.testAcceptSuccessFailFail(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptSuccessFailSuccess() {
        try {
            this.testAcceptSuccessFailSuccess(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptSuccessSuccessFail() {
        try {
            this.testAcceptSuccessSuccessFail(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptSuccessSuccessSuccess() {
        try {
            this.testAcceptSuccessSuccessSuccess(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAcceptAfterClose() {
        try {
            this.testAcceptAfterClose(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCloseAfterSuccessfulAccept() {
        try {
            this.testCloseAfterSuccessfulAccept(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCloseAfterUnsuccessfulAccept() {
        try {
            this.testCloseAfterSuccessfulAccept(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCloseAfterClose() {
        try {
            this.testCloseAfterClose(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkServerEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }
}

