/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkNonBlockingReader;
import com.neeve.emx.test.unit.EmxNwLnkReaderTest;
import org.junit.Assert;
import org.junit.Test;

public final class EmxNwLnkNonBlockingReaderTest
extends EmxNwLnkReaderTest {
    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNullCallback() throws Exception {
        EmxNwLnkNonBlockingReader.create(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateAddNullLink() throws Exception {
        EmxNwLnkNonBlockingReader.create(null).addLink(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateAddLink() throws Exception {
        EmxNwLnkNonBlockingReader.create(new EmxNwLnkReaderTest.Callback()).addLink(this.clink);
    }

    @Test
    public void testCreateStop() throws Exception {
        EmxNwLnkNonBlockingReader.create(new EmxNwLnkReaderTest.Callback()).stop();
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateStopAddLink() throws Exception {
        EmxNwLnkNonBlockingReader creader = EmxNwLnkNonBlockingReader.create(new EmxNwLnkReaderTest.Callback());
        creader.stop();
        creader.addLink(this.clink);
    }

    @Test
    public void testCreateStopStart() throws Exception {
        EmxNwLnkNonBlockingReader creader = EmxNwLnkNonBlockingReader.create(new EmxNwLnkReaderTest.Callback());
        creader.stop();
        Thread thread = new Thread(creader);
        thread.start();
        thread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStartStop() throws Exception {
        EmxNwLnkReaderTest.Callback cb = new EmxNwLnkReaderTest.Callback();
        EmxNwLnkNonBlockingReader creader = EmxNwLnkNonBlockingReader.create(cb);
        try {
            Thread thread = new Thread(creader);
            thread.start();
            Thread.sleep(1000L);
            Assert.assertTrue((boolean)thread.isAlive());
            creader.stop();
            Assert.assertFalse((boolean)thread.isAlive());
            Assert.assertNull((Object)cb.failureCause);
        }
        finally {
            creader.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testCreateStartStopAddLink() throws Exception {
        EmxNwLnkReaderTest.Callback cb = new EmxNwLnkReaderTest.Callback();
        EmxNwLnkNonBlockingReader creader = EmxNwLnkNonBlockingReader.create(cb);
        try {
            Thread thread = new Thread(creader);
            thread.start();
            Thread.sleep(1000L);
            Assert.assertTrue((boolean)thread.isAlive());
            creader.stop();
            Assert.assertFalse((boolean)thread.isAlive());
            Assert.assertNull((Object)cb.failureCause);
        }
        finally {
            creader.stop();
        }
        creader.addLink(this.clink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStartAddLinkServerSideClose() throws Exception {
        EmxNwLnkReaderTest.Callback cb = new EmxNwLnkReaderTest.Callback();
        EmxNwLnkNonBlockingReader creader = EmxNwLnkNonBlockingReader.create(cb);
        try {
            Thread thread = new Thread(creader);
            thread.start();
            creader.waitForStart();
            creader.addLink(this.clink);
            this.slink.close();
            cb.waitUntilClose(1000L);
            Assert.assertTrue((boolean)cb.receivedClose);
            Assert.assertNull((Object)cb.failureCause);
        }
        finally {
            creader.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStartAddLinkClientSideClose() throws Exception {
        EmxNwLnkReaderTest.Callback cb = new EmxNwLnkReaderTest.Callback();
        EmxNwLnkNonBlockingReader creader = EmxNwLnkNonBlockingReader.create(cb);
        try {
            Thread thread = new Thread(creader);
            thread.start();
            creader.waitForStart();
            creader.addLink(this.clink);
            this.clink.close();
            cb.waitUntilFail(1000L);
            Assert.assertFalse((boolean)cb.receivedClose);
            Assert.assertNull((String)("Unexpected reader failure: " + cb.failureCause), (Object)cb.failureCause);
        }
        finally {
            creader.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStartBidirectionalDataExchange() throws Exception {
        EmxNwLnkReaderTest.Callback ccb = new EmxNwLnkReaderTest.Callback();
        EmxNwLnkNonBlockingReader creader = EmxNwLnkNonBlockingReader.create(ccb);
        try {
            Thread cthread = new Thread(creader);
            cthread.start();
            creader.waitForStart();
            creader.addLink(this.clink);
            EmxNwLnkReaderTest.Callback scb = new EmxNwLnkReaderTest.Callback();
            EmxNwLnkNonBlockingReader sreader = EmxNwLnkNonBlockingReader.create(scb);
            try {
                Thread sthread = new Thread(sreader);
                sthread.start();
                sreader.waitForStart();
                sreader.addLink(this.slink);
                this.clink.configureBlockingWrite(true);
                this.slink.configureBlockingWrite(true);
                EmxNwLnkReaderTest.Writer cwriter = new EmxNwLnkReaderTest.Writer(this.clink);
                EmxNwLnkReaderTest.Writer swriter = new EmxNwLnkReaderTest.Writer(this.slink);
                cwriter.start();
                swriter.start();
                cwriter.join();
                swriter.join();
                scb.waitUntilBytesReceived(cwriter.bytesSent, 10000L);
                Assert.assertEquals((long)cwriter.bytesSent, (long)scb.bytesReceived);
                ccb.waitUntilBytesReceived(swriter.bytesSent, 10000L);
                Assert.assertEquals((long)swriter.bytesSent, (long)ccb.bytesReceived);
            }
            finally {
                sreader.stop();
            }
        }
        finally {
            creader.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStartFaninPublish() throws Exception {
        EmxNwLnk clink1 = this.clink;
        EmxNwLnk slink1 = this.slink;
        this.before();
        EmxNwLnk clink2 = this.clink;
        EmxNwLnk slink2 = this.slink;
        try {
            EmxNwLnkReaderTest.Callback ccb = new EmxNwLnkReaderTest.Callback();
            EmxNwLnkNonBlockingReader creader = EmxNwLnkNonBlockingReader.create(ccb);
            try {
                Thread cthread = new Thread(creader);
                cthread.start();
                creader.waitForStart();
                creader.addLink(clink1);
                creader.addLink(clink2);
                slink1.configureBlockingWrite(true);
                slink2.configureBlockingWrite(true);
                EmxNwLnkReaderTest.Writer swriter1 = new EmxNwLnkReaderTest.Writer(slink1);
                EmxNwLnkReaderTest.Writer swriter2 = new EmxNwLnkReaderTest.Writer(slink2);
                swriter1.start();
                swriter2.start();
                swriter1.join();
                swriter2.join();
                ccb.waitUntilBytesReceived(swriter1.bytesSent + swriter2.bytesSent, 10000L);
                Assert.assertEquals((long)(swriter1.bytesSent + swriter2.bytesSent), (long)ccb.bytesReceived);
            }
            finally {
                creader.stop();
            }
        }
        finally {
            clink1.close();
            slink1.close();
        }
    }
}

