/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkAcceptor;
import com.neeve.test.UnitTest;
import org.junit.Assert;
import org.junit.Test;

public final class EmxNwLnkAcceptorTest
extends UnitTest {
    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNullDescriptor() throws Exception {
        EmxNwLnkAcceptor.create(null, new Callback());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNullCallback() throws Exception {
        EmxNwLnkAcceptor.create("tcp://localhost:6000", null);
    }

    @Test
    public void testCreateClose() throws Exception {
        EmxNwLnkAcceptor.create("tcp://localhost:6000", new Callback()).close();
    }

    @Test
    public void testCreateCloseStart() throws Exception {
        try (EmxNwLnkAcceptor acceptor = EmxNwLnkAcceptor.create("tcp://localhost:0", new Callback());){
            acceptor.close();
            Thread thread = new Thread(acceptor);
            thread.start();
            thread.join();
        }
    }

    @Test
    public void testCreateStartClose() throws Exception {
        Callback cb = new Callback();
        EmxNwLnkAcceptor acceptor = EmxNwLnkAcceptor.create("tcp://localhost:0", cb);
        Thread thread = new Thread(acceptor);
        thread.start();
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)thread.isAlive());
        acceptor.close();
        Assert.assertFalse((boolean)thread.isAlive());
        Assert.assertNull((Object)cb.failureCause);
    }

    static final class Callback
    implements EmxNwLnkAcceptor.Callback {
        EmxNwLnk link;
        Throwable failureCause;

        Callback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitUntilAccept(long timeout) throws InterruptedException {
            Callback callback = this;
            synchronized (callback) {
                long start = System.currentTimeMillis();
                long remaining = timeout;
                while (remaining > 0L && this.link == null) {
                    this.wait(remaining);
                    remaining = timeout - (System.currentTimeMillis() - start);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handleAcceptedLink(EmxNwLnk link) {
            Callback callback = this;
            synchronized (callback) {
                this.link = link;
                this.notifyAll();
            }
        }

        @Override
        public final void handleAcceptorFailure(Throwable cause) {
            this.failureCause = cause;
        }
    }
}

