/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.nio.tcp;

import com.neeve.ci.XRuntime;
import com.neeve.command.Command;
import com.neeve.command.ECommandException;
import com.neeve.command.ECommandInvalidDataTypeException;
import com.neeve.command.ECommandNotSupportedException;
import com.neeve.command.ICommandHandler;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkInetAddrFormatException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkInetAddr;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.EmxNwLnkProps;
import com.neeve.emx.IEmxNwConnectReadyEvent;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.nio.EmxNioNwConnectReadyEvent;
import com.neeve.emx.nio.EmxNioNwLnkEndpoint;
import com.neeve.emx.nio.tcp.EmxNioTcpNwLnkPeerEndpoint;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;

public final class EmxNioTcpNwLnkClientEndpoint
extends EmxNioNwLnkEndpoint
implements IEmxNwLnkClientEndpoint,
ICommandHandler {
    private final EmxNioNwLnkEndpoint.StringProperty localIfAddr = new EmxNioNwLnkEndpoint.StringProperty(EmxNwLnkProps.Socket.localifaddr.toString(), "0.0.0.0");
    private final EmxNioNwLnkEndpoint.IntProperty localPort = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.localport.toString(), 0);
    private final EmxNioNwLnkEndpoint.StringProperty remoteIfAddr = new EmxNioNwLnkEndpoint.StringProperty(EmxNwLnkProps.Socket.remoteifaddr.toString(), "0.0.0.0");
    private final EmxNioNwLnkEndpoint.IntProperty remotePort = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.remoteport.toString(), 0);
    private final EmxNioNwLnkEndpoint.BooleanProperty tcpKeepAlive = new EmxNioNwLnkEndpoint.BooleanProperty(EmxNwLnkProps.Tcp.keepalive.toString(), false);
    private final EmxNioNwLnkEndpoint.BooleanProperty tcpNoDelay = new EmxNioNwLnkEndpoint.BooleanProperty(EmxNwLnkProps.Tcp.nodelay.toString(), XRuntime.optimizeForLatency());
    private final EmxNioNwLnkEndpoint.IntProperty sendBufferSize = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.sendbuffersize.toString(), Short.MAX_VALUE);
    private final EmxNioNwLnkEndpoint.IntProperty recvBufferSize = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.recvbuffersize.toString(), Short.MAX_VALUE);
    private final EmxNioNwLnkEndpoint.BooleanProperty linger = new EmxNioNwLnkEndpoint.BooleanProperty(EmxNwLnkProps.Socket.linger.toString(), true);
    private final EmxNioNwLnkEndpoint.IntProperty lingerTime = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.lingertime.toString(), 10);
    private final UtlAddressDescriptor descriptor;
    private SocketChannel sc;
    private EmxNioNwConnectReadyEvent crevent;
    private boolean connected;
    private boolean closed;

    private EmxNioTcpNwLnkClientEndpoint(UtlAddressDescriptor descriptor) throws EEmxException {
        EmxNwLnkInetAddr inetAddr;
        this.tracer.setLevel(XRuntime.getProps(), "nv.emx.nio.tcp.trace");
        this.descriptor = descriptor;
        try {
            inetAddr = EmxNwLnkInetAddr.parse(this.descriptor.address);
        }
        catch (IllegalArgumentException e) {
            throw new EEmxNwLnkInetAddrFormatException(this.descriptor.address);
        }
        this.descriptor.props.put(EmxNwLnkProps.Socket.remoteifaddr.toString(), inetAddr.host);
        this.descriptor.props.put(EmxNwLnkProps.Socket.remoteport.toString(), String.valueOf(inetAddr.port));
        this.localIfAddr.init(this.descriptor.props).save(this.descriptor.props);
        this.localPort.init(this.descriptor.props).save(this.descriptor.props);
        this.remoteIfAddr.init(this.descriptor.props).save(this.descriptor.props);
        this.remotePort.init(this.descriptor.props).save(this.descriptor.props);
        this.tcpKeepAlive.init(this.descriptor.props).save(this.descriptor.props);
        this.tcpNoDelay.init(this.descriptor.props).save(this.descriptor.props);
        this.sendBufferSize.init(this.descriptor.props).save(this.descriptor.props);
        this.recvBufferSize.init(this.descriptor.props).save(this.descriptor.props);
        this.linger.init(this.descriptor.props).save(this.descriptor.props);
        this.lingerTime.init(this.descriptor.props).save(this.descriptor.props);
        this.init();
    }

    public static IEmxNwLnkClientEndpoint create(UtlAddressDescriptor descriptor) throws EEmxException {
        return new EmxNioTcpNwLnkClientEndpoint(descriptor);
    }

    private final void init() throws EEmxException {
        try {
            this.closeInternal();
        }
        catch (Exception e) {
            this.tracer.log("Failure in closing the TCP network link client endpoint socket channel suring reinitialization [" + e.toString() + "]", Tracer.Level.WARNING);
        }
        try {
            this.sc = SocketChannel.open();
        }
        catch (Exception e) {
            this.tracer.log("Failure in creating the TCP network link client endpoint socket channel [" + e.toString() + "]", Tracer.Level.WARNING);
            throw new EEmxException(e);
        }
        try {
            this.sc.socket().bind(new InetSocketAddress(this.localIfAddr.value(), this.localPort.value()));
        }
        catch (Exception e) {
            this.tracer.log("Failure in binding the TCP network link client endpoint socket to " + this.localIfAddr.value() + ":" + this.localPort.value() + " [" + e.toString() + "]", Tracer.Level.WARNING);
            throw new EEmxException(e);
        }
        EmxNioNwLnkEndpoint.StringProperty localIfAddrBound = new EmxNioNwLnkEndpoint.StringProperty(EmxNwLnkProps.Socket.localifaddrbound.toString(), this.sc.socket().getLocalAddress().getHostAddress());
        EmxNioNwLnkEndpoint.IntProperty localPortBound = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.localportbound.toString(), this.sc.socket().getLocalPort());
        localIfAddrBound.init(null).save(this.descriptor.props);
        localPortBound.init(null).save(this.descriptor.props);
        try {
            this.sc.configureBlocking(false);
        }
        catch (Exception e) {
            this.tracer.log("Failure in configuring the TCP network link client endpoint socket to non-blocking [" + e.toString() + "]", Tracer.Level.WARNING);
            throw new EEmxException(e);
        }
        this.tracer.log("TCP Network Link Client Endpoint Configuration...", Tracer.Level.CONFIG);
        try {
            this.tracer.log("....localaddr = " + this.localIfAddr.value() + ":" + this.localPort.value() + " {actual = " + localIfAddrBound.value() + ":" + localPortBound.value() + "}", Tracer.Level.CONFIG);
            this.tracer.log("....remoteaddr = " + this.remoteIfAddr.value() + ":" + this.remotePort.value() + " {actual = 0.0.0.0:0}", Tracer.Level.CONFIG);
            this.sc.socket().setKeepAlive(this.tcpKeepAlive.value());
            this.tracer.log("....tcp keepalive = " + this.tcpKeepAlive.value() + " {actual = " + this.sc.socket().getKeepAlive() + "}", Tracer.Level.CONFIG);
            this.sc.socket().setTcpNoDelay(this.tcpNoDelay.value());
            this.tracer.log("....tcp nodelay = " + this.tcpNoDelay.value() + " {actual = " + this.sc.socket().getTcpNoDelay() + "}", Tracer.Level.CONFIG);
            this.sc.socket().setSoLinger(this.linger.value(), this.linger.value() ? this.lingerTime.value() : 0);
            this.tracer.log("....socket linger = " + this.linger.value() + " (" + (this.linger.value() ? this.lingerTime.value() : 0) + ") {actual = " + this.sc.socket().getSoLinger() + "}", Tracer.Level.CONFIG);
            if (this.sendBufferSize.value() > 0) {
                this.sc.socket().setSendBufferSize(this.sendBufferSize.value());
            }
            this.tracer.log("....socket send buffer size = " + this.sendBufferSize.value() + " {actual = " + this.sc.socket().getSendBufferSize() + "}", Tracer.Level.CONFIG);
            if (this.recvBufferSize.value() > 0) {
                this.sc.socket().setReceiveBufferSize(this.recvBufferSize.value());
            }
            this.tracer.log("....socket recv buffer size = " + this.recvBufferSize.value() + " {actual = " + this.sc.socket().getReceiveBufferSize() + "}", Tracer.Level.CONFIG);
        }
        catch (Exception e) {
            this.tracer.log("Failure in configuring a TCP network link client endpoint socket property [" + e.toString() + "]", Tracer.Level.WARNING);
            throw new EEmxException(e);
        }
        this.crevent = new EmxNioNwConnectReadyEvent(this.sc);
        this.closed = false;
        this.connected = false;
    }

    private final void onGetpropsCommand(HashMap<String, Object> props) throws SocketException {
        this.getSocketNTcpProps(this.sc, props);
    }

    private final void configureBlockingInternal(boolean blocking) throws IOException {
        this.sc.configureBlocking(blocking);
    }

    private final boolean isBlockingInternal() {
        return this.sc.isBlocking();
    }

    private final IEmxNwLnkPeerEndpoint connectInternal(EmxNwLnkOpWaitCond waitCond) throws EEmxNwLnkOpFailedException {
        if (waitCond != null) {
            waitCond.reset();
        }
        this.tracer.log("Connecting TCP network link client endpoint to " + this.remoteIfAddr.value() + ":" + this.remotePort.value() + "...", Tracer.Level.FINE);
        try {
            if (!this.sc.isConnectionPending() ? this.sc.connect(new InetSocketAddress(this.remoteIfAddr.value(), this.remotePort.value())) : this.sc.finishConnect()) {
                this.connected = true;
                this.tracer.log("Connect successfully completed.", Tracer.Level.FINE);
                return new EmxNioTcpNwLnkPeerEndpoint(null, this.sc, this.descriptor);
            }
            this.tracer.log("Connect pending completion.", Tracer.Level.FINE);
            waitCond.add(this.crevent);
            return null;
        }
        catch (Exception e) {
            this.tracer.log("Connect failed [" + e.toString() + "]", Tracer.Level.FINE);
            try {
                this.init();
            }
            catch (Exception e1) {
                this.tracer.log("Failed to reinitialize underlying socket on connect failure [" + e1.toString() + "]. Subsequent connects may not succeed.", Tracer.Level.WARNING);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new EEmxNwLnkOpFailedException(e);
        }
    }

    private final void closeInternal() throws IOException {
        if (this.sc != null) {
            this.sc.socket().close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void configureBlocking(boolean blocking) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (this.closed) throw new EEmxInvalidStateException("network link client endpoint configure blocking", "closed");
        if (this.connected) throw new EEmxInvalidStateException("network link client endpoint configure blocking", "connected");
        try {
            this.configureBlockingInternal(blocking);
            return;
        }
        catch (Exception e) {
            this.tracer.log("Failure in configuring the TCP network link client endpoint socket to " + (blocking ? "blocking" : "non-blocking") + " [" + e.toString() + "]", Tracer.Level.WARNING);
            if (!(e instanceof RuntimeException)) throw new EEmxNwLnkOpFailedException(e);
            throw (RuntimeException)e;
        }
    }

    @Override
    public final boolean isBlocking() throws EEmxInvalidStateException {
        if (!this.closed) {
            return this.isBlockingInternal();
        }
        throw new EEmxInvalidStateException("network link client endpoint is blocking", "closed");
    }

    @Override
    public final IEmxNwLnkPeerEndpoint connect(EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (!this.connected) {
                return this.connectInternal(waitCond);
            }
            throw new EEmxInvalidStateException("network link client endpoint connect", "connected");
        }
        throw new EEmxInvalidStateException("network link client endpoint connect", "closed");
    }

    @Override
    public final IEmxNwLnkPeerEndpoint connect() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        return this.connect(null);
    }

    @Override
    public final IEmxNwConnectReadyEvent getConnectReadyEvent() {
        return this.crevent;
    }

    @Override
    public final void close() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (!this.connected) {
                if (this.sc.socket().isConnected()) {
                    throw new InternalError("Socket is connected but TCP network link client endpoint is not!");
                }
                this.tracer.log("Closing TCP network link client endpoint...", Tracer.Level.FINE);
                try {
                    this.closeInternal();
                }
                catch (IOException e) {
                    this.tracer.log("Failure in closing TCP network link client endpoint [" + e.toString() + "].", Tracer.Level.WARNING);
                }
                finally {
                    this.closed = true;
                }
            } else {
                throw new EEmxInvalidStateException("network link client endpoint close", "connected");
            }
        }
    }

    public final Object procCommand(String command, Object data) throws ECommandException {
        try {
            switch (Command.valueOf((String)command)) {
                case getprops: {
                    try {
                        HashMap props = (HashMap)data;
                        if (props != null) {
                            this.onGetpropsCommand(props);
                            return props;
                        }
                        throw new ECommandInvalidDataTypeException(command, "java.util.HashMap<String, Object>", "null");
                    }
                    catch (ClassCastException e) {
                        throw new ECommandInvalidDataTypeException(command, "java.util.HashMap<String, Object>", data.getClass().getName());
                    }
                }
            }
            throw new ECommandNotSupportedException(command.toString());
        }
        catch (Exception e) {
            throw new ECommandException((Throwable)e);
        }
    }
}

