/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.license;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;

public final class License
extends Properties {
    private static final long serialVersionUID = 1L;
    static final String DEFVAL_ISSUED_TO = "<unknown>";
    static final String DEFVAL_EXPIRATION_DATE = "01/01/1970 00:00:00 GMT";
    public static final String PROP_CODE = "Code";
    public static final String PROP_KEY = "Key";
    public static final String PROP_TYPE = "Type";
    public static final String PROP_ISSUED_TO = "IssuedTo";
    public static final String PROP_PERPETUAL = "Perpetual";
    public static final String PROP_EXPIRATION_DATE = "Expires";
    static final String PROP_EXPIRATION_DATE_FORMAT = "MM/dd/yyyy HH:mm:ss zzz";
    private transient URL source;

    public License() {
        try {
            Date datum = new SimpleDateFormat(PROP_EXPIRATION_DATE_FORMAT).parse("01/01/2000 00:00:00 GMT");
            this.setProperty(PROP_CODE, String.format("%08X", (int)((new Date().getTime() - datum.getTime()) / 1000L)));
            this.setProperty(PROP_ISSUED_TO, DEFVAL_ISSUED_TO);
            this.setProperty(PROP_PERPETUAL, "false");
            this.setProperty(PROP_EXPIRATION_DATE, DEFVAL_EXPIRATION_DATE);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            this.load(new InputStreamReader(is));
            this.source = url;
        }
        finally {
            is.close();
        }
    }

    public URL getSource() {
        return this.source;
    }

    public final String getKey() {
        return this.getProperty(PROP_KEY);
    }

    public final String getCode() {
        return this.getProperty(PROP_CODE);
    }

    public final License setType(String type) {
        this.setProperty(PROP_TYPE, type);
        return this;
    }

    public final String getType() {
        return this.getProperty(PROP_TYPE, null);
    }

    public final License setIssuedTo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("issued to entity name cannot be null");
        }
        this.setProperty(PROP_ISSUED_TO, name);
        return this;
    }

    public final String getIssuedTo() {
        return this.getProperty(PROP_ISSUED_TO, DEFVAL_ISSUED_TO);
    }

    public final License setPerpetual() {
        this.setProperty(PROP_PERPETUAL, "true");
        return this;
    }

    public final boolean isPerpetual() {
        return Boolean.valueOf(this.getProperty(PROP_PERPETUAL, "false"));
    }

    public final License setExpiration(Date date) {
        this.setProperty(PROP_EXPIRATION_DATE, new SimpleDateFormat(PROP_EXPIRATION_DATE_FORMAT).format(new Date(date.getTime() % 1000L == 0L ? date.getTime() / 1000L * 1000L : date.getTime() / 1000L * 1000L + 1000L)));
        return this;
    }

    public final Date getExpiration() throws Exception {
        return new SimpleDateFormat(PROP_EXPIRATION_DATE_FORMAT).parse(this.getProperty(PROP_EXPIRATION_DATE, DEFVAL_EXPIRATION_DATE));
    }

    @Override
    public final String toString() {
        ArrayList<String> propertyNames = new ArrayList<String>(this.stringPropertyNames());
        Collections.sort(propertyNames);
        StringBuilder sb = new StringBuilder();
        sb.append(PROP_CODE).append("=").append(this.getProperty(PROP_CODE)).append("\n");
        sb.append(PROP_KEY).append("=").append(this.getProperty(PROP_KEY)).append("\n");
        sb.append(PROP_ISSUED_TO).append("=").append(this.getProperty(PROP_ISSUED_TO)).append("\n");
        sb.append(PROP_PERPETUAL).append("=").append(this.getProperty(PROP_PERPETUAL)).append("\n");
        sb.append(PROP_EXPIRATION_DATE).append("=").append(this.getProperty(PROP_EXPIRATION_DATE)).append("\n");
        sb.append("\n");
        for (String propertyName : propertyNames) {
            if (propertyName.equals(PROP_CODE) || propertyName.equals(PROP_KEY) || propertyName.equals(PROP_ISSUED_TO) || propertyName.equals(PROP_PERPETUAL) || propertyName.equals(PROP_EXPIRATION_DATE)) continue;
            sb.append(propertyName).append("=").append(this.getProperty(propertyName)).append("\n");
        }
        return sb.toString();
    }
}

