/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.trace;

import cern.colt.function.ObjectProcedure;
import cern.colt.list.ObjectArrayList;
import com.neeve.env.Env;
import com.neeve.trace.TraceLoggerFactory;
import com.neeve.trace.TracerRegistry;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.util.Properties;
import java.util.logging.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Tracer {
    private final ObjectArrayList loggers = new ObjectArrayList();
    private volatile Level level;
    private volatile LevelChangeCallback levelChangeCallback;
    public static final Level defaultLevel;
    public volatile boolean debug;
    public volatile boolean fine;
    public volatile boolean verbose;

    private Tracer(String name, Level defaultLevel) {
        String levelStr = Env.getValue(name + ".trace", new TraceLevelPropertyChangeCallback());
        Level level = null;
        try {
            level = levelStr != null ? Tracer.getLevel(levelStr) : defaultLevel;
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid trace level configured for the '" + name + "' tracer.\nStack Trace:" + UtlThrowable.prepareStackTrace(e));
        }
        this.setLevel(level);
        this.bind(name);
    }

    private Tracer(Level level) {
        this.setLevel(level);
    }

    public static final Tracer get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("tracer name cannot be null");
        }
        Tracer tracer = TracerRegistry.getInstance().get(name);
        if (tracer == null) {
            tracer = TracerRegistry.getInstance().put(name, new Tracer(name, defaultLevel));
        }
        return tracer;
    }

    public static final Tracer create(Level level) {
        return new Tracer(level);
    }

    public static final Tracer create() {
        return Tracer.create(defaultLevel);
    }

    private final boolean useSlf4j() {
        return Env.getValue("nv.trace.useslf4j", false);
    }

    private final int findLogger(String name) {
        Object[] elements = this.loggers.elements();
        for (int i = 0; i < this.loggers.size(); ++i) {
            if (!(elements[i] instanceof Logger ? ((Logger)elements[i]).getName().equalsIgnoreCase(name) : ((java.util.logging.Logger)elements[i]).getName().equalsIgnoreCase(name))) continue;
            return i;
        }
        return -1;
    }

    public final Tracer setLevelChangeCallback(LevelChangeCallback cb) {
        this.levelChangeCallback = cb;
        return this;
    }

    public static Level getLevel(String str) {
        if (str.compareToIgnoreCase("off") == 0) {
            return Level.OFF;
        }
        if (str.compareToIgnoreCase("severe") == 0) {
            return Level.SEVERE;
        }
        if (str.compareToIgnoreCase("warn") == 0 || str.compareToIgnoreCase("warning") == 0) {
            return Level.WARNING;
        }
        if (str.compareToIgnoreCase("info") == 0) {
            return Level.INFO;
        }
        if (str.compareToIgnoreCase("config") == 0) {
            return Level.CONFIG;
        }
        if (str.compareToIgnoreCase("fine") == 0 || str.compareToIgnoreCase("diagnose") == 0) {
            return Level.FINE;
        }
        if (str.compareToIgnoreCase("finer") == 0 || str.compareToIgnoreCase("verbose") == 0) {
            return Level.FINER;
        }
        if (str.compareToIgnoreCase("finest") == 0 || str.compareToIgnoreCase("debug") == 0) {
            return Level.FINEST;
        }
        if (str.compareToIgnoreCase("all") == 0) {
            return Level.ALL;
        }
        throw new IllegalArgumentException("Invalid trace level [" + str + "]");
    }

    public static Level getLevel(Properties props, String name, Level defLevel) {
        Level level = defLevel;
        String value = UtlProps.getValue(props, name);
        if (value != null) {
            try {
                level = Tracer.getLevel(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return level;
    }

    public static Level getLevel(Properties props, String name) {
        return Tracer.getLevel(props, name, defaultLevel);
    }

    public static Level getLevel(Logger logger) {
        if (logger.isTraceEnabled()) {
            return Level.DEBUG;
        }
        if (logger.isDebugEnabled()) {
            return Level.VERBOSE;
        }
        if (logger.isInfoEnabled()) {
            return Level.CONFIG;
        }
        if (logger.isWarnEnabled()) {
            return Level.WARNING;
        }
        return Level.SEVERE;
    }

    public final void setLevel(Level level) {
        if (this.level != level) {
            this.level = level;
            this.debug = this.isEnabled(Level.DEBUG);
            this.fine = this.isEnabled(Level.FINE);
            this.verbose = this.isEnabled(Level.VERBOSE);
            if (this.levelChangeCallback != null) {
                this.levelChangeCallback.onLevelChange(level);
            }
        }
    }

    public final void setLevel(String level) {
        this.setLevel(Tracer.getLevel(level));
    }

    public final void setLevel(Properties props, String name) {
        if (UtlProps.getValue(props, name) != null) {
            this.setLevel(Tracer.getLevel(props, name, this.level));
        }
    }

    public final Level getLevel() {
        return this.level;
    }

    public final boolean isEnabled(Level level) {
        return level.val >= this.level.val;
    }

    @Deprecated
    public final void setPrefix(String prefix) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void bind(Object logger) {
        ObjectArrayList objectArrayList = this.loggers;
        synchronized (objectArrayList) {
            this.loggers.add(logger);
            if (logger instanceof Logger) {
                this.setLevel(Tracer.getLevel((Logger)logger));
            }
        }
    }

    final void bind(java.util.logging.Logger logger) {
        this.bind((Object)logger);
    }

    final void bind(Logger logger) {
        this.bind((Object)logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bind(String name) {
        ObjectArrayList objectArrayList = this.loggers;
        synchronized (objectArrayList) {
            if (this.findLogger(name) < 0) {
                if (this.useSlf4j()) {
                    this.bind(LoggerFactory.getLogger((String)name));
                } else {
                    this.bind(TraceLoggerFactory.getInstance().getLogger(name, true));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unbind(String name) {
        ObjectArrayList objectArrayList = this.loggers;
        synchronized (objectArrayList) {
            int idx = this.findLogger(name);
            if (idx >= 0) {
                this.loggers.removeFromTo(idx, idx);
            }
        }
    }

    public final void log(final String msg, final Level level) {
        if (level.val < Level.OFF.val && level.val > Level.ALL.val) {
            if (level.val >= this.level.val) {
                this.loggers.forEach(new ObjectProcedure(){

                    public final boolean apply(Object element) {
                        if (element instanceof java.util.logging.Logger) {
                            java.util.logging.Logger logger = (java.util.logging.Logger)element;
                            switch (level) {
                                case SEVERE: {
                                    logger.severe(msg);
                                    break;
                                }
                                case WARNING: {
                                    logger.warning(msg);
                                    break;
                                }
                                case INFO: {
                                    logger.info(msg);
                                    break;
                                }
                                case CONFIG: {
                                    logger.config(msg);
                                    break;
                                }
                                case FINE: 
                                case DIAGNOSE: {
                                    logger.fine(msg);
                                    break;
                                }
                                case FINER: 
                                case VERBOSE: {
                                    logger.finer(msg);
                                    break;
                                }
                                case FINEST: 
                                case DEBUG: {
                                    logger.finest(msg);
                                    break;
                                }
                                default: {
                                    throw new InternalError("Unknown log level [" + level.toString() + "]");
                                }
                            }
                            Handler[] handlers = logger.getHandlers();
                            for (int i = 0; i < handlers.length; ++i) {
                                handlers[i].flush();
                            }
                        } else {
                            Logger logger = (Logger)element;
                            switch (level) {
                                case SEVERE: {
                                    logger.error(msg);
                                    break;
                                }
                                case WARNING: {
                                    logger.warn(msg);
                                    break;
                                }
                                case INFO: 
                                case CONFIG: {
                                    logger.info(msg);
                                    break;
                                }
                                case FINE: 
                                case DIAGNOSE: 
                                case FINER: 
                                case VERBOSE: {
                                    logger.debug(msg);
                                    break;
                                }
                                case FINEST: 
                                case DEBUG: {
                                    logger.trace(msg);
                                    break;
                                }
                                default: {
                                    throw new InternalError("Unknown log level [" + level.toString() + "]");
                                }
                            }
                        }
                        return true;
                    }
                });
            }
        } else {
            throw new IllegalArgumentException("Level of a trace message cannot be ALL or OFF");
        }
    }

    static {
        String defaultLevelStr = Env.getValue("nv.trace.defaultLevel");
        Level defaultLevelVal = Level.CONFIG;
        if (defaultLevelStr != null) {
            try {
                defaultLevelVal = Tracer.getLevel(defaultLevelStr);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        defaultLevel = defaultLevelVal;
    }

    public static interface LevelChangeCallback {
        public void onLevelChange(Level var1);
    }

    public static enum Level {
        OFF(Integer.MAX_VALUE),
        SEVERE(1000),
        WARNING(900),
        INFO(800),
        CONFIG(700),
        FINE(600),
        DIAGNOSE(600),
        FINER(500),
        VERBOSE(500),
        FINEST(400),
        DEBUG(400),
        ALL(Integer.MIN_VALUE);

        public final int val;

        private Level(int val) {
            this.val = val;
        }

        final boolean isEqual(Level level) {
            return level.val == this.val;
        }
    }

    private final class TraceLevelPropertyChangeCallback
    implements Env.PropertyChangeCallback {
        private TraceLevelPropertyChangeCallback() {
        }

        @Override
        public final void onPropertyChange(String name, Object oldValue, Object newValue) {
            if (newValue == null) {
                Tracer.this.setLevel(defaultLevel);
            } else if (newValue instanceof String) {
                try {
                    Tracer.this.setLevel((String)newValue);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Invalid trace level configured for the '" + name + "' tracer.\nStack Trace:" + UtlThrowable.prepareStackTrace(e));
                }
            }
        }
    }
}

