/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlEnv;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class UtlNet {
    private static final boolean WARN_ON_SLOW_HOSTNAME_RESOLUTION = UtlEnv.getValue("nv.net.warnonslowhostnameresolution", true);
    private static InetAddress localhostInetAddress;
    private static String localhostAddress;
    private static String localhostName;
    private static UnknownHostException unknownHostException;

    private static final InetAddress inferLocalHostFromOverride(String localhostOverride) {
        if (localhostOverride != null) {
            try {
                return InetAddress.getByName(localhostOverride);
            }
            catch (UnknownHostException e) {
                System.err.println("WARNING: failed to resolve nv.localhostoverride=" + localhostOverride);
                unknownHostException = e;
            }
        }
        return null;
    }

    private static final InetAddress inferLocalHostFromInetAdress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            unknownHostException = e;
            return null;
        }
    }

    private static final InetAddress inferLocalHostFromNetworkInterfaces() {
        NetworkInterface localhostNetworkInterface = null;
        try {
            localhostNetworkInterface = UtlNet.getFirstActiveNetworkInterface(false);
        }
        catch (SocketException e) {
            System.err.println("*** WARNING: error trying to determine suitable network device [" + e.getClass().getName() + "] *** " + e.getMessage());
        }
        if (localhostNetworkInterface == null) {
            System.err.println("*** WARNING: unable to find suitable network device, falling back to InetAddress.getLocalHost() ***");
            return UtlNet.inferLocalHostFromInetAdress();
        }
        InetAddress result = UtlNet.getFirstInetAddress(localhostNetworkInterface);
        if (result == null) {
            System.err.println("*** WARNING: unable to find suitable IP on network device " + localhostNetworkInterface.getName() + ", falling back to InetAddress.getLocalHost() ***");
            return UtlNet.inferLocalHostFromInetAdress();
        }
        return result;
    }

    private static final void initializeLocalHost() {
        String localhostOverride = UtlEnv.getEnvPropsNoWarn().getProperty("nv.overridelocalhost", null);
        if (localhostOverride != null) {
            localhostInetAddress = UtlNet.inferLocalHostFromOverride(localhostOverride);
        }
        if (localhostInetAddress == null) {
            unknownHostException = null;
            localhostInetAddress = UtlNet.inferLocalHostFromInetAdress();
            if (localhostInetAddress == null || localhostInetAddress.isLoopbackAddress()) {
                unknownHostException = null;
                localhostInetAddress = UtlNet.inferLocalHostFromNetworkInterfaces();
            }
        }
        if (localhostInetAddress != null) {
            localhostAddress = localhostInetAddress.getHostAddress();
            localhostName = UtlNet.getHostName(localhostInetAddress);
        }
    }

    public static final String inetAddrToName(String addr) {
        try {
            InetAddress address = InetAddress.getByName(addr);
            return UtlNet.getHostName(address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getHostName(InetAddress address) {
        long start = System.currentTimeMillis();
        String hostname = null;
        try {
            String string = hostname = address.getHostName();
            return string;
        }
        finally {
            if (System.currentTimeMillis() - start > 1000L && WARN_ON_SLOW_HOSTNAME_RESOLUTION) {
                System.err.println("WARN: Host name resolution for " + address + " (" + hostname + ") took " + (System.currentTimeMillis() - start) + "ms ... consider updating your hosts file?");
            }
        }
    }

    public static final NetworkInterface getFirstActiveNetworkInterface(boolean multicastRequired) throws SocketException {
        return UtlNet.getFirstActiveNetworkInterface(null, multicastRequired);
    }

    public static final NetworkInterface getFirstActiveNetworkInterface(DebugTracer tracer, boolean multicastRequired) throws SocketException {
        boolean tracingEnabled;
        boolean bl = tracingEnabled = tracer != null && tracer.isEnabled();
        if (tracingEnabled) {
            tracer.log("Finding a suitable network interface for use...");
        }
        Enumeration<NetworkInterface> nifEnumerator = NetworkInterface.getNetworkInterfaces();
        while (nifEnumerator.hasMoreElements()) {
            NetworkInterface nif = nifEnumerator.nextElement();
            String nifDescriptor = UtlNet.formatNetworkInterfaceDescriptor(nif);
            if (tracingEnabled) {
                tracer.log("...Checking " + nifDescriptor + "...");
            }
            if (nif.isUp()) {
                if (nif.getHardwareAddress() != null) {
                    if (!multicastRequired || nif.supportsMulticast()) {
                        if (!nif.isVirtual()) {
                            if (!nif.isLoopback()) {
                                if (tracingEnabled) {
                                    tracer.log("..." + nifDescriptor + " is a suitable interface. Terminating search.");
                                }
                                return nif;
                            }
                            if (!tracingEnabled) continue;
                            tracer.log("..." + nifDescriptor + " is loopback. Moving onto next one...");
                            continue;
                        }
                        if (!tracingEnabled) continue;
                        tracer.log("..." + nifDescriptor + " is virtual. Moving onto next one...");
                        continue;
                    }
                    if (!tracingEnabled) continue;
                    tracer.log("..." + nifDescriptor + " does not support multicast. Moving onto next one...");
                    continue;
                }
                if (!tracingEnabled) continue;
                tracer.log("..." + nifDescriptor + " is not a physical interface. Moving onto next one...");
                continue;
            }
            if (!tracingEnabled) continue;
            tracer.log("..." + nifDescriptor + " is not up. Moving onto next one...");
        }
        return null;
    }

    public static final InetAddress getFirstInetAddress(NetworkInterface networkInterface) {
        InetAddress v4Address = UtlNet.getFirstInetAddressByType(networkInterface, Inet4Address.class);
        if (v4Address != null) {
            return v4Address;
        }
        return UtlNet.getFirstInetAddressByType(networkInterface, Inet6Address.class);
    }

    public static final String formatNetworkInterfaceDescriptor(NetworkInterface nif) {
        StringBuilder builder = new StringBuilder("[");
        Enumeration<InetAddress> addresses = nif.getInetAddresses();
        builder.append(nif.getName());
        builder.append(",<");
        while (addresses.hasMoreElements()) {
            builder.append(addresses.nextElement().toString());
            if (!addresses.hasMoreElements()) continue;
            builder.append(",");
        }
        builder.append(">");
        builder.append("]");
        return builder.toString();
    }

    private static final InetAddress getFirstInetAddressByType(NetworkInterface networkInterface, Class<? extends InetAddress> type) {
        Enumeration<InetAddress> addressEnumeration = networkInterface.getInetAddresses();
        while (addressEnumeration.hasMoreElements()) {
            InetAddress address = addressEnumeration.nextElement();
            if (!type.isAssignableFrom(address.getClass())) continue;
            return address;
        }
        return null;
    }

    public static boolean isAddressLocal(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public static final InetAddress getLocalHostInetAddress() throws UnknownHostException {
        if (localhostInetAddress == null) {
            throw unknownHostException;
        }
        return localhostInetAddress;
    }

    public static final String getLocalHostNameForDisplay(String defaultValue) {
        return localhostName == null ? defaultValue : localhostName;
    }

    public static final String getLocalHostName() throws UnknownHostException {
        if (localhostName == null) {
            throw unknownHostException;
        }
        return localhostName;
    }

    public static final String getLocalHostAddressForDisplay(String defaultValue) {
        return localhostAddress == null ? defaultValue : localhostAddress;
    }

    public static final String getLocalHostAddress() throws UnknownHostException {
        if (localhostAddress == null) {
            throw unknownHostException;
        }
        return localhostAddress;
    }

    static {
        UtlNet.initializeLocalHost();
    }

    public static interface DebugTracer {
        public boolean isEnabled();

        public void log(String var1);
    }
}

