/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.memory;

import com.neeve.ci.XRuntime;
import com.neeve.stats.Stats;
import com.neeve.util.UtlLinkedHashMap;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.NumberFormat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class MemoryStats
extends Stats {
    private static final boolean recordEntityTypeStats = XRuntime.getValue("nv.memory.stats.type.enable", false);
    private static final boolean recordStats = XRuntime.getValue("nv.memory.stats.enable", false);
    private final MemoryMXBean memoryBean;
    private final NumberFormat format;
    private final NativeMemoryStats nativeMemoryStats = new NativeMemoryStats();
    private final IOBufferStats ioBufferStats = new IOBufferStats();
    private final EntityTypeStats embeddedEntityStats = new EntityTypeStats();
    private final UtlLinkedHashMap<Class<?>, EntityTypeStats> embeddedEntityTypeStats = new UtlLinkedHashMap();
    private final EntityTypeStats entityStats = new EntityTypeStats();
    private final UtlLinkedHashMap<Class<?>, EntityTypeStats> entityTypeStats = new UtlLinkedHashMap();
    private final EntityTypeStats messageStats = new EntityTypeStats();
    private final UtlLinkedHashMap<Class<?>, EntityTypeStats> messageTypeStats = new UtlLinkedHashMap();
    private final EntityTypeStats collectionStats = new EntityTypeStats();
    private final UtlLinkedHashMap<Class<?>, EntityTypeStats> collectionTypeStats = new UtlLinkedHashMap();
    private long startTime;
    private long deltaStartTime;
    private static final MemoryStats instance = new MemoryStats("stats", "nv.memory.stats.interval");

    private MemoryStats(String name, String startProp) {
        super("nv.memory", name, "nv.memory.stats", startProp);
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
        this.startPeriodicOutputIfConfigured();
    }

    public static final MemoryStats getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stampCurrent() {
        UtlLinkedHashMap.FastIterator iterator;
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap;
        this.deltaStartTime = System.currentTimeMillis();
        this.nativeMemoryStats.stampCurrent();
        this.ioBufferStats.stampCurrent();
        this.embeddedEntityStats.stampCurrent();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.embeddedEntityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.embeddedEntityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).stampCurrent();
                }
            }
        }
        this.entityStats.stampCurrent();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.entityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.entityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).stampCurrent();
                }
            }
        }
        this.messageStats.stampCurrent();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.messageTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.messageTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).stampCurrent();
                }
            }
        }
        this.collectionStats.stampCurrent();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.collectionTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.collectionTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).stampCurrent();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void currentToLast() {
        UtlLinkedHashMap.FastIterator iterator;
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap;
        this.deltaStartTime = System.currentTimeMillis();
        this.nativeMemoryStats.currentToLast();
        this.ioBufferStats.currentToLast();
        this.embeddedEntityStats.currentToLast();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.embeddedEntityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.embeddedEntityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).currentToLast();
                }
            }
        }
        this.entityStats.currentToLast();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.entityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.entityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).currentToLast();
                }
            }
        }
        this.messageStats.currentToLast();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.messageTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.messageTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).currentToLast();
                }
            }
        }
        this.collectionStats.currentToLast();
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.collectionTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.collectionTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    ((EntityTypeStats)iterator.nextEntry().getValue()).currentToLast();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntityTypeStats getEmbeddedEntityTypeStats(Class<?> entity) {
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap = this.embeddedEntityTypeStats;
        synchronized (utlLinkedHashMap) {
            EntityTypeStats stats = (EntityTypeStats)this.embeddedEntityTypeStats.get(entity);
            if (stats == null) {
                stats = new EntityTypeStats();
                this.embeddedEntityTypeStats.put(entity, (Object)stats);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntityTypeStats getEntityTypeStats(Class<?> entity) {
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap = this.entityTypeStats;
        synchronized (utlLinkedHashMap) {
            EntityTypeStats stats = (EntityTypeStats)this.entityTypeStats.get(entity);
            if (stats == null) {
                stats = new EntityTypeStats();
                this.entityTypeStats.put(entity, (Object)stats);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntityTypeStats getMessageTypeStats(Class<?> message) {
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap = this.messageTypeStats;
        synchronized (utlLinkedHashMap) {
            EntityTypeStats stats = (EntityTypeStats)this.messageTypeStats.get(message);
            if (stats == null) {
                stats = new EntityTypeStats();
                this.messageTypeStats.put(message, (Object)stats);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntityTypeStats getCollectionTypeStats(Class<?> collection) {
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap = this.collectionTypeStats;
        synchronized (utlLinkedHashMap) {
            EntityTypeStats stats = (EntityTypeStats)this.collectionTypeStats.get(collection);
            if (stats == null) {
                stats = new EntityTypeStats();
                this.collectionTypeStats.put(collection, (Object)stats);
            }
            return stats;
        }
    }

    @Override
    protected final void init() {
        this.startTime = System.currentTimeMillis();
        this.stampCurrent();
        this.currentToLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void get(StringBuilder sb) {
        Map.Entry entry;
        UtlLinkedHashMap.FastIterator iterator;
        UtlLinkedHashMap<Class<?>, EntityTypeStats> utlLinkedHashMap;
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        this.stampCurrent();
        String nativeMemoryUsedLiveStr = this.format.format(this.nativeMemoryStats.allocBytesCurrent - this.nativeMemoryStats.freeBytesCurrent + this.nativeMemoryStats.reallocBytesCurrent + (this.ioBufferStats.directBufferAllocBytesCurrent + this.ioBufferStats.directBufferPoolAllocBytesCurrent - this.ioBufferStats.directBufferPoolDisposeBytesCurrent - this.ioBufferStats.directBufferGCDisposeBytesCurrent));
        String nativeMemoryUsedPooledStr = this.format.format(this.ioBufferStats.directBufferPoolDisposeBytesCurrent - this.ioBufferStats.directBufferPoolAllocBytesCurrent - this.ioBufferStats.directBufferPoolLeakBytesCurrent);
        MemoryUsage heapUsage = this.memoryBean.getHeapMemoryUsage();
        sb.append("Heap {");
        sb.append(this.format.format(heapUsage.getInit())).append(", ").append(this.format.format(heapUsage.getUsed())).append(", ").append(this.format.format(heapUsage.getCommitted())).append(", ").append(this.format.format(heapUsage.getMax()));
        sb.append("}").append("\n");
        sb.append("Off Heap {");
        sb.append(nativeMemoryUsedLiveStr).append(", ").append(nativeMemoryUsedPooledStr).append("[").append(this.format.format(this.nativeMemoryStats.allocBytesCurrent)).append(", ").append(this.format.format(this.nativeMemoryStats.freeBytesCurrent)).append(", ").append(this.format.format(this.nativeMemoryStats.reallocBytesCurrent)).append(", ").append(this.format.format(this.ioBufferStats.directBufferAllocBytesCurrent)).append(", ").append(this.format.format(this.ioBufferStats.directBufferPoolAllocBytesCurrent)).append(", ").append(this.format.format(this.ioBufferStats.directBufferPoolDisposeBytesCurrent)).append(", ").append(this.format.format(this.ioBufferStats.directBufferGCDisposeBytesCurrent)).append("]");
        sb.append("}").append("\n");
        this.messageStats.get("Message Entities", sb, deltaTime, deltaTotalTime);
        sb.append("\n");
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.messageTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.messageTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    entry = iterator.nextEntry();
                    sb.append("...");
                    ((EntityTypeStats)entry.getValue()).get(((Class)entry.getKey()).getName(), sb, deltaTime, deltaTotalTime);
                    sb.append("\n");
                }
            }
        }
        this.embeddedEntityStats.get("Embedded Entities", sb, deltaTime, deltaTotalTime);
        sb.append("\n");
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.embeddedEntityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.embeddedEntityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    entry = iterator.nextEntry();
                    sb.append("...");
                    ((EntityTypeStats)entry.getValue()).get(((Class)entry.getKey()).getName(), sb, deltaTime, deltaTotalTime);
                    sb.append("\n");
                }
            }
        }
        this.entityStats.get("State Entities", sb, deltaTime, deltaTotalTime);
        sb.append("\n");
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.entityTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.entityTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    entry = iterator.nextEntry();
                    sb.append("...");
                    ((EntityTypeStats)entry.getValue()).get(((Class)entry.getKey()).getName(), sb, deltaTime, deltaTotalTime);
                    sb.append("\n");
                }
            }
        }
        this.collectionStats.get("State Collections", sb, deltaTime, deltaTotalTime);
        sb.append("\n");
        if (recordEntityTypeStats) {
            utlLinkedHashMap = this.collectionTypeStats;
            synchronized (utlLinkedHashMap) {
                iterator = this.collectionTypeStats.fastIterator().toFirst();
                while (iterator.hasNext()) {
                    entry = iterator.nextEntry();
                    sb.append("...");
                    ((EntityTypeStats)entry.getValue()).get(((Class)entry.getKey()).getName(), sb, deltaTime, deltaTotalTime);
                    sb.append("\n");
                }
            }
        }
        this.currentToLast();
    }

    public final void onNativeMemoryAllocated(long bytes) {
        if (!recordStats) {
            return;
        }
        this.nativeMemoryStats.allocCount.incrementAndGet();
        this.nativeMemoryStats.allocBytes.addAndGet(bytes);
    }

    public final void onNativeMemoryReallocated(long bytes) {
        if (!recordStats) {
            return;
        }
        this.nativeMemoryStats.reallocCount.incrementAndGet();
        this.nativeMemoryStats.reallocBytes.addAndGet(bytes);
    }

    public final void onNativeMemoryFreed(long bytes) {
        if (!recordStats) {
            return;
        }
        this.nativeMemoryStats.freeCount.incrementAndGet();
        this.nativeMemoryStats.freeBytes.addAndGet(bytes);
    }

    public final void onIOBufferAllocated(boolean isNative, boolean fromPool, int bytes) {
        if (!recordStats) {
            return;
        }
        if (isNative) {
            if (fromPool) {
                this.ioBufferStats.directBufferPoolAllocCount.incrementAndGet();
                this.ioBufferStats.directBufferPoolAllocBytes.addAndGet(bytes);
            } else {
                this.ioBufferStats.directBufferAllocCount.incrementAndGet();
                this.ioBufferStats.directBufferAllocBytes.addAndGet(bytes);
            }
        } else if (fromPool) {
            this.ioBufferStats.heapBufferPoolAllocCount.incrementAndGet();
            this.ioBufferStats.heapBufferPoolAllocBytes.addAndGet(bytes);
        } else {
            this.ioBufferStats.heapBufferAllocCount.incrementAndGet();
            this.ioBufferStats.heapBufferAllocBytes.addAndGet(bytes);
        }
    }

    public final void onIOBufferDisposed(boolean isNative, boolean toPool, int bytes) {
        if (!recordStats) {
            return;
        }
        if (isNative) {
            if (toPool) {
                this.ioBufferStats.directBufferPoolDisposeCount.incrementAndGet();
                this.ioBufferStats.directBufferPoolDisposeBytes.addAndGet(bytes);
            } else {
                this.ioBufferStats.directBufferGCDisposeCount.incrementAndGet();
                this.ioBufferStats.directBufferGCDisposeBytes.addAndGet(bytes);
            }
        } else if (toPool) {
            this.ioBufferStats.heapBufferPoolDisposeCount.incrementAndGet();
            this.ioBufferStats.heapBufferPoolDisposeBytes.addAndGet(bytes);
        } else {
            this.ioBufferStats.heapBufferGCDisposeCount.incrementAndGet();
            this.ioBufferStats.heapBufferGCDisposeBytes.addAndGet(bytes);
        }
    }

    public final void onIOBufferLeaked(boolean isNative, int bytes) {
        if (!recordStats) {
            return;
        }
        if (isNative) {
            this.ioBufferStats.directBufferPoolLeakCount.incrementAndGet();
            this.ioBufferStats.directBufferPoolLeakBytes.addAndGet(bytes);
        } else {
            this.ioBufferStats.heapBufferPoolLeakCount.incrementAndGet();
            this.ioBufferStats.heapBufferPoolLeakBytes.addAndGet(bytes);
        }
    }

    public final void onEntityAllocated(Class<?> entity, EntityType entityType, boolean fromPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (fromPool) {
                        this.embeddedEntityStats.poolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).poolAllocCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.createAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).createAllocCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (fromPool) {
                        this.entityStats.poolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).poolAllocCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.createAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).createAllocCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (fromPool) {
                        this.messageStats.poolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).poolAllocCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.createAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).createAllocCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (fromPool) {
                        this.collectionStats.poolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).poolAllocCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.createAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).createAllocCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityDisposed(Class<?> entity, EntityType entityType, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.poolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).poolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.gcDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).gcDisposeCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.poolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).poolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.gcDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).gcDisposeCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.poolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).poolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.gcDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).gcDisposeCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.poolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).poolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.gcDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).gcDisposeCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityLeaked(Class<?> entity, EntityType entityType) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.poolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).poolLeakCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    this.entityStats.poolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).poolLeakCount.incrementAndGet();
                    break;
                }
                case Message: {
                    this.messageStats.poolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).poolLeakCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    this.collectionStats.poolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).poolLeakCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityPojoAllocated(Class<?> entity, EntityType entityType, boolean fromPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (fromPool) {
                        this.embeddedEntityStats.pojoPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).pojoPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.pojoCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).pojoCreateAllocCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (fromPool) {
                        this.entityStats.pojoPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).pojoPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.pojoCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).pojoCreateAllocCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (fromPool) {
                        this.messageStats.pojoPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).pojoPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.pojoCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).pojoCreateAllocCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (fromPool) {
                        this.collectionStats.pojoPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).pojoPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.pojoCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).pojoCreateAllocCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityPojoDisposed(Class<?> entity, EntityType entityType, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.pojoPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).pojoPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.pojoGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).pojoGCDisposeCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.pojoPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).pojoPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.pojoGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).pojoGCDisposeCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.pojoPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).pojoPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.pojoGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).pojoGCDisposeCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.pojoPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).pojoPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.pojoGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).pojoGCDisposeCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityPojoLeaked(Class<?> entity, EntityType entityType) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.pojoPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).pojoPoolLeakCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    this.entityStats.pojoPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).pojoPoolLeakCount.incrementAndGet();
                    break;
                }
                case Message: {
                    this.messageStats.pojoPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).pojoPoolLeakCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    this.collectionStats.pojoPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).pojoPoolLeakCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntitySerializerAllocated(Class<?> entity, EntityType entityType, boolean fromPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (fromPool) {
                        this.embeddedEntityStats.serializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).serializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.serializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).serializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (fromPool) {
                        this.entityStats.serializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).serializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.serializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).serializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (fromPool) {
                        this.messageStats.serializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).serializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.serializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).serializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (fromPool) {
                        this.collectionStats.serializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).serializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.serializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).serializerCreateAllocCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntitySerializerDisposed(Class<?> entity, EntityType entityType, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.serializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).serializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.serializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).serializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.serializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).serializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.serializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).serializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.serializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).serializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.serializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).serializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.serializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).serializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.serializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).serializerGCDisposeCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntitySerializerLeaked(Class<?> entity, EntityType entityType) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.serializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).serializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    this.entityStats.serializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).serializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Message: {
                    this.messageStats.serializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).serializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    this.collectionStats.serializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).serializerPoolLeakCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityDeserializerAllocated(Class<?> entity, EntityType entityType, boolean fromPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (fromPool) {
                        this.embeddedEntityStats.deserializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).deserializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.deserializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).deserializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (fromPool) {
                        this.entityStats.deserializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).deserializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.deserializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).deserializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (fromPool) {
                        this.messageStats.deserializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).deserializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.deserializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).deserializerCreateAllocCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (fromPool) {
                        this.collectionStats.deserializerPoolAllocCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).deserializerPoolAllocCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.deserializerCreateAllocCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).deserializerCreateAllocCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityDeserializerDisposed(Class<?> entity, EntityType entityType, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.deserializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEmbeddedEntityTypeStats(entity).deserializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.embeddedEntityStats.deserializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).deserializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.deserializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getEntityTypeStats(entity).deserializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.entityStats.deserializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).deserializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.deserializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getMessageTypeStats(entity).deserializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.messageStats.deserializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).deserializerGCDisposeCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.deserializerPoolDisposeCount.incrementAndGet();
                        if (!recordEntityTypeStats) break;
                        this.getCollectionTypeStats(entity).deserializerPoolDisposeCount.incrementAndGet();
                        break;
                    }
                    this.collectionStats.deserializerGCDisposeCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).deserializerGCDisposeCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityDeserializerLeaked(Class<?> entity, EntityType entityType) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.deserializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEmbeddedEntityTypeStats(entity).deserializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Entity: {
                    this.entityStats.deserializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getEntityTypeStats(entity).deserializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Message: {
                    this.messageStats.deserializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getMessageTypeStats(entity).deserializerPoolLeakCount.incrementAndGet();
                    break;
                }
                case Collection: {
                    this.collectionStats.deserializerPoolLeakCount.incrementAndGet();
                    if (!recordEntityTypeStats) break;
                    this.getCollectionTypeStats(entity).deserializerPoolLeakCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    public final void onEntityMetadataAllocated(Class<?> entity, EntityType entityType, int bytes) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.metadataCreateAllocCount.incrementAndGet();
                    this.embeddedEntityStats.metadataCreateAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                    typeStats.metadataCreateAllocCount.incrementAndGet();
                    typeStats.metadataCreateAllocBytes.addAndGet(bytes);
                    break;
                }
                case Entity: {
                    this.entityStats.metadataCreateAllocCount.incrementAndGet();
                    this.entityStats.metadataCreateAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                    typeStats.metadataCreateAllocCount.incrementAndGet();
                    typeStats.metadataCreateAllocBytes.addAndGet(bytes);
                    break;
                }
                case Message: {
                    this.messageStats.metadataCreateAllocCount.incrementAndGet();
                    this.messageStats.metadataCreateAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                    typeStats.metadataCreateAllocCount.incrementAndGet();
                    typeStats.metadataCreateAllocBytes.addAndGet(bytes);
                    break;
                }
                case Collection: {
                    this.collectionStats.metadataCreateAllocCount.incrementAndGet();
                    this.collectionStats.metadataCreateAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                    typeStats.metadataCreateAllocCount.incrementAndGet();
                    typeStats.metadataCreateAllocBytes.addAndGet(bytes);
                    break;
                }
            }
        }
    }

    public final void onEntityMetadataDisposed(Class<?> entity, EntityType entityType, int bytes, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.metadataPoolDisposeCount.incrementAndGet();
                        this.embeddedEntityStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                        typeStats.metadataPoolDisposeCount.incrementAndGet();
                        typeStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.embeddedEntityStats.metadataGCDisposeCount.incrementAndGet();
                    this.embeddedEntityStats.metadataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                    typeStats.metadataGCDisposeCount.incrementAndGet();
                    typeStats.metadataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.metadataPoolDisposeCount.incrementAndGet();
                        this.entityStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                        typeStats.metadataPoolDisposeCount.incrementAndGet();
                        typeStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.entityStats.metadataGCDisposeCount.incrementAndGet();
                    this.entityStats.metadataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                    typeStats.metadataGCDisposeCount.incrementAndGet();
                    typeStats.metadataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.metadataPoolDisposeCount.incrementAndGet();
                        this.messageStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                        typeStats.metadataPoolDisposeCount.incrementAndGet();
                        typeStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.messageStats.metadataGCDisposeCount.incrementAndGet();
                    this.messageStats.metadataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                    typeStats.metadataGCDisposeCount.incrementAndGet();
                    typeStats.metadataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.metadataPoolDisposeCount.incrementAndGet();
                        this.collectionStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                        typeStats.metadataPoolDisposeCount.incrementAndGet();
                        typeStats.metadataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.collectionStats.metadataGCDisposeCount.incrementAndGet();
                    this.collectionStats.metadataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                    typeStats.metadataGCDisposeCount.incrementAndGet();
                    typeStats.metadataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
            }
        }
    }

    public final void onEntityDataAllocated(Class<?> entity, EntityType entityType, int bytes) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    this.embeddedEntityStats.dataCreateAllocCount.incrementAndGet();
                    this.embeddedEntityStats.dataCreateAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                    typeStats.dataCreateAllocCount.incrementAndGet();
                    typeStats.dataCreateAllocBytes.addAndGet(bytes);
                    break;
                }
                case Entity: {
                    this.entityStats.dataCreateAllocCount.incrementAndGet();
                    this.entityStats.dataCreateAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                    typeStats.dataCreateAllocCount.incrementAndGet();
                    typeStats.dataCreateAllocBytes.addAndGet(bytes);
                    break;
                }
                case Message: {
                    this.messageStats.dataCreateAllocCount.incrementAndGet();
                    this.messageStats.dataCreateAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                    typeStats.dataCreateAllocCount.incrementAndGet();
                    typeStats.dataCreateAllocBytes.addAndGet(bytes);
                    break;
                }
                case Collection: {
                    this.collectionStats.dataCreateAllocCount.incrementAndGet();
                    this.collectionStats.dataCreateAllocBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                    typeStats.dataCreateAllocCount.incrementAndGet();
                    typeStats.dataCreateAllocBytes.addAndGet(bytes);
                    break;
                }
            }
        }
    }

    public final void onEntityDataDisposed(Class<?> entity, EntityType entityType, int bytes, boolean toPool) {
        if (!recordStats) {
            return;
        }
        if (entityType != null) {
            switch (entityType) {
                case EmbeddedEntity: {
                    if (toPool) {
                        this.embeddedEntityStats.dataPoolDisposeCount.incrementAndGet();
                        this.embeddedEntityStats.dataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                        typeStats.dataPoolDisposeCount.incrementAndGet();
                        typeStats.dataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.embeddedEntityStats.dataGCDisposeCount.incrementAndGet();
                    this.embeddedEntityStats.dataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEmbeddedEntityTypeStats(entity);
                    typeStats.dataGCDisposeCount.incrementAndGet();
                    typeStats.dataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Entity: {
                    if (toPool) {
                        this.entityStats.dataPoolDisposeCount.incrementAndGet();
                        this.entityStats.dataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                        typeStats.dataPoolDisposeCount.incrementAndGet();
                        typeStats.dataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.entityStats.dataGCDisposeCount.incrementAndGet();
                    this.entityStats.dataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getEntityTypeStats(entity);
                    typeStats.dataGCDisposeCount.incrementAndGet();
                    typeStats.dataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Message: {
                    if (toPool) {
                        this.messageStats.dataPoolDisposeCount.incrementAndGet();
                        this.messageStats.dataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                        typeStats.dataPoolDisposeCount.incrementAndGet();
                        typeStats.dataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.messageStats.dataGCDisposeCount.incrementAndGet();
                    this.messageStats.dataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getMessageTypeStats(entity);
                    typeStats.dataGCDisposeCount.incrementAndGet();
                    typeStats.dataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
                case Collection: {
                    if (toPool) {
                        this.collectionStats.dataPoolDisposeCount.incrementAndGet();
                        this.collectionStats.dataPoolDisposeBytes.addAndGet(bytes);
                        if (!recordEntityTypeStats) break;
                        EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                        typeStats.dataPoolDisposeCount.incrementAndGet();
                        typeStats.dataPoolDisposeBytes.addAndGet(bytes);
                        break;
                    }
                    this.collectionStats.dataGCDisposeCount.incrementAndGet();
                    this.collectionStats.dataGCDisposeBytes.addAndGet(bytes);
                    if (!recordEntityTypeStats) break;
                    EntityTypeStats typeStats = this.getCollectionTypeStats(entity);
                    typeStats.dataGCDisposeCount.incrementAndGet();
                    typeStats.dataGCDisposeBytes.addAndGet(bytes);
                    break;
                }
            }
        }
    }

    public final MemoryUsage getHeapMemoryUsage() {
        return this.memoryBean.getHeapMemoryUsage();
    }

    public final long getOffHeapMemoryUsedLive() {
        return this.nativeMemoryStats.allocBytes.get() - this.nativeMemoryStats.freeBytes.get() + this.nativeMemoryStats.reallocBytes.get() + (this.ioBufferStats.directBufferAllocBytes.get() + this.ioBufferStats.directBufferPoolAllocBytes.get() - this.ioBufferStats.directBufferPoolDisposeBytes.get() - this.ioBufferStats.directBufferGCDisposeBytes.get());
    }

    public final long getOffHeapMemoryUsedPooled() {
        return this.ioBufferStats.directBufferPoolDisposeBytes.get() - this.ioBufferStats.directBufferPoolAllocBytes.get() - this.ioBufferStats.directBufferPoolLeakBytes.get();
    }

    public final NativeMemoryStats getNativeStatsCounters() {
        return this.nativeMemoryStats;
    }

    public final IOBufferStats getIOBufferStatsCounters() {
        return this.ioBufferStats;
    }

    public static enum EntityType {
        EmbeddedEntity,
        Entity,
        Message,
        Collection;

    }

    private final class EntityTypeStats {
        private final AtomicLong createAllocCount = new AtomicLong();
        private final AtomicLong poolAllocCount = new AtomicLong();
        private final AtomicLong gcDisposeCount = new AtomicLong();
        private final AtomicLong poolDisposeCount = new AtomicLong();
        private final AtomicLong poolLeakCount = new AtomicLong();
        private final AtomicLong pojoCreateAllocCount = new AtomicLong();
        private final AtomicLong pojoPoolAllocCount = new AtomicLong();
        private final AtomicLong pojoGCDisposeCount = new AtomicLong();
        private final AtomicLong pojoPoolDisposeCount = new AtomicLong();
        private final AtomicLong pojoPoolLeakCount = new AtomicLong();
        private final AtomicLong serializerCreateAllocCount = new AtomicLong();
        private final AtomicLong serializerPoolAllocCount = new AtomicLong();
        private final AtomicLong serializerGCDisposeCount = new AtomicLong();
        private final AtomicLong serializerPoolDisposeCount = new AtomicLong();
        private final AtomicLong serializerPoolLeakCount = new AtomicLong();
        private final AtomicLong deserializerCreateAllocCount = new AtomicLong();
        private final AtomicLong deserializerPoolAllocCount = new AtomicLong();
        private final AtomicLong deserializerGCDisposeCount = new AtomicLong();
        private final AtomicLong deserializerPoolDisposeCount = new AtomicLong();
        private final AtomicLong deserializerPoolLeakCount = new AtomicLong();
        private final AtomicLong metadataCreateAllocCount = new AtomicLong();
        private final AtomicLong metadataCreateAllocBytes = new AtomicLong();
        private final AtomicLong metadataGCDisposeCount = new AtomicLong();
        private final AtomicLong metadataGCDisposeBytes = new AtomicLong();
        private final AtomicLong metadataPoolDisposeCount = new AtomicLong();
        private final AtomicLong metadataPoolDisposeBytes = new AtomicLong();
        private final AtomicLong dataCreateAllocCount = new AtomicLong();
        private final AtomicLong dataCreateAllocBytes = new AtomicLong();
        private final AtomicLong dataGCDisposeCount = new AtomicLong();
        private final AtomicLong dataGCDisposeBytes = new AtomicLong();
        private final AtomicLong dataPoolDisposeCount = new AtomicLong();
        private final AtomicLong dataPoolDisposeBytes = new AtomicLong();
        private long createAllocCountLast;
        private long poolAllocCountLast;
        private long gcDisposeCountLast;
        private long poolDisposeCountLast;
        private long poolLeakCountLast;
        private long pojoCreateAllocCountLast;
        private long pojoPoolAllocCountLast;
        private long pojoGCDisposeCountLast;
        private long pojoPoolDisposeCountLast;
        private long pojoPoolLeakCountLast;
        private long serializerCreateAllocCountLast;
        private long serializerPoolAllocCountLast;
        private long serializerGCDisposeCountLast;
        private long serializerPoolDisposeCountLast;
        private long serializerPoolLeakCountLast;
        private long deserializerCreateAllocCountLast;
        private long deserializerPoolAllocCountLast;
        private long deserializerGCDisposeCountLast;
        private long deserializerPoolDisposeCountLast;
        private long deserializerPoolLeakCountLast;
        private long metadataCreateAllocCountLast;
        private long metadataCreateAllocBytesLast;
        private long metadataGCDisposeCountLast;
        private long metadataGCDisposeBytesLast;
        private long metadataPoolDisposeCountLast;
        private long metadataPoolDisposeBytesLast;
        private long dataCreateAllocCountLast;
        private long dataCreateAllocBytesLast;
        private long dataGCDisposeCountLast;
        private long dataGCDisposeBytesLast;
        private long dataPoolDisposeCountLast;
        private long dataPoolDisposeBytesLast;
        private long createAllocCountCurrent;
        private long poolAllocCountCurrent;
        private long gcDisposeCountCurrent;
        private long poolDisposeCountCurrent;
        private long poolLeakCountCurrent;
        private long pojoCreateAllocCountCurrent;
        private long pojoPoolAllocCountCurrent;
        private long pojoGCDisposeCountCurrent;
        private long pojoPoolDisposeCountCurrent;
        private long pojoPoolLeakCountCurrent;
        private long serializerCreateAllocCountCurrent;
        private long serializerPoolAllocCountCurrent;
        private long serializerGCDisposeCountCurrent;
        private long serializerPoolDisposeCountCurrent;
        private long serializerPoolLeakCountCurrent;
        private long deserializerCreateAllocCountCurrent;
        private long deserializerPoolAllocCountCurrent;
        private long deserializerGCDisposeCountCurrent;
        private long deserializerPoolDisposeCountCurrent;
        private long deserializerPoolLeakCountCurrent;
        private long metadataCreateAllocCountCurrent;
        private long metadataCreateAllocBytesCurrent;
        private long metadataGCDisposeCountCurrent;
        private long metadataGCDisposeBytesCurrent;
        private long metadataPoolDisposeCountCurrent;
        private long metadataPoolDisposeBytesCurrent;
        private long dataCreateAllocCountCurrent;
        private long dataCreateAllocBytesCurrent;
        private long dataGCDisposeCountCurrent;
        private long dataGCDisposeBytesCurrent;
        private long dataPoolDisposeCountCurrent;
        private long dataPoolDisposeBytesCurrent;

        private EntityTypeStats() {
        }

        final void stampCurrent() {
            this.createAllocCountCurrent = this.createAllocCount.get();
            this.poolAllocCountCurrent = this.poolAllocCount.get();
            this.gcDisposeCountCurrent = this.gcDisposeCount.get();
            this.poolDisposeCountCurrent = this.poolDisposeCount.get();
            this.poolLeakCountCurrent = this.poolLeakCount.get();
            this.pojoCreateAllocCountCurrent = this.pojoCreateAllocCount.get();
            this.pojoPoolAllocCountCurrent = this.pojoPoolAllocCount.get();
            this.pojoGCDisposeCountCurrent = this.pojoGCDisposeCount.get();
            this.pojoPoolDisposeCountCurrent = this.pojoPoolDisposeCount.get();
            this.pojoPoolLeakCountCurrent = this.pojoPoolLeakCount.get();
            this.serializerCreateAllocCountCurrent = this.serializerCreateAllocCount.get();
            this.serializerPoolAllocCountCurrent = this.serializerPoolAllocCount.get();
            this.serializerGCDisposeCountCurrent = this.serializerGCDisposeCount.get();
            this.serializerPoolDisposeCountCurrent = this.serializerPoolDisposeCount.get();
            this.serializerPoolLeakCountCurrent = this.serializerPoolLeakCount.get();
            this.deserializerCreateAllocCountCurrent = this.deserializerCreateAllocCount.get();
            this.deserializerPoolAllocCountCurrent = this.deserializerPoolAllocCount.get();
            this.deserializerGCDisposeCountCurrent = this.deserializerGCDisposeCount.get();
            this.deserializerPoolDisposeCountCurrent = this.deserializerPoolDisposeCount.get();
            this.deserializerPoolLeakCountCurrent = this.deserializerPoolLeakCount.get();
            this.metadataCreateAllocCountCurrent = this.metadataCreateAllocCount.get();
            this.metadataCreateAllocBytesCurrent = this.metadataCreateAllocBytes.get();
            this.metadataGCDisposeCountCurrent = this.metadataGCDisposeCount.get();
            this.metadataGCDisposeBytesCurrent = this.metadataGCDisposeBytes.get();
            this.metadataPoolDisposeCountCurrent = this.metadataPoolDisposeCount.get();
            this.metadataPoolDisposeBytesCurrent = this.metadataPoolDisposeBytes.get();
            this.dataCreateAllocCountCurrent = this.dataCreateAllocCount.get();
            this.dataCreateAllocBytesCurrent = this.dataCreateAllocBytes.get();
            this.dataGCDisposeCountCurrent = this.dataGCDisposeCount.get();
            this.dataGCDisposeBytesCurrent = this.dataGCDisposeBytes.get();
            this.dataPoolDisposeCountCurrent = this.dataPoolDisposeCount.get();
            this.dataPoolDisposeBytesCurrent = this.dataPoolDisposeBytes.get();
        }

        final void currentToLast() {
            this.createAllocCountLast = this.createAllocCountCurrent;
            this.poolAllocCountLast = this.poolAllocCountCurrent;
            this.gcDisposeCountLast = this.gcDisposeCountCurrent;
            this.poolDisposeCountLast = this.poolDisposeCountCurrent;
            this.poolLeakCountLast = this.poolLeakCountCurrent;
            this.pojoCreateAllocCountLast = this.pojoCreateAllocCountCurrent;
            this.pojoPoolAllocCountLast = this.pojoPoolAllocCountCurrent;
            this.pojoGCDisposeCountLast = this.pojoGCDisposeCountCurrent;
            this.pojoPoolDisposeCountLast = this.pojoPoolDisposeCountCurrent;
            this.pojoPoolLeakCountLast = this.pojoPoolLeakCountCurrent;
            this.serializerCreateAllocCountLast = this.serializerCreateAllocCountCurrent;
            this.serializerPoolAllocCountLast = this.serializerPoolAllocCountCurrent;
            this.serializerGCDisposeCountLast = this.serializerGCDisposeCountCurrent;
            this.serializerPoolDisposeCountLast = this.serializerPoolDisposeCountCurrent;
            this.serializerPoolLeakCountLast = this.serializerPoolLeakCountCurrent;
            this.deserializerCreateAllocCountLast = this.deserializerCreateAllocCountCurrent;
            this.deserializerPoolAllocCountLast = this.deserializerPoolAllocCountCurrent;
            this.deserializerGCDisposeCountLast = this.deserializerGCDisposeCountCurrent;
            this.deserializerPoolDisposeCountLast = this.deserializerPoolDisposeCountCurrent;
            this.deserializerPoolLeakCountLast = this.deserializerPoolLeakCountCurrent;
            this.metadataCreateAllocCountLast = this.metadataCreateAllocCountCurrent;
            this.metadataCreateAllocBytesLast = this.metadataCreateAllocBytesCurrent;
            this.metadataGCDisposeCountLast = this.metadataGCDisposeCountCurrent;
            this.metadataGCDisposeBytesLast = this.metadataGCDisposeBytesCurrent;
            this.metadataPoolDisposeCountLast = this.metadataPoolDisposeCountCurrent;
            this.metadataPoolDisposeBytesLast = this.metadataPoolDisposeBytesCurrent;
            this.dataCreateAllocCountLast = this.dataCreateAllocCountCurrent;
            this.dataCreateAllocBytesLast = this.dataCreateAllocBytesCurrent;
            this.dataGCDisposeCountLast = this.dataGCDisposeCountCurrent;
            this.dataGCDisposeBytesLast = this.dataGCDisposeBytesCurrent;
            this.dataPoolDisposeCountLast = this.dataPoolDisposeCountCurrent;
            this.dataPoolDisposeBytesLast = this.dataPoolDisposeBytesCurrent;
        }

        final void get(String prefix, StringBuilder sb, long deltaTime, long deltaTotalTime) {
            String countLiveStr = MemoryStats.this.format.format(this.createAllocCountCurrent + this.poolAllocCountCurrent - this.gcDisposeCountCurrent - this.poolDisposeCountCurrent);
            String countPooledStr = MemoryStats.this.format.format(this.poolDisposeCountCurrent - this.poolAllocCountCurrent - this.poolLeakCountCurrent);
            String pojoCountLiveStr = MemoryStats.this.format.format(this.pojoCreateAllocCountCurrent + this.pojoPoolAllocCountCurrent - this.pojoGCDisposeCountCurrent - this.pojoPoolDisposeCountCurrent);
            String pojoCountPooledStr = MemoryStats.this.format.format(this.pojoPoolDisposeCountCurrent - this.pojoPoolAllocCountCurrent - this.pojoPoolLeakCountCurrent);
            String serializerCountLiveStr = MemoryStats.this.format.format(this.serializerCreateAllocCountCurrent + this.serializerPoolAllocCountCurrent - this.serializerGCDisposeCountCurrent - this.serializerPoolDisposeCountCurrent);
            String serializerCountPooledStr = MemoryStats.this.format.format(this.serializerPoolDisposeCountCurrent - this.serializerPoolAllocCountCurrent - this.serializerPoolLeakCountCurrent);
            String deserializerCountLiveStr = MemoryStats.this.format.format(this.deserializerCreateAllocCountCurrent + this.deserializerPoolAllocCountCurrent - this.deserializerGCDisposeCountCurrent - this.deserializerPoolDisposeCountCurrent);
            String deserializerCountPooledStr = MemoryStats.this.format.format(this.deserializerPoolDisposeCountCurrent - this.deserializerPoolAllocCountCurrent - this.deserializerPoolLeakCountCurrent);
            String metadataBytesLiveStr = MemoryStats.this.format.format(this.metadataCreateAllocBytesCurrent - this.metadataPoolDisposeBytesCurrent - this.metadataGCDisposeBytesCurrent);
            String dataBytesLiveStr = MemoryStats.this.format.format(this.dataCreateAllocBytesCurrent - this.dataPoolDisposeBytesCurrent - this.dataGCDisposeBytesCurrent);
            sb.append(prefix).append(" {");
            sb.append(countLiveStr).append(", ").append(countPooledStr);
            sb.append(" Po {");
            sb.append(pojoCountLiveStr).append(", ").append(pojoCountPooledStr);
            sb.append("}");
            sb.append(" Se {");
            sb.append(serializerCountLiveStr).append(", ").append(serializerCountPooledStr);
            sb.append("}");
            sb.append(" De {");
            sb.append(deserializerCountLiveStr).append(", ").append(deserializerCountPooledStr);
            sb.append("}");
            sb.append(" Me {");
            sb.append(metadataBytesLiveStr);
            sb.append("}");
            sb.append(" Da {");
            sb.append(dataBytesLiveStr);
            sb.append("}");
            sb.append("}");
        }
    }

    public final class IOBufferStats {
        private final AtomicLong directBufferAllocCount = new AtomicLong();
        private final AtomicLong directBufferAllocBytes = new AtomicLong();
        private final AtomicLong directBufferPoolAllocCount = new AtomicLong();
        private final AtomicLong directBufferPoolAllocBytes = new AtomicLong();
        private final AtomicLong directBufferGCDisposeCount = new AtomicLong();
        private final AtomicLong directBufferGCDisposeBytes = new AtomicLong();
        private final AtomicLong directBufferPoolDisposeCount = new AtomicLong();
        private final AtomicLong directBufferPoolDisposeBytes = new AtomicLong();
        private final AtomicLong directBufferPoolLeakCount = new AtomicLong();
        private final AtomicLong directBufferPoolLeakBytes = new AtomicLong();
        private final AtomicLong heapBufferAllocCount = new AtomicLong();
        private final AtomicLong heapBufferAllocBytes = new AtomicLong();
        private final AtomicLong heapBufferPoolAllocCount = new AtomicLong();
        private final AtomicLong heapBufferPoolAllocBytes = new AtomicLong();
        private final AtomicLong heapBufferGCDisposeCount = new AtomicLong();
        private final AtomicLong heapBufferGCDisposeBytes = new AtomicLong();
        private final AtomicLong heapBufferPoolDisposeCount = new AtomicLong();
        private final AtomicLong heapBufferPoolDisposeBytes = new AtomicLong();
        private final AtomicLong heapBufferPoolLeakCount = new AtomicLong();
        private final AtomicLong heapBufferPoolLeakBytes = new AtomicLong();
        private long directBufferAllocCountLast;
        private long directBufferAllocBytesLast;
        private long directBufferPoolAllocCountLast;
        private long directBufferPoolAllocBytesLast;
        private long directBufferGCDisposeCountLast;
        private long directBufferGCDisposeBytesLast;
        private long directBufferPoolDisposeCountLast;
        private long directBufferPoolDisposeBytesLast;
        private long directBufferPoolLeakCountLast;
        private long directBufferPoolLeakBytesLast;
        private long heapBufferAllocCountLast;
        private long heapBufferAllocBytesLast;
        private long heapBufferPoolAllocCountLast;
        private long heapBufferPoolAllocBytesLast;
        private long heapBufferGCDisposeCountLast;
        private long heapBufferGCDisposeBytesLast;
        private long heapBufferPoolDisposeCountLast;
        private long heapBufferPoolDisposeBytesLast;
        private long heapBufferPoolLeakCountLast;
        private long heapBufferPoolLeakBytesLast;
        private long directBufferAllocCountCurrent;
        private long directBufferAllocBytesCurrent;
        private long directBufferPoolAllocCountCurrent;
        private long directBufferPoolAllocBytesCurrent;
        private long directBufferGCDisposeCountCurrent;
        private long directBufferGCDisposeBytesCurrent;
        private long directBufferPoolDisposeCountCurrent;
        private long directBufferPoolDisposeBytesCurrent;
        private long directBufferPoolLeakCountCurrent;
        private long directBufferPoolLeakBytesCurrent;
        private long heapBufferAllocCountCurrent;
        private long heapBufferAllocBytesCurrent;
        private long heapBufferPoolAllocCountCurrent;
        private long heapBufferPoolAllocBytesCurrent;
        private long heapBufferGCDisposeCountCurrent;
        private long heapBufferGCDisposeBytesCurrent;
        private long heapBufferPoolDisposeCountCurrent;
        private long heapBufferPoolDisposeBytesCurrent;
        private long heapBufferPoolLeakCountCurrent;
        private long heapBufferPoolLeakBytesCurrent;

        final void stampCurrent() {
            this.directBufferAllocCountCurrent = this.directBufferAllocCount.get();
            this.directBufferAllocBytesCurrent = this.directBufferAllocBytes.get();
            this.directBufferPoolAllocCountCurrent = this.directBufferPoolAllocCount.get();
            this.directBufferPoolAllocBytesCurrent = this.directBufferPoolAllocBytes.get();
            this.directBufferGCDisposeCountCurrent = this.directBufferGCDisposeCount.get();
            this.directBufferGCDisposeBytesCurrent = this.directBufferGCDisposeBytes.get();
            this.directBufferPoolDisposeCountCurrent = this.directBufferPoolDisposeCount.get();
            this.directBufferPoolDisposeBytesCurrent = this.directBufferPoolDisposeBytes.get();
            this.directBufferPoolLeakCountCurrent = this.directBufferPoolLeakCount.get();
            this.directBufferPoolLeakBytesCurrent = this.directBufferPoolLeakBytes.get();
            this.heapBufferAllocCountCurrent = this.heapBufferAllocCount.get();
            this.heapBufferAllocBytesCurrent = this.heapBufferAllocBytes.get();
            this.heapBufferPoolAllocCountCurrent = this.heapBufferPoolAllocCount.get();
            this.heapBufferPoolAllocBytesCurrent = this.heapBufferPoolAllocBytes.get();
            this.heapBufferGCDisposeCountCurrent = this.heapBufferGCDisposeCount.get();
            this.heapBufferGCDisposeBytesCurrent = this.heapBufferGCDisposeBytes.get();
            this.heapBufferPoolDisposeCountCurrent = this.heapBufferPoolDisposeCount.get();
            this.heapBufferPoolDisposeBytesCurrent = this.heapBufferPoolDisposeBytes.get();
            this.heapBufferPoolLeakCountCurrent = this.heapBufferPoolLeakCount.get();
            this.heapBufferPoolLeakBytesCurrent = this.heapBufferPoolLeakBytes.get();
        }

        final void currentToLast() {
            this.directBufferAllocCountLast = this.directBufferAllocCountCurrent;
            this.directBufferAllocBytesLast = this.directBufferAllocBytesCurrent;
            this.directBufferPoolAllocCountLast = this.directBufferPoolAllocCountCurrent;
            this.directBufferPoolAllocBytesLast = this.directBufferPoolAllocBytesCurrent;
            this.directBufferGCDisposeCountLast = this.directBufferGCDisposeCountCurrent;
            this.directBufferGCDisposeBytesLast = this.directBufferGCDisposeBytesCurrent;
            this.directBufferPoolDisposeCountLast = this.directBufferPoolDisposeCountCurrent;
            this.directBufferPoolDisposeBytesLast = this.directBufferPoolDisposeBytesCurrent;
            this.directBufferPoolLeakCountLast = this.directBufferPoolLeakCountCurrent;
            this.directBufferPoolLeakBytesLast = this.directBufferPoolLeakBytesCurrent;
            this.heapBufferAllocCountLast = this.heapBufferAllocCountCurrent;
            this.heapBufferAllocBytesLast = this.heapBufferAllocBytesCurrent;
            this.heapBufferPoolAllocCountLast = this.heapBufferPoolAllocCountCurrent;
            this.heapBufferPoolAllocBytesLast = this.heapBufferPoolAllocBytesCurrent;
            this.heapBufferGCDisposeCountLast = this.heapBufferGCDisposeCountCurrent;
            this.heapBufferGCDisposeBytesLast = this.heapBufferGCDisposeBytesCurrent;
            this.heapBufferPoolDisposeCountLast = this.heapBufferPoolDisposeCountCurrent;
            this.heapBufferPoolDisposeBytesLast = this.heapBufferPoolDisposeBytesCurrent;
            this.heapBufferPoolLeakCountLast = this.heapBufferPoolLeakCountCurrent;
            this.heapBufferPoolLeakBytesLast = this.heapBufferPoolLeakBytesCurrent;
        }

        final void get(String prefix, StringBuilder sb, long deltaTime, long deltaTotalTime) {
        }

        public final long getDirectBufferCountUsedLive() {
            return this.getDirectBufferAllocCount() + this.getDirectBufferPoolAllocCount() - this.getDirectBufferPoolDisposeCount() - this.getDirectBufferGCDisposeCount();
        }

        public final long getDirectBufferBytesUsedLive() {
            return this.getDirectBufferAllocBytes() + this.getDirectBufferPoolAllocBytes() - this.getDirectBufferPoolDisposeBytes() - this.getDirectBufferGCDisposeBytes();
        }

        public final long getDirectBufferCountUsedPooled() {
            return this.getDirectBufferPoolDisposeCount() - this.getDirectBufferPoolAllocCount() - this.getDirectBufferPoolLeakCount();
        }

        public final long getDirectBufferBytesUsedPooled() {
            return this.getDirectBufferPoolDisposeBytes() - this.getDirectBufferPoolAllocBytes() - this.getDirectBufferPoolLeakBytes();
        }

        public final long getDirectBufferAllocCount() {
            return this.directBufferAllocCount.get();
        }

        public final long getDirectBufferAllocBytes() {
            return this.directBufferAllocBytes.get();
        }

        public final long getDirectBufferPoolAllocCount() {
            return this.directBufferPoolAllocCount.get();
        }

        public final long getDirectBufferPoolAllocBytes() {
            return this.directBufferPoolAllocBytes.get();
        }

        public final long getDirectBufferGCDisposeCount() {
            return this.directBufferGCDisposeCount.get();
        }

        public final long getDirectBufferGCDisposeBytes() {
            return this.directBufferGCDisposeBytes.get();
        }

        public final long getDirectBufferPoolDisposeCount() {
            return this.directBufferPoolDisposeCount.get();
        }

        public final long getDirectBufferPoolDisposeBytes() {
            return this.directBufferPoolDisposeBytes.get();
        }

        public final long getDirectBufferPoolLeakCount() {
            return this.directBufferPoolLeakCount.get();
        }

        public final long getDirectBufferPoolLeakBytes() {
            return this.directBufferPoolLeakBytes.get();
        }
    }

    public final class NativeMemoryStats {
        private final AtomicLong allocCount = new AtomicLong();
        private final AtomicLong allocBytes = new AtomicLong();
        private final AtomicLong reallocCount = new AtomicLong();
        private final AtomicLong reallocBytes = new AtomicLong();
        private final AtomicLong freeCount = new AtomicLong();
        private final AtomicLong freeBytes = new AtomicLong();
        private long allocCountLast;
        private long allocBytesLast;
        private long reallocCountLast;
        private long reallocBytesLast;
        private long freeCountLast;
        private long freeBytesLast;
        private long allocCountCurrent;
        private long allocBytesCurrent;
        private long reallocCountCurrent;
        private long reallocBytesCurrent;
        private long freeCountCurrent;
        private long freeBytesCurrent;

        final void stampCurrent() {
            this.allocCountCurrent = this.allocCount.get();
            this.allocBytesCurrent = this.allocBytes.get();
            this.reallocCountCurrent = this.reallocCount.get();
            this.reallocBytesCurrent = this.reallocBytes.get();
            this.freeCountCurrent = this.freeCount.get();
            this.freeBytesCurrent = this.freeBytes.get();
        }

        final void currentToLast() {
            this.allocCountLast = this.allocCountCurrent;
            this.allocBytesLast = this.allocBytesCurrent;
            this.reallocCountLast = this.reallocCountCurrent;
            this.reallocBytesLast = this.reallocBytesCurrent;
            this.freeCountLast = this.freeCountCurrent;
            this.freeBytesLast = this.freeBytesCurrent;
        }

        final void get(String prefix, StringBuilder sb, long deltaTime, long deltaTotalTime) {
        }

        public final long getBytesUsedLive() {
            return this.getAllocBytes() - this.getFreeBytes() + this.getReallocBytes();
        }

        public final long getAllocCount() {
            return this.allocCount.get();
        }

        public final long getAllocBytes() {
            return this.allocBytes.get();
        }

        public final long getReallocCount() {
            return this.reallocCount.get();
        }

        public final long getReallocBytes() {
            return this.reallocBytes.get();
        }

        public final long getFreeCount() {
            return this.freeCount.get();
        }

        public final long getFreeBytes() {
            return this.freeBytes.get();
        }
    }
}

