/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang.test.unit;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.neeve.lang.XIntCollection;
import com.neeve.lang.XIntIterator;
import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.lang.XIntLinkedList;
import com.neeve.lang.XIntList;
import com.neeve.lang.XIntListIterator;
import com.neeve.lang.XIntMap;
import com.neeve.lang.XIntSet;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class IntCollectionAdapters {
    IntCollectionAdapters() {
    }

    static <V> Map<Integer, V> toLinkedIntegerMap(XIntMap<V> map) {
        return new XPrimitiveToIntegerMapAdapter<V>(map);
    }

    static <V> List<Integer> toIntegerList(XIntList list) {
        return new XPrimitiveToIntegerListAdapter(list);
    }

    private static int adaptInteger(Object value) {
        if (value == null) {
            throw new NullPointerException("Null values not supported");
        }
        return (Integer)value;
    }

    private static Object adaptIntegerMapEntry(Object entry) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof Map.Entry) {
            try {
                return IntCollectionAdapters.adaptIntegerMapEntry((Map.Entry)entry);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return entry;
    }

    private static <V> XIntMap.Entry<V> adaptIntegerMapEntry(Map.Entry<Integer, V> entry) {
        if (entry == null) {
            return null;
        }
        return new XIntegerToPrimitiveMapEntryAdapter<V>(entry);
    }

    private static Collection<?> adaptToPrimitiveIntegerMapEntryCollectionIfPossible(Collection<?> c) {
        if (c == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(IntCollectionAdapters.adaptIntegerMapEntry(o));
        }
        return list;
    }

    private static <V> Collection<? extends XIntMap.Entry<V>> adaptToPrimitiveIntegerMapEntryCollection(Collection<? extends Map.Entry<Integer, V>> c) {
        if (c == null) {
            return null;
        }
        ArrayList<XIntMap.Entry<V>> list = new ArrayList<XIntMap.Entry<V>>(c.size());
        for (Map.Entry<Integer, V> e : c) {
            list.add(IntCollectionAdapters.adaptIntegerMapEntry(e));
        }
        return list;
    }

    public static class Integers
    extends SampleElements<Integer> {
        public Integers() {
            super((Object)1, (Object)2, (Object)3, (Object)4, (Object)5);
        }
    }

    public static abstract class TestIntegerListGenerator
    implements TestListGenerator<Integer> {
        public SampleElements<Integer> samples() {
            return new Integers();
        }

        public List<Integer> create(Object ... elements) {
            Integer[] array = new Integer[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Integer)e;
            }
            return this.create(array);
        }

        protected abstract List<Integer> create(Integer[] var1);

        public Integer[] createArray(int length) {
            return new Integer[length];
        }

        public List<Integer> order(List<Integer> insertionOrder) {
            return insertionOrder;
        }
    }

    public static abstract class TestIntegerMapGenerator
    implements TestMapGenerator<Integer, String> {
        public SampleElements<Map.Entry<Integer, String>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)1, (Object)"January"), (Object)Helpers.mapEntry((Object)2, (Object)"February"), (Object)Helpers.mapEntry((Object)3, (Object)"March"), (Object)Helpers.mapEntry((Object)4, (Object)"April"), (Object)Helpers.mapEntry((Object)5, (Object)"May"));
        }

        public Map<Integer, String> create(Object ... entries) {
            Map.Entry[] array = new Map.Entry[entries.length];
            int i = 0;
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                array[i++] = e;
            }
            return this.create(array);
        }

        protected abstract Map<Integer, String> create(Map.Entry<Integer, String>[] var1);

        public final Map.Entry<Integer, String>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public final Integer[] createKeyArray(int length) {
            return new Integer[length];
        }

        public final String[] createValueArray(int length) {
            return new String[length];
        }

        public Iterable<Map.Entry<Integer, String>> order(List<Map.Entry<Integer, String>> insertionOrder) {
            return insertionOrder;
        }
    }

    private static class XPrimtiveToIntegerEntrySetAdapter<V>
    extends AbstractSet<Map.Entry<Integer, V>>
    implements Set<Map.Entry<Integer, V>> {
        private final Set<XIntMap.Entry<V>> adaptee;

        public XPrimtiveToIntegerEntrySetAdapter(Set<XIntMap.Entry<V>> entrySet) {
            this.adaptee = entrySet;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(IntCollectionAdapters.adaptIntegerMapEntry(o));
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            final Iterator<XIntMap.Entry<V>> toAdapt = this.adaptee.iterator();
            return new Iterator<Map.Entry<Integer, V>>(){

                @Override
                public boolean hasNext() {
                    return toAdapt.hasNext();
                }

                @Override
                public Map.Entry<Integer, V> next() {
                    XIntMap.Entry next = (XIntMap.Entry)toAdapt.next();
                    if (next == null) {
                        return null;
                    }
                    return new AbstractMap.SimpleEntry(next.getKey(), next.getValue());
                }

                @Override
                public void remove() {
                    toAdapt.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] toAdapt = this.adaptee.toArray();
            Object[] adapted = new Object[toAdapt.length];
            for (int i = 0; i < toAdapt.length; ++i) {
                if (toAdapt[i] == null) continue;
                XIntMap.Entry xEntry = (XIntMap.Entry)toAdapt[i];
                adapted[i] = new AbstractMap.SimpleEntry(xEntry.getKey(), xEntry.getValue());
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            XIntMap.Entry[] toAdapt = this.adaptee.toArray(new XIntMap.Entry[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < toAdapt.length; ++i) {
                a[i] = toAdapt[i] != null ? new AbstractMap.SimpleEntry(toAdapt[i].getKey(), toAdapt[i].getValue()) : null;
            }
            return a;
        }

        @Override
        public boolean add(Map.Entry<Integer, V> e) {
            return this.adaptee.add(IntCollectionAdapters.adaptIntegerMapEntry(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(IntCollectionAdapters.adaptIntegerMapEntry(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.adaptee.containsAll(IntCollectionAdapters.adaptToPrimitiveIntegerMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Integer, V>> c) {
            return this.adaptee.addAll(IntCollectionAdapters.adaptToPrimitiveIntegerMapEntryCollection(c));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.adaptee.retainAll(IntCollectionAdapters.adaptToPrimitiveIntegerMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.adaptee.removeAll(IntCollectionAdapters.adaptToPrimitiveIntegerMapEntryCollectionIfPossible(c));
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class XIntegerToPrimitiveMapEntryAdapter<V>
    extends XIntLinkedHashMap.Entry<V> {
        XIntegerToPrimitiveMapEntryAdapter(Map.Entry<Integer, V> entry) {
            this.setKey(entry.getKey());
            this.setValue(entry.getValue());
        }
    }

    private static class XPrimitiveToIntegerListIteratorAdapater
    extends XIntIteratorAdapater
    implements ListIterator<Integer> {
        final XIntListIterator adaptee;

        XPrimitiveToIntegerListIteratorAdapater(XIntListIterator iterator) {
            super(iterator);
            this.adaptee = iterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.adaptee.hasPrevious();
        }

        @Override
        public Integer previous() {
            return this.adaptee.previous();
        }

        @Override
        public int nextIndex() {
            return this.adaptee.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.adaptee.previousIndex();
        }

        @Override
        public void set(Integer e) {
            this.adaptee.set(IntCollectionAdapters.adaptInteger(e));
        }

        @Override
        public void add(Integer e) {
            this.adaptee.add(IntCollectionAdapters.adaptInteger(e));
        }
    }

    private static class XIntIteratorAdapater
    implements Iterator<Integer> {
        final XIntIterator iterator;

        XIntIteratorAdapater(XIntIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Integer next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class XPrimitiveToIntegerCollectionAdapter<S extends XIntCollection>
    extends AbstractCollection<Integer>
    implements Collection<Integer> {
        final S adaptee;

        XPrimitiveToIntegerCollectionAdapter(S collection) {
            this.adaptee = collection;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(IntCollectionAdapters.adaptInteger(o));
        }

        @Override
        public Iterator<Integer> iterator() {
            return new XIntIteratorAdapater(this.adaptee.iterator());
        }

        @Override
        public Object[] toArray() {
            int[] val = this.adaptee.toArray();
            Object[] adapted = new Object[val.length];
            for (int i = 0; i < val.length; ++i) {
                adapted[i] = val[i];
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int[] toAdapt = this.adaptee.toArray(new int[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < this.adaptee.size(); ++i) {
                a[i] = toAdapt[i];
            }
            if (a.length > this.adaptee.size()) {
                a[this.adaptee.size()] = null;
            }
            return a;
        }

        @Override
        public boolean add(Integer e) {
            return this.adaptee.add(IntCollectionAdapters.adaptInteger(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(IntCollectionAdapters.adaptInteger(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            XIntLinkedList adapter = new XIntLinkedList();
            for (Object o : c) {
                adapter.add(IntCollectionAdapters.adaptInteger(o));
            }
            return this.adaptee.containsAll(adapter);
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            XIntLinkedList adapter = new XIntLinkedList();
            for (Integer n : c) {
                adapter.add(IntCollectionAdapters.adaptInteger(n));
            }
            return this.adaptee.addAll(adapter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            XIntLinkedList adapter = new XIntLinkedList();
            for (Object o : c) {
                try {
                    adapter.add(IntCollectionAdapters.adaptInteger(o));
                }
                catch (NullPointerException nullPointerException) {}
            }
            return this.adaptee.retainAll(adapter);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            XIntLinkedList adapter = new XIntLinkedList();
            for (Object o : c) {
                adapter.add(IntCollectionAdapters.adaptInteger(o));
            }
            return this.adaptee.removeAll(adapter);
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }
    }

    private static class XPrimitiveToIntegerListAdapter
    extends XPrimitiveToIntegerCollectionAdapter<XIntList>
    implements List<Integer> {
        XPrimitiveToIntegerListAdapter(XIntList set) {
            super(set);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Integer> c) {
            XIntLinkedList adapter = new XIntLinkedList();
            for (Integer n : c) {
                adapter.add(IntCollectionAdapters.adaptInteger(n));
            }
            return ((XIntList)this.adaptee).addAll(index, adapter);
        }

        @Override
        public Integer get(int index) {
            return ((XIntList)this.adaptee).get(index);
        }

        @Override
        public Integer set(int index, Integer element) {
            return ((XIntList)this.adaptee).set(index, IntCollectionAdapters.adaptInteger(element));
        }

        @Override
        public void add(int index, Integer element) {
            ((XIntList)this.adaptee).add(index, IntCollectionAdapters.adaptInteger(element));
        }

        @Override
        public boolean remove(Object value) {
            return ((XIntList)this.adaptee).remove((Integer)value);
        }

        @Override
        public Integer remove(int index) {
            return ((XIntList)this.adaptee).removeIndex(index);
        }

        @Override
        public int indexOf(Object o) {
            return ((XIntList)this.adaptee).indexOf(IntCollectionAdapters.adaptInteger(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((XIntList)this.adaptee).lastIndexOf(IntCollectionAdapters.adaptInteger(o));
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return new XPrimitiveToIntegerListIteratorAdapater(((XIntList)this.adaptee).listIterator());
        }

        @Override
        public ListIterator<Integer> listIterator(int index) {
            return new XPrimitiveToIntegerListIteratorAdapater(((XIntList)this.adaptee).listIterator(index));
        }

        @Override
        public List<Integer> subList(int fromIndex, int toIndex) {
            return new XPrimitiveToIntegerListAdapter(((XIntList)this.adaptee).subList(fromIndex, toIndex));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            ListIterator<Integer> e1 = this.listIterator();
            ListIterator e2 = ((List)o).listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Integer o1 = e1.next();
                Object o2 = e2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Integer obj : this) {
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return hashCode;
        }
    }

    private static class XPrimitiveToIntSetAdapter
    extends XPrimitiveToIntegerCollectionAdapter<XIntSet>
    implements Set<Integer> {
        XPrimitiveToIntSetAdapter(XIntSet set) {
            super(set);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Integer obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            if (this.size() > c.size()) {
                Iterator<?> i = c.iterator();
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            } else {
                Iterator<Integer> i = this.iterator();
                while (i.hasNext()) {
                    if (!c.contains(i.next())) continue;
                    i.remove();
                    modified = true;
                }
            }
            return modified;
        }
    }

    private static class XPrimitiveToIntegerMapAdapter<V>
    extends AbstractMap<Integer, V>
    implements Map<Integer, V> {
        private final XIntMap<V> map;

        public XPrimitiveToIntegerMapAdapter(XIntMap<V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(IntCollectionAdapters.adaptInteger(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.map.get(IntCollectionAdapters.adaptInteger(key));
        }

        @Override
        public V put(Integer key, V value) {
            return this.map.put(IntCollectionAdapters.adaptInteger(key), value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(IntCollectionAdapters.adaptInteger(key));
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends V> m) {
            XIntLinkedHashMap<V> adapter = new XIntLinkedHashMap<V>(m != null ? m.size() : 16);
            for (Map.Entry<Integer, V> entry : m.entrySet()) {
                adapter.put(IntCollectionAdapters.adaptInteger(entry.getKey()), entry.getValue());
            }
            this.map.putAll(adapter);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<Integer> keySet() {
            return new XPrimitiveToIntSetAdapter(this.map.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<Integer, V>> entrySet() {
            return new XPrimtiveToIntegerEntrySetAdapter<V>(this.map.entrySet());
        }
    }
}

