/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang.test.unit;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.neeve.lang.XFloatCollection;
import com.neeve.lang.XFloatIterator;
import com.neeve.lang.XFloatLinkedHashMap;
import com.neeve.lang.XFloatLinkedList;
import com.neeve.lang.XFloatList;
import com.neeve.lang.XFloatListIterator;
import com.neeve.lang.XFloatMap;
import com.neeve.lang.XFloatSet;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class FloatCollectionAdapters {
    FloatCollectionAdapters() {
    }

    static <V> Map<Float, V> toLinkedFloatMap(XFloatMap<V> map) {
        return new XPrimitiveToFloatMapAdapter<V>(map);
    }

    static <V> List<Float> toFloatList(XFloatList list) {
        return new XPrimitiveToFloatListAdapter(list);
    }

    private static float adaptFloat(Object value) {
        if (value == null) {
            throw new NullPointerException("Null values not supported");
        }
        return ((Float)value).floatValue();
    }

    private static Object adaptFloatMapEntry(Object entry) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof Map.Entry) {
            try {
                return FloatCollectionAdapters.adaptFloatMapEntry((Map.Entry)entry);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return entry;
    }

    private static <V> XFloatMap.Entry<V> adaptFloatMapEntry(Map.Entry<Float, V> entry) {
        if (entry == null) {
            return null;
        }
        return new XFloatToPrimitiveMapEntryAdapter<V>(entry);
    }

    private static Collection<?> adaptToPrimitiveFloatMapEntryCollectionIfPossible(Collection<?> c) {
        if (c == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(FloatCollectionAdapters.adaptFloatMapEntry(o));
        }
        return list;
    }

    private static <V> Collection<? extends XFloatMap.Entry<V>> adaptToPrimitiveFloatMapEntryCollection(Collection<? extends Map.Entry<Float, V>> c) {
        if (c == null) {
            return null;
        }
        ArrayList<XFloatMap.Entry<V>> list = new ArrayList<XFloatMap.Entry<V>>(c.size());
        for (Map.Entry<Float, V> e : c) {
            list.add(FloatCollectionAdapters.adaptFloatMapEntry(e));
        }
        return list;
    }

    public static class Floats
    extends SampleElements<Float> {
        public Floats() {
            super((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f), (Object)Float.valueOf(4.0f), (Object)Float.valueOf(5.0f));
        }
    }

    public static abstract class TestFloatListGenerator
    implements TestListGenerator<Float> {
        public SampleElements<Float> samples() {
            return new Floats();
        }

        public List<Float> create(Object ... elements) {
            Float[] array = new Float[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Float)e;
            }
            return this.create(array);
        }

        protected abstract List<Float> create(Float[] var1);

        public Float[] createArray(int length) {
            return new Float[length];
        }

        public List<Float> order(List<Float> insertionOrder) {
            return insertionOrder;
        }
    }

    public static abstract class TestFloatMapGenerator
    implements TestMapGenerator<Float, String> {
        public SampleElements<Map.Entry<Float, String>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)Float.valueOf(1.0f), (Object)"January"), (Object)Helpers.mapEntry((Object)Float.valueOf(2.0f), (Object)"February"), (Object)Helpers.mapEntry((Object)Float.valueOf(3.0f), (Object)"March"), (Object)Helpers.mapEntry((Object)Float.valueOf(4.0f), (Object)"April"), (Object)Helpers.mapEntry((Object)Float.valueOf(5.0f), (Object)"May"));
        }

        public Map<Float, String> create(Object ... entries) {
            Map.Entry[] array = new Map.Entry[entries.length];
            int i = 0;
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                array[i++] = e;
            }
            return this.create(array);
        }

        protected abstract Map<Float, String> create(Map.Entry<Float, String>[] var1);

        public final Map.Entry<Float, String>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public final Float[] createKeyArray(int length) {
            return new Float[length];
        }

        public final String[] createValueArray(int length) {
            return new String[length];
        }

        public Iterable<Map.Entry<Float, String>> order(List<Map.Entry<Float, String>> insertionOrder) {
            return insertionOrder;
        }
    }

    private static class XPrimtiveToFloatEntrySetAdapter<V>
    extends AbstractSet<Map.Entry<Float, V>>
    implements Set<Map.Entry<Float, V>> {
        private final Set<XFloatMap.Entry<V>> adaptee;

        public XPrimtiveToFloatEntrySetAdapter(Set<XFloatMap.Entry<V>> entrySet) {
            this.adaptee = entrySet;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(FloatCollectionAdapters.adaptFloatMapEntry(o));
        }

        @Override
        public Iterator<Map.Entry<Float, V>> iterator() {
            final Iterator<XFloatMap.Entry<V>> toAdapt = this.adaptee.iterator();
            return new Iterator<Map.Entry<Float, V>>(){

                @Override
                public boolean hasNext() {
                    return toAdapt.hasNext();
                }

                @Override
                public Map.Entry<Float, V> next() {
                    XFloatMap.Entry next = (XFloatMap.Entry)toAdapt.next();
                    if (next == null) {
                        return null;
                    }
                    return new AbstractMap.SimpleEntry(Float.valueOf(next.getKey()), next.getValue());
                }

                @Override
                public void remove() {
                    toAdapt.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] toAdapt = this.adaptee.toArray();
            Object[] adapted = new Object[toAdapt.length];
            for (int i = 0; i < toAdapt.length; ++i) {
                if (toAdapt[i] == null) continue;
                XFloatMap.Entry xEntry = (XFloatMap.Entry)toAdapt[i];
                adapted[i] = new AbstractMap.SimpleEntry(Float.valueOf(xEntry.getKey()), xEntry.getValue());
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            XFloatMap.Entry[] toAdapt = this.adaptee.toArray(new XFloatMap.Entry[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < toAdapt.length; ++i) {
                a[i] = toAdapt[i] != null ? new AbstractMap.SimpleEntry(Float.valueOf(toAdapt[i].getKey()), toAdapt[i].getValue()) : null;
            }
            return a;
        }

        @Override
        public boolean add(Map.Entry<Float, V> e) {
            return this.adaptee.add(FloatCollectionAdapters.adaptFloatMapEntry(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(FloatCollectionAdapters.adaptFloatMapEntry(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.adaptee.containsAll(FloatCollectionAdapters.adaptToPrimitiveFloatMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Float, V>> c) {
            return this.adaptee.addAll(FloatCollectionAdapters.adaptToPrimitiveFloatMapEntryCollection(c));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.adaptee.retainAll(FloatCollectionAdapters.adaptToPrimitiveFloatMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.adaptee.removeAll(FloatCollectionAdapters.adaptToPrimitiveFloatMapEntryCollectionIfPossible(c));
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class XFloatToPrimitiveMapEntryAdapter<V>
    extends XFloatLinkedHashMap.Entry<V> {
        XFloatToPrimitiveMapEntryAdapter(Map.Entry<Float, V> entry) {
            this.setKey(entry.getKey().floatValue());
            this.setValue(entry.getValue());
        }
    }

    private static class XPrimitiveToFloatListIteratorAdapater
    extends XFloatIteratorAdapater
    implements ListIterator<Float> {
        final XFloatListIterator adaptee;

        XPrimitiveToFloatListIteratorAdapater(XFloatListIterator iterator) {
            super(iterator);
            this.adaptee = iterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.adaptee.hasPrevious();
        }

        @Override
        public Float previous() {
            return Float.valueOf(this.adaptee.previous());
        }

        @Override
        public int nextIndex() {
            return this.adaptee.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.adaptee.previousIndex();
        }

        @Override
        public void set(Float e) {
            this.adaptee.set(FloatCollectionAdapters.adaptFloat(e));
        }

        @Override
        public void add(Float e) {
            this.adaptee.add(FloatCollectionAdapters.adaptFloat(e));
        }
    }

    private static class XFloatIteratorAdapater
    implements Iterator<Float> {
        final XFloatIterator iterator;

        XFloatIteratorAdapater(XFloatIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Float next() {
            return Float.valueOf(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class XPrimitiveToFloatCollectionAdapter<S extends XFloatCollection>
    extends AbstractCollection<Float>
    implements Collection<Float> {
        final S adaptee;

        XPrimitiveToFloatCollectionAdapter(S collection) {
            this.adaptee = collection;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(FloatCollectionAdapters.adaptFloat(o));
        }

        @Override
        public Iterator<Float> iterator() {
            return new XFloatIteratorAdapater(this.adaptee.iterator());
        }

        @Override
        public Object[] toArray() {
            float[] val = this.adaptee.toArray();
            Object[] adapted = new Object[val.length];
            for (int i = 0; i < val.length; ++i) {
                adapted[i] = Float.valueOf(val[i]);
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            float[] toAdapt = this.adaptee.toArray(new float[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < this.adaptee.size(); ++i) {
                a[i] = Float.valueOf(toAdapt[i]);
            }
            if (a.length > this.adaptee.size()) {
                a[this.adaptee.size()] = null;
            }
            return a;
        }

        @Override
        public boolean add(Float e) {
            return this.adaptee.add(FloatCollectionAdapters.adaptFloat(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(FloatCollectionAdapters.adaptFloat(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            XFloatLinkedList adapter = new XFloatLinkedList();
            for (Object o : c) {
                adapter.add(FloatCollectionAdapters.adaptFloat(o));
            }
            return this.adaptee.containsAll(adapter);
        }

        @Override
        public boolean addAll(Collection<? extends Float> c) {
            XFloatLinkedList adapter = new XFloatLinkedList();
            for (Float f : c) {
                adapter.add(FloatCollectionAdapters.adaptFloat(f));
            }
            return this.adaptee.addAll(adapter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            XFloatLinkedList adapter = new XFloatLinkedList();
            for (Object o : c) {
                try {
                    adapter.add(FloatCollectionAdapters.adaptFloat(o));
                }
                catch (NullPointerException nullPointerException) {}
            }
            return this.adaptee.retainAll(adapter);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            XFloatLinkedList adapter = new XFloatLinkedList();
            for (Object o : c) {
                adapter.add(FloatCollectionAdapters.adaptFloat(o));
            }
            return this.adaptee.removeAll(adapter);
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }
    }

    private static class XPrimitiveToFloatListAdapter
    extends XPrimitiveToFloatCollectionAdapter<XFloatList>
    implements List<Float> {
        XPrimitiveToFloatListAdapter(XFloatList set) {
            super(set);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Float> c) {
            XFloatLinkedList adapter = new XFloatLinkedList();
            for (Float f : c) {
                adapter.add(FloatCollectionAdapters.adaptFloat(f));
            }
            return ((XFloatList)this.adaptee).addAll(index, adapter);
        }

        @Override
        public Float get(int index) {
            return Float.valueOf(((XFloatList)this.adaptee).get(index));
        }

        @Override
        public Float set(int index, Float element) {
            return Float.valueOf(((XFloatList)this.adaptee).set(index, FloatCollectionAdapters.adaptFloat(element)));
        }

        @Override
        public void add(int index, Float element) {
            ((XFloatList)this.adaptee).add(index, FloatCollectionAdapters.adaptFloat(element));
        }

        @Override
        public Float remove(int index) {
            return Float.valueOf(((XFloatList)this.adaptee).remove(index));
        }

        @Override
        public int indexOf(Object o) {
            return ((XFloatList)this.adaptee).indexOf(FloatCollectionAdapters.adaptFloat(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((XFloatList)this.adaptee).lastIndexOf(FloatCollectionAdapters.adaptFloat(o));
        }

        @Override
        public ListIterator<Float> listIterator() {
            return new XPrimitiveToFloatListIteratorAdapater(((XFloatList)this.adaptee).listIterator());
        }

        @Override
        public ListIterator<Float> listIterator(int index) {
            return new XPrimitiveToFloatListIteratorAdapater(((XFloatList)this.adaptee).listIterator(index));
        }

        @Override
        public List<Float> subList(int fromIndex, int toIndex) {
            return new XPrimitiveToFloatListAdapter(((XFloatList)this.adaptee).subList(fromIndex, toIndex));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            ListIterator<Float> e1 = this.listIterator();
            ListIterator e2 = ((List)o).listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Float o1 = e1.next();
                Object o2 = e2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Float obj : this) {
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return hashCode;
        }
    }

    private static class XPrimitiveToFloatSetAdapter
    extends XPrimitiveToFloatCollectionAdapter<XFloatSet>
    implements Set<Float> {
        XPrimitiveToFloatSetAdapter(XFloatSet set) {
            super(set);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Float obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            if (this.size() > c.size()) {
                Iterator<?> i = c.iterator();
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            } else {
                Iterator<Float> i = this.iterator();
                while (i.hasNext()) {
                    if (!c.contains(i.next())) continue;
                    i.remove();
                    modified = true;
                }
            }
            return modified;
        }
    }

    private static class XPrimitiveToFloatMapAdapter<V>
    extends AbstractMap<Float, V>
    implements Map<Float, V> {
        private final XFloatMap<V> map;

        public XPrimitiveToFloatMapAdapter(XFloatMap<V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(FloatCollectionAdapters.adaptFloat(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.map.get(FloatCollectionAdapters.adaptFloat(key));
        }

        @Override
        public V put(Float key, V value) {
            return this.map.put(FloatCollectionAdapters.adaptFloat(key), value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(FloatCollectionAdapters.adaptFloat(key));
        }

        @Override
        public void putAll(Map<? extends Float, ? extends V> m) {
            XFloatLinkedHashMap<V> adapter = new XFloatLinkedHashMap<V>(m != null ? m.size() : 16);
            for (Map.Entry<Float, V> entry : m.entrySet()) {
                adapter.put(FloatCollectionAdapters.adaptFloat(entry.getKey()), entry.getValue());
            }
            this.map.putAll(adapter);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<Float> keySet() {
            return new XPrimitiveToFloatSetAdapter(this.map.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<Float, V>> entrySet() {
            return new XPrimtiveToFloatEntrySetAdapter<V>(this.map.entrySet());
        }
    }
}

