/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang.test.unit;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.neeve.lang.XDoubleCollection;
import com.neeve.lang.XDoubleIterator;
import com.neeve.lang.XDoubleLinkedHashMap;
import com.neeve.lang.XDoubleLinkedList;
import com.neeve.lang.XDoubleList;
import com.neeve.lang.XDoubleListIterator;
import com.neeve.lang.XDoubleMap;
import com.neeve.lang.XDoubleSet;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class DoubleCollectionAdapters {
    DoubleCollectionAdapters() {
    }

    static <V> Map<Double, V> toLinkedDoubleMap(XDoubleMap<V> map) {
        return new XPrimitiveToDoubleMapAdapter<V>(map);
    }

    static <V> List<Double> toDoubleList(XDoubleList list) {
        return new XPrimitiveToDoubleListAdapter(list);
    }

    private static double adaptDouble(Object value) {
        if (value == null) {
            throw new NullPointerException("Null values not supported");
        }
        return (Double)value;
    }

    private static Object adaptDoubleMapEntry(Object entry) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof Map.Entry) {
            try {
                return DoubleCollectionAdapters.adaptDoubleMapEntry((Map.Entry)entry);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return entry;
    }

    private static <V> XDoubleMap.Entry<V> adaptDoubleMapEntry(Map.Entry<Double, V> entry) {
        if (entry == null) {
            return null;
        }
        return new XDoubleToPrimitiveMapEntryAdapter<V>(entry);
    }

    private static Collection<?> adaptToPrimitiveDoubleMapEntryCollectionIfPossible(Collection<?> c) {
        if (c == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(DoubleCollectionAdapters.adaptDoubleMapEntry(o));
        }
        return list;
    }

    private static <V> Collection<? extends XDoubleMap.Entry<V>> adaptToPrimitiveDoubleMapEntryCollection(Collection<? extends Map.Entry<Double, V>> c) {
        if (c == null) {
            return null;
        }
        ArrayList<XDoubleMap.Entry<V>> list = new ArrayList<XDoubleMap.Entry<V>>(c.size());
        for (Map.Entry<Double, V> e : c) {
            list.add(DoubleCollectionAdapters.adaptDoubleMapEntry(e));
        }
        return list;
    }

    public static class Doubles
    extends SampleElements<Double> {
        public Doubles() {
            super((Object)1.0, (Object)2.0, (Object)3.0, (Object)4.0, (Object)5.0);
        }
    }

    public static abstract class TestDoubleListGenerator
    implements TestListGenerator<Double> {
        public SampleElements<Double> samples() {
            return new Doubles();
        }

        public List<Double> create(Object ... elements) {
            Double[] array = new Double[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Double)e;
            }
            return this.create(array);
        }

        protected abstract List<Double> create(Double[] var1);

        public Double[] createArray(int length) {
            return new Double[length];
        }

        public List<Double> order(List<Double> insertionOrder) {
            return insertionOrder;
        }
    }

    public static abstract class TestDoubleMapGenerator
    implements TestMapGenerator<Double, String> {
        public SampleElements<Map.Entry<Double, String>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)1.0, (Object)"January"), (Object)Helpers.mapEntry((Object)2.0, (Object)"February"), (Object)Helpers.mapEntry((Object)3.0, (Object)"March"), (Object)Helpers.mapEntry((Object)4.0, (Object)"April"), (Object)Helpers.mapEntry((Object)5.0, (Object)"May"));
        }

        public Map<Double, String> create(Object ... entries) {
            Map.Entry[] array = new Map.Entry[entries.length];
            int i = 0;
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                array[i++] = e;
            }
            return this.create(array);
        }

        protected abstract Map<Double, String> create(Map.Entry<Double, String>[] var1);

        public final Map.Entry<Double, String>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public final Double[] createKeyArray(int length) {
            return new Double[length];
        }

        public final String[] createValueArray(int length) {
            return new String[length];
        }

        public Iterable<Map.Entry<Double, String>> order(List<Map.Entry<Double, String>> insertionOrder) {
            return insertionOrder;
        }
    }

    private static class XPrimtiveToDoubleEntrySetAdapter<V>
    extends AbstractSet<Map.Entry<Double, V>>
    implements Set<Map.Entry<Double, V>> {
        private final Set<XDoubleMap.Entry<V>> adaptee;

        public XPrimtiveToDoubleEntrySetAdapter(Set<XDoubleMap.Entry<V>> entrySet) {
            this.adaptee = entrySet;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(DoubleCollectionAdapters.adaptDoubleMapEntry(o));
        }

        @Override
        public Iterator<Map.Entry<Double, V>> iterator() {
            final Iterator<XDoubleMap.Entry<V>> toAdapt = this.adaptee.iterator();
            return new Iterator<Map.Entry<Double, V>>(){

                @Override
                public boolean hasNext() {
                    return toAdapt.hasNext();
                }

                @Override
                public Map.Entry<Double, V> next() {
                    XDoubleMap.Entry next = (XDoubleMap.Entry)toAdapt.next();
                    if (next == null) {
                        return null;
                    }
                    return new AbstractMap.SimpleEntry(next.getKey(), next.getValue());
                }

                @Override
                public void remove() {
                    toAdapt.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] toAdapt = this.adaptee.toArray();
            Object[] adapted = new Object[toAdapt.length];
            for (int i = 0; i < toAdapt.length; ++i) {
                if (toAdapt[i] == null) continue;
                XDoubleMap.Entry xEntry = (XDoubleMap.Entry)toAdapt[i];
                adapted[i] = new AbstractMap.SimpleEntry(xEntry.getKey(), xEntry.getValue());
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            XDoubleMap.Entry[] toAdapt = this.adaptee.toArray(new XDoubleMap.Entry[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < toAdapt.length; ++i) {
                a[i] = toAdapt[i] != null ? new AbstractMap.SimpleEntry(toAdapt[i].getKey(), toAdapt[i].getValue()) : null;
            }
            return a;
        }

        @Override
        public boolean add(Map.Entry<Double, V> e) {
            return this.adaptee.add(DoubleCollectionAdapters.adaptDoubleMapEntry(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(DoubleCollectionAdapters.adaptDoubleMapEntry(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.adaptee.containsAll(DoubleCollectionAdapters.adaptToPrimitiveDoubleMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Double, V>> c) {
            return this.adaptee.addAll(DoubleCollectionAdapters.adaptToPrimitiveDoubleMapEntryCollection(c));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.adaptee.retainAll(DoubleCollectionAdapters.adaptToPrimitiveDoubleMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.adaptee.removeAll(DoubleCollectionAdapters.adaptToPrimitiveDoubleMapEntryCollectionIfPossible(c));
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class XDoubleToPrimitiveMapEntryAdapter<V>
    extends XDoubleLinkedHashMap.Entry<V> {
        XDoubleToPrimitiveMapEntryAdapter(Map.Entry<Double, V> entry) {
            this.setKey(entry.getKey());
            this.setValue(entry.getValue());
        }
    }

    private static class XPrimitiveToDoubleListIteratorAdapater
    extends XDoubleIteratorAdapater
    implements ListIterator<Double> {
        final XDoubleListIterator adaptee;

        XPrimitiveToDoubleListIteratorAdapater(XDoubleListIterator iterator) {
            super(iterator);
            this.adaptee = iterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.adaptee.hasPrevious();
        }

        @Override
        public Double previous() {
            return this.adaptee.previous();
        }

        @Override
        public int nextIndex() {
            return this.adaptee.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.adaptee.previousIndex();
        }

        @Override
        public void set(Double e) {
            this.adaptee.set(DoubleCollectionAdapters.adaptDouble(e));
        }

        @Override
        public void add(Double e) {
            this.adaptee.add(DoubleCollectionAdapters.adaptDouble(e));
        }
    }

    private static class XDoubleIteratorAdapater
    implements Iterator<Double> {
        final XDoubleIterator iterator;

        XDoubleIteratorAdapater(XDoubleIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Double next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class XPrimitiveToDoubleCollectionAdapter<S extends XDoubleCollection>
    extends AbstractCollection<Double>
    implements Collection<Double> {
        final S adaptee;

        XPrimitiveToDoubleCollectionAdapter(S collection) {
            this.adaptee = collection;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(DoubleCollectionAdapters.adaptDouble(o));
        }

        @Override
        public Iterator<Double> iterator() {
            return new XDoubleIteratorAdapater(this.adaptee.iterator());
        }

        @Override
        public Object[] toArray() {
            double[] val = this.adaptee.toArray();
            Object[] adapted = new Object[val.length];
            for (int i = 0; i < val.length; ++i) {
                adapted[i] = val[i];
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            double[] toAdapt = this.adaptee.toArray(new double[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < this.adaptee.size(); ++i) {
                a[i] = toAdapt[i];
            }
            if (a.length > this.adaptee.size()) {
                a[this.adaptee.size()] = null;
            }
            return a;
        }

        @Override
        public boolean add(Double e) {
            return this.adaptee.add(DoubleCollectionAdapters.adaptDouble(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(DoubleCollectionAdapters.adaptDouble(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            XDoubleLinkedList adapter = new XDoubleLinkedList();
            for (Object o : c) {
                adapter.add(DoubleCollectionAdapters.adaptDouble(o));
            }
            return this.adaptee.containsAll(adapter);
        }

        @Override
        public boolean addAll(Collection<? extends Double> c) {
            XDoubleLinkedList adapter = new XDoubleLinkedList();
            for (Double d : c) {
                adapter.add(DoubleCollectionAdapters.adaptDouble(d));
            }
            return this.adaptee.addAll(adapter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            XDoubleLinkedList adapter = new XDoubleLinkedList();
            for (Object o : c) {
                try {
                    adapter.add(DoubleCollectionAdapters.adaptDouble(o));
                }
                catch (NullPointerException nullPointerException) {}
            }
            return this.adaptee.retainAll(adapter);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            XDoubleLinkedList adapter = new XDoubleLinkedList();
            for (Object o : c) {
                adapter.add(DoubleCollectionAdapters.adaptDouble(o));
            }
            return this.adaptee.removeAll(adapter);
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }
    }

    private static class XPrimitiveToDoubleListAdapter
    extends XPrimitiveToDoubleCollectionAdapter<XDoubleList>
    implements List<Double> {
        XPrimitiveToDoubleListAdapter(XDoubleList set) {
            super(set);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c) {
            XDoubleLinkedList adapter = new XDoubleLinkedList();
            for (Double d : c) {
                adapter.add(DoubleCollectionAdapters.adaptDouble(d));
            }
            return ((XDoubleList)this.adaptee).addAll(index, adapter);
        }

        @Override
        public Double get(int index) {
            return ((XDoubleList)this.adaptee).get(index);
        }

        @Override
        public Double set(int index, Double element) {
            return ((XDoubleList)this.adaptee).set(index, DoubleCollectionAdapters.adaptDouble(element));
        }

        @Override
        public void add(int index, Double element) {
            ((XDoubleList)this.adaptee).add(index, DoubleCollectionAdapters.adaptDouble(element));
        }

        @Override
        public Double remove(int index) {
            return ((XDoubleList)this.adaptee).remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return ((XDoubleList)this.adaptee).indexOf(DoubleCollectionAdapters.adaptDouble(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((XDoubleList)this.adaptee).lastIndexOf(DoubleCollectionAdapters.adaptDouble(o));
        }

        @Override
        public ListIterator<Double> listIterator() {
            return new XPrimitiveToDoubleListIteratorAdapater(((XDoubleList)this.adaptee).listIterator());
        }

        @Override
        public ListIterator<Double> listIterator(int index) {
            return new XPrimitiveToDoubleListIteratorAdapater(((XDoubleList)this.adaptee).listIterator(index));
        }

        @Override
        public List<Double> subList(int fromIndex, int toIndex) {
            return new XPrimitiveToDoubleListAdapter(((XDoubleList)this.adaptee).subList(fromIndex, toIndex));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            ListIterator<Double> e1 = this.listIterator();
            ListIterator e2 = ((List)o).listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Double o1 = e1.next();
                Object o2 = e2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Double obj : this) {
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return hashCode;
        }
    }

    private static class XPrimitiveToDoubleSetAdapter
    extends XPrimitiveToDoubleCollectionAdapter<XDoubleSet>
    implements Set<Double> {
        XPrimitiveToDoubleSetAdapter(XDoubleSet set) {
            super(set);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Double obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            if (this.size() > c.size()) {
                Iterator<?> i = c.iterator();
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            } else {
                Iterator<Double> i = this.iterator();
                while (i.hasNext()) {
                    if (!c.contains(i.next())) continue;
                    i.remove();
                    modified = true;
                }
            }
            return modified;
        }
    }

    private static class XPrimitiveToDoubleMapAdapter<V>
    extends AbstractMap<Double, V>
    implements Map<Double, V> {
        private final XDoubleMap<V> map;

        public XPrimitiveToDoubleMapAdapter(XDoubleMap<V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(DoubleCollectionAdapters.adaptDouble(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.map.get(DoubleCollectionAdapters.adaptDouble(key));
        }

        @Override
        public V put(Double key, V value) {
            return this.map.put(DoubleCollectionAdapters.adaptDouble(key), value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(DoubleCollectionAdapters.adaptDouble(key));
        }

        @Override
        public void putAll(Map<? extends Double, ? extends V> m) {
            XDoubleLinkedHashMap<V> adapter = new XDoubleLinkedHashMap<V>(m != null ? m.size() : 16);
            for (Map.Entry<Double, V> entry : m.entrySet()) {
                adapter.put(DoubleCollectionAdapters.adaptDouble(entry.getKey()), entry.getValue());
            }
            this.map.putAll(adapter);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<Double> keySet() {
            return new XPrimitiveToDoubleSetAdapter(this.map.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<Double, V>> entrySet() {
            return new XPrimtiveToDoubleEntrySetAdapter<V>(this.map.entrySet());
        }
    }
}

