/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XBooleanCollection;
import com.neeve.lang.XBooleanIterator;
import com.neeve.lang.XBooleanIteratorImpl;
import com.neeve.lang.XBooleanList;
import com.neeve.lang.XBooleanListIterator;
import com.neeve.lang.XBooleanSet;
import com.neeve.lang.XCollection;
import java.util.List;

public abstract class XBooleanCollectionBase
implements XBooleanCollection {
    private XBooleanIteratorImpl reusableIterator;

    protected XBooleanCollectionBase() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract XCollection.Record head();

    @Override
    public abstract XCollection.Record tail();

    @Override
    public abstract boolean valueOf(XCollection.Record var1);

    @Override
    public abstract void delete(XCollection.Record var1);

    @Override
    public XBooleanCollection unmodifiable() {
        return new Unmodifiable();
    }

    @Override
    public XBooleanCollection shared() {
        return new Shared();
    }

    @Override
    public XBooleanIterator iterator() {
        return XBooleanIteratorImpl.valueOf(this);
    }

    @Override
    public XBooleanIterator reusableIterator() {
        if (this.reusableIterator == null) {
            this.reusableIterator = XBooleanIteratorImpl.valueOf(this);
        } else {
            this.reusableIterator.toFirst();
        }
        return this.reusableIterator;
    }

    @Override
    public boolean supportsIteratorModifications() {
        return true;
    }

    @Override
    public boolean add(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(boolean value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        XCollection.Record head = this.head();
        for (XCollection.Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(boolean value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(XBooleanCollection c) {
        boolean modified = false;
        XBooleanIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(XBooleanCollection c) {
        XBooleanIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(XBooleanCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(XBooleanCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean[] toArray() {
        return this.toArray(new boolean[this.size()]);
    }

    @Override
    public boolean[] toArray(boolean[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new boolean[size];
        }
        if (array.length > size) {
            array[size] = false;
        }
        int i = 0;
        boolean[] arrayView = array;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    public String toString() {
        XBooleanIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            boolean e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof XBooleanList) {
            return obj instanceof XBooleanList ? this.equalsOrder((XBooleanList)obj) : false;
        }
        if (obj instanceof XBooleanList) {
            return false;
        }
        if (!(obj instanceof XBooleanCollection)) {
            return false;
        }
        XBooleanCollection that = (XBooleanCollection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(XBooleanList that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        XBooleanIterator thatIterator = that.iterator();
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            boolean o2;
            boolean o1 = this.valueOf(r);
            if (o1 == (o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        int hash = 0;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += this.hashCodeFor(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        int h = 1;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + this.hashCodeFor(this.valueOf(r));
        }
        return h;
    }

    private int hashCodeFor(boolean value) {
        return value ? 1231 : 1237;
    }

    private class Shared
    implements XBooleanCollection {
        private Shared() {
        }

        @Override
        public synchronized int size() {
            return XBooleanCollectionBase.this.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return XBooleanCollectionBase.this.isEmpty();
        }

        @Override
        public synchronized boolean contains(boolean o) {
            return XBooleanCollectionBase.this.contains(o);
        }

        @Override
        public synchronized boolean[] toArray() {
            return XBooleanCollectionBase.this.toArray();
        }

        @Override
        public synchronized boolean[] toArray(boolean[] a) {
            return XBooleanCollectionBase.this.toArray(a);
        }

        @Override
        public synchronized XBooleanIterator iterator() {
            return new CollectionArrayIterator(XBooleanCollectionBase.this.toArray());
        }

        @Override
        public XBooleanIterator reusableIterator() {
            throw new UnsupportedOperationException("Reusable iterator not supported for this shared collection");
        }

        @Override
        public synchronized boolean supportsIteratorModifications() {
            return XBooleanCollectionBase.this.supportsIteratorModifications();
        }

        @Override
        public synchronized boolean add(boolean e) {
            return XBooleanCollectionBase.this.add(e);
        }

        @Override
        public synchronized boolean remove(boolean o) {
            return XBooleanCollectionBase.this.remove(o);
        }

        @Override
        public synchronized boolean containsAll(XBooleanCollection c) {
            return XBooleanCollectionBase.this.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(XBooleanCollection c) {
            return XBooleanCollectionBase.this.addAll(c);
        }

        @Override
        public synchronized boolean removeAll(XBooleanCollection c) {
            return XBooleanCollectionBase.this.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(XBooleanCollection c) {
            return XBooleanCollectionBase.this.retainAll(c);
        }

        @Override
        public synchronized void clear() {
            XBooleanCollectionBase.this.clear();
        }

        public synchronized String toString() {
            return XBooleanCollectionBase.this.toString();
        }

        @Override
        public synchronized XCollection.Record head() {
            return XBooleanCollectionBase.this.head();
        }

        @Override
        public synchronized XCollection.Record tail() {
            return XBooleanCollectionBase.this.tail();
        }

        @Override
        public boolean valueOf(XCollection.Record record) {
            return XBooleanCollectionBase.this.valueOf(record);
        }

        @Override
        public synchronized void delete(XCollection.Record record) {
            XBooleanCollectionBase.this.delete(record);
        }

        @Override
        public XBooleanCollection unmodifiable() {
            return XBooleanCollectionBase.this.unmodifiable();
        }

        @Override
        public XBooleanCollection shared() {
            return this;
        }

        private class CollectionArrayIterator
        implements XBooleanIterator {
            private boolean[] _elements;
            private int _index;
            private boolean _next;
            private boolean removed;

            public CollectionArrayIterator(boolean[] elements) {
                this._elements = elements;
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public boolean next() {
                this.removed = false;
                this._next = this._elements[this._index++];
                return this._next;
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("No element to remove");
                }
                Shared.this.remove(this._next);
                this.removed = true;
            }

            @Override
            public CollectionArrayIterator toFirst() {
                this._index = 0;
                this._next = false;
                this._elements = Shared.this.toArray();
                this.removed = true;
                return this;
            }
        }
    }

    class Unmodifiable
    extends XBooleanCollectionBase
    implements XBooleanSet,
    XBooleanList {
        Unmodifiable() {
        }

        @Override
        public int size() {
            return XBooleanCollectionBase.this.size();
        }

        @Override
        public XCollection.Record head() {
            return XBooleanCollectionBase.this.head();
        }

        @Override
        public XCollection.Record tail() {
            return XBooleanCollectionBase.this.tail();
        }

        @Override
        public boolean valueOf(XCollection.Record record) {
            return XBooleanCollectionBase.this.valueOf(record);
        }

        @Override
        public boolean contains(boolean value) {
            return XBooleanCollectionBase.this.contains(value);
        }

        @Override
        public boolean containsAll(XBooleanCollection c) {
            return XBooleanCollectionBase.this.containsAll(c);
        }

        @Override
        public boolean add(boolean obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(XCollection.Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean addAll(int index, XBooleanCollection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean get(int index) {
            return ((XBooleanList)((Object)XBooleanCollectionBase.this)).get(index);
        }

        @Override
        public boolean set(int index, boolean element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void add(int index, boolean element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean remove(boolean index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(boolean o) {
            return ((XBooleanList)((Object)XBooleanCollectionBase.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(boolean o) {
            return ((XBooleanList)((Object)XBooleanCollectionBase.this)).lastIndexOf(o);
        }

        @Override
        public XBooleanListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XBooleanListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XBooleanList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }
}

