/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.build.codegen;

import com.neeve.build.codegen.CgCodeSource;
import com.neeve.build.codegen.CgMappable;
import com.neeve.ci.XRuntime;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class CgSourceCodeErrorAggregator
implements CgMappable {
    private final int maxErrors = Integer.parseInt(XRuntime.getProps().getProperty("nvx.adm.codegen.max_errors", "50"));
    private Map<URL, Set<Message>> errorMessages = new LinkedHashMap<URL, Set<Message>>();
    private Set<Message> nonURLErrorMessages = new LinkedHashSet<Message>();
    private int numErrors = 0;
    private int numWarnings = 0;
    private int numMessages = 0;
    private URL defaultURL = null;

    public CgSourceCodeErrorAggregator() {
    }

    public CgSourceCodeErrorAggregator(URL defaultURL) {
        if (defaultURL == null) {
            throw new IllegalArgumentException("'defaultURL' cannot be null.");
        }
        this.defaultURL = defaultURL;
    }

    public void add(String message, Severity severity, CgCodeSource srcInfo, Throwable cause) {
        if (srcInfo == null && this.defaultURL == null) {
            throw new IllegalArgumentException("'srcInfo' cannot be null for this instance because 'defaultURL' is not defined.");
        }
        URL url = this.defaultURL;
        CgCodeSource finalSrcInfo = srcInfo;
        if (finalSrcInfo != null) {
            url = finalSrcInfo.getUrl();
        } else {
            finalSrcInfo = new CgCodeSource(url, 1, 1);
        }
        if (severity == Severity.ERROR && this.numErrors >= this.maxErrors) {
            return;
        }
        this.getOrCreateForUrl(url).add(new Message(message, severity, finalSrcInfo, cause));
        switch (severity) {
            case ERROR: {
                ++this.numErrors;
                break;
            }
            case INFO: {
                ++this.numMessages;
                break;
            }
            case WARNING: {
                ++this.numWarnings;
            }
        }
    }

    public final Collection<Message> getErrors() {
        ArrayList<Message> retVal = new ArrayList<Message>();
        for (Set<Message> urlMessages : this.errorMessages.values()) {
            retVal.addAll(urlMessages);
        }
        retVal.addAll(this.nonURLErrorMessages);
        return retVal;
    }

    public final Map<URL, Set<Message>> getErrorMessages() {
        return this.errorMessages;
    }

    public final int getNumWarnings() {
        return this.numWarnings;
    }

    public final int getNumMessages() {
        return this.numMessages;
    }

    public int getNumErrors() {
        return this.numErrors;
    }

    private Set<Message> getOrCreateForUrl(URL url) {
        Set<Message> retVal = null;
        if (url == null) {
            retVal = this.nonURLErrorMessages;
        } else {
            retVal = this.errorMessages.get(url);
            if (retVal == null) {
                retVal = new LinkedHashSet<Message>();
                this.errorMessages.put(url, retVal);
            }
        }
        return retVal;
    }

    @Override
    public Map<String, Object> toMap() {
        TreeMap<String, Object> retVal = new TreeMap<String, Object>();
        TreeMap<String, ArrayList> errorMessagesAsMaps = new TreeMap<String, ArrayList>();
        for (Map.Entry<URL, Set<Message>> entry : this.errorMessages.entrySet()) {
            ArrayList messagesForURL = new ArrayList();
            for (Message message : entry.getValue()) {
                messagesForURL.add(message.toMap());
            }
            errorMessagesAsMaps.put(entry.getKey().toString(), messagesForURL);
        }
        retVal.put("errorMessages", errorMessagesAsMaps);
        ArrayList<Map<String, Object>> allErrorMessagesAsMaps = new ArrayList<Map<String, Object>>();
        for (ArrayList messagesForURL : errorMessagesAsMaps.values()) {
            allErrorMessagesAsMaps.addAll(messagesForURL);
        }
        for (Message nonURLMessage : this.nonURLErrorMessages) {
            allErrorMessagesAsMaps.add(nonURLMessage.toMap());
        }
        retVal.put("allErrorMessages", allErrorMessagesAsMaps);
        retVal.put("numErrors", this.numErrors);
        retVal.put("numWarnings", this.numWarnings);
        retVal.put("numMessages", this.numMessages);
        return retVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (URL source : this.errorMessages.keySet()) {
            sb.append(source).append(":\n");
            int i = 1;
            for (Message message : this.errorMessages.get(source)) {
                sb.append(" (").append(i++).append(") [").append((Object)message.getSeverity()).append(", (line: ").append(message.getSrcInfo().getLine()).append(", col: ").append(message.getSrcInfo().getColumnStart()).append(")]: ").append(message.getMessage()).append("\n");
            }
        }
        int i = 1;
        for (Message message : this.nonURLErrorMessages) {
            sb.append("unknown source:");
            sb.append(" (").append(i++).append(") [").append((Object)message.getSeverity()).append(", (line: ").append(message.getSrcInfo().getLine()).append(", col: ").append(message.getSrcInfo().getColumnStart()).append(")]: ").append(message.getMessage()).append("\n");
            sb.append(":\n");
        }
        return sb.toString();
    }

    public static class Message
    implements CgMappable {
        private String message;
        private Severity severity;
        private CgCodeSource srcInfo;
        private Throwable cause;

        public Message(String message, Severity severity, CgCodeSource srcInfo, Throwable cause) {
            if (message == null || message.isEmpty()) {
                throw new IllegalArgumentException("'message' cannot be null or empty string.");
            }
            if (severity == null) {
                throw new IllegalArgumentException("'severity' cannot be null.");
            }
            this.message = message;
            this.severity = severity;
            this.srcInfo = srcInfo;
            this.cause = cause;
        }

        public String getMessage() {
            return this.message;
        }

        public CgCodeSource getSrcInfo() {
            return this.srcInfo;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public final Throwable getCause() {
            return this.cause;
        }

        @Override
        public Map<String, Object> toMap() {
            TreeMap<String, Object> retVal = new TreeMap<String, Object>();
            retVal.put("message", this.message);
            retVal.put("severity", this.severity.toString());
            if (this.srcInfo != null) {
                retVal.put("srcInfo", this.srcInfo.toMap());
            }
            return retVal;
        }

        public String toString() {
            String retVal = "[" + (Object)((Object)this.severity) + "]";
            if (this.srcInfo != null) {
                retVal = retVal + " " + this.srcInfo;
            }
            retVal = retVal + ": " + this.message;
            return retVal;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

