/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.discovery.test.unit;

import com.neeve.discovery.DiscoveryCacheEvents;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryCacheEventHandler;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.discovery.impl.DiscoveryCacheBase;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlAddressDescriptor;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class DiscoveryCacheTest
extends UnitTest {
    private static IDiscoveryCache localCache;
    private static List<UtlAddressDescriptor> descriptors;
    private static List<UtlAddressDescriptor> m1n1descriptors;
    private static List<UtlAddressDescriptor> m1n2descriptors;
    private static List<UtlAddressDescriptor> m2n1descriptors;
    private static List<UtlAddressDescriptor> m2n2descriptors;
    private static List<UtlAddressDescriptor> m3n1descriptors;
    private static List<UtlAddressDescriptor> m3n2descriptors;
    private final int MAX_ESA_PROPAGATION_DELAY = 100;

    private final void validateEntity(IDiscoveryEntity entity, IDiscoveryCache cache, String owner, String type, String name, int maxAge, boolean wasDiscovered, List<UtlAddressDescriptor> descriptors) throws Exception {
        Assert.assertSame((Object)cache, (Object)entity.getCache());
        Assert.assertEquals((Object)owner, (Object)entity.getOwner());
        Assert.assertEquals((Object)type, (Object)entity.getType());
        Assert.assertEquals((Object)name, (Object)entity.getName());
        Assert.assertEquals((long)((short)maxAge), (long)entity.getMaxAge());
        Assert.assertEquals((Object)wasDiscovered, (Object)entity.wasDiscovered());
        Assert.assertTrue((descriptors != null == (entity.getAddressDescriptors() != null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)descriptors.equals(entity.getAddressDescriptors()));
    }

    @BeforeClass
    public static void initialize() throws Exception {
        localCache = DiscoveryCacheFactory.getInstance().createCache("local://.&initWaitTime=0");
        Assert.assertNotNull((Object)localCache);
        descriptors = new LinkedList<UtlAddressDescriptor>();
        descriptors.add(UtlAddressDescriptor.parse((String)"tcp://localhost:4081", null));
        m1n1descriptors = new LinkedList<UtlAddressDescriptor>();
        m1n1descriptors.add(UtlAddressDescriptor.parse((String)"tcp://localhost:4090", null));
        m1n2descriptors = new LinkedList<UtlAddressDescriptor>();
        m1n2descriptors.add(UtlAddressDescriptor.parse((String)"tcp://localhost:4092", null));
        m2n1descriptors = new LinkedList<UtlAddressDescriptor>();
        m2n1descriptors.add(UtlAddressDescriptor.parse((String)"tcp://localhost:4094", null));
        m2n2descriptors = new LinkedList<UtlAddressDescriptor>();
        m2n2descriptors.add(UtlAddressDescriptor.parse((String)"tcp://localhost:4096", null));
        m3n1descriptors = new LinkedList<UtlAddressDescriptor>();
        m3n1descriptors.add(UtlAddressDescriptor.parse((String)"tcp://localhost:4098", null));
        m3n2descriptors = new LinkedList<UtlAddressDescriptor>();
        m3n2descriptors.add(UtlAddressDescriptor.parse((String)"tcp://localhost:4100", null));
    }

    @Test
    public void testAddEventHandlerWithNullHandler() throws Exception {
        try {
            localCache.addEventHandler(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveEventHandlerWithNullHandler() throws Exception {
        try {
            localCache.removeEventHandler(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithNullType() throws Exception {
        try {
            localCache.add(null, "name", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithWildcardType() throws Exception {
        try {
            localCache.add("*type", "name", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.add("type*", "name", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.add("ty*pe", "name", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.add("*/*", "name", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.add("...", "name", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithNullName() throws Exception {
        try {
            localCache.add("type", null, descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithWildcardName() throws Exception {
        try {
            localCache.add("type", "*name", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.add("type", "name*", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.add("type", "na*me", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.add("type", "*/*", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.add("type", "...", descriptors);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithNullDescriptorSet() throws Exception {
        try {
            localCache.add("type", "name", null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithEmptyDescriptorSet() throws Exception {
        try {
            localCache.add("type", "name", new LinkedList<UtlAddressDescriptor>());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddShouldActuallyAdd() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0&maxEntityAge=20&memberName=m1");){
            m1.cache.add("type", "name", descriptors);
            IDiscoveryEntity entity = m1.cache.get("type", "name");
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((long)1L, (long)m1.cache.size());
            this.validateEntity(entity, m1.cache, "m1", "type", "name", 24, false, descriptors);
        }
    }

    @Test
    public void testAddAgainShouldReplace() throws Exception {
        try {
            localCache.add("type", "name", descriptors);
            IDiscoveryEntity entity1 = localCache.get("type", "name");
            localCache.add("type", "name", descriptors);
            IDiscoveryEntity entity2 = localCache.get("type", "name");
            Assert.assertNotSame((Object)entity1, (Object)entity2);
            Assert.assertEquals((long)1L, (long)localCache.size());
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testAddAgainWithDifferentTypeShouldAddNewObject() throws Exception {
        try {
            localCache.add("type1", "name", descriptors);
            IDiscoveryEntity entity1 = localCache.get("type1", "name");
            localCache.add("type2", "name", descriptors);
            IDiscoveryEntity entity2 = localCache.get("type2", "name");
            Assert.assertNotSame((Object)entity1, (Object)entity2);
            Assert.assertEquals((Object)entity1, (Object)localCache.get("type1", "name"));
            Assert.assertEquals((Object)entity2, (Object)localCache.get("type2", "name"));
            Assert.assertEquals((long)2L, (long)localCache.size());
        }
        finally {
            localCache.remove("type1", "name");
            Assert.assertEquals((long)1L, (long)localCache.size());
            localCache.remove("type2", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testAddAgainWithDifferentNameShouldAddNewObject() throws Exception {
        try {
            localCache.add("type", "name1", descriptors);
            IDiscoveryEntity entity1 = localCache.get("type", "name1");
            localCache.add("type", "name2", descriptors);
            IDiscoveryEntity entity2 = localCache.get("type", "name2");
            Assert.assertNotSame((Object)entity1, (Object)entity2);
            Assert.assertEquals((Object)entity1, (Object)localCache.get("type", "name1"));
            Assert.assertEquals((Object)entity2, (Object)localCache.get("type", "name2"));
            Assert.assertEquals((long)2L, (long)localCache.size());
        }
        finally {
            localCache.remove("type", "name1");
            Assert.assertEquals((long)1L, (long)localCache.size());
            localCache.remove("type", "name2");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testAddOnClosedCache() throws Exception {
        IDiscoveryCache cache = DiscoveryCacheFactory.getInstance().createCache("local://.&initWaitTime=0");
        Assert.assertNotNull((Object)cache);
        cache.close();
        try {
            cache.add("type", "name", descriptors);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWithNullType() throws Exception {
        try {
            localCache.get(null, "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWithWildcardType() throws Exception {
        try {
            localCache.get("*type", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.get("type*", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.get("ty*pe", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.get("*/*", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.get("...", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWithNullName() throws Exception {
        try {
            localCache.get("type", null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWithWildcardName() throws Exception {
        try {
            localCache.get("type", "*name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.get("type", "name*");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.get("type", "na*me");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.get("type", "*/*");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.get("type", "...");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetOnEmptyCache() throws Exception {
        Assert.assertNull((Object)localCache.get("type", "name"));
    }

    @Test
    public void testGetShouldActuallyGet() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            Assert.assertNotNull((Object)localCache.get("type", "name"));
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testGetAgainShouldReturnSameObject() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            IDiscoveryEntity entity = localCache.get("type", "name");
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)entity, (Object)localCache.get("type", "name"));
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testGetWithWrongTypeShouldNotReturnObject() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            Assert.assertNotNull((Object)localCache.get("type", "name"));
            Assert.assertNull((Object)localCache.get("type1", "name"));
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testGetWithWrongNameShouldNotReturnObject() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            Assert.assertNotNull((Object)localCache.get("type", "name"));
            Assert.assertNull((Object)localCache.get("type", "name1"));
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testGetOnClosedCache() throws Exception {
        IDiscoveryCache cache = DiscoveryCacheFactory.getInstance().createCache("local://.&initWaitTime=0");
        Assert.assertNotNull((Object)cache);
        cache.close();
        try {
            cache.get("type", "name");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveWithNullType() throws Exception {
        try {
            localCache.remove(null, "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveWithWildcardType() throws Exception {
        try {
            localCache.remove("*type", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.remove("type*", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.remove("ty*pe", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.remove("*/*", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.remove("...", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveWithNullName() throws Exception {
        try {
            localCache.remove("type", null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveWithWildcardName() throws Exception {
        try {
            localCache.remove("type", "*name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.remove("type", "name*");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.remove("type", "na*me");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.remove("type", "*/*");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            localCache.remove("type", "...");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveShouldActuallyRemove() throws Exception {
        localCache.add("type", "name", descriptors);
        localCache.remove("type", "name");
        Assert.assertEquals((long)0L, (long)localCache.size());
    }

    @Test
    public void testRemoveShouldReturnRemovedObject() throws Exception {
        localCache.add("type", "name", descriptors);
        IDiscoveryEntity entity = localCache.get("type", "name");
        Assert.assertSame((Object)entity, (Object)localCache.remove("type", "name"));
        Assert.assertEquals((long)0L, (long)localCache.size());
    }

    @Test
    public void testRemoveAgainShouldReturnNull() throws Exception {
        localCache.add("type", "name", descriptors);
        IDiscoveryEntity entity = localCache.get("type", "name");
        Assert.assertSame((Object)entity, (Object)localCache.remove("type", "name"));
        Assert.assertEquals((long)0L, (long)localCache.size());
        Assert.assertNull((Object)localCache.remove("type", "name"));
    }

    @Test
    public void testRemoveOnClosedCache() throws Exception {
        IDiscoveryCache cache = DiscoveryCacheFactory.getInstance().createCache("local://.&initWaitTime=0");
        Assert.assertNotNull((Object)cache);
        cache.close();
        try {
            cache.remove("type", "name");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchesWithNullType() throws Exception {
        try {
            localCache.matches(null, "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchesWithLevelWildcardType() throws Exception {
        try {
            localCache.matches("...", "name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchesWithNullNamePattern() throws Exception {
        try {
            localCache.matches("type", null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchesWithInvalidWildcardName() throws Exception {
        try {
            localCache.matches("type", ".../name");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchesWithValidWildcardName() throws Exception {
        localCache.matches("type", "name/*/...");
    }

    @Test
    public void testMatchesWithNullTypePattern() throws Exception {
        try {
            localCache.matches(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchesWithValidWildcardTypePattern() throws Exception {
        localCache.matches("type/a*/...");
    }

    @Test
    public void testMatchesWithInvalidWildcardTypePattern() throws Exception {
        try {
            localCache.matches("type/.../a*");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMatches() throws Exception {
        localCache.add("category1/type1", "l1name/l2name", descriptors);
        IDiscoveryEntity entity1 = localCache.get("category1/type1", "l1name/l2name");
        localCache.add("category1/type2", "l1name/l2name", descriptors);
        IDiscoveryEntity entity2 = localCache.get("category1/type2", "l1name/l2name");
        localCache.add("category2/type1", "l1name/l2name", descriptors);
        IDiscoveryEntity entity3 = localCache.get("category2/type1", "l1name/l2name");
        localCache.add("category2/type2", "l1name/l2name", descriptors);
        IDiscoveryEntity entity4 = localCache.get("category2/type2", "l1name/l2name");
        try {
            Set<IDiscoveryEntity> matches = localCache.matches("category1/type1", "l1name/l2name");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity1, (Object)matches.iterator().next());
            matches = localCache.matches("category1/type2", "l1name/l2name");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity2, (Object)matches.iterator().next());
            matches = localCache.matches("category2/type1", "l1name/l2name");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity3, (Object)matches.iterator().next());
            matches = localCache.matches("category2/type2", "l1name/l2name");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity4, (Object)matches.iterator().next());
            matches = localCache.matches("category1/type1", "l1name/*");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity1, (Object)matches.iterator().next());
            matches = localCache.matches("c*1/t*1", "l1name/l2name");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity1, (Object)matches.iterator().next());
            matches = localCache.matches("c*1/t*1", "l1name/*");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity1, (Object)matches.iterator().next());
            matches = localCache.matches("category1/type2", "l1name/*");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity2, (Object)matches.iterator().next());
            matches = localCache.matches("c*1/t*2", "l1name/l2name");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity2, (Object)matches.iterator().next());
            matches = localCache.matches("c*1/t*2", "l1name/*");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity2, (Object)matches.iterator().next());
            matches = localCache.matches("category2/type1", "l1name/*");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity3, (Object)matches.iterator().next());
            matches = localCache.matches("c*2/t*1", "l1name/l2name");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity3, (Object)matches.iterator().next());
            matches = localCache.matches("c*2/t*1", "l1name/*");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity3, (Object)matches.iterator().next());
            matches = localCache.matches("category2/type2", "l1name/*");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity4, (Object)matches.iterator().next());
            matches = localCache.matches("c*2/t*2", "l1name/l2name");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity4, (Object)matches.iterator().next());
            matches = localCache.matches("c*2/t*2", "l1name/*");
            Assert.assertEquals((long)1L, (long)matches.size());
            Assert.assertSame((Object)entity4, (Object)matches.iterator().next());
            matches = localCache.matches("*1/*", "l1name/l2name");
            Assert.assertEquals((long)2L, (long)matches.size());
            Assert.assertTrue((boolean)matches.contains(entity1));
            Assert.assertTrue((boolean)matches.contains(entity2));
            matches = localCache.matches("*2/*", "l1name/l2name");
            Assert.assertEquals((long)2L, (long)matches.size());
            Assert.assertTrue((boolean)matches.contains(entity3));
            Assert.assertTrue((boolean)matches.contains(entity4));
            matches = localCache.matches("*/*1", "l1name/l2name");
            Assert.assertEquals((long)2L, (long)matches.size());
            Assert.assertTrue((boolean)matches.contains(entity1));
            Assert.assertTrue((boolean)matches.contains(entity3));
            matches = localCache.matches("*/*2", "l1name/l2name");
            Assert.assertEquals((long)2L, (long)matches.size());
            Assert.assertTrue((boolean)matches.contains(entity2));
            Assert.assertTrue((boolean)matches.contains(entity4));
            matches = localCache.matches("*1/*");
            Assert.assertEquals((long)2L, (long)matches.size());
            Assert.assertTrue((boolean)matches.contains(entity1));
            Assert.assertTrue((boolean)matches.contains(entity2));
            matches = localCache.matches("*2/*");
            Assert.assertEquals((long)2L, (long)matches.size());
            Assert.assertTrue((boolean)matches.contains(entity3));
            Assert.assertTrue((boolean)matches.contains(entity4));
            matches = localCache.matches("*/*1");
            Assert.assertEquals((long)2L, (long)matches.size());
            Assert.assertTrue((boolean)matches.contains(entity1));
            Assert.assertTrue((boolean)matches.contains(entity3));
            matches = localCache.matches("*/*2");
            Assert.assertEquals((long)2L, (long)matches.size());
            Assert.assertTrue((boolean)matches.contains(entity2));
            Assert.assertTrue((boolean)matches.contains(entity4));
            matches = localCache.matches("...");
            Assert.assertEquals((long)4L, (long)matches.size());
            Assert.assertTrue((boolean)matches.contains(entity1));
            Assert.assertTrue((boolean)matches.contains(entity2));
            Assert.assertTrue((boolean)matches.contains(entity3));
            Assert.assertTrue((boolean)matches.contains(entity4));
            Assert.assertTrue((localCache.matches("category3/type3", "l1name/l2name").size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((localCache.matches("category1/type1", "l1noname/l2noname").size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((localCache.matches("*3/*", "l1name/l2name").size() == 0 ? 1 : 0) != 0);
            localCache.remove("category1/type1", "l1name/l2name");
        }
        catch (Throwable throwable) {
            localCache.remove("category1/type1", "l1name/l2name");
            localCache.remove("category1/type2", "l1name/l2name");
            localCache.remove("category2/type1", "l1name/l2name");
            localCache.remove("category2/type2", "l1name/l2name");
            Assert.assertTrue((localCache.matches("...").size() == 0 ? 1 : 0) != 0);
            throw throwable;
        }
        localCache.remove("category1/type2", "l1name/l2name");
        localCache.remove("category2/type1", "l1name/l2name");
        localCache.remove("category2/type2", "l1name/l2name");
        Assert.assertTrue((localCache.matches("...").size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMatchesOnClosedCache() throws Exception {
        IDiscoveryCache cache = DiscoveryCacheFactory.getInstance().createCache("local://.&initWaitTime=0");
        Assert.assertNotNull((Object)cache);
        cache.close();
        try {
            cache.matches("type", "name");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cache.matches("type");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSizeOnEmptyCache() throws Exception {
        Assert.assertEquals((long)0L, (long)localCache.size());
    }

    @Test
    public void testAddShouldIncrementSize() throws Exception {
        try {
            Assert.assertEquals((long)0L, (long)localCache.size());
            localCache.add("type", "name", descriptors);
            Assert.assertEquals((long)1L, (long)localCache.size());
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testAddAgainShouldNotIncrementSize() throws Exception {
        try {
            Assert.assertEquals((long)0L, (long)localCache.size());
            localCache.add("type", "name", descriptors);
            Assert.assertEquals((long)1L, (long)localCache.size());
            localCache.add("type", "name", descriptors);
            Assert.assertEquals((long)1L, (long)localCache.size());
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testAddRemoveAddShouldRestoreSize() throws Exception {
        try {
            Assert.assertEquals((long)0L, (long)localCache.size());
            localCache.add("type", "name", descriptors);
            Assert.assertEquals((long)1L, (long)localCache.size());
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
            localCache.add("type", "name", descriptors);
            Assert.assertEquals((long)1L, (long)localCache.size());
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testSizeOnClosedCache() throws Exception {
        IDiscoveryCache cache = DiscoveryCacheFactory.getInstance().createCache("local://.&initWaitTime=0");
        Assert.assertNotNull((Object)cache);
        cache.close();
        try {
            cache.size();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventOnAdd() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0");){
            m1.cache.add("type", "name", descriptors);
            IDiscoveryEntity entity = m1.cache.get("type", "name");
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertEquals((Object)entity, (Object)eventData.newEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventOnRemove() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0");){
            m1.cache.add("type", "name", descriptors);
            IDiscoveryEntity entity = m1.cache.get("type", "name");
            m1.cache.remove("type", "name");
            Assert.assertEquals((long)2L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)1)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)1)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            DiscoveryCacheEvents.DiscoveryCacheRemoveEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)1)).data;
            Assert.assertEquals((Object)entity, (Object)eventData.removedEntity);
        }
    }

    @Test
    public void testNoEventOnMissedRemove1() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0");){
            m1.cache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)m1.eventHandler.events.size());
        }
    }

    @Test
    public void testNoEventOnMissedRemove2() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0");){
            m1.cache.add("type", "name", descriptors);
            m1.cache.remove("type", "name");
            m1.eventHandler.reset();
            m1.cache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)m1.eventHandler.events.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventOnReplace() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0");){
            m1.cache.add("type", "name", descriptors);
            IDiscoveryEntity entity1 = m1.cache.get("type", "name");
            m1.cache.add("type", "name", descriptors);
            IDiscoveryEntity entity2 = m1.cache.get("type", "name");
            Assert.assertEquals((long)2L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)1)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)1)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)1)).data;
            Assert.assertEquals((Object)entity1, (Object)eventData.oldEntity);
            Assert.assertEquals((Object)entity2, (Object)eventData.newEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventOnAddRemoveAdd() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0");){
            m1.cache.add("type", "name", descriptors);
            m1.cache.remove("type", "name");
            m1.cache.add("type", "name", descriptors);
            IDiscoveryEntity entity2 = m1.cache.get("type", "name");
            Assert.assertEquals((long)3L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)2)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)2)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)2)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertEquals((Object)entity2, (Object)eventData.newEntity);
        }
    }

    @Test
    public void testAddEventHandlerFromAddEventHandlerShouldFail() throws Exception {
        ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.AddEventHandler);
        localCache.addEventHandler(eventHandler);
        try {
            localCache.add("type", "name", descriptors);
            try {
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.remove("type", "name");
                Assert.assertEquals((long)0L, (long)localCache.size());
            }
        }
        finally {
            localCache.removeEventHandler(eventHandler);
        }
    }

    @Test
    public void testAddEventHandlerFromRemoveEventHandlerShouldFail() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.AddEventHandler);
            localCache.addEventHandler(eventHandler);
            try {
                localCache.remove("type", "name");
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.removeEventHandler(eventHandler);
            }
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testRemoveEventHandlerFromAddEventHandlerShouldFail() throws Exception {
        ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.RemoveEventHandler);
        localCache.addEventHandler(eventHandler);
        try {
            localCache.add("type", "name", descriptors);
            try {
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.remove("type", "name");
                Assert.assertEquals((long)0L, (long)localCache.size());
            }
        }
        finally {
            localCache.removeEventHandler(eventHandler);
        }
    }

    @Test
    public void testRemoveEventHandlerFromRemoveEventHandlerShouldFail() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.RemoveEventHandler);
            localCache.addEventHandler(eventHandler);
            try {
                localCache.remove("type", "name");
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.removeEventHandler(eventHandler);
            }
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testAddFromAddEventHandlerShouldFail() throws Exception {
        ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Add);
        localCache.addEventHandler(eventHandler);
        try {
            localCache.add("type", "name", descriptors);
            try {
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.remove("type", "name");
                Assert.assertEquals((long)0L, (long)localCache.size());
            }
        }
        finally {
            localCache.removeEventHandler(eventHandler);
        }
    }

    @Test
    public void testAddFromRemoveEventHandlerShouldFail() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Add);
            localCache.addEventHandler(eventHandler);
            try {
                localCache.remove("type", "name");
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.removeEventHandler(eventHandler);
            }
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testGetFromAddEventHandlerShouldFail() throws Exception {
        ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Get);
        localCache.addEventHandler(eventHandler);
        try {
            localCache.add("type", "name", descriptors);
            try {
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.remove("type", "name");
                Assert.assertEquals((long)0L, (long)localCache.size());
            }
        }
        finally {
            localCache.removeEventHandler(eventHandler);
        }
    }

    @Test
    public void testGetEventHandlerFromRemoveEventHandlerShouldFail() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Get);
            localCache.addEventHandler(eventHandler);
            try {
                localCache.remove("type", "name");
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.removeEventHandler(eventHandler);
            }
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testRemoveFromAddEventHandlerShouldFail() throws Exception {
        ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Remove);
        localCache.addEventHandler(eventHandler);
        try {
            localCache.add("type", "name", descriptors);
            try {
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.remove("type", "name");
                Assert.assertEquals((long)0L, (long)localCache.size());
            }
        }
        finally {
            localCache.removeEventHandler(eventHandler);
        }
    }

    @Test
    public void testRemoveFromRemoveEventHandlerShouldFail() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Remove);
            localCache.addEventHandler(eventHandler);
            try {
                localCache.remove("type", "name");
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.removeEventHandler(eventHandler);
            }
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testMatchesFromAddEventHandlerShouldFail1() throws Exception {
        ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Match1);
        localCache.addEventHandler(eventHandler);
        try {
            localCache.add("type", "name", descriptors);
            try {
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.remove("type", "name");
                Assert.assertEquals((long)0L, (long)localCache.size());
            }
        }
        finally {
            localCache.removeEventHandler(eventHandler);
        }
    }

    @Test
    public void testMatchesFromRemoveEventHandlerShouldFail1() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Match1);
            localCache.addEventHandler(eventHandler);
            try {
                localCache.remove("type", "name");
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.removeEventHandler(eventHandler);
            }
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testMatchesFromAddEventHandlerShouldFail2() throws Exception {
        ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Match2);
        localCache.addEventHandler(eventHandler);
        try {
            localCache.add("type", "name", descriptors);
            try {
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.remove("type", "name");
                Assert.assertEquals((long)0L, (long)localCache.size());
            }
        }
        finally {
            localCache.removeEventHandler(eventHandler);
        }
    }

    @Test
    public void testMatchesFromRemoveEventHandlerShouldFail2() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Match2);
            localCache.addEventHandler(eventHandler);
            try {
                localCache.remove("type", "name");
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.removeEventHandler(eventHandler);
            }
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testSizeFromAddEventHandlerShouldFail() throws Exception {
        ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Size);
        localCache.addEventHandler(eventHandler);
        try {
            localCache.add("type", "name", descriptors);
            try {
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.remove("type", "name");
                Assert.assertEquals((long)0L, (long)localCache.size());
            }
        }
        finally {
            localCache.removeEventHandler(eventHandler);
        }
    }

    @Test
    public void testSizeFromRemoveEventHandlerShouldFail() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Size);
            localCache.addEventHandler(eventHandler);
            try {
                localCache.remove("type", "name");
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.removeEventHandler(eventHandler);
            }
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testCloseFromAddEventHandlerShouldFail() throws Exception {
        ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Close);
        localCache.addEventHandler(eventHandler);
        try {
            localCache.add("type", "name", descriptors);
            try {
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.remove("type", "name");
                Assert.assertEquals((long)0L, (long)localCache.size());
            }
        }
        finally {
            localCache.removeEventHandler(eventHandler);
        }
    }

    @Test
    public void testCloseFromRemoveEventHandlerShouldFail() throws Exception {
        localCache.add("type", "name", descriptors);
        try {
            ActiveEventHandler eventHandler = new ActiveEventHandler(ActiveEventHandler.Operation.Close);
            localCache.addEventHandler(eventHandler);
            try {
                localCache.remove("type", "name");
                Assert.assertNotNull((Object)eventHandler.opStatus);
                Assert.assertTrue((boolean)(eventHandler.opStatus instanceof IllegalStateException));
            }
            finally {
                localCache.removeEventHandler(eventHandler);
            }
        }
        finally {
            localCache.remove("type", "name");
            Assert.assertEquals((long)0L, (long)localCache.size());
        }
    }

    @Test
    public void testSetLocalMemberName() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0&memberName=m1");){
            Assert.assertEquals((Object)"m1", (Object)m1.cache.getLocalMemberName());
        }
    }

    @Test
    public void testDefaultInitWaitTime() throws Exception {
        try (Member m1 = new Member("local://.");){
            Assert.assertEquals((long)5L, (long)m1.cache.getInitWaitTime());
        }
    }

    @Test
    public void testModifiedInitWaitTime() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0");){
            Assert.assertEquals((long)0L, (long)m1.cache.getInitWaitTime());
        }
    }

    @Test
    public void testDefaultMaxEntityAge() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0");){
            Assert.assertEquals((long)30L, (long)m1.cache.getMaxEntityAge());
        }
    }

    @Test
    public void testModifiedMaxEntityAge() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0&maxEntityAge=20");){
            Assert.assertEquals((long)24L, (long)m1.cache.getMaxEntityAge());
        }
    }

    @Test
    public void testDefaultMaxesaLoss() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0");){
            Assert.assertEquals((long)6L, (long)m1.cache.getMaxEsaLoss());
        }
    }

    @Test
    public void testModifiedMaxEsaLoss() throws Exception {
        try (Member m1 = new Member("local://.&initWaitTime=0&maxEsaLoss=5");){
            Assert.assertEquals((long)5L, (long)m1.cache.getMaxEsaLoss());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheInitialization() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=18");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            m1.cache.add("type", "m1n2", m1n2descriptors);
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=2&memberName=m2&maxEntityAge=24");
            Set<IDiscoveryEntity> entities = m2.cache.matches("...");
            Assert.assertEquals((long)2L, (long)entities.size());
            for (IDiscoveryEntity entity : entities) {
                if (entity.getName().equals("m1n1")) {
                    this.validateEntity(entity, m2.cache, "m1", "type", "m1n1", 18, true, m1n1descriptors);
                    continue;
                }
                this.validateEntity(entity, m2.cache, "m1", "type", "m1n2", 18, true, m1n2descriptors);
            }
            m2.cache.add("type", "m2n1", m2n1descriptors);
            this.validateEntity(m2.cache.get("type", "m2n1"), m2.cache, "m2", "type", "m2n1", 24, false, m2n1descriptors);
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=2&memberName=m3&maxEntityAge=30");
            entities = m3.cache.matches("...");
            Assert.assertEquals((long)3L, (long)entities.size());
            for (IDiscoveryEntity entity : entities) {
                if (entity.getName().equals("m1n1")) {
                    this.validateEntity(entity, m3.cache, "m1", "type", "m1n1", 18, true, m1n1descriptors);
                    continue;
                }
                if (entity.getName().equals("m1n2")) {
                    this.validateEntity(entity, m3.cache, "m1", "type", "m1n2", 18, true, m1n2descriptors);
                    continue;
                }
                this.validateEntity(entity, m3.cache, "m2", "type", "m2n1", 24, true, m2n1descriptors);
            }
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddPropagatesAddition() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=18");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=24");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3&maxEntityAge=30");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m1.cache.get("type", "m1n1"));
            this.validateEntity(eventData.newEntity, m1.cache, "m1", "type", "m1n1", 18, false, m1n1descriptors);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m2.cache.get("type", "m1n1"));
            this.validateEntity(eventData.newEntity, m2.cache, "m1", "type", "m1n1", 18, true, m1n1descriptors);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(eventData.newEntity, m3.cache, "m1", "type", "m1n1", 18, true, m1n1descriptors);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m2.cache.add("type", "m2n1", m2n1descriptors);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m2.cache.get("type", "m2n1"));
            this.validateEntity(eventData.newEntity, m2.cache, "m2", "type", "m2n1", 24, false, m2n1descriptors);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m1.cache.get("type", "m2n1"));
            this.validateEntity(eventData.newEntity, m1.cache, "m2", "type", "m2n1", 24, true, m2n1descriptors);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m3.cache.get("type", "m2n1"));
            this.validateEntity(eventData.newEntity, m3.cache, "m2", "type", "m2n1", 24, true, m2n1descriptors);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m3.cache.add("type", "m3n1", m3n1descriptors);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m3.cache.get("type", "m3n1"));
            this.validateEntity(eventData.newEntity, m3.cache, "m3", "type", "m3n1", 30, false, m3n1descriptors);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m1.cache.get("type", "m3n1"));
            this.validateEntity(eventData.newEntity, m1.cache, "m3", "type", "m3n1", 30, true, m3n1descriptors);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m2.cache.get("type", "m3n1"));
            this.validateEntity(eventData.newEntity, m2.cache, "m3", "type", "m3n1", 30, true, m3n1descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemovePropagatesRemoval() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=18");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=24");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3&maxEntityAge=30");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            m2.cache.add("type", "m2n1", m2n1descriptors);
            m3.cache.add("type", "m3n1", m3n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            IDiscoveryEntity m2n1EntityAtM1 = m1.cache.get("type", "m2n1");
            Assert.assertNotNull((Object)m2n1EntityAtM1);
            IDiscoveryEntity m2n1EntityAtM2 = m2.cache.get("type", "m2n1");
            Assert.assertNotNull((Object)m2n1EntityAtM2);
            IDiscoveryEntity m2n1EntityAtM3 = m3.cache.get("type", "m2n1");
            Assert.assertNotNull((Object)m2n1EntityAtM3);
            IDiscoveryEntity m3n1EntityAtM1 = m1.cache.get("type", "m3n1");
            Assert.assertNotNull((Object)m3n1EntityAtM1);
            IDiscoveryEntity m3n1EntityAtM2 = m2.cache.get("type", "m3n1");
            Assert.assertNotNull((Object)m3n1EntityAtM2);
            IDiscoveryEntity m3n1EntityAtM3 = m3.cache.get("type", "m3n1");
            Assert.assertNotNull((Object)m3n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.remove("type", "m1n1");
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            DiscoveryCacheEvents.DiscoveryCacheRemoveEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m1.cache.get("type", "m1n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m1n1EntityAtM1);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m2.cache.get("type", "m1n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m1n1EntityAtM2);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m3.cache.get("type", "m1n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m1n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m2.cache.remove("type", "m2n1");
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m2.cache.get("type", "m2n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m2n1EntityAtM2);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m1.cache.get("type", "m2n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m2n1EntityAtM1);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m3.cache.get("type", "m2n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m2n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m3.cache.remove("type", "m3n1");
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m3.cache.get("type", "m3n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m3n1EntityAtM3);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m1.cache.get("type", "m3n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m3n1EntityAtM1);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m2.cache.get("type", "m3n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m3n1EntityAtM2);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClosePropagatesRemoval() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=18");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=24");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3&maxEntityAge=30");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            m2.cache.add("type", "m2n1", m2n1descriptors);
            m3.cache.add("type", "m3n1", m3n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            IDiscoveryEntity m2n1EntityAtM1 = m1.cache.get("type", "m2n1");
            Assert.assertNotNull((Object)m2n1EntityAtM1);
            IDiscoveryEntity m2n1EntityAtM2 = m2.cache.get("type", "m2n1");
            Assert.assertNotNull((Object)m2n1EntityAtM2);
            IDiscoveryEntity m2n1EntityAtM3 = m3.cache.get("type", "m2n1");
            Assert.assertNotNull((Object)m2n1EntityAtM3);
            IDiscoveryEntity m3n1EntityAtM1 = m1.cache.get("type", "m3n1");
            Assert.assertNotNull((Object)m3n1EntityAtM1);
            IDiscoveryEntity m3n1EntityAtM2 = m2.cache.get("type", "m3n1");
            Assert.assertNotNull((Object)m3n1EntityAtM2);
            IDiscoveryEntity m3n1EntityAtM3 = m3.cache.get("type", "m3n1");
            Assert.assertNotNull((Object)m3n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.close();
            Assert.assertEquals((long)0L, (long)m1.eventHandler.events.size());
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            DiscoveryCacheEvents.DiscoveryCacheRemoveEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m2.cache.get("type", "m1n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m1n1EntityAtM2);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m3.cache.get("type", "m1n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m1n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m2.cache.close();
            Assert.assertEquals((long)0L, (long)m2.eventHandler.events.size());
            Thread.sleep(100L);
            Assert.assertEquals((long)0L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)m3.cache.get("type", "m2n1"));
            Assert.assertSame((Object)eventData.removedEntity, (Object)m2n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m3.cache.close();
            Assert.assertEquals((long)0L, (long)m3.eventHandler.events.size());
            Thread.sleep(100L);
            Assert.assertEquals((long)0L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)m2.eventHandler.events.size());
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplacePropagatesRemovalAndAddition() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=18");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=24");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3&maxEntityAge=30");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM1);
            Assert.assertNotSame((Object)addEventData.newEntity, (Object)m1n1EntityAtM1);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m1.cache.get("type", "m1n1"));
            this.validateEntity(m1.cache.get("type", "m1n1"), m1.cache, "m1", "type", "m1n1", 18, false, m1n1descriptors);
            Assert.assertEquals((long)2L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            DiscoveryCacheEvents.DiscoveryCacheRemoveEventData removeEventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)1)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)1)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)1)).data;
            Assert.assertSame((Object)removeEventData.removedEntity, (Object)m1n1EntityAtM2);
            Assert.assertNull((Object)addEventData.oldEntity);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m2.cache.get("type", "m1n1"));
            this.validateEntity(m2.cache.get("type", "m1n1"), m2.cache, "m1", "type", "m1n1", 18, true, m1n1descriptors);
            Assert.assertEquals((long)2L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            removeEventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)1)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)1)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)1)).data;
            Assert.assertSame((Object)removeEventData.removedEntity, (Object)m1n1EntityAtM3);
            Assert.assertNull((Object)addEventData.oldEntity);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(m3.cache.get("type", "m1n1"), m3.cache, "m1", "type", "m1n1", 18, true, m1n1descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHijackPropagatesOnlyAddEvent() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=18");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=24");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3&maxEntityAge=30");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m2.cache.add("type", "m1n1", m2n1descriptors);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM1);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m1.cache.get("type", "m1n1"));
            this.validateEntity(m1.cache.get("type", "m1n1"), m1.cache, "m2", "type", "m1n1", 24, true, m2n1descriptors);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM2);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m2.cache.get("type", "m1n1"));
            this.validateEntity(m2.cache.get("type", "m1n1"), m2.cache, "m2", "type", "m1n1", 24, false, m2n1descriptors);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM3);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(m3.cache.get("type", "m1n1"), m3.cache, "m2", "type", "m1n1", 24, true, m2n1descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveDiscoveredEntityDoesNotPropagateEvents() throws Exception {
        Member m1 = null;
        Member m2 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=18");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=24");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m2.cache.remove("type", "m1n1");
            Thread.sleep(100L);
            Assert.assertEquals((long)0L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMigrateWithRemove() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=18");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=24");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3&maxEntityAge=30");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.remove("type", "m1n1");
            Thread.sleep(100L);
            m2.cache.add("type", "m1n1", m2n1descriptors);
            Thread.sleep(100L);
            Assert.assertEquals((long)2L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            DiscoveryCacheEvents.DiscoveryCacheRemoveEventData removeEventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)1)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)1)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)1)).data;
            Assert.assertSame((Object)removeEventData.removedEntity, (Object)m1n1EntityAtM1);
            Assert.assertNull((Object)addEventData.oldEntity);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m1.cache.get("type", "m1n1"));
            this.validateEntity(m1.cache.get("type", "m1n1"), m1.cache, "m2", "type", "m1n1", 24, true, m2n1descriptors);
            Assert.assertEquals((long)2L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            removeEventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)1)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)1)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)1)).data;
            Assert.assertSame((Object)removeEventData.removedEntity, (Object)m1n1EntityAtM2);
            Assert.assertNull((Object)addEventData.oldEntity);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m2.cache.get("type", "m1n1"));
            this.validateEntity(m2.cache.get("type", "m1n1"), m2.cache, "m2", "type", "m1n1", 24, false, m2n1descriptors);
            Assert.assertEquals((long)2L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            removeEventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)1)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)1)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)1)).data;
            Assert.assertSame((Object)removeEventData.removedEntity, (Object)m1n1EntityAtM3);
            Assert.assertNull((Object)addEventData.oldEntity);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(m3.cache.get("type", "m1n1"), m3.cache, "m2", "type", "m1n1", 24, true, m2n1descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMigrateWithClose() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=18");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=24");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3&maxEntityAge=30");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.close();
            Thread.sleep(100L);
            m2.cache.add("type", "m1n1", m2n1descriptors);
            Thread.sleep(100L);
            Assert.assertEquals((long)0L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)2L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            DiscoveryCacheEvents.DiscoveryCacheRemoveEventData removeEventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)1)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)1)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)1)).data;
            Assert.assertSame((Object)removeEventData.removedEntity, (Object)m1n1EntityAtM2);
            Assert.assertNull((Object)addEventData.oldEntity);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m2.cache.get("type", "m1n1"));
            this.validateEntity(m2.cache.get("type", "m1n1"), m2.cache, "m2", "type", "m1n1", 24, false, m2n1descriptors);
            Assert.assertEquals((long)2L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            removeEventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)1)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)1)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)1)).data;
            Assert.assertSame((Object)removeEventData.removedEntity, (Object)m1n1EntityAtM3);
            Assert.assertNull((Object)addEventData.oldEntity);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(m3.cache.get("type", "m1n1"), m3.cache, "m2", "type", "m1n1", 24, true, m2n1descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLostEsaTriggeredByAdd() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=3&maxEsaLoss=3");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3");
            Thread.sleep(100L);
            ((DiscoveryCacheBase)m1.cache).setNumEsatoLose(1);
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)m1.cache.get("type", "m1n1"));
            Assert.assertNull((Object)m2.cache.get("type", "m1n1"));
            Assert.assertNull((Object)m3.cache.get("type", "m1n1"));
            Assert.assertEquals((long)0L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)m3.eventHandler.events.size());
            Thread.sleep(1100L);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m2.cache.get("type", "m1n1"));
            this.validateEntity(eventData.newEntity, m2.cache, "m1", "type", "m1n1", 3, true, m1n1descriptors);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            eventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertNull((Object)eventData.oldEntity);
            Assert.assertNotNull((Object)eventData.newEntity);
            Assert.assertSame((Object)eventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(eventData.newEntity, m3.cache, "m1", "type", "m1n1", 3, true, m1n1descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLostEsaTriggeredByRemove() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=3&maxEsaLoss=3");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3");
            Thread.sleep(100L);
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)m1.cache.get("type", "m1n1"));
            Assert.assertNotNull((Object)m2.cache.get("type", "m1n1"));
            Assert.assertNotNull((Object)m3.cache.get("type", "m1n1"));
            ((DiscoveryCacheBase)m1.cache).setNumEsatoLose(1);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.remove("type", "m1n1");
            Thread.sleep(100L);
            Assert.assertNull((Object)m1.cache.get("type", "m1n1"));
            Assert.assertNotNull((Object)m2.cache.get("type", "m1n1"));
            Assert.assertNotNull((Object)m3.cache.get("type", "m1n1"));
            Assert.assertEquals((long)0L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)m3.eventHandler.events.size());
            Thread.sleep(1100L);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertNull((Object)m2.cache.get("type", "m1n1"));
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertNull((Object)m3.cache.get("type", "m1n1"));
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    @Test
    public void testLostEsaTriggeredByClose() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLostRemoveEsaTriggeredByReplace() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=3&maxEsaLoss=3");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3");
            Thread.sleep(100L);
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            ((DiscoveryCacheBase)m1.cache).setNumEsatoLose(1);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.add("type", "m1n1", m1n2descriptors);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM2);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m2.cache.get("type", "m1n1"));
            this.validateEntity(m2.cache.get("type", "m1n1"), m2.cache, "m1", "type", "m1n1", 3, true, m1n2descriptors);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM3);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(m3.cache.get("type", "m1n1"), m3.cache, "m1", "type", "m1n1", 3, true, m1n2descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLostRemoveAndAddEsasTriggeredByReplace() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=3&maxEsaLoss=3");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3");
            Thread.sleep(100L);
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            ((DiscoveryCacheBase)m1.cache).setNumEsatoLose(2);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.add("type", "m1n1", m1n2descriptors);
            Thread.sleep(100L);
            Assert.assertNotNull((Object)m1.cache.get("type", "m1n1"));
            Assert.assertNotSame((Object)m1n1EntityAtM1, (Object)m1.cache.get("type", "m1n1"));
            Assert.assertSame((Object)m1n1EntityAtM2, (Object)m2.cache.get("type", "m1n1"));
            Assert.assertSame((Object)m1n1EntityAtM3, (Object)m3.cache.get("type", "m1n1"));
            Thread.sleep(1100L);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM2);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertNotSame((Object)addEventData.newEntity, (Object)m1n1EntityAtM2);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m2.cache.get("type", "m1n1"));
            this.validateEntity(m2.cache.get("type", "m1n1"), m2.cache, "m1", "type", "m1n1", 3, true, m1n2descriptors);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM3);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertNotSame((Object)addEventData.newEntity, (Object)m1n1EntityAtM3);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(m3.cache.get("type", "m1n1"), m3.cache, "m1", "type", "m1n1", 3, true, m1n2descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLostEsaTriggeredByHijack() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=3&maxEsaLoss=3");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            ((DiscoveryCacheBase)m2.cache).setNumEsatoLose(1);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m2.cache.add("type", "m1n1", m2n1descriptors);
            Thread.sleep(100L);
            Assert.assertSame((Object)m1n1EntityAtM1, (Object)m1.cache.get("type", "m1n1"));
            Assert.assertNotNull((Object)m2.cache.get("type", "m1n1"));
            Assert.assertNotSame((Object)m1n1EntityAtM2, (Object)m2.cache.get("type", "m1n1"));
            Assert.assertSame((Object)m1n1EntityAtM3, (Object)m3.cache.get("type", "m1n1"));
            Thread.sleep(1100L);
            Assert.assertEquals((long)1L, (long)m1.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m1.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM1);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m1.cache.get("type", "m1n1"));
            this.validateEntity(m1.cache.get("type", "m1n1"), m1.cache, "m2", "type", "m1n1", 3, true, m2n1descriptors);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM3);
            Assert.assertNotNull((Object)addEventData.newEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(m3.cache.get("type", "m1n1"), m3.cache, "m2", "type", "m1n1", 3, true, m2n1descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemberCrash() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=3&maxEsaLoss=3");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            ((DiscoveryCacheBase)m1.cache).setNumEsatoLose(-1);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.close();
            Thread.sleep(100L);
            Assert.assertSame((Object)m1n1EntityAtM2, (Object)m2.cache.get("type", "m1n1"));
            Assert.assertSame((Object)m1n1EntityAtM3, (Object)m3.cache.get("type", "m1n1"));
            Assert.assertEquals((long)0L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)m3.eventHandler.events.size());
            Thread.sleep(3000L);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            DiscoveryCacheEvents.DiscoveryCacheRemoveEventData removeEventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)removeEventData.removedEntity, (Object)m1n1EntityAtM2);
            Assert.assertNull((Object)m2.cache.get("type", "m1n1"));
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)1L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheRemoveEventData));
            removeEventData = (DiscoveryCacheEvents.DiscoveryCacheRemoveEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)removeEventData.removedEntity, (Object)m1n1EntityAtM3);
            Assert.assertNull((Object)m3.cache.get("type", "m1n1"));
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemberCrashAndRestart() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=3&maxEsaLoss=3");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3");
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            ((DiscoveryCacheBase)m1.cache).setNumEsatoLose(-1);
            m1.eventHandler.reset();
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1.cache.close();
            Thread.sleep(100L);
            Assert.assertSame((Object)m1n1EntityAtM2, (Object)m2.cache.get("type", "m1n1"));
            Assert.assertSame((Object)m1n1EntityAtM3, (Object)m3.cache.get("type", "m1n1"));
            Assert.assertEquals((long)0L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)m3.eventHandler.events.size());
            Thread.sleep(1500L);
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=3&maxEsaLoss=3");
            Assert.assertEquals((long)0L, (long)m1.cache.size());
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)m2.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            DiscoveryCacheEvents.DiscoveryCacheAddEventData addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m2.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM2);
            Assert.assertNotSame((Object)addEventData.newEntity, (Object)addEventData.oldEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m2.cache.get("type", "m1n1"));
            this.validateEntity(m2.cache.get("type", "m1n1"), m2.cache, "m1", "type", "m1n1", 3, true, m1n1descriptors);
            Assert.assertEquals((long)1L, (long)m3.eventHandler.events.size());
            Assert.assertEquals((long)0L, (long)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).type);
            Assert.assertTrue((boolean)(((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data instanceof DiscoveryCacheEvents.DiscoveryCacheAddEventData));
            addEventData = (DiscoveryCacheEvents.DiscoveryCacheAddEventData)((PassiveEventHandler.Event)((PassiveEventHandler)m3.eventHandler).events.get((int)0)).data;
            Assert.assertSame((Object)addEventData.oldEntity, (Object)m1n1EntityAtM3);
            Assert.assertNotSame((Object)addEventData.newEntity, (Object)addEventData.oldEntity);
            Assert.assertSame((Object)addEventData.newEntity, (Object)m3.cache.get("type", "m1n1"));
            this.validateEntity(m3.cache.get("type", "m1n1"), m3.cache, "m1", "type", "m1n1", 3, true, m1n1descriptors);
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    @Test
    public void testLostRemoveEsaTriggeredByMigrate() throws Exception {
    }

    @Test
    public void testLostRemoveAndAddEsaTriggeredByMigrate() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutOfOrderRemoveAndAddEsaTriggeredByMigrate() throws Exception {
        Member m1 = null;
        Member m2 = null;
        Member m3 = null;
        try {
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m1&maxEntityAge=3&maxEsaLoss=3");
            m2 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m2&maxEntityAge=3&maxEsaLoss=3");
            m3 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=0&memberName=m3");
            Thread.sleep(100L);
            m1.cache.add("type", "m1n1", m1n1descriptors);
            Thread.sleep(100L);
            IDiscoveryEntity m1n1EntityAtM1 = m1.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM1);
            IDiscoveryEntity m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            IDiscoveryEntity m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            ((DiscoveryCacheBase)m1.cache).setNumEsatoLose(1);
            m1.cache.close();
            Thread.sleep(100L);
            Assert.assertSame((Object)m1n1EntityAtM2, (Object)m2.cache.get("type", "m1n1"));
            Assert.assertSame((Object)m1n1EntityAtM3, (Object)m3.cache.get("type", "m1n1"));
            m2.cache.add("type", "m1n1", m2n1descriptors);
            Thread.sleep(100L);
            Assert.assertNotSame((Object)m1n1EntityAtM2, (Object)m2.cache.get("type", "m1n1"));
            m1n1EntityAtM2 = m2.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM2);
            Assert.assertNotSame((Object)m1n1EntityAtM3, (Object)m3.cache.get("type", "m1n1"));
            m1n1EntityAtM3 = m3.cache.get("type", "m1n1");
            Assert.assertNotNull((Object)m1n1EntityAtM3);
            m2.eventHandler.reset();
            m3.eventHandler.reset();
            m1 = new Member(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + "&initWaitTime=1&memberName=m1&maxEntityAge=3&maxEsaLoss=3");
            Assert.assertEquals((long)1L, (long)m1.cache.size());
            m1.cache.remove("type", "m1n1");
            ((DiscoveryCacheBase)m1.cache).setNumEsatoLose(1);
            m1.cache.add("type", "m1n1", m1n1descriptors);
            m1.cache.remove("type", "m1n1");
            Assert.assertEquals((long)0L, (long)m2.eventHandler.events.size());
            Assert.assertSame((Object)m1n1EntityAtM2, (Object)m2.cache.get("type", "m1n1"));
            Assert.assertEquals((long)0L, (long)m3.eventHandler.events.size());
            Assert.assertSame((Object)m1n1EntityAtM3, (Object)m3.cache.get("type", "m1n1"));
        }
        finally {
            if (m1 != null) {
                m1.close();
            }
            if (m2 != null) {
                m2.close();
            }
            if (m3 != null) {
                m3.close();
            }
        }
    }

    @AfterClass
    public static void cleanup() {
        DiscoveryCacheFactory.getInstance().close();
        localCache.close();
    }

    private final class Member {
        final IDiscoveryCache cache;
        final PassiveEventHandler eventHandler;

        Member(String descriptor) throws Exception {
            this.cache = DiscoveryCacheFactory.getInstance().createCache(descriptor);
            Assert.assertNotNull((Object)this.cache);
            this.eventHandler = new PassiveEventHandler();
            this.cache.addEventHandler(this.eventHandler);
        }

        void close() {
            this.cache.close();
        }
    }

    private static final class PassiveEventHandler
    implements IDiscoveryCacheEventHandler {
        private final LinkedList<Event> events = new LinkedList();

        private PassiveEventHandler() {
        }

        @Override
        public final void onEvent(IDiscoveryCache cache, int type, Object data) {
            this.events.add(new Event(type, data));
        }

        void reset() {
            this.events.clear();
        }

        private final class Event {
            final int type;
            final Object data;

            Event(int type, Object data) {
                this.type = type;
                this.data = data;
            }

            public String toString() {
                return "type=" + this.type + " event=" + this.data;
            }
        }
    }

    private static final class ActiveEventHandler
    implements IDiscoveryCacheEventHandler {
        private Operation op;
        Exception opStatus;

        ActiveEventHandler(Operation op) {
            this.op = op;
        }

        @Override
        public final void onEvent(IDiscoveryCache cache, int type, Object data) {
            try {
                switch (this.op) {
                    case AddEventHandler: {
                        cache.addEventHandler(new PassiveEventHandler());
                        break;
                    }
                    case RemoveEventHandler: {
                        cache.removeEventHandler(new PassiveEventHandler());
                        break;
                    }
                    case Add: {
                        cache.add("type", "name", descriptors);
                        break;
                    }
                    case Get: {
                        cache.get("type", "name");
                        break;
                    }
                    case Remove: {
                        cache.remove("type", "name");
                        break;
                    }
                    case Match1: {
                        cache.matches("type", "name");
                        break;
                    }
                    case Match2: {
                        cache.matches("type");
                        break;
                    }
                    case Size: {
                        cache.size();
                        break;
                    }
                    case Close: {
                        cache.close();
                    }
                }
            }
            catch (Exception e) {
                this.opStatus = e;
            }
        }

        static enum Operation {
            AddEventHandler,
            RemoveEventHandler,
            Add,
            Get,
            Remove,
            Match1,
            Match2,
            Size,
            Close;

        }
    }
}

