/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingFailedEvent;
import com.neeve.ods.IStoreBindingRoleChangedEvent;
import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStorePersisterStats;
import com.neeve.ods.IStoreQueryEngine;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.ods.impl.StoreMemberInitCompleteEvent;
import com.neeve.rog.IRogChangeDataCaptureHandler;
import com.neeve.rog.IRogGraphCollection;
import com.neeve.rog.IRogNode;
import com.neeve.rog.IRogRootNode;
import com.neeve.rog.impl.RogGraphCollection;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCdcProcessor;
import com.neeve.rog.log.RogLogCompactor;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.sto.StoTypeFactory;
import com.neeve.sto.StoTypeFactoryRegistry;
import com.neeve.test.UnitTest;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;

public abstract class RogReplicatedStoreTestBase
extends UnitTest {
    protected int memberCount = 2;
    protected static List<Member> openMembers = new ArrayList<Member>();
    protected boolean persistent = true;
    protected static AtomicInteger nextGridId = new AtomicInteger(0);
    protected volatile boolean cdcEnabled = false;
    private volatile String storeName;
    private volatile CdcHandler cdcHandler;
    private volatile RogLogCdcProcessor cdcProcessor;
    private volatile Thread cdcThread;

    protected RogReplicatedStoreTestBase() {
    }

    @Before
    public void setupBase() throws IOException {
        if (openMembers.isEmpty()) {
            UtlFile.deleteDirectory((File)new File(RogReplicatedStoreTestBase.getTestbedRoot(), this.getStoreName()));
        }
    }

    @After
    public void tearDownBase() throws IOException {
        this.validateCdc();
        if (openMembers.isEmpty()) {
            UtlFile.deleteDirectory((File)new File(RogReplicatedStoreTestBase.getTestbedRoot(), this.getStoreName()));
        }
    }

    protected void validateCdc() {
        if (this.cdcEnabled && this.cdcHandler != null) {
            this.cdcHandler.validate();
        }
    }

    public String getStoreName() {
        if (this.storeName == null) {
            String storeName = this.testcaseName.getMethodName();
            int bracket = storeName.indexOf(91);
            if (bracket > 0) {
                int underscore = storeName.indexOf(95, bracket);
                if (underscore == -1) {
                    throw new IllegalStateException("Expected parameterized test to have be named with {index}_");
                }
                storeName = storeName.substring(0, storeName.indexOf(91)) + "_" + storeName.substring(bracket + 1, underscore);
            }
            this.storeName = storeName;
        }
        return this.storeName;
    }

    protected abstract Collection<IStoreObjectFactory> getObjectFactories();

    protected void configureStoreDescriptor(StoreDescriptor descriptor) {
    }

    protected void configurePersisterDescriptor(StorePersisterDescriptor persisterDescriptor) {
    }

    public void configureReplicatorDescriptor(StoreReplicatorDescriptor replicatorDescriptor) {
    }

    protected Member primaryMember() {
        return this.getReplicationMember(1);
    }

    protected Member backupMember() {
        return this.getReplicationMember(2);
    }

    protected int nextGraphId() {
        return nextGridId.incrementAndGet();
    }

    protected synchronized void induceCommitFailure() throws Exception {
    }

    private Member getReplicationMember(int memberNumber) {
        try {
            this.checkInitialized();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing replication members", e);
        }
        return openMembers.get(memberNumber - 1);
    }

    public synchronized void checkInitialized() throws Exception, InterruptedException {
        if (openMembers.isEmpty()) {
            for (int i = 0; i < this.memberCount; ++i) {
                Member m = new Member("m" + (i + 1));
                m.registerObjectFactories(this.getObjectFactories());
                m.open(4090 + i);
                if (i == 0) {
                    m.waitForRole(IStoreBinding.Role.Primary);
                }
                openMembers.add(m);
            }
            for (Member member : openMembers) {
                member.waitForPeerInitialization();
            }
        }
    }

    protected static void closeOpenMembers() throws InterruptedException {
        for (Member member : openMembers) {
            if (member.role != IStoreBinding.Role.Backup) continue;
            member.close();
        }
        for (Member member : openMembers) {
            if (member.role != IStoreBinding.Role.Primary) continue;
            member.close();
        }
        openMembers.clear();
    }

    protected void onStoreEvent(Member member, IStoreEvent event) {
    }

    @AfterClass
    public static void afterTests() throws InterruptedException {
        RogReplicatedStoreTestBase.closeOpenMembers();
    }

    protected class Member
    implements IStoreEventHandler {
        private String memberName;
        private StoreDescriptor descriptor;
        private IStoreBinding binding;
        private IStoreBinding.Role role;
        private IRogGraphCollection collection;
        private boolean peerInitialized = false;
        private Exception failure;
        private long lastTransactionId = -1L;
        private long lastStableTransactionId = -1L;

        private Member(String memberName) {
            this.memberName = memberName;
        }

        private void open(int port) throws Exception {
            System.out.println("Opening store " + RogReplicatedStoreTestBase.this.getStoreName() + " [member=" + this.memberName + "]");
            this.descriptor = StoreDescriptor.create(RogReplicatedStoreTestBase.this.getStoreName());
            StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.create(this.descriptor.getName() + "-" + this.memberName);
            replicatorDescriptor.setProperty("storeName", this.descriptor.getName());
            replicatorDescriptor.setProperty("discoveryDescriptor", "loopback://clusterdiscovery");
            replicatorDescriptor.setProperty("initWaitTime", "500");
            RogReplicatedStoreTestBase.this.configureReplicatorDescriptor(replicatorDescriptor);
            replicatorDescriptor.save();
            this.descriptor.setReplicator(replicatorDescriptor.getName());
            if (RogReplicatedStoreTestBase.this.persistent) {
                StorePersisterDescriptor persisterDescriptor = StorePersisterDescriptor.create(RogReplicatedStoreTestBase.this.getStoreName() + "-" + this.memberName, "com.neeve.rog.log.RogLog");
                persisterDescriptor.setProperty("flushOnCommit", "true");
                persisterDescriptor.setProperty("initialLogLength", "0");
                persisterDescriptor.setProperty("storeRoot", new File(RogReplicatedStoreTestBase.getTestbedRoot() + "/" + RogReplicatedStoreTestBase.this.getStoreName(), this.memberName).getCanonicalPath());
                RogReplicatedStoreTestBase.this.configurePersisterDescriptor(persisterDescriptor);
                persisterDescriptor.save();
                this.descriptor.setPersister(persisterDescriptor.getName());
            }
            RogReplicatedStoreTestBase.this.configureStoreDescriptor(this.descriptor);
            this.collection = RogGraphCollection.create(this.memberName, this.descriptor, this);
            this.binding = this.collection.getStore();
            this.binding.open();
            this.role = this.binding.getRole();
            if (this.role == IStoreBinding.Role.Primary && RogReplicatedStoreTestBase.this.cdcEnabled) {
                this.startCdcProcessor();
            }
            System.out.println("Opened store " + RogReplicatedStoreTestBase.this.getStoreName() + " [member=" + this.memberName + ", role=" + (Object)((Object)this.role) + "]");
        }

        private void close() throws InterruptedException {
            this.stopCdcProcessor();
            this.binding.close(0);
        }

        public void restart() throws Exception, InterruptedException {
            this.close();
            this.open(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(IStoreEvent event) {
            if (event instanceof IStoreBindingRoleChangedEvent) {
                IStoreBinding.Role newRole = ((IStoreBindingRoleChangedEvent)event).getRole();
                if (newRole == IStoreBinding.Role.Primary) {
                    if (RogReplicatedStoreTestBase.this.cdcEnabled) {
                        try {
                            this.startCdcProcessor();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Member member = this;
                    synchronized (member) {
                        this.role = newRole;
                        this.notify();
                    }
                }
            } else if (event instanceof StoreMemberInitCompleteEvent) {
                Member member = this;
                synchronized (member) {
                    this.peerInitialized = true;
                    this.lastStableTransactionId = this.lastTransactionId = ((StoreMemberInitCompleteEvent)event).getLastTransactionId();
                    this.notifyAll();
                }
            } else if (event instanceof IStoreBindingFailedEvent) {
                System.err.println("Store Binding Failure:");
                ((IStoreBindingFailedEvent)event).getCause().printStackTrace();
                Member member = this;
                synchronized (member) {
                    this.failure = ((IStoreBindingFailedEvent)event).getCause();
                    this.notifyAll();
                }
            } else if (event instanceof IStoreCommitCompletionEvent) {
                ++this.lastStableTransactionId;
            }
            RogReplicatedStoreTestBase.this.onStoreEvent(this, event);
        }

        private void startCdcProcessor() throws Exception {
            if (RogReplicatedStoreTestBase.this.cdcHandler == null) {
                RogReplicatedStoreTestBase.this.cdcHandler = new CdcHandler();
            }
            this.stopCdcProcessor();
            RogReplicatedStoreTestBase.this.cdcProcessor = this.getPersister().createCdcProcessor(RogReplicatedStoreTestBase.this.cdcHandler);
            RogReplicatedStoreTestBase.this.cdcThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.out.println(Thread.currentThread().getName() + " Starting CDC Processor");
                        RogReplicatedStoreTestBase.this.cdcProcessor.run();
                    }
                    catch (Throwable thrown) {
                        System.out.println(Thread.currentThread().getName() + " CDC Processor Error " + UtlThrowable.prepareStackTrace((Throwable)thrown));
                    }
                }
            }, "CDCRunner-" + RogReplicatedStoreTestBase.this.storeName + "-" + this.memberName);
            RogReplicatedStoreTestBase.this.cdcThread.start();
        }

        private void stopCdcProcessor() throws InterruptedException {
            if (RogReplicatedStoreTestBase.this.cdcThread != null) {
                if (RogReplicatedStoreTestBase.this.cdcThread.isAlive()) {
                    RogReplicatedStoreTestBase.this.cdcProcessor.close();
                }
                RogReplicatedStoreTestBase.this.cdcThread.join();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRole(IStoreBinding.Role newRole) throws InterruptedException {
            Member member = this;
            synchronized (member) {
                while (newRole != this.role) {
                    this.checkFailures();
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForPeerInitialization() throws InterruptedException {
            Member member = this;
            synchronized (member) {
                while (!this.peerInitialized) {
                    this.checkFailures();
                    this.wait();
                }
            }
        }

        public void checkFailures() {
            if (this.failure != null) {
                Assert.fail((String)("Store binding failure occured: " + this.failure.getMessage()));
            }
        }

        public void commitAndFail(boolean sync) throws OdsException, InterruptedException, Exception {
            this.commit(sync);
            RogReplicatedStoreTestBase.this.induceCommitFailure();
        }

        public void commit(boolean sync) throws OdsException, InterruptedException {
            IStoreCommitCompletionEvent event = this.binding.createCommitCompletionEvent();
            event.setNotify(true);
            event.setEndOfBatch(true);
            ++this.lastTransactionId;
            this.binding.commit(this.lastTransactionId, this.lastTransactionId, event, 0);
            if (sync) {
                event.waitForCompletion();
            }
        }

        public void registerObjectFactories(Collection<IStoreObjectFactory> factories) {
            for (IStoreObjectFactory factory : factories) {
                StoreObjectFactoryRegistry.getInstance().registerObjectFactory(factory);
                if (factory instanceof StoTypeFactory) {
                    StoTypeFactoryRegistry.getInstance().registerTypeFactory((StoTypeFactory)factory);
                }
                if (!(factory instanceof MessageViewFactory)) continue;
                MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)factory);
            }
        }

        public <T extends IRogRootNode> T addRootObject(T node) {
            this.collection.add((IRogNode)((Object)node));
            return node;
        }

        public <T extends IRogRootNode> T getRootObject(int graphId) {
            return (T)this.collection.get(graphId);
        }

        public void removeRootObject(IRogNode node) {
            this.collection.remove(node);
        }

        public void rollback() {
            this.binding.rollback();
        }

        public IStoreBinding getStore() {
            return this.binding;
        }

        public RogLog getPersister() {
            return (RogLog)this.getStore().getPersister();
        }

        public void flushPersister() throws TimeoutException {
            RogLog log = (RogLog)this.getStore().getPersister();
            if (log == null) {
                return;
            }
            IStorePersisterStats stats = log.getStats();
            log.flush(true);
            if (!stats.isDetached()) {
                return;
            }
            long timeout = System.currentTimeMillis() + 5000L;
            while (stats.getDisruptorCapacity() - stats.getDisruptorRemaining() > 0 && System.currentTimeMillis() < timeout) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (stats.getDisruptorCapacity() - stats.getDisruptorRemaining() > 0) {
                throw new TimeoutException("Timed out flusing persister");
            }
        }

        public RogLogCompactor getCompactor() {
            return this.getPersister().getCompactor();
        }

        public long getLastStableTransactionId() {
            return this.lastStableTransactionId;
        }

        public IStoreQueryEngine getQueryEngine() {
            return this.binding.getQueryEngine();
        }
    }

    public class CdcHandler
    implements IRogChangeDataCaptureHandler {
        private final String tracePrefix = "[CDCHANDLER] ";
        private final Tracer tracer = Tracer.create((Tracer.Level)Tracer.Level.INFO);
        volatile Throwable error;
        volatile Object lastValueReceived;
        volatile int lastLogNumber;

        CdcHandler() {
            this.tracer.bind("app.cdchandler");
        }

        @Override
        public boolean handleChange(UUID objectId, IRogChangeDataCaptureHandler.ChangeType changeType, List<IRogNode> entries) {
            if (this.tracer.debug) {
                this.tracer.log("[CDCHANDLER] handleChange id: " + objectId + " type: " + (Object)((Object)changeType) + " entries: " + entries.size(), Tracer.Level.DEBUG);
            }
            if (entries.get(0).getClass().getSimpleName().equals("Repository")) {
                this.lastValueReceived = UtlReflection.getProperty((Object)entries.get(entries.size() - 1), (String)"FixlenField");
            }
            return true;
        }

        @Override
        public boolean onCheckpointComplete(long checkpointVersion) {
            if (this.tracer.debug) {
                this.tracer.log("[CDCHANDLER] onCheckpointComplete " + checkpointVersion, Tracer.Level.DEBUG);
            }
            return true;
        }

        @Override
        public void onCheckpointStart(long checkpointVersion) {
            if (this.tracer.debug) {
                this.tracer.log("[CDCHANDLER] onCheckpointStart " + checkpointVersion, Tracer.Level.DEBUG);
            }
        }

        @Override
        public void onLogComplete(int logNumber, IRogChangeDataCaptureHandler.LogCompletionReason reason, Throwable errorCause) {
            this.tracer.log("[CDCHANDLER] onLogComplete " + logNumber + ", status: " + (Object)((Object)reason) + (errorCause != null ? ", ERROR: " + UtlThrowable.prepareStackTrace((Throwable)errorCause) : ""), Tracer.Level.INFO);
            this.lastLogNumber = logNumber;
            if (reason == IRogChangeDataCaptureHandler.LogCompletionReason.Error) {
                this.error = errorCause;
            }
        }

        @Override
        public void onLogStart(int logNumber) {
            this.tracer.log("[CDCHANDLER] onLogStart " + logNumber, Tracer.Level.INFO);
        }

        @Override
        public void onWait() {
            if (this.tracer.debug) {
                this.tracer.log("[CDCHANDLER] onWait", Tracer.Level.DEBUG);
            }
        }

        public void validate() {
        }
    }
}

