/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.test.unit.proto.Factory;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.ods.impl.StorePersisterCompactionCompletedEvent;
import com.neeve.ods.impl.StorePersisterCompactionErrorEvent;
import com.neeve.ods.impl.StorePersisterCompactionStartedEvent;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogRootNode;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.log.RogLogCheckpointReaderParams;
import com.neeve.rog.test.unit.RogReplicatedStoreTestBase;
import com.neeve.util.UtlObjectGraph;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTableFormatter;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RogLogContinuousCompactionTest
extends RogReplicatedStoreTestBase {
    private static final int COMPACTION_CYCLES = 10;
    @Parameterized.Parameter(value=0)
    public AdmEncodingType encoding;
    @Parameterized.Parameter(value=1)
    public boolean cdcEnabled = false;
    @Parameterized.Parameter(value=2)
    public boolean clustered = true;
    @Parameterized.Parameter(value=3)
    public String offheapBuffering = "Disabled";
    @Parameterized.Parameter(value=4)
    public boolean windowed = false;
    private volatile int numCompactionsStarted = 0;
    private volatile int numCompactionsCompleted = 0;
    private volatile Throwable compactionException = null;

    @Parameterized.Parameters(name="{index}_{0}_cdc_{1}_clustered_{2}_buffering{3}_windowed_{4}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{AdmEncodingType.Protobuf, false, false, "MemoryMappedRead", false}, {AdmEncodingType.Protobuf, false, false, "RandomAccessFile", false}, {AdmEncodingType.Protobuf, false, false, "PktReader", false}, {AdmEncodingType.Protobuf, false, false, "Disabled", false}, {AdmEncodingType.Protobuf, true, false, "MemoryMappedRead", false}, {AdmEncodingType.Protobuf, true, false, "RandomAccessFile", false}, {AdmEncodingType.Protobuf, true, false, "PktReader", false}, {AdmEncodingType.Protobuf, true, false, "Disabled", false}, {AdmEncodingType.Json, true, false, "RandomAccessFile", false}, {AdmEncodingType.Xbuf, true, false, "RandomAccessFile", false}, {AdmEncodingType.Protobuf, false, false, "Disabled", true}, {AdmEncodingType.Protobuf, true, false, "Disabled", true}, {AdmEncodingType.Json, true, false, "RandomAccessFile", true}, {AdmEncodingType.Xbuf, true, false, "RandomAccessFile", true}};
        return Arrays.asList(data);
    }

    @Before
    public void setup() throws OdsException {
        this.memberCount = !this.clustered ? 1 : 2;
        ((RogReplicatedStoreTestBase)this).cdcEnabled = this.cdcEnabled;
        this.numCompactionsStarted = 0;
        this.numCompactionsCompleted = 0;
        this.compactionException = null;
    }

    @After
    public void tearDown() throws OdsException, InterruptedException {
        RogLogContinuousCompactionTest.closeOpenMembers();
    }

    @Override
    protected Collection<IStoreObjectFactory> getObjectFactories() {
        switch (this.encoding) {
            case Protobuf: {
                return Arrays.asList(new Factory());
            }
            case Xbuf: {
                return Arrays.asList(new com.neeve.adm.test.unit.xbuf.Factory());
            }
            case Json: {
                return Arrays.asList(new com.neeve.adm.test.unit.json.Factory());
            }
        }
        return null;
    }

    @Override
    protected void configureStoreDescriptor(StoreDescriptor descriptor) {
        descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
        descriptor.setCheckpointThreshold(1);
    }

    @Override
    protected void configurePersisterDescriptor(StorePersisterDescriptor persisterDescriptor) {
        persisterDescriptor.setProperty("logScavengePolicy", "Delete");
        persisterDescriptor.setProperty("initialLogLength", "0");
        persisterDescriptor.setProperty("cdcEnabled", String.valueOf(this.cdcEnabled));
        persisterDescriptor.setCompactorProperty("compactionThreshold", "512k");
        persisterDescriptor.setCompactorProperty("conflateCheckpoints", String.valueOf(!this.windowed));
        if (this.windowed) {
            persisterDescriptor.setCompactorProperty("maxCompactionWindowSize", "32k");
        }
        persisterDescriptor.setCompactorProperty("offheapBuffering", String.valueOf(!this.windowed));
        persisterDescriptor.setCompactorProperty("offheapBufferingLoadStrategy", RogLogCheckpointReaderParams.OffheapBufferingLoadStrategy.valueOf(this.offheapBuffering).name());
        persisterDescriptor.setCompactorProperty("memMappedReadBufferMaxSize", "8k");
    }

    @Override
    protected void onStoreEvent(RogReplicatedStoreTestBase.Member member, IStoreEvent event) {
        if (event instanceof StorePersisterCompactionCompletedEvent) {
            ++this.numCompactionsCompleted;
        } else if (event instanceof StorePersisterCompactionStartedEvent) {
            ++this.numCompactionsStarted;
        } else if (event instanceof StorePersisterCompactionErrorEvent && this.compactionException == null) {
            this.compactionException = ((StorePersisterCompactionErrorEvent)event).getError();
        }
    }

    @Override
    public void configureReplicatorDescriptor(StoreReplicatorDescriptor replicatorDescriptor) {
    }

    @Test
    public void testContinuousCompact() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        int graphId = this.nextGraphId();
        IRogRootNode parent = (IRogRootNode)this.createFactoryObject("Parent2", graphId);
        m1.addRootObject(parent);
        HashSet<Class> toPopulate = new HashSet<Class>(Arrays.asList(this.factoryType("IChildEntity"), this.factoryType("IChildEntityL2"), this.factoryType("IChild2"), this.factoryType("IChild3")));
        UtlObjectGraph.BasePopulationHelper helper = new UtlObjectGraph.BasePopulationHelper(){

            public boolean shouldPopulate(Class<?> type, Stack<String> getterStack, Random random) {
                return getterStack.size() < 2 && !type.isArray();
            }
        };
        int cycle = 0;
        while (this.numCompactionsStarted < 10 && this.compactionException == null) {
            ++cycle;
            parent = m1.getRootObject(graphId);
            Map childMap = (Map)this.invoke((Object)parent, "getStringMapField", new Object[0]);
            RogNode childObject = (RogNode)this.createFactoryObject("ChildEntity");
            long ts = System.nanoTime();
            UtlObjectGraph.populateObject((Object)childObject, toPopulate, (UtlObjectGraph.PopulationHelper)helper);
            if (RogLogContinuousCompactionTest.verbose()) {
                System.out.println("Populated " + childObject.getClass().getSimpleName() + " in " + UtlUnit.formatDuration((double)(System.nanoTime() - ts), (TimeUnit)TimeUnit.NANOSECONDS));
            }
            childMap.put(String.valueOf(cycle), childObject);
            if (cycle > 3) {
                ts = System.nanoTime();
                childMap.remove(String.valueOf(cycle - 3));
                if (RogLogContinuousCompactionTest.verbose()) {
                    System.out.println("Removed " + childObject.getClass().getSimpleName() + " in " + UtlUnit.formatDuration((double)(System.nanoTime() - ts), (TimeUnit)TimeUnit.NANOSECONDS));
                }
            }
            ts = System.nanoTime();
            m1.commit(false);
            if (!RogLogContinuousCompactionTest.verbose()) continue;
            System.out.println("Committed in " + UtlUnit.formatDuration((double)(System.nanoTime() - ts), (TimeUnit)TimeUnit.NANOSECONDS));
        }
        if (this.compactionException != null) {
            Assert.fail((String)("Compactor encountered error:" + UtlThrowable.prepareStackTrace((Throwable)this.compactionException)));
        }
        long timeout = System.currentTimeMillis() + 10000L;
        while (this.numCompactionsStarted > this.numCompactionsCompleted && System.currentTimeMillis() < timeout) {
            System.out.println("Waiting for compaction to complete");
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"Number of compactions completed does not match compactions started", (long)this.numCompactionsStarted, (long)this.numCompactionsCompleted);
        m1.getCompactor().waitForCompactionToComplete();
        m1.restart();
        this.assertGraphObjectsEqual(parent, m1.getRootObject(graphId));
    }

    @Test
    public void testContinuousCompactPopulateAndUpdate() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        int graphId = this.nextGraphId();
        IRogRootNode parent = (IRogRootNode)this.createFactoryObject("Parent2", graphId);
        m1.addRootObject(parent);
        HashSet<Class> toPopulate = new HashSet<Class>(Arrays.asList(this.factoryType("IChildEntity"), this.factoryType("IChildEntityL2"), this.factoryType("IChild2"), this.factoryType("IChild3")));
        UtlObjectGraph.BasePopulationHelper helper = new UtlObjectGraph.BasePopulationHelper(){

            public boolean shouldPopulate(Class<?> type, Stack<String> getterStack, Random random) {
                return getterStack.size() < 2 && !type.isArray();
            }
        };
        int cycle = 0;
        while (this.numCompactionsStarted < 10 && this.compactionException == null) {
            ++cycle;
            parent = m1.getRootObject(graphId);
            Map childMap = (Map)this.invoke((Object)parent, "getStringMapField", new Object[0]);
            RogNode childObject = (RogNode)this.createFactoryObject("ChildEntity");
            if (RogLogContinuousCompactionTest.verbose()) {
                System.out.println("Populating " + childObject.getClass().getSimpleName());
            }
            UtlObjectGraph.populateObject((Object)childObject, toPopulate, (UtlObjectGraph.PopulationHelper)helper);
            if (RogLogContinuousCompactionTest.verbose()) {
                System.out.println("Populated " + childObject.getClass().getSimpleName());
            }
            childMap.put(String.valueOf(cycle), childObject);
            if (cycle > 10) {
                childMap.remove(String.valueOf(cycle - 3));
                Object toUpdate = childMap.get(String.valueOf(cycle - 2));
                if (RogLogContinuousCompactionTest.verbose()) {
                    System.out.println("Updating " + childObject.getClass().getSimpleName());
                }
                UtlObjectGraph.populateObject(toUpdate, toPopulate, (UtlObjectGraph.PopulationHelper)helper);
                if (RogLogContinuousCompactionTest.verbose()) {
                    System.out.println("Updated " + childObject.getClass().getSimpleName());
                }
                this.invoke(toUpdate, "setStringKey", String.valueOf(cycle - 2));
            }
            m1.commit(true);
        }
        if (this.compactionException != null) {
            Assert.fail((String)("Compactor encountered error:" + UtlThrowable.prepareStackTrace((Throwable)this.compactionException)));
        }
        long timeout = System.currentTimeMillis() + 10000L;
        while (this.numCompactionsStarted > this.numCompactionsCompleted && System.currentTimeMillis() < timeout) {
            System.out.println("Waiting for compaction to complete");
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"Number of compactions completed does not match compactions started", (long)this.numCompactionsStarted, (long)this.numCompactionsCompleted);
        m1.getCompactor().waitForCompactionToComplete();
        m1.restart();
        this.assertGraphObjectsEqual(parent, m1.getRootObject(graphId));
    }

    private void assertGraphObjectsEqual(Object parent1, Object parent2) throws Exception {
        StringBuffer diffs = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)parent1, (Object)parent2, (StringBuffer)diffs, (UtlTableFormatter.Format)UtlTableFormatter.Format.TABULAR, Arrays.asList(IRogMetadata.class, this.factoryType("IParent"), this.factoryType("IChildEntity"), this.factoryType("IChildEntityL2"), this.factoryType("IChild2"), this.factoryType("IChild3")), (UtlObjectGraph.ComparatorFactory)new UtlObjectGraph.ComparatorFactory(){

            public boolean treatEmptyAndNullArraysAsSame() {
                return true;
            }

            public Comparator<?> getComparator(Class<?> clazz, Stack<String> getterStack) {
                return null;
            }
        })) {
            Assert.fail((String)("Recovered parent differs from original parent:\n" + diffs));
        }
    }

    private Class<?> factoryType(String name) throws Exception {
        switch (this.encoding) {
            case Protobuf: {
                return Class.forName("com.neeve.adm.test.unit.proto." + name);
            }
            case Xbuf: {
                return Class.forName("com.neeve.adm.test.unit.xbuf." + name);
            }
            case Json: {
                return Class.forName("com.neeve.adm.test.unit.json." + name);
            }
        }
        throw new IllegalArgumentException();
    }

    private Object createFactoryObject(String name) throws Exception {
        Class<?> clazz = this.factoryType(name);
        return UtlReflection.getMethod(clazz, (String)"create", (Class[])new Class[0]).invoke(null, new Object[0]);
    }

    private Object createFactoryObject(String name, int graphId) throws Exception {
        Class<?> clazz = this.factoryType(name);
        return UtlReflection.getMethod(clazz, (String)"create", (Class[])new Class[]{Integer.TYPE}).invoke(null, new Integer(graphId));
    }

    public Object invoke(Object object, String method, Object ... params) throws Exception {
        Class<?> clazz = object.getClass();
        if (params.length == 0) {
            return UtlReflection.getMethod(clazz, (String)method, (Class[])new Class[0]).invoke(object, new Object[0]);
        }
        Class[] parameterTypes = new Class[params.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = params[i].getClass();
        }
        return UtlReflection.getMethod(clazz, (String)method, (Class[])parameterTypes).invoke(object, params);
    }

    public Object invoke(Object object, String method, Class<?>[] parameterTypes, Object ... params) throws Exception {
        Class<?> clazz = object.getClass();
        if (params.length == 0) {
            return UtlReflection.getMethod(clazz, (String)method, (Class[])new Class[0]).invoke(object, new Object[0]);
        }
        return UtlReflection.getMethod(clazz, (String)method, (Class[])parameterTypes).invoke(object, params);
    }
}

