/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl.log;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.neeve.adm.AdmGenerator;
import com.neeve.ods.IStoreObject;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryAbstractField;
import com.neeve.query.impl.QueryDefaultFieldResolver;
import com.neeve.query.impl.util.UtlNumbers;
import com.neeve.query.impl.util.UtlQueryReflection;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxFieldResolver;
import com.neeve.raw.RawType;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.log.RogLogEntryField;
import com.neeve.rog.impl.log.RogLogFieldWrapper;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.trace.Tracer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Generated;

public class RogLogQueryFieldResolver
extends QueryDefaultFieldResolver<RogLog.Entry>
implements IdxFieldResolver<RogLog.Entry> {
    private static RogLogQueryFieldResolver instance = null;
    private LinkedHashMultimap<String, Class<?>> unqualifiedTypes = LinkedHashMultimap.create();
    private BiMap<Class<?>, Integer> classIds = HashBiMap.create();
    private Set<RogLogQueryEngine.RogLogField<?>> payloadTypeFields = Sets.newHashSet();
    private SetMultimap<RogLogQueryEngine.RogLogField<?>, Class<?>> payloadTypes = HashMultimap.create();
    private boolean typeInferenceEnabled = true;
    private static final Set<String> metadataFields = UtlQueryReflection.getProperties(IRogMetadata.class);
    private static final Set<String> entryFields = UtlQueryReflection.getProperties(RogLog.Entry.class);
    public static RogLogQueryEngine.RogLogField<String> REPOSITORY_NAME_FIELD;
    public static final RogLogQueryEngine.RogLogField<Object> SELECT_ALL_FIELD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RogLogQueryFieldResolver get() {
        if (instance != null) return instance;
        Class<RogLogQueryFieldResolver> clazz = RogLogQueryFieldResolver.class;
        synchronized (RogLogQueryFieldResolver.class) {
            if (instance != null) return instance;
            instance = new RogLogQueryFieldResolver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RogLogQueryFieldResolver() {
        super(RogLog.Entry.class);
        this.registerWellKnownPath("metadata", IRogMetadata.class);
        this.registerWellKnownPath("object", IStoreObject.class);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (REPOSITORY_NAME_FIELD == null) {
                REPOSITORY_NAME_FIELD = new RogLogFieldWrapper<String>(super.getRepositoryNameField());
            }
        }
    }

    @Override
    public Class<?> resolveType(String className) {
        Set classes;
        if (className.equalsIgnoreCase("metadata") || className.equals("IRogMetadata")) {
            return IRogMetadata.class;
        }
        if (className.equalsIgnoreCase("entry")) {
            return RogLog.Entry.class;
        }
        Class type = super.resolveType(className);
        if (type == null && (classes = this.unqualifiedTypes.get((Object)className)) != null && !classes.isEmpty()) {
            if (classes.size() == 1) {
                type = (Class)classes.iterator().next();
            } else {
                throw new QueryException("Type '" + className + "' is ambiguous. Found " + classes.size() + " potential matches, need a qualified class name");
            }
        }
        return type;
    }

    public void addFactory(Class<?> factoryClass) {
        short factoryId;
        try {
            Field ofidField = factoryClass.getField("OFID");
            factoryId = ofidField.getShort(null);
        }
        catch (Exception e) {
            factoryId = 0;
        }
        for (Method method : factoryClass.getMethods()) {
            Class<?> type;
            block8: {
                if ((method.getModifiers() & 8) == 0 || (method.getModifiers() & 1) == 0 || (type = method.getReturnType()) == null || method.getParameterTypes().length > 0 && (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE || !IRogNode.class.isAssignableFrom(type)) || !IRogNode.class.isAssignableFrom(type)) continue;
                try {
                    short typeId = this.findTypeId(factoryClass, type);
                    this.registerDiscoveredType(type, factoryId, typeId);
                }
                catch (NoSuchFieldException e) {
                    IRogNode rogNode = this.createInstance(method);
                    factoryId = rogNode.getOfid();
                    short typeId = rogNode.getType();
                    this.registerDiscoveredType(type, factoryId, typeId);
                }
                catch (Exception e) {
                    this.registerDiscoveredType(type);
                    if (!factoryClass.isAnnotationPresent(Generated.class)) break block8;
                    this.tracer.log("Error locating factory type id for " + type.getName() + " in generated factory: " + factoryClass.getCanonicalName(), Tracer.Level.WARNING);
                }
            }
            try {
                Class<?> intfType = Class.forName(type.getPackage().getName() + '.' + AdmGenerator.interfaceName((String)type.getSimpleName()));
                this.registerDiscoveredType(intfType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private IRogNode createInstance(Method method) {
        try {
            return (IRogNode)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new QueryException("Could not create an IRogNode via: " + method, e);
        }
    }

    private short findTypeId(Class<?> factoryClass, Class<?> type) throws NoSuchFieldException {
        String typeIdFieldName = "ID_" + type.getSimpleName();
        try {
            Field field = factoryClass.getField(typeIdFieldName);
            field.setAccessible(true);
            return field.getShort(null);
        }
        catch (IllegalArgumentException e) {
            throw new QueryException("Could not access " + typeIdFieldName, e);
        }
        catch (IllegalAccessException e) {
            throw new QueryException("Could not access " + typeIdFieldName, e);
        }
    }

    private void registerDiscoveredType(Class<?> type) {
        boolean added = this.unqualifiedTypes.put((Object)type.getSimpleName(), type);
        if (added && this.tracer.debug) {
            this.tracer.log("Registering type: " + type.getName(), Tracer.Level.DEBUG);
        }
    }

    private final void registerDiscoveredType(Class<?> type, short factoryId, short typeId) {
        this.registerDiscoveredType(type);
        int classId = UtlNumbers.pack(factoryId, typeId);
        this.classIds.put(type, (Object)classId);
    }

    public Class<?> getType(short factoryId, short typeId) {
        int classId = UtlNumbers.pack(factoryId, typeId);
        return (Class)this.classIds.inverse().get((Object)classId);
    }

    public Short getFactoryId(Class<?> type) {
        Integer classId = (Integer)this.classIds.get(type);
        if (classId == null) {
            return null;
        }
        return UtlNumbers.unpackLeft(classId);
    }

    public Short getTypeId(Class<?> type) {
        Integer classId = (Integer)this.classIds.get(type);
        if (classId == null) {
            return null;
        }
        return UtlNumbers.unpackRight(classId);
    }

    public Collection<Class<?>> getTypes() {
        return this.unqualifiedTypes.values();
    }

    @Override
    protected Class<?> findTypeForPath(String fieldPath) {
        if (UtlQueryReflection.hasPath(Object.class, (String)fieldPath)) {
            return Object.class;
        }
        if (UtlQueryReflection.hasPath(IRogMetadata.class, (String)fieldPath)) {
            return IRogMetadata.class;
        }
        if (UtlQueryReflection.hasPath(RogLog.Entry.class, (String)fieldPath)) {
            return RogLog.Entry.class;
        }
        return Object.class;
    }

    public final <T> RogLogQueryEngine.RogLogField<T> getField(String recordTypeName, String fieldPath) {
        return (RogLogQueryEngine.RogLogField)super.getField(recordTypeName, fieldPath);
    }

    public final <T> RogLogQueryEngine.RogLogField<T> getField(Class<?> objectType, String fieldPath) {
        return (RogLogQueryEngine.RogLogField)super.getField(objectType, fieldPath);
    }

    public <T> RogLogQueryEngine.RogLogField<T> getField(Class<?> recordType, String fieldPath, Class<T> fieldType, Class<?> ... pathTypes) {
        RogLogQueryEngine.RogLogField<T> field = this.createField(recordType, fieldPath, fieldType, pathTypes);
        if (this.typeInferenceEnabled) {
            if (!this.payloadTypeFields.contains(field)) {
                String resolvedPath = field.getFieldPath();
                if (resolvedPath.startsWith("object")) {
                    if (resolvedPath.equals("object")) {
                        Class resolvedFieldType = field.getFieldType();
                        if (field.getFieldType() != Object.class) {
                            this.payloadTypes.put(field, resolvedFieldType);
                        }
                    } else {
                        String payloadPath = resolvedPath.substring(7);
                        QueryAbstractField baseField = (QueryAbstractField)((Object)field);
                        Class<?>[] pathSelector = baseField.getPathSelector();
                        Class payloadType = Object.class;
                        if (pathSelector != null && pathSelector.length > 0) {
                            payloadType = pathSelector[0];
                        }
                        for (Class<?> type : this.getTypes()) {
                            Class<?> returnType;
                            if (!payloadType.isAssignableFrom(type) || type.isInterface() || !UtlQueryReflection.hasPath(type, (String)payloadPath) || (returnType = UtlQueryReflection.getReturnType(type, payloadPath)) == null || !returnType.equals(fieldType)) continue;
                            this.payloadTypes.put(field, type);
                        }
                    }
                }
                this.payloadTypeFields.add(field);
            }
            for (Class payloadType : this.payloadTypes.get(field)) {
                field.registerPayloadType(payloadType);
            }
        }
        return field;
    }

    private <T> RogLogQueryEngine.RogLogField<T> createField(Class<?> recordType, String fieldPath, Class<T> fieldType, Class<?> ... pathTypes) {
        if (RogLogQueryFieldResolver.isPureMetadataField(recordType, fieldPath)) {
            String fieldName;
            String[] path = fieldPath.split("\\.");
            String string = fieldName = path.length == 0 ? fieldPath : path[path.length - 1];
            if (path.length >= 2 && path[path.length - 2].equals("messageTransportHeaders")) {
                fieldName = "messageTransportHeaders." + path[path.length - 1];
            }
            return RogLogEntryField.create(fieldName, "metadata." + fieldName, fieldType, pathTypes);
        }
        if (RogLogQueryFieldResolver.isPureEntryField(recordType, fieldPath)) {
            if (!recordType.equals(RogLog.Entry.class) && fieldPath.equals("class")) {
                return RogLogEntryField.create("Entry.object.class", "object.class", Class.class, pathTypes);
            }
            return RogLogEntryField.create(fieldPath, fieldPath, fieldType, pathTypes);
        }
        if (recordType == RogLog.Entry.class) {
            return RogLogEntryField.create(fieldPath, fieldPath, fieldType, pathTypes);
        }
        if (recordType == IRogMetadata.class) {
            return RogLogEntryField.create("metadata", "metadata", fieldType, pathTypes);
        }
        if (pathTypes != null && pathTypes.length > 0) {
            Class[] transalatedPathTypes = new Class[pathTypes.length + 1];
            System.arraycopy(pathTypes, 0, transalatedPathTypes, 1, pathTypes.length);
            pathTypes = transalatedPathTypes;
            pathTypes[0] = recordType;
        } else {
            pathTypes = new Class[]{recordType};
        }
        if (Strings.isNullOrEmpty((String)fieldPath)) {
            // empty if block
        }
        if (Strings.isNullOrEmpty((String)fieldPath)) {
            fieldPath = "object";
        } else if (!fieldPath.equals("object") && !fieldPath.startsWith("object.")) {
            fieldPath = "object." + fieldPath;
        }
        String fieldName = fieldPath;
        if (recordType != Object.class) {
            fieldName = recordType.getSimpleName() + "." + fieldPath;
        }
        return RogLogEntryField.create(fieldName, fieldPath, fieldType, pathTypes);
    }

    static final boolean isPureMetadataField(Class<?> objectType, String fieldPath) {
        if (Strings.isNullOrEmpty((String)fieldPath)) {
            return false;
        }
        if (objectType == IRogMetadata.class) {
            return true;
        }
        if (objectType == Object.class || objectType == null) {
            return metadataFields.contains(fieldPath) || fieldPath.startsWith("messageTransportHeaders");
        }
        if (objectType == RogLog.Entry.class) {
            int fieldPathLen = fieldPath.length();
            if (fieldPathLen > 9 && fieldPath.startsWith("metadata.")) {
                return true;
            }
            if (fieldPathLen > 7 && fieldPath.startsWith("object.")) {
                return metadataFields.contains(fieldPath.substring(7));
            }
            if (metadataFields.contains(fieldPath) && entryFields.contains(fieldPath)) {
                return true;
            }
        }
        return false;
    }

    static final boolean isPureEntryField(Class<?> objectType, String fieldPath) {
        if (Strings.isNullOrEmpty((String)fieldPath)) {
            return false;
        }
        if (objectType == RogLog.Entry.class) {
            return Strings.isNullOrEmpty((String)fieldPath) || entryFields.contains(fieldPath);
        }
        if ((objectType == Object.class || objectType == null) && entryFields.contains(fieldPath)) {
            return !fieldPath.equals("type");
        }
        return false;
    }

    @Override
    protected final Class<?> resolveFieldType(Class<?> objectType, String fieldPath) {
        Class returnType = super.resolveFieldType(objectType, fieldPath);
        if (returnType == null) {
            Class<Object> rt;
            Class<Object> payloadType = objectType;
            String payloadPath = fieldPath;
            String exampleType = null;
            HashSet returnTypes = Sets.newHashSet();
            if (fieldPath.length() > 7 && fieldPath.startsWith("object.")) {
                if (objectType == null || objectType == Object.class || objectType == RogLog.Entry.class) {
                    objectType = RogLog.Entry.class;
                    payloadType = IStoreObject.class;
                }
                payloadPath = fieldPath.substring(7);
            }
            for (Class<?> type : this.getTypes()) {
                Class<?> rt2;
                if (!payloadType.isAssignableFrom(type) || (rt2 = super.resolveFieldType(type, payloadPath)) == null) continue;
                returnTypes.add(rt2);
                if (exampleType != null) continue;
                exampleType = type.getSimpleName();
            }
            if (RogLogQueryFieldResolver.isPureMetadataField(objectType, fieldPath) && (rt = super.resolveFieldType(IRogMetadata.class, fieldPath)) != null) {
                returnTypes.add(rt);
                if (exampleType == null) {
                    exampleType = "metadata";
                }
            }
            if (RogLogQueryFieldResolver.isPureEntryField(objectType, fieldPath) && (rt = super.resolveFieldType(RogLog.Entry.class, fieldPath)) != null) {
                returnTypes.add(rt);
                if (exampleType == null) {
                    exampleType = "Entry";
                }
            }
            if (returnTypes.isEmpty()) {
                throw new QueryException("The path [" + objectType.getSimpleName() + "." + fieldPath + "] could not be resolved");
            }
            if (returnTypes.size() > 1) {
                throw new QueryException("The path [" + objectType.getSimpleName() + "." + fieldPath + "] is ambiguous. Please specify a concrete path such as [" + exampleType + "." + fieldPath + "]");
            }
            returnType = (Class)returnTypes.iterator().next();
            if (returnType != null) {
                this.cacheReturnType(objectType, fieldPath, returnType);
            }
        }
        return returnType;
    }

    public RogLogQueryEngine.RogLogField<RogLog.Entry> getRecordField() {
        return RogLogEntryField.ENTRY;
    }

    public final RogLogQueryEngine.RogLogField<Object> getSelectAllField() {
        return SELECT_ALL_FIELD;
    }

    public final RogLogQueryEngine.RogLogField<String> getRepositoryNameField() {
        return REPOSITORY_NAME_FIELD;
    }

    public void describeFields(IdxField<RogLog.Entry, ?> typeField, StringBuffer buf) {
        TreeMap<String, IdxField> fields;
        Class<?> clazz = typeField.getFieldType();
        Class<?> intf = null;
        if (!clazz.isInterface()) {
            try {
                intf = this.resolveType(clazz.getPackage().getName() + ".I" + clazz.getSimpleName());
            }
            catch (QueryException queryException) {}
        } else {
            intf = clazz;
        }
        buf.append(typeField.getName()).append("\n");
        buf.append("Type: ").append(clazz.getCanonicalName().replace(".", "/")).append("\n");
        if (IRogNode.class.isAssignableFrom(clazz)) {
            buf.append("\nLog Entry fields:\n");
            fields = new TreeMap();
            for (String string : entryFields) {
                try {
                    IdxField idxField = this.getField((Class)RogLog.Entry.class, string);
                    if (!this.isFieldQueryable(idxField) || idxField.getFieldPath().startsWith("metadata.") || idxField.getFieldPath().startsWith("serializedMetadata") || idxField.getFieldPath().startsWith("rawBody")) continue;
                    fields.put(idxField.getFieldPath(), idxField);
                }
                catch (QueryException queryException) {}
            }
            for (Map.Entry entry : fields.entrySet()) {
                buf.append(String.format("%-30s%s", entry.getKey(), this.translateFieldType((IdxField)entry.getValue()).getSimpleName())).append("\n");
            }
            buf.append("\nMetadata fields:\n");
            fields.clear();
            for (String string : metadataFields) {
                try {
                    IdxField idxField = this.getField((Class)IRogMetadata.class, string);
                    if (!this.isFieldQueryable(idxField)) continue;
                    fields.put(string, idxField);
                }
                catch (QueryException queryException) {}
            }
            for (Map.Entry entry : fields.entrySet()) {
                buf.append(String.format("%-30s%s", entry.getKey(), this.translateFieldType((IdxField)entry.getValue()).getSimpleName())).append("\n");
            }
        }
        fields = new TreeMap<String, IdxField>();
        for (String string : UtlQueryReflection.getDeclaredProperties(intf != null ? intf : clazz)) {
            if (clazz != RogLog.Entry.class && clazz != IRogMetadata.class && (entryFields.contains(string) || metadataFields.contains(string))) continue;
            try {
                RogLogQueryEngine.RogLogField rogLogField = (RogLogQueryEngine.RogLogField)typeField;
                String fieldPath = rogLogField.getFieldPath();
                fieldPath = fieldPath.startsWith("object") ? (fieldPath.equals("object") ? string : fieldPath.substring(7) + "." + string) : string;
                IdxField field = this.getField((Class)rogLogField.getObjectType(), fieldPath);
                if (!this.isFieldQueryable(field) || field.getName().endsWith("AsTimestamp")) continue;
                fields.put(string, field);
            }
            catch (QueryException queryException) {}
        }
        boolean first = true;
        for (Map.Entry entry : fields.entrySet()) {
            if (first) {
                buf.append("\nFields:\n");
                first = false;
            }
            buf.append(String.format("%-30s%s", entry.getKey(), this.translateFieldType((IdxField)entry.getValue()).getSimpleName())).append("\n");
        }
        if (clazz.isEnum()) {
            try {
                Object[] objectArray = (Object[])clazz.getMethod("values", new Class[0]).invoke(clazz, new Object[0]);
                if (objectArray.length > 0) {
                    buf.append("\nValues:\n");
                    for (Object object : objectArray) {
                        buf.append(object.toString()).append("\n");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isFieldQueryable(IdxField<?, ?> field) {
        if (field == null || field.getFieldType() == null || IRogNode.class.isAssignableFrom(field.getFieldType())) {
            return false;
        }
        if (field.getFieldType().isArray()) {
            return false;
        }
        if (Collection.class.isAssignableFrom(field.getFieldType())) {
            return false;
        }
        if (Map.class.isAssignableFrom(field.getFieldType())) {
            return false;
        }
        return !RawType.class.isAssignableFrom(field.getFieldType());
    }

    private Class<?> translateFieldType(IdxField<?, ?> field) {
        if (this.isTimestampField(field)) {
            return Date.class;
        }
        return field.getFieldType();
    }

    private boolean isTimestampField(IdxField<?, ?> field) {
        if (field.getFieldType() == Date.class) {
            return true;
        }
        if (field.getFieldType() == Long.class || field.getFieldType() == Long.TYPE) {
            return field.getFieldPath().endsWith("Ts") || field.getFieldPath().endsWith("imestamp");
        }
        return false;
    }

    public void enableTypeReference(boolean enable) {
        this.typeInferenceEnabled = enable;
    }

    static {
        SELECT_ALL_FIELD = RogLogEntryField.PAYLOAD;
        entryFields.remove("persister");
    }

    public class PayloadTypeKeyMapping
    extends IdxField.KeyMapping<Class<?>> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<?> getIndexKeyType() {
            return Class.class;
        }

        protected Object doForward(Class<?> clazz) {
            return RogLogQueryFieldResolver.this.classIds.get(clazz);
        }

        protected Class<?> doBackward(Object classId) {
            return (Class)RogLogQueryFieldResolver.this.classIds.inverse().get(classId);
        }
    }
}

