/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogNode;
import com.neeve.rog.IRogStringMap;
import com.neeve.rog.IRogStringMapElement;
import com.neeve.rog.impl.RogCollectionNode;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RogStringMap<T extends IRogCollectionNodeElement>
extends RogCollectionNode<T>
implements IRogStringMap<T> {
    private final int initialCapacity = XRuntime.getValue((String)("nv.rog.map." + this.getClass().getName() + ".initialCapacity"), (int)0);
    private final XLinkedHashMap<String, T> map = this.initialCapacity > 0 ? new XLinkedHashMap(this.initialCapacity) : new XLinkedHashMap();

    protected RogStringMap(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
    }

    protected String getMapElementKey(T value) {
        if (value instanceof IRogStringMapElement) {
            return ((IRogStringMapElement)value).getStringKey();
        }
        throw new IllegalStateException("Unable to determine map String key field for '" + value.getClass().getCanonicalName() + "'");
    }

    protected void setMapElementKey(T value, String key) {
        if (!(value instanceof IRogStringMapElement)) {
            throw new IllegalStateException("Unable to determine map String key field for '" + value.getClass().getCanonicalName() + "'");
        }
        ((IRogStringMapElement)value).setStringKey(key);
    }

    private final T add(T element) {
        return (T)((IRogCollectionNodeElement)this.map.put((Object)this.getMapElementKey(element), element));
    }

    @Override
    protected final void visitFields(RogGraphVisitor visitor) {
        int i = 0;
        for (Map.Entry<String, T> entry : this.entrySet()) {
            this.visitField(visitor, "Key " + i, entry.getKey());
            this.visitField(visitor, "Value " + i, (RogNode)entry.getValue());
            ++i;
        }
    }

    @Override
    protected final PktPacket getStoreCommitPacket() {
        return PktFactory.getInstance().createPacket(257);
    }

    @Override
    public final void clear() {
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            this.remove((String)iterator.next());
            iterator = this.map.keySet().iterator();
        }
        this.map.clear();
    }

    public final boolean containsKey(String key) {
        return this.map.containsKey((Object)key);
    }

    public final boolean containsKey(XString key) {
        if (key == null || key.isNull()) {
            return this.containsKey((String)null);
        }
        return this.containsKey(key.getValue());
    }

    @Override
    public final boolean containsKey(CharSequence key) {
        if (key == null) {
            return this.containsKey((String)null);
        }
        if (key instanceof String) {
            return this.containsKey((String)key);
        }
        if (key instanceof XString) {
            return this.containsKey((XString)key);
        }
        return this.containsKey(key.toString());
    }

    @Override
    public final boolean containsKey(Object key) {
        if (key instanceof CharSequence) {
            return this.containsKey((CharSequence)key);
        }
        return false;
    }

    @Override
    public final boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    @Override
    public final Set<Map.Entry<String, T>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public XIterator<String> reuseableKeyIterator() {
        return this.map.reuseableKeyIterator();
    }

    @Override
    public XIterator<T> reuseableValueIterator() {
        return this.map.reuseableValueIterator();
    }

    @Override
    public XIterator<Map.Entry<String, T>> reuseableEntryIterator() {
        return this.map.reuseableEntryIterator();
    }

    @Override
    public final boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public final T get(CharSequence key) {
        if (key == null) {
            return this.get((String)key);
        }
        if (key instanceof String) {
            return this.get((String)key);
        }
        if (key instanceof XString) {
            return this.get((XString)key);
        }
        return this.get(key.toString());
    }

    public final T get(XString key) {
        if (key == null || key.isNull()) {
            return this.get((String)null);
        }
        return this.get(key.getValue());
    }

    @Override
    public final T get(Object key) {
        if (key instanceof CharSequence) {
            return this.get((CharSequence)key);
        }
        return null;
    }

    public final T get(String key) {
        return (T)((IRogCollectionNodeElement)this.map.get((Object)key));
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public T put(CharSequence key, T value) {
        if (key == null) {
            return this.put((String)null, value);
        }
        if (key instanceof String) {
            return this.put((String)key, value);
        }
        if (key instanceof XString) {
            return this.put((XString)key, value);
        }
        return this.put(key.toString(), value);
    }

    @Override
    public final T put(XString key, T value) {
        if (key == null || key.isNull()) {
            return this.put((String)null, value);
        }
        return this.put(key.getValue(), value);
    }

    @Override
    public final T put(String key, T value) {
        T rc;
        String currentKey = this.getMapElementKey(value);
        if (value.getParent() == this && (key == currentKey || key != null && key.equals(currentKey))) {
            return value;
        }
        if (currentKey != key) {
            this.setMapElementKey(value, key);
        }
        if ((rc = this.add(value)) != null && rc != value) {
            try {
                this.removeChild(rc);
            }
            catch (RuntimeException thrown) {
                this.map.remove((Object)key);
                throw thrown;
            }
        }
        this.addChild(value);
        return rc;
    }

    @Override
    public final void putAll(Map<? extends String, ? extends T> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(CharSequence key) {
        if (key == null) {
            return this.remove((String)null);
        }
        if (key instanceof String) {
            return this.remove((String)key);
        }
        if (key instanceof XString) {
            return this.remove((XString)key);
        }
        return this.remove(key.toString());
    }

    public T remove(XString key) {
        if (key == null || key.isNull()) {
            return this.remove((String)null);
        }
        return this.remove(key.getValue());
    }

    @Override
    public final T remove(Object key) {
        if (key instanceof CharSequence) {
            return this.remove((CharSequence)key);
        }
        return null;
    }

    public final T remove(String key) {
        IRogCollectionNodeElement element = (IRogCollectionNodeElement)this.map.remove((Object)key);
        if (element != null) {
            this.setMapElementKey(element, "");
            this.removeChild(element);
        }
        return (T)element;
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final Collection<T> values() {
        return this.map.values();
    }

    @Override
    protected final void onChildAddRollback(RogNode element) {
        this.map.remove((Object)this.getMapElementKey((IRogCollectionNodeElement)((Object)element)));
    }

    @Override
    protected final void onChildRemoveRollback(RogNode element) {
        this.add((IRogCollectionNodeElement)((Object)element));
    }

    @Override
    public final void addChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.put(this.getMapElementKey(mapElement), (T)mapElement);
    }

    @Override
    public final void removeChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.remove(this.getMapElementKey(mapElement));
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            this.map.clear();
        }
        return count;
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this.size();
    }
}

