/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogRawMessage;
import com.neeve.rog.impl.RogRawMessageImpl;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.util.UtlProps;
import java.nio.ByteBuffer;
import java.util.Properties;

public class RogRawMessageFactory
implements IStoreObjectFactory,
MessageViewFactory {
    static final short OFID = 4;
    static final short VFID = 7;
    public static final short ID_RogRawMessage = 1;
    static final ObjectMapper mapper = new ObjectMapper();

    public static final RogRawMessageFactory create(Properties properties) {
        return new RogRawMessageFactory();
    }

    public static IRogRawMessage createRogRawMessage() {
        return new RogRawMessageImpl(new UUID(), null);
    }

    public static IRogRawMessage wrap(PktPacket packet) {
        return RogRawMessageImpl.createFrom(null, packet);
    }

    @Override
    public short getOfid() {
        return 4;
    }

    @Override
    public final IStoreObject create(short type, UUID id, IStoreObject.EncodingType encodingType, PktPacket packet) {
        if (encodingType != IStoreObject.EncodingType.Custom) {
            throw new IllegalArgumentException("Raw messages only support the Custom encoding type");
        }
        if (type == 1) {
            return RogRawMessageImpl.createFrom(id, packet);
        }
        throw new IllegalArgumentException("Unsupported serialized form (" + (Object)((Object)encodingType) + ") '" + packet.getClass().getName() + "'.");
    }

    public final short getVfid() {
        return 7;
    }

    public final MessageView create(short vid) {
        if (vid == 1) {
            return RogRawMessageImpl.createFrom((ByteBuffer)null);
        }
        throw new IllegalArgumentException("unknown view id '" + vid + "'");
    }

    public final MessageView wrap(short type, int encodingType, Object message) {
        if (message instanceof ByteBuffer) {
            return new RogRawMessageImpl(null, (ByteBuffer)message);
        }
        if (message instanceof byte[]) {
            return new RogRawMessageImpl(null, ByteBuffer.wrap((byte[])message));
        }
        if (message instanceof PktPacket) {
            return RogRawMessageImpl.createFrom(null, (PktPacket)message);
        }
        throw new IllegalArgumentException("Unsupported serialized form '" + message.getClass().getName() + "'. This factory (" + this.getClass().getName() + ") currently only supports ByteBuffer and byte[] serialized forms");
    }

    static {
        mapper.configure(MapperFeature.USE_ANNOTATIONS, true).configure(MapperFeature.AUTO_DETECT_GETTERS, false).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false).configure(MapperFeature.AUTO_DETECT_FIELDS, false).configure(MapperFeature.AUTO_DETECT_SETTERS, false).configure(MapperFeature.AUTO_DETECT_CREATORS, false).configure(MapperFeature.USE_GETTERS_AS_SETTERS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.indent.json", (boolean)false));
    }
}

