/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.neeve.query.Query;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryEngineImpl;
import com.neeve.query.impl.mem.MemQuerySetRepository;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.mock.domain.Address;
import com.neeve.query.impl.mock.domain.Customer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryEngineCollateTest {
    private static QueryEngineImpl<Integer, MockRecord> engine;
    private static MemQuerySetRepository<Integer, MockRecord> repo1;
    private static MemQuerySetRepository<Integer, MockRecord> repo2;

    @BeforeClass
    public static void setup() throws Exception {
        engine = new MockQueryEngine();
        repo1 = new MemQuerySetRepository<Integer, MockRecord>("mock", MockRecord.keyMapper);
        repo2 = new MemQuerySetRepository<Integer, MockRecord>("mock", MockRecord.keyMapper);
        repo1.open();
        repo2.open();
        engine.addRepository(repo1, "repo1");
        engine.addRepository(repo2, "repo2");
        engine.setDefaultPackage(Customer.class.getPackage());
        for (int i = 1; i <= 25; ++i) {
            repo1.add(QueryEngineCollateTest.createCustomerRecord(i));
            repo2.add(QueryEngineCollateTest.createCustomerRecord(100 + i));
        }
    }

    protected static MockRecord createCustomerRecord(int i) {
        String name = "John Doe #" + i;
        Customer cust = new Customer(i, name);
        if (i % 2 == 0) {
            cust.setAddress(new Address("12345"));
        } else {
            cust.setAddress(new Address("22222"));
        }
        return new MockRecord(i, cust);
    }

    @AfterClass
    public static void teardown() throws Exception {
        engine.close();
    }

    @Test
    public void testHaving() {
        String sql = "select Customer.address.zipcode, count(*) from repositories group by Customer.address.zipcode having count(*) > 20";
        Query<MockRecord> query = engine.createQuery(sql);
        QueryResultSet<MockRecord> rs = engine.execute(query);
        while (rs.next()) {
            String zipcode = rs.getString(1);
            int count = rs.getInteger(2);
            if (zipcode.equals("12345")) {
                Assert.assertEquals((String)"24 even rows", (long)24L, (long)count);
                continue;
            }
            if (zipcode.equals("22222")) {
                Assert.assertEquals((String)"26 odd rows", (long)26L, (long)count);
                continue;
            }
            Assert.fail((String)("unexpected zipcode:" + zipcode));
        }
        rs.close();
    }
}

