/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.neeve.query.impl.predicates.FieldPredicate;
import com.neeve.query.impl.predicates.PredicateBase;
import com.neeve.query.impl.predicates.PredicateOperator;
import com.neeve.query.impl.predicates.PredicateOperators;
import com.neeve.query.impl.predicates.Predicates;
import com.neeve.query.index.IdxField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PredicatesImpl
implements Predicates {
    private static final PredicatesImpl instance = new PredicatesImpl();
    public static final com.neeve.query.predicates.Predicate<Object> ALWAYS_TRUE = new PredicateBase<Object>(){

        public boolean apply(Object input) {
            return true;
        }

        public String toString() {
            return "ALWAYS_FALSE";
        }

        @Override
        public double getCost() {
            return 0.0;
        }

        @Override
        public void regularize() {
        }

        @Override
        public void prioritizeBy(Comparator<com.neeve.query.predicates.Predicate<?>> comparator) {
        }
    };
    public static final com.neeve.query.predicates.Predicate<Object> ALWAYS_FALSE = new PredicateBase<Object>(){

        public boolean apply(Object input) {
            return false;
        }

        public String toString() {
            return "ALWAYS_FALSE";
        }

        @Override
        public double getCost() {
            return 0.0;
        }

        @Override
        public void regularize() {
        }

        @Override
        public void prioritizeBy(Comparator<com.neeve.query.predicates.Predicate<?>> comparator) {
        }
    };

    private PredicatesImpl() {
    }

    @Override
    public <T> com.neeve.query.predicates.Predicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    @Override
    public <T> com.neeve.query.predicates.Predicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    @Override
    public <T> com.neeve.query.predicates.Predicate<T> and(com.neeve.query.predicates.Predicate<T> ... predicates) {
        if (predicates.length == 0) {
            return this.alwaysTrue();
        }
        if (predicates.length == 1) {
            return predicates[0];
        }
        return this.and(Lists.newArrayList((Object[])predicates));
    }

    @Override
    public <T> com.neeve.query.predicates.Predicate<T> and(Collection<com.neeve.query.predicates.Predicate<T>> predicates) {
        if (predicates.isEmpty()) {
            return this.alwaysTrue();
        }
        if (predicates.contains(ALWAYS_FALSE)) {
            return this.alwaysFalse();
        }
        ArrayList preds = Lists.newArrayList();
        for (com.neeve.query.predicates.Predicate<T> predicate : predicates) {
            if (predicate.equals(ALWAYS_TRUE)) continue;
            preds.add(predicate);
        }
        if (preds.isEmpty()) {
            return this.alwaysTrue();
        }
        if (preds.size() == 1) {
            return (com.neeve.query.predicates.Predicate)preds.get(0);
        }
        return new And(preds);
    }

    @Override
    public <T> com.neeve.query.predicates.Predicate<T> or(com.neeve.query.predicates.Predicate<T> ... predicates) {
        if (predicates.length == 0) {
            return this.alwaysFalse();
        }
        if (predicates.length == 1) {
            return predicates[0];
        }
        return this.or(Lists.newArrayList((Object[])predicates));
    }

    @Override
    public <T> com.neeve.query.predicates.Predicate<T> or(Collection<com.neeve.query.predicates.Predicate<T>> predicates) {
        if (predicates.isEmpty()) {
            return this.alwaysFalse();
        }
        if (predicates.contains(ALWAYS_TRUE)) {
            return this.alwaysTrue();
        }
        ArrayList preds = Lists.newArrayList();
        for (com.neeve.query.predicates.Predicate<T> predicate : predicates) {
            if (predicate.equals(ALWAYS_FALSE)) continue;
            preds.add(predicate);
        }
        if (preds.isEmpty()) {
            return this.alwaysFalse();
        }
        if (preds.size() == 1) {
            return (com.neeve.query.predicates.Predicate)preds.get(0);
        }
        return new Or(preds);
    }

    @Override
    public <T> com.neeve.query.predicates.Predicate<T> not(com.neeve.query.predicates.Predicate<T> predicate) {
        if (predicate.equals(ALWAYS_TRUE)) {
            return this.alwaysFalse();
        }
        if (predicate.equals(ALWAYS_FALSE)) {
            return this.alwaysTrue();
        }
        return new Not((com.neeve.query.predicates.Predicate)predicate);
    }

    public <REC, T> com.neeve.query.predicates.Predicate<REC> createUnary(IdxField<REC, T> field, PredicateOperators oper) {
        PredicateOperator operator = PredicateOperator.lookup(oper);
        if (!(operator instanceof PredicateOperator.UnaryOperator)) {
            throw new IllegalArgumentException("This operator [" + (Object)((Object)oper) + "] does not take any values");
        }
        PredicateOperator.UnaryOperator unaryOperator = (PredicateOperator.UnaryOperator)operator;
        return new FieldPredicate.UnaryFieldPredicate<REC, T>(field, unaryOperator);
    }

    public <REC, T> com.neeve.query.predicates.Predicate<REC> createBinary(IdxField<REC, T> field, PredicateOperators oper, T value) {
        PredicateOperator operator = PredicateOperator.lookup(oper);
        if (!(operator instanceof PredicateOperator.BinaryOperator)) {
            throw new IllegalArgumentException("This operator [" + (Object)((Object)oper) + "] takes more than one value");
        }
        PredicateOperator.BinaryOperator binaryOperator = (PredicateOperator.BinaryOperator)operator;
        return new FieldPredicate.BinaryFieldPredicate<REC, T>(field, binaryOperator, value);
    }

    public <REC, T> com.neeve.query.predicates.Predicate<REC> createTernary(IdxField<REC, T> field, PredicateOperators oper, T lowValue, T highValue) {
        PredicateOperator operator = PredicateOperator.lookup(oper);
        if (!(operator instanceof PredicateOperator.TernaryOperator)) {
            throw new IllegalArgumentException("This operator [" + (Object)((Object)oper) + "] does not take a lowValue and highValue");
        }
        PredicateOperator.TernaryOperator ternaryOperator = (PredicateOperator.TernaryOperator)operator;
        return new FieldPredicate.TernaryFieldPredicate<REC, T>(field, ternaryOperator, lowValue, highValue);
    }

    public <REC, T> com.neeve.query.predicates.Predicate<REC> createNary(IdxField<REC, T> field, PredicateOperators oper, Collection<T> values) {
        PredicateOperator operator = PredicateOperator.lookup(oper);
        if (!(operator instanceof PredicateOperator.NaryOperator)) {
            throw new IllegalArgumentException("This operator [" + (Object)((Object)oper) + "] takes many values.");
        }
        PredicateOperator.NaryOperator naryOperator = (PredicateOperator.NaryOperator)operator;
        return new FieldPredicate.NaryFieldPredicate<REC, T>(field, naryOperator, values);
    }

    public static PredicatesImpl get() {
        return instance;
    }

    public static class Or<T>
    extends CompositePredicate<T> {
        private Predicate<T> googlePredicate = null;

        private Or(com.neeve.query.predicates.Predicate<T> ... children) {
            super(children);
        }

        private Or(Collection<com.neeve.query.predicates.Predicate<T>> children) {
            super(children);
        }

        public boolean apply(T value) {
            if (this.googlePredicate == null) {
                List children = this.getChildPredicates();
                this.googlePredicate = com.google.common.base.Predicates.or(children);
            }
            return this.googlePredicate.apply(value);
        }

        @Override
        public void regularize() {
            this.childPredicates = this.extractOrChildren(this);
            for (com.neeve.query.predicates.Predicate childPredicate : this.childPredicates) {
                if (!(childPredicate instanceof PredicateBase)) continue;
                PredicateBase childImpl = (PredicateBase)childPredicate;
                childImpl.regularize();
            }
        }

        private List<com.neeve.query.predicates.Predicate<T>> extractOrChildren(Or<T> or) {
            ArrayList orChildren = Lists.newArrayList();
            for (com.neeve.query.predicates.Predicate orChild : or.getChildPredicates()) {
                if (orChild instanceof Or) {
                    List<com.neeve.query.predicates.Predicate<T>> grandchildren = this.extractOrChildren((Or)orChild);
                    orChildren.addAll(grandchildren);
                    continue;
                }
                orChildren.add(orChild);
            }
            return orChildren;
        }
    }

    public static class And<T>
    extends CompositePredicate<T> {
        private Predicate<T> googlePredicate = null;

        private And(com.neeve.query.predicates.Predicate<T> ... children) {
            super(children);
        }

        private And(Collection<com.neeve.query.predicates.Predicate<T>> children) {
            super(children);
        }

        public boolean apply(T value) {
            if (this.googlePredicate == null) {
                List children = this.getChildPredicates();
                this.googlePredicate = com.google.common.base.Predicates.and(children);
            }
            return this.googlePredicate.apply(value);
        }

        @Override
        public void regularize() {
            this.childPredicates = this.extractAndChildren(this);
            for (com.neeve.query.predicates.Predicate childPredicate : this.childPredicates) {
                if (!(childPredicate instanceof PredicateBase)) continue;
                PredicateBase childImpl = (PredicateBase)childPredicate;
                childImpl.regularize();
            }
        }

        private List<com.neeve.query.predicates.Predicate<T>> extractAndChildren(And<T> and) {
            ArrayList andChildren = Lists.newArrayList();
            for (com.neeve.query.predicates.Predicate andChild : and.getChildPredicates()) {
                if (andChild instanceof And) {
                    List<com.neeve.query.predicates.Predicate<T>> grandchildren = this.extractAndChildren((And)andChild);
                    andChildren.addAll(grandchildren);
                    continue;
                }
                andChildren.add(andChild);
            }
            return andChildren;
        }
    }

    public static class Not<T>
    extends CompositePredicate<T> {
        private com.neeve.query.predicates.Predicate<T> child;

        private Not(com.neeve.query.predicates.Predicate<T> child) {
            super(child);
            this.child = child;
        }

        public com.neeve.query.predicates.Predicate<T> getChild() {
            return this.child;
        }

        public boolean apply(T value) {
            return !this.child.apply(value);
        }

        @Override
        public void regularize() {
            if (this.child instanceof PredicateBase) {
                ((PredicateBase)this.child).regularize();
            }
        }
    }

    public static abstract class CompositePredicate<T>
    extends PredicateBase<T> {
        protected List<com.neeve.query.predicates.Predicate<T>> childPredicates = Lists.newArrayList();
        private double cost = 0.0;
        private boolean costCalculated = false;

        public CompositePredicate(com.neeve.query.predicates.Predicate<T> ... children) {
            for (com.neeve.query.predicates.Predicate<T> child : children) {
                this.childPredicates.add(child);
            }
        }

        public CompositePredicate(Collection<com.neeve.query.predicates.Predicate<T>> children) {
            for (com.neeve.query.predicates.Predicate<T> child : children) {
                this.childPredicates.add(child);
            }
        }

        public List<com.neeve.query.predicates.Predicate<T>> getChildPredicates() {
            return this.childPredicates;
        }

        public String toString() {
            return this.getClass().getSimpleName() + this.childPredicates;
        }

        @Override
        public double getCost() {
            if (!this.costCalculated) {
                this.cost = 0.0;
                for (com.neeve.query.predicates.Predicate<T> child : this.childPredicates) {
                    this.cost += child.getCost();
                }
                this.costCalculated = true;
            }
            return this.cost;
        }

        @Override
        public void prioritizeBy(Comparator<com.neeve.query.predicates.Predicate<?>> comparator) {
            if (this.childPredicates.size() > 1) {
                Collections.sort(this.childPredicates, comparator);
            }
            for (com.neeve.query.predicates.Predicate<T> child : this.childPredicates) {
                if (!(child instanceof PredicateBase)) continue;
                PredicateBase childImpl = (PredicateBase)child;
                childImpl.prioritizeBy(comparator);
            }
        }
    }
}

