/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index.test.unit;

import com.google.common.collect.Lists;
import com.neeve.query.impl.index.IdxUniqueTreeIndex;
import com.neeve.query.impl.util.collect.UtlRangeBase;
import com.neeve.test.UnitTest;
import java.util.ArrayList;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Test;

public class UniqueIndexTest
extends UnitTest {
    @Test
    public void basicTest() {
        TreeMap map = new TreeMap();
        IdxUniqueTreeIndex index = new IdxUniqueTreeIndex("test", map);
        index.put(1, "a");
        index.put(1, "b");
        index.put(2, "c");
        Assert.assertEquals((String)"replace a with b", (Object)"b", index.getId(1));
        Assert.assertNull((String)"3 is not a key", index.getId(3));
    }

    @Test
    public void testRange() {
        TreeMap map = new TreeMap();
        IdxUniqueTreeIndex index = new IdxUniqueTreeIndex("test", map);
        index.put(1, "a");
        index.put(2, "b");
        index.put(3, "c");
        index.put(4, "d");
        index.put(5, "e");
        index.put(6, "f");
        UtlRangeBase<Integer> range = new UtlRangeBase<Integer>(3, 5);
        Iterable values = index.getIds(range);
        ArrayList valueList = Lists.newArrayList(values);
        Assert.assertEquals((String)"range: c-e", (Object)Lists.newArrayList((Object[])new String[]{"c", "d", "e"}), (Object)valueList);
        range.setIncludeStart(false);
        values = index.getIds(range);
        valueList = Lists.newArrayList(values);
        Assert.assertEquals((String)"range: c-e", (Object)Lists.newArrayList((Object[])new String[]{"d", "e"}), (Object)valueList);
        range.setIncludeEnd(false);
        values = index.getIds(range);
        valueList = Lists.newArrayList(values);
        Assert.assertEquals((String)"range: c-e", (Object)Lists.newArrayList((Object[])new String[]{"d"}), (Object)valueList);
        range = new UtlRangeBase<Integer>(null, 4);
        values = index.getIds(range);
        valueList = Lists.newArrayList(values);
        Assert.assertEquals((String)"range: c-e", (Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"}), (Object)valueList);
        range = new UtlRangeBase<Object>(4, null);
        values = index.getIds(range);
        valueList = Lists.newArrayList(values);
        Assert.assertEquals((String)"range: c-e", (Object)Lists.newArrayList((Object[])new String[]{"d", "e", "f"}), (Object)valueList);
        range = new UtlRangeBase<Object>(null, null);
        values = index.getIds(range);
        valueList = Lists.newArrayList(values);
        Assert.assertEquals((String)"range: c-e", (Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f"}), (Object)valueList);
    }
}

