/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.test.unit;

import com.neeve.ods.StoreDescriptor;
import com.neeve.test.UnitTest;
import org.junit.Assert;
import org.junit.Test;

public final class StoreDescriptorTest
extends UnitTest {
    @Test
    public void testCreateDescriptorWithNullName() throws Exception {
        try {
            StoreDescriptor.create(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetName() throws Exception {
        Assert.assertEquals((Object)"store", (Object)StoreDescriptor.create("store").getName());
    }

    @Test
    public void testGetPersisterNull() throws Exception {
        Assert.assertNull((Object)StoreDescriptor.create("store").setPersister(null).getPersister());
    }

    @Test
    public void testGetPersisterNonNull() throws Exception {
        Assert.assertEquals((Object)"persister", (Object)StoreDescriptor.create("store").setPersister("persister").getPersister());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetPersistenceQuorumZero() throws Exception {
        StoreDescriptor.create("store").setPersistenceQuorum(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetPersistenceQuorumLessZero() throws Exception {
        StoreDescriptor.create("store").setPersistenceQuorum(-1);
    }

    @Test
    public void testGetPersistenceQuorum() throws Exception {
        Assert.assertEquals((long)5L, (long)StoreDescriptor.create("store").setPersistenceQuorum(5).getPersistenceQuorum());
    }

    @Test
    public void testGetMaxPersistSyncBacklogLessZero() throws Exception {
        Assert.assertEquals((long)-1L, (long)StoreDescriptor.create("store").setMaxPersistSyncBacklog(-1).getMaxPersistSyncBacklog());
    }

    @Test
    public void testGetMaxPersistSyncBacklogZero() throws Exception {
        Assert.assertEquals((long)0L, (long)StoreDescriptor.create("store").setMaxPersistSyncBacklog(0).getMaxPersistSyncBacklog());
    }

    @Test
    public void testGetMaxPersistSyncBacklogGreaterZero() throws Exception {
        Assert.assertEquals((long)60L, (long)StoreDescriptor.create("store").setMaxPersistSyncBacklog(60).getMaxPersistSyncBacklog());
    }

    @Test
    public void testGetInterClusterReplicatorNull() throws Exception {
        Assert.assertNull((Object)StoreDescriptor.create("store").setInterClusterReplicator(null).getInterClusterReplicator());
    }

    @Test
    public void testGetInterClusterReplicatorNonNull() throws Exception {
        Assert.assertEquals((Object)"icr", (Object)StoreDescriptor.create("store").setInterClusterReplicator("icr").getInterClusterReplicator());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetInterClusterReplicationQuorumZero() throws Exception {
        StoreDescriptor.create("store").setInterClusterReplicationQuorum(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetInterClusterReplicationQuorumLessZero() throws Exception {
        StoreDescriptor.create("store").setInterClusterReplicationQuorum(-1);
    }

    @Test
    public void testGetInterClusterReplicationQuorum() throws Exception {
        Assert.assertEquals((long)5L, (long)StoreDescriptor.create("store").setInterClusterReplicationQuorum(5).getInterClusterReplicationQuorum());
    }

    @Test
    public void testGetMaxInterClusterReplicationSyncBacklogLessZero() throws Exception {
        Assert.assertEquals((long)-1L, (long)StoreDescriptor.create("store").setMaxInterClusterReplicationSyncBacklog(-1).getMaxInterClusterReplicationSyncBacklog());
    }

    @Test
    public void testGetMaxInterClusterReplicationSyncBacklogZero() throws Exception {
        Assert.assertEquals((long)0L, (long)StoreDescriptor.create("store").setMaxInterClusterReplicationSyncBacklog(0).getMaxInterClusterReplicationSyncBacklog());
    }

    @Test
    public void testGetMaxInterClusterReplicationSyncBacklogGreaterZero() throws Exception {
        Assert.assertEquals((long)60L, (long)StoreDescriptor.create("store").setMaxInterClusterReplicationSyncBacklog(60).getMaxInterClusterReplicationSyncBacklog());
    }
}

