/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.test.unit;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.StoreBindingFactory;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.impl.StoreCommitCompletionEvent;
import com.neeve.stats.Stats;
import com.neeve.test.ConditionalIgnoreRule;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public final class StoreCommitCompletionEventTest
extends UnitTest {
    private static IStoreBinding binding;
    @Rule
    public ConditionalIgnoreRule rule = new ConditionalIgnoreRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testCompletionNotification(boolean sync, boolean dispatch) throws Exception {
        NotificationWaiter waiter;
        IStoreCommitCompletionEvent event = binding.createCommitCompletionEvent();
        NotificationWaiter notificationWaiter = waiter = new NotificationWaiter(event);
        synchronized (notificationWaiter) {
            waiter.start();
            waiter.wait();
        }
        event.setNotify(true).setDispatch(dispatch).complete(sync);
        waiter.join();
        this.validate(event, true, dispatch, true, sync, true);
    }

    private final void validate(IStoreCommitCompletionEvent event, boolean notify, boolean dispatch, boolean complete, boolean syncComplete, boolean completionStatus) {
        Assert.assertEquals((Object)event.getNotify(), (Object)notify);
        Assert.assertEquals((Object)event.getDispatch(), (Object)dispatch);
        Assert.assertEquals((Object)event.isComplete(), (Object)complete);
        if (completionStatus) {
            Assert.assertNotNull((Object)event.getCompletionStatus());
        } else {
            Assert.assertNull((Object)event.getCompletionStatus());
        }
    }

    @BeforeClass
    public static void init() throws Exception {
        binding = StoreBindingFactory.getInstance().createBinding("m", StoreDescriptor.create("test"), null);
    }

    @AfterClass
    public static void fin() {
        binding.close(0);
    }

    @Test
    public void testFreshCreate() throws Exception {
        this.validate(binding.createCommitCompletionEvent(), false, false, false, false, false);
    }

    @Test
    public void testSetNotify() throws Exception {
        this.validate(binding.createCommitCompletionEvent().setNotify(true), true, false, false, false, false);
    }

    @Test
    public void testSetDispatch() throws Exception {
        this.validate(binding.createCommitCompletionEvent().setDispatch(true), false, true, false, false, false);
    }

    @Test
    public void testSyncComplete() throws Exception {
        this.validate(binding.createCommitCompletionEvent().complete(true), false, false, true, true, true);
    }

    @Test
    public void testAsyncComplete() throws Exception {
        this.validate(binding.createCommitCompletionEvent().complete(true), false, false, true, false, true);
    }

    @Test
    public void testSetNotifySyncComplete() throws Exception {
        this.validate(binding.createCommitCompletionEvent().setNotify(true).complete(true), true, false, true, true, true);
    }

    @Test
    public void testSetNotifyAsyncComplete() throws Exception {
        this.validate(binding.createCommitCompletionEvent().setNotify(true).complete(false), true, false, true, false, true);
    }

    @Test
    public void testSetDispatchSyncComplete() throws Exception {
        this.validate(binding.createCommitCompletionEvent().setDispatch(true).complete(true), false, true, true, true, true);
    }

    @Test
    public void testSetDispatchAsyncComplete() throws Exception {
        this.validate(binding.createCommitCompletionEvent().setDispatch(true).complete(false), false, true, true, false, true);
    }

    @Test
    public void testNotifyCausesNotification() throws Exception {
        this.testCompletionNotification(false, false);
    }

    @Test
    public void testNotifyOverridesDispatch() throws Exception {
        this.testCompletionNotification(false, true);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=PoolingDisabled.class)
    public void testCreateDisposeCreate() throws Exception {
        IStoreCommitCompletionEvent event1 = binding.createCommitCompletionEvent();
        event1.dispose();
        IStoreCommitCompletionEvent event2 = binding.createCommitCompletionEvent();
        Assert.assertSame((Object)event1, (Object)event2);
        this.validate(event1, false, false, false, false, false);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=PoolingDisabled.class)
    public void testCreateSetNotifyDisposeCreate() throws Exception {
        IStoreCommitCompletionEvent event1 = binding.createCommitCompletionEvent();
        event1.setNotify(true).dispose();
        IStoreCommitCompletionEvent event2 = binding.createCommitCompletionEvent();
        Assert.assertSame((Object)event1, (Object)event2);
        this.validate(event2, false, false, false, false, false);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=PoolingDisabled.class)
    public void testCreateSetDispatchDisposeCreate() throws Exception {
        IStoreCommitCompletionEvent event1 = binding.createCommitCompletionEvent();
        event1.setDispatch(true).dispose();
        IStoreCommitCompletionEvent event2 = binding.createCommitCompletionEvent();
        Assert.assertSame((Object)event1, (Object)event2);
        this.validate(event2, false, false, false, false, false);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=PoolingDisabled.class)
    public void testCreateSetNotifySyncCompleteDisposeCreate() throws Exception {
        IStoreCommitCompletionEvent event1 = binding.createCommitCompletionEvent();
        event1.setNotify(true).complete(true).dispose();
        IStoreCommitCompletionEvent event2 = binding.createCommitCompletionEvent();
        Assert.assertSame((Object)event1, (Object)event2);
        this.validate(event2, false, false, false, true, false);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=PoolingDisabled.class)
    public void testCreateSetNotifyAsyncCompleteDisposeCreate() throws Exception {
        IStoreCommitCompletionEvent event1 = binding.createCommitCompletionEvent();
        event1.setNotify(true).complete(false).dispose();
        IStoreCommitCompletionEvent event2 = binding.createCommitCompletionEvent();
        Assert.assertSame((Object)event1, (Object)event2);
        this.validate(event2, false, false, false, false, false);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=PoolingDisabled.class)
    public void testCreateSetDispatchSyncCompleteDisposeCreate() throws Exception {
        IStoreCommitCompletionEvent event1 = binding.createCommitCompletionEvent();
        event1.setDispatch(true).complete(true).dispose();
        IStoreCommitCompletionEvent event2 = binding.createCommitCompletionEvent();
        Assert.assertSame((Object)event1, (Object)event2);
        this.validate(event2, false, false, false, true, false);
    }

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=PoolingDisabled.class)
    public void testCreateSetDispatchAsyncCompleteDisposeCreate() throws Exception {
        IStoreCommitCompletionEvent event1 = binding.createCommitCompletionEvent();
        event1.setDispatch(true).complete(false).dispose();
        IStoreCommitCompletionEvent event2 = binding.createCommitCompletionEvent();
        Assert.assertSame((Object)event1, (Object)event2);
        this.validate(event2, false, false, false, false, false);
    }

    @Ignore
    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=PoolingDisabled.class)
    public void testCreatePerf() throws Exception {
        CarrierEventProcessor processor = new CarrierEventProcessor();
        RingBuffer ringBuffer = new RingBuffer((EventFactory)new EventFactory<CarrierEvent>(){

            public CarrierEvent newInstance() {
                return new CarrierEvent();
            }
        }, (ClaimStrategy)new SingleThreadedClaimStrategy(1024), (WaitStrategy)new BusySpinWaitStrategy());
        SequenceBarrier sequenceBarrier = ringBuffer.newBarrier(new Sequence[0]);
        BatchEventProcessor batchProcessor = new BatchEventProcessor(ringBuffer, sequenceBarrier, (EventHandler)processor);
        ringBuffer.setGatingSequences(new Sequence[]{batchProcessor.getSequence()});
        new WriterThread((BatchEventProcessor<CarrierEvent>)batchProcessor).start();
        for (int i = 0; i < 100000000; ++i) {
            long sequence = ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)ringBuffer.get(sequence);
            carrierEvent.event = StoreCommitCompletionEvent.create((IStoreBinding)null);
            carrierEvent.publishTs = UtlTime.now();
            ringBuffer.publish(sequence);
            if (i % 100000 != 0) continue;
            System.out.println("..." + i + "(size=" + ringBuffer.remainingCapacity() + ")");
        }
        StringBuilder sb = new StringBuilder();
        processor.stats.compute();
        processor.stats.get(sb);
        System.out.println(sb.toString());
    }

    public final class PoolingDisabled
    implements ConditionalIgnoreRule.IgnoreCondition {
        public final boolean isSatisfied() {
            return !com.neeve.event.EventFactory.getInstance().getEventType((short)303).isPooled();
        }
    }

    private final class NotificationWaiter
    extends Thread {
        private IStoreCommitCompletionEvent event;

        NotificationWaiter(IStoreCommitCompletionEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            NotificationWaiter notificationWaiter = this;
            synchronized (notificationWaiter) {
                this.notify();
            }
            while (true) {
                try {
                    this.event.waitForCompletion();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private final class WriterThread
    extends Thread {
        WriterThread(BatchEventProcessor<CarrierEvent> batchProcessor) {
            super((Runnable)batchProcessor);
            this.setDaemon(true);
        }

        @Override
        public final void run() {
            super.run();
        }
    }

    private final class CarrierEventProcessor
    implements EventHandler<CarrierEvent> {
        final Stats.LatencyManager stats = new Stats.LatencyManager("test", 1000000);

        private CarrierEventProcessor() {
        }

        public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            this.stats.add((double)(UtlTime.now() - event.publishTs));
            event.event.dispose();
        }
    }

    private final class CarrierEvent {
        long publishTs;
        StoreCommitCompletionEvent event;

        private CarrierEvent() {
        }
    }
}

