/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.eaio.uuid.UUID;
import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.MultiThreadedClaimStrategy;
import com.lmax.disruptor.MultiThreadedLowContentionClaimStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreWriter;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.impl.StorePacketPersisterStatsBase;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.Properties;

public abstract class StorePacketPersisterBase
extends OdsObject
implements IStoreWriter {
    private static final boolean captureStoreLatencyStats = UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.ods.latency.stats", (boolean)false);
    private final String id;
    private final SequenceBarrier sequenceBarrier;
    private final CarrierEventProcessor processor;
    private final UtlPool<WriteQueueElement> writeQueueEntryPool;
    private final UtlList writeQueue;
    private final long writerCpuAffinityMask;
    private final boolean detached;
    private final boolean shared;
    private final String claimStrategyStr;
    private final String waitStrategyStr;
    private final IStoreWriter.Parameters parameters;
    private final BatchEventProcessor<CarrierEvent> batchProcessor;
    private final WriterThread writer;
    private StorePacketPersisterStatsBase stats;
    protected final RingBuffer<CarrierEvent> ringBuffer;
    protected final boolean flushOnCommit;
    protected volatile IStoreBinding.Role role;
    protected volatile Exception failure;
    public static final String PROP_DETACHED = "detachedPersist";
    public static final String PROP_DETACHED_QUEUE_DEPTH = "queueDepth";
    public static final String PROP_DETACHED_QUEUE_OFFER_STRATEGY = "queueOfferStrategy";
    public static final String PROP_DETACHED_QUEUE_WAIT_STRATEGY = "queueWaitStrategy";
    public static final String PROP_DETACHED_QUEUE_DRAINER_CPU_AFFINITIZATION_MASK = "queueDrainerCpuAffinityMask";
    public static final String PROP_SHARED = "shared";
    public static final String PROP_FLUSH_ON_COMMIT = "flushOnCommit";

    protected StorePacketPersisterBase(RootConfig.ObjectConfig config, String idSuffix, Properties props) {
        super(config);
        this.id = "X-ODS-Store" + idSuffix;
        boolean administrative = UtlProps.getValue((Properties)props, (String)"administrative", (boolean)false);
        boolean bl = this.detached = UtlProps.getValue((Properties)props, (String)PROP_DETACHED, (String)UtlProps.getValue((Properties)props, (String)"detachedWrite", (String)UtlProps.getValue((Properties)props, (String)"detachedSend", null))) == null && !administrative && (XRuntime.optimizeForLatency() || XRuntime.optimizeForThroughput()) ? true : UtlProps.getValue((Properties)props, (String)PROP_DETACHED, (boolean)UtlProps.getValue((Properties)props, (String)"detachedWrite", (boolean)UtlProps.getValue((Properties)props, (String)"detachedSend", (boolean)false)));
        if (this.detached) {
            int queueDepth = UtlProps.getValue((Properties)props, (String)PROP_DETACHED_QUEUE_DEPTH, (int)1024);
            SingleThreadedClaimStrategy claimStrategy = null;
            String string = XRuntime.optimizeForLatency() ? "SingleThreaded" : (this.claimStrategyStr = XRuntime.optimizeForThroughput() ? "MultiThreadedSufficientCores" : UtlProps.getValue((Properties)props, (String)"publisherClaimStrategy", (String)UtlProps.getValue((Properties)props, (String)PROP_DETACHED_QUEUE_OFFER_STRATEGY, (String)"MultiThreaded")));
            if (this.claimStrategyStr.equalsIgnoreCase("SingleThreaded")) {
                claimStrategy = new SingleThreadedClaimStrategy(queueDepth);
            } else if (this.claimStrategyStr.equalsIgnoreCase("MultiThreaded")) {
                claimStrategy = new MultiThreadedClaimStrategy(queueDepth);
            } else if (this.claimStrategyStr.equalsIgnoreCase("MultiThreadedSufficientCores")) {
                claimStrategy = new MultiThreadedLowContentionClaimStrategy(queueDepth);
            } else {
                throw new IllegalArgumentException("invalid publisher claim strategy '" + this.claimStrategyStr + "'");
            }
            WaitStrategy waitStrategy = XRuntime.createWaitStrategy((String)UtlProps.getValue((Properties)props, (String)"writerWaitStrategy", (String)UtlProps.getValue((Properties)props, (String)PROP_DETACHED_QUEUE_WAIT_STRATEGY, null)), (!administrative ? 1 : 0) != 0);
            if (waitStrategy instanceof BlockingWaitStrategy) {
                this.waitStrategyStr = "Blocking";
            } else if (waitStrategy instanceof SleepingWaitStrategy) {
                this.waitStrategyStr = "Sleeping";
            } else if (waitStrategy instanceof YieldingWaitStrategy) {
                this.waitStrategyStr = "Yielding";
            } else if (waitStrategy instanceof BusySpinWaitStrategy) {
                this.waitStrategyStr = "BusySpin";
            } else {
                throw new IllegalArgumentException("invalid writer wait strategy '" + waitStrategy + "'");
            }
            this.writerCpuAffinityMask = UtlThread.parseAffinityMask((String)UtlProps.getValue((Properties)props, (String)"cpuAffinityMask", (String)UtlProps.getValue((Properties)props, (String)PROP_DETACHED_QUEUE_DRAINER_CPU_AFFINITIZATION_MASK, (String)"0")));
            if (this.tracer.isEnabled(Tracer.Level.CONFIG)) {
                this.tracer.log("[" + idSuffix + "]...operating in detached mode (asynchronous writes)...", Tracer.Level.CONFIG);
                this.tracer.log("[" + idSuffix + "]......queue depth=" + queueDepth + ".", Tracer.Level.CONFIG);
                this.tracer.log("[" + idSuffix + "]......queue offer strategy=" + this.claimStrategyStr + ".", Tracer.Level.CONFIG);
                this.tracer.log("[" + idSuffix + "]......queue wait strategy=" + this.waitStrategyStr + ".", Tracer.Level.CONFIG);
                this.tracer.log("[" + idSuffix + "]......queue drainer cpu affinity=" + this.writerCpuAffinityMask + ".", Tracer.Level.CONFIG);
            }
            this.processor = new CarrierEventProcessor();
            this.ringBuffer = new RingBuffer((EventFactory)new EventFactory<CarrierEvent>(){

                public CarrierEvent newInstance() {
                    return new CarrierEvent();
                }
            }, (ClaimStrategy)claimStrategy, waitStrategy);
            this.sequenceBarrier = UtlThread.asIntrumentedSequenceBarrier((SequenceBarrier)this.ringBuffer.newBarrier(new Sequence[0]));
            this.batchProcessor = new BatchEventProcessor(this.ringBuffer, this.sequenceBarrier, (EventHandler)this.processor);
            this.ringBuffer.setGatingSequences(new Sequence[]{this.batchProcessor.getSequence()});
            this.writer = new WriterThread(this.id, this.batchProcessor);
            this.writer.start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            if (this.tracer.isEnabled(Tracer.Level.CONFIG)) {
                this.tracer.log("[" + idSuffix + "]...operating in attached mode...", Tracer.Level.CONFIG);
            }
            this.writerCpuAffinityMask = 0L;
            this.claimStrategyStr = "N/A";
            this.waitStrategyStr = "N/A";
            this.processor = null;
            this.ringBuffer = null;
            this.writer = null;
            this.sequenceBarrier = null;
            this.batchProcessor = null;
        }
        this.writeQueue = UtlList.create();
        this.writeQueueEntryPool = UtlPool.create((String)"ods.pktjrnlr.writeq", (String)new UUID().toString(), (UtlPool.Factory)new WriteQueueElementFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.shared = UtlProps.getValue((Properties)props, (String)PROP_SHARED, (boolean)false);
        this.flushOnCommit = UtlProps.getValue((Properties)props, (String)PROP_FLUSH_ON_COMMIT, (boolean)false);
        this.parameters = new IStoreWriter.Parameters(this.detached);
    }

    protected StorePacketPersisterBase(String idSuffix, Properties props) {
        this(null, idSuffix, props);
    }

    private final String commitEntryTypeToStr(short commitEntryType) {
        switch (commitEntryType) {
            case 1: {
                return "Put";
            }
            case 2: {
                return "Update";
            }
            case 3: {
                return "Remove";
            }
            case 4: {
                return "Send";
            }
            case 5: {
                return "Message";
            }
        }
        return "Unknown";
    }

    protected final void dumpStackTraceBeforeFail(String str, Throwable e) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(str).append("\n");
            sb.append("Stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Failing persister...\n");
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void pruneWriteQueue(long stableTransactionId) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Pruning write queue (size=" + this.writeQueue.count() + ", stable transaction id=" + stableTransactionId + ")...", Tracer.Level.DEBUG);
        }
        WriteQueueElement wqe = null;
        int count = 0;
        while ((wqe = (WriteQueueElement)this.writeQueue.first()) != null && wqe.transactionId <= stableTransactionId) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "...X " + (Object)((Object)wqe) + "", Tracer.Level.DEBUG);
            }
            wqe.unlink();
            wqe.dispose();
            ++count;
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "...pruned " + count + " entries.", Tracer.Level.DEBUG);
        }
    }

    private final void flushWriteQueue() throws Exception {
        WriteQueueElement wqe = null;
        int count = 0;
        while ((wqe = (WriteQueueElement)this.writeQueue.first()) != null) {
            wqe.unlink();
            try {
                this.doWrite(wqe.packet);
            }
            finally {
                wqe.dispose();
            }
            ++count;
        }
        this.tracer.log(this.tracePrefix() + "Flushed " + count + " in-doubt entries from write queue", Tracer.Level.INFO);
    }

    private final void write(PktPacket packet, long transactionId, long stableTransactionId, boolean commitEnd) throws Exception {
        if (packet != null) {
            packet.getHeader().getODSSubheader().setTimestamp(System.currentTimeMillis());
        }
        if (this.role == IStoreBinding.Role.Primary || !this.shared) {
            if (this.writeQueue.count() > 0) {
                this.flushWriteQueue();
            }
            this.doWrite(packet);
        } else {
            WriteQueueElement wqe = (WriteQueueElement)this.writeQueueEntryPool.get(null);
            packet.acquire();
            wqe.packet = packet;
            wqe.transactionId = transactionId;
            wqe.stableTransactionId = stableTransactionId;
            this.writeQueue.append((UtlListElement)wqe);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "Enqueued " + (Object)((Object)wqe) + " in write queue", Tracer.Level.DEBUG);
            }
            if (commitEnd) {
                this.pruneWriteQueue(stableTransactionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write(StoreCommitEntry commitEntry, boolean sync) {
        try {
            commitEntry.checkAndPrepareSerializedObjectForWrite();
            if (commitEntry.serializedPersisterMetadata.getLength() > 0) {
                this.doWritePersisterMetadata(commitEntry.serializedPersisterMetadata);
            }
            this.write(commitEntry.serializedObject, commitEntry.transactionId, commitEntry.stableTransactionId, commitEntry.commitEnd);
            if (commitEntry.commitEnd && this.flushOnCommit || sync) {
                this.flush(sync);
            }
            if (this.stats != null) {
                switch (commitEntry.operation) {
                    case Put: {
                        ++this.stats.numPutsRecorded;
                        break;
                    }
                    case Update: {
                        ++this.stats.numUpdatesRecorded;
                        break;
                    }
                    case Remove: {
                        ++this.stats.numRemovesRecorded;
                        break;
                    }
                    case Send: {
                        ++this.stats.numSendsRecorded;
                        break;
                    }
                }
            }
            if (commitEntry.commitEnd) {
                ++this.stats.numCommits;
            }
        }
        catch (Throwable e) {
            this.dumpStackTraceBeforeFail("Exception encountered during write of commit entry", e);
            this.doFail(new OdsException(e));
        }
        finally {
            commitEntry.dispose();
        }
    }

    private final void flush(boolean sync) {
        if (this.role == IStoreBinding.Role.Primary || !this.shared) {
            try {
                if (this.writeQueue.count() > 0) {
                    this.flushWriteQueue();
                }
                this.doFlush(sync);
            }
            catch (Throwable e) {
                this.dumpStackTraceBeforeFail("Exception encountered during flush", e);
                this.doFail(new OdsException(e));
            }
        }
    }

    private final void stopCore() {
        this.writeQueueEntryPool.close();
        if (this.stats != null) {
            this.stats.close();
        }
    }

    protected final boolean isDetached() {
        return this.detached;
    }

    final int getWriteQueueSize() {
        return this.writeQueue.count;
    }

    final int getDisruptorCapacity() {
        return this.ringBuffer != null ? this.ringBuffer.getBufferSize() : -1;
    }

    final int getDisruptorRemaining() {
        return this.ringBuffer != null ? (int)this.ringBuffer.remainingCapacity() : -1;
    }

    final String getDisruptorClaimStrategy() {
        return this.claimStrategyStr;
    }

    final String getDisruptorWaitStrategy() {
        return this.waitStrategyStr;
    }

    protected final void setStats(StorePacketPersisterStatsBase stats) {
        this.stats = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scheduleFlush(boolean sync) {
        if (this.ringBuffer != null) {
            long sequence = this.ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
            carrierEvent.write = false;
            carrierEvent.flush = true;
            carrierEvent.sync = sync;
            carrierEvent.publishTs = captureStoreLatencyStats ? UtlTime.now() : 0L;
            this.ringBuffer.publish(sequence);
        } else {
            StorePacketPersisterBase storePacketPersisterBase = this;
            synchronized (storePacketPersisterBase) {
                this.flush(sync);
            }
        }
    }

    protected void doChangeRole(IStoreBinding.Role role) {
        this.role = role;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Role changed to '" + (Object)((Object)role) + "'", Tracer.Level.DEBUG);
        }
    }

    protected abstract void doWritePersisterMetadata(PktBuffer var1) throws Exception;

    protected abstract void doWrite(PktPacket var1) throws Exception;

    protected abstract void doFlush(boolean var1) throws Exception;

    protected abstract void doFail(Exception var1);

    protected abstract String tracePrefix();

    protected final boolean depacketize(PktPacket packet, StoreCommitEntry commitEntry) throws OdsException {
        PktSubheaderODS subheaderODS = packet.getHeader().getODSSubheader();
        if (subheaderODS == null) {
            throw new OdsException("received invalid packet [no ODS subheader]");
        }
        short commitEntryType = subheaderODS.getCommitEntryType();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "...commit entry (type=" + this.commitEntryTypeToStr(commitEntryType) + ").", Tracer.Level.DEBUG);
        }
        if (commitEntryType != 5) {
            commitEntry.init(packet);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "......{id=" + (commitEntry.id != null ? commitEntry.id.toString() : "null") + ", ofid=" + commitEntry.ofid + ", otype=" + commitEntry.otype + ", encoding=" + (Object)((Object)commitEntry.contentEncodingType) + ").", Tracer.Level.DEBUG);
            }
            return true;
        }
        return false;
    }

    protected final void stop() {
        if (this.ringBuffer != null) {
            if (this.writer.isAlive()) {
                long sequence = this.ringBuffer.next();
                CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
                carrierEvent.stop = true;
                this.ringBuffer.publish(sequence);
            }
            if (this.writer != Thread.currentThread()) {
                while (this.writer.isAlive()) {
                    try {
                        this.writer.join(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            UtlThread.deregister((Thread)this.writer);
        } else {
            this.stopCore();
        }
    }

    protected final void onFailure(Exception cause) {
        this.failure = cause;
    }

    @Override
    public final IStoreWriter.Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public final boolean isShared() {
        return this.shared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onRoleChange(IStoreBinding.Role role) {
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Received role change event (role=" + (Object)((Object)role) + ")...", Tracer.Level.DEBUG);
        }
        if (this.ringBuffer != null) {
            long sequence = this.ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
            carrierEvent.role = role;
            carrierEvent.publishTs = captureStoreLatencyStats ? UtlTime.now() : 0L;
            this.ringBuffer.publish(sequence);
        } else {
            StorePacketPersisterBase storePacketPersisterBase = this;
            synchronized (storePacketPersisterBase) {
                this.doChangeRole(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeCommitEntry(StoreCommitEntry commitEntry, boolean isSerializedObjectMutable, boolean sync) {
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Committing (sync=" + sync + ", detached=" + (this.ringBuffer != null) + ")...", Tracer.Level.DEBUG);
        }
        if (this.ringBuffer != null) {
            long offerTime = captureStoreLatencyStats ? UtlTime.now() : 0L;
            long sequence = this.ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
            carrierEvent.publishTs = offerTime;
            carrierEvent.commitEntry.init(commitEntry).prepareForDetachedWrite(isSerializedObjectMutable);
            if (isSerializedObjectMutable) {
                ++this.stats.numForks;
            }
            carrierEvent.write = true;
            carrierEvent.flush = false;
            carrierEvent.sync = sync;
            this.ringBuffer.publish(sequence);
        } else {
            StorePacketPersisterBase storePacketPersisterBase = this;
            synchronized (storePacketPersisterBase) {
                this.write(commitEntry, sync);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sync() {
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Syncing (detached=" + (this.ringBuffer != null) + ")...", Tracer.Level.DEBUG);
        }
        if (this.ringBuffer != null) {
            long sequence = this.ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
            carrierEvent.publishTs = captureStoreLatencyStats ? UtlTime.now() : 0L;
            carrierEvent.write = false;
            carrierEvent.sync = true;
            this.ringBuffer.publish(sequence);
        } else {
            StorePacketPersisterBase storePacketPersisterBase = this;
            synchronized (storePacketPersisterBase) {
                this.flush(true);
            }
        }
    }

    protected final class CarrierEvent {
        public long publishTs;
        public IStoreBinding.Role role;
        public final StoreCommitEntry commitEntry = StoreCommitEntry.create();
        public boolean write;
        public boolean flush;
        public boolean sync;
        public boolean stop;

        final void reset() {
            this.publishTs = 0L;
            this.role = null;
            this.write = false;
            this.flush = false;
            this.sync = false;
            this.stop = false;
        }
    }

    private final class CarrierEventProcessor
    implements EventHandler<CarrierEvent> {
        private CarrierEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                if (event.stop) {
                    StorePacketPersisterBase.this.batchProcessor.halt();
                    StorePacketPersisterBase.this.stopCore();
                } else if (StorePacketPersisterBase.this.failure == null) {
                    if (StorePacketPersisterBase.this.stats != null && event.publishTs > 0L) {
                        ((StorePacketPersisterBase)StorePacketPersisterBase.this).stats.o2p.add((double)(UtlTime.now() - event.publishTs));
                    }
                    if (event.role != null) {
                        StorePacketPersisterBase.this.doChangeRole(event.role);
                    }
                    if (event.write) {
                        StorePacketPersisterBase.this.write(event.commitEntry, event.sync);
                        event.commitEntry.fin();
                    }
                    if (event.flush || event.sync) {
                        StorePacketPersisterBase.this.flush(event.sync);
                    }
                }
            }
            catch (Throwable e) {
                StorePacketPersisterBase.this.dumpStackTraceBeforeFail("Unhandled exception encountered in detached persister", e);
                StorePacketPersisterBase.this.doFail(new OdsException(e));
            }
            finally {
                event.reset();
            }
        }
    }

    private final class WriterThread
    extends Thread {
        WriterThread(String name, BatchEventProcessor<CarrierEvent> batchProcessor) {
            super((Runnable)batchProcessor);
            this.setDaemon(true);
            this.setName(name);
        }

        @Override
        public final void run() {
            UtlThread.setCPUAffinityMask((long)StorePacketPersisterBase.this.writerCpuAffinityMask);
            super.run();
        }
    }

    private final class WriteQueueElementFactory
    implements UtlPool.Factory<WriteQueueElement> {
        private WriteQueueElementFactory() {
        }

        public final WriteQueueElement createItem(Object object) {
            return new WriteQueueElement();
        }

        public final WriteQueueElement[] createItemArray(int size) {
            return new WriteQueueElement[size];
        }
    }

    private final class WriteQueueElement
    extends UtlListElement
    implements UtlPool.Item<WriteQueueElement> {
        private PktPacket packet;
        private long transactionId;
        private long stableTransactionId;
        private UtlPool<WriteQueueElement> pool;

        private WriteQueueElement() {
        }

        final void dispose() {
            if (this.packet != null) {
                this.packet.dispose();
            }
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }

        public final WriteQueueElement init() {
            this.packet = null;
            this.transactionId = 0L;
            this.stableTransactionId = 0L;
            return this;
        }

        public final WriteQueueElement setPool(UtlPool<WriteQueueElement> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<WriteQueueElement> getPool() {
            return this.pool;
        }

        public final String toString() {
            return "[packet=" + this.packet.getBody().getClass().getSimpleName() + ", txnid=" + this.transactionId + ", stbltxnid=" + this.stableTransactionId + "]";
        }
    }
}

