/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.event.Event;
import com.neeve.event.EventFactory;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectAddedEvent;
import com.neeve.ods.impl.StoreEvent;
import java.util.Properties;

public final class StoreObjectAddedEvent
extends StoreEvent
implements IStoreObjectAddedEvent {
    private IStoreObject object;
    private long transactionId;
    private long stableTransactionId;
    private boolean commitEnd;

    private StoreObjectAddedEvent() {
        super((short)307);
    }

    public static Event create(Properties props) {
        return new StoreObjectAddedEvent();
    }

    public static StoreObjectAddedEvent create(IStoreBinding binding, IStoreObject object, long transactionId, long stableTransactionId, boolean commitEnd) {
        return ((StoreObjectAddedEvent)EventFactory.getInstance().createEvent((short)307)).init(binding, object, transactionId, stableTransactionId, commitEnd);
    }

    private final StoreObjectAddedEvent init(IStoreBinding binding, IStoreObject object, long transactionId, long stableTransactionId, boolean commitEnd) {
        super.init(binding);
        this.object = object;
        this.transactionId = transactionId;
        this.stableTransactionId = stableTransactionId;
        this.commitEnd = commitEnd;
        return this;
    }

    @Override
    protected final void reset() {
        this.object = null;
        this.transactionId = 0L;
        this.stableTransactionId = 0L;
        this.commitEnd = false;
    }

    protected final void preDispose() {
        if (this.object != null) {
            this.object.dispose();
        }
    }

    @Override
    public final IStoreObject getObject() {
        return this.object;
    }

    @Override
    public final long getTransactionId() {
        return this.transactionId;
    }

    @Override
    public final long getStableTransactionId() {
        return this.stableTransactionId;
    }

    @Override
    @Deprecated
    public final boolean isEndOfCommit() {
        return this.commitEnd;
    }

    @Override
    public final boolean isCommitEnd() {
        return this.commitEnd;
    }
}

