/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.eaio.uuid.UUID;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreObject;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;

public final class StoreCommitEntry {
    public IStoreBinding.Operation operation;
    public UUID id;
    public short ofid;
    public short otype;
    public long transactionId;
    public long stableTransactionId;
    public long checkpointVersion;
    public IStoreObject object;
    public PktPacket serializedObject;
    private boolean serializedObjectAcquired;
    private boolean objectAcquired;
    public IStoreObject.EncodingType contentEncodingType;
    public PktBuffer serializedMetadata;
    public final PktBuffer serializedPersisterMetadata = PktBuffer.create(null, (int)1, (boolean)true);
    public boolean commitStart;
    public boolean commitEnd;

    private StoreCommitEntry() {
    }

    public static final StoreCommitEntry create() {
        return new StoreCommitEntry();
    }

    private final int fromStoreOperation(IStoreBinding.Operation operation) {
        switch (operation) {
            case Put: {
                return 8;
            }
            case Update: {
                return 16;
            }
            case Send: {
                return 64;
            }
            case Remove: {
                return 32;
            }
        }
        throw new RuntimeException("unknown store operation [" + (Object)((Object)operation) + "]");
    }

    private final IStoreBinding.Operation toStoreOperation(PktSubheaderODS subheaderODS) {
        switch (subheaderODS.getCommitEntryType()) {
            case 1: {
                return IStoreBinding.Operation.Put;
            }
            case 2: {
                return IStoreBinding.Operation.Update;
            }
            case 3: {
                return IStoreBinding.Operation.Remove;
            }
            case 4: {
                return IStoreBinding.Operation.Send;
            }
        }
        throw new RuntimeException("unknown packet entry type");
    }

    private final void prepareSerializedObjectForWrite() {
        PktHeader header = this.serializedObject.getHeader();
        if (this.operation != IStoreBinding.Operation.Send || header.getODSSubheader() == null) {
            int serializedMetadataLength;
            PktSubheaderODS subheaderODS = header.activateODSSubheader(false);
            int flags = this.fromStoreOperation(this.operation);
            if (this.commitStart) {
                flags |= 2;
            }
            if (this.commitEnd) {
                flags |= 1;
            }
            if ((serializedMetadataLength = this.object.getSerializedMetadataLength()) > 0) {
                int offset = subheaderODS.prepareForObjectMetadataCopy(serializedMetadataLength);
                this.serializedMetadata = subheaderODS.getObjectMetadata();
                this.object.serializeMetadata((IOElasticBuffer)this.serializedMetadata, offset);
            }
            if (this.commitStart && this.serializedPersisterMetadata.getLength() > 0) {
                subheaderODS.copyPersisterMetadataFrom((IOElasticBuffer)this.serializedPersisterMetadata);
            }
            PktSubheaderODS.prepare((PktPacket)this.serializedObject, (UUID)this.id, (short)this.ofid, (short)this.otype, (short)((short)(this.contentEncodingType == null ? 0 : this.contentEncodingType.toMessageViewEncoding())), (long)this.transactionId, (long)this.stableTransactionId, (long)this.checkpointVersion, (long)System.currentTimeMillis(), (byte)((byte)flags));
        }
    }

    public final StoreCommitEntry init(IStoreBinding.Operation operation, UUID id, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, IStoreObject object, PktPacket serializedObject, IStoreObject.EncodingType contentEncodingType, boolean commitStart, boolean commitEnd) {
        this.operation = operation;
        this.id = id;
        this.ofid = ofid;
        this.otype = otype;
        this.transactionId = transactionId;
        this.stableTransactionId = stableTransactionId;
        this.checkpointVersion = checkpointVersion;
        this.object = object;
        this.serializedObject = serializedObject;
        this.serializedObjectAcquired = false;
        this.contentEncodingType = contentEncodingType == IStoreObject.EncodingType.Xbuf2 ? IStoreObject.EncodingType.Protobuf : contentEncodingType;
        this.commitStart = commitStart;
        this.commitEnd = commitEnd;
        if (serializedObject != null) {
            this.prepareSerializedObjectForWrite();
        }
        return this;
    }

    public final StoreCommitEntry init(PktPacket serializedObject) {
        PktSubheaderODS subheaderODS = serializedObject.getHeader().getODSSubheader();
        this.operation = this.toStoreOperation(subheaderODS);
        this.id = subheaderODS.getObjectId();
        this.ofid = subheaderODS.getObjectFactoryId();
        this.otype = subheaderODS.getObjectType();
        this.transactionId = subheaderODS.getTransactionId();
        this.stableTransactionId = subheaderODS.getStableTransactionId();
        this.checkpointVersion = subheaderODS.getCheckpointVersion();
        this.object = null;
        this.serializedObject = serializedObject;
        this.serializedObjectAcquired = false;
        this.contentEncodingType = IStoreObject.EncodingType.fromMessageViewEncoding(subheaderODS.getContentEncodingType());
        this.commitStart = subheaderODS.getFlagCommitStart();
        this.commitEnd = subheaderODS.getFlagCommitEnd();
        this.serializedMetadata = subheaderODS.getObjectMetadata();
        PktBuffer persisterMetadata = subheaderODS.getPersisterMetadata();
        if (persisterMetadata != null && persisterMetadata.getLength() > 0) {
            this.serializedPersisterMetadata.putFrom(0, (IOElasticBuffer)persisterMetadata, 0, persisterMetadata.getLength());
        }
        return this;
    }

    public final StoreCommitEntry init(StoreCommitEntry commitEntry) {
        this.operation = commitEntry.operation;
        this.id = commitEntry.id;
        this.ofid = commitEntry.ofid;
        this.otype = commitEntry.otype;
        this.transactionId = commitEntry.transactionId;
        this.stableTransactionId = commitEntry.stableTransactionId;
        this.checkpointVersion = commitEntry.checkpointVersion;
        this.object = commitEntry.object;
        this.serializedObject = commitEntry.serializedObject;
        this.serializedObjectAcquired = commitEntry.serializedObjectAcquired;
        this.contentEncodingType = commitEntry.contentEncodingType;
        this.commitStart = commitEntry.commitStart;
        this.commitEnd = commitEntry.commitEnd;
        this.serializedMetadata = commitEntry.serializedMetadata;
        if (commitEntry.serializedPersisterMetadata.getLength() > 0) {
            this.serializedPersisterMetadata.putFrom(0, (IOElasticBuffer)commitEntry.serializedPersisterMetadata, 0, commitEntry.serializedPersisterMetadata.getLength());
        }
        return this;
    }

    public final StoreCommitEntry commitEnd() {
        this.commitEnd = true;
        this.serializedObject.getHeader().getODSSubheader().setFlagCommitEnd(true);
        return this;
    }

    public final StoreCommitEntry checkAndPrepareSerializedObjectForWrite() {
        if (this.serializedObject == null) {
            this.serializedObject = this.object.serialize();
            this.serializedObjectAcquired = true;
            this.prepareSerializedObjectForWrite();
        }
        return this;
    }

    public final StoreCommitEntry prepareForDetachedWrite(boolean concurrentReadWrite) {
        if (this.serializedObject == null && concurrentReadWrite) {
            throw new IllegalStateException("detached serialization is not supported for concurrent read write");
        }
        if (this.serializedObject != null) {
            if (concurrentReadWrite) {
                this.serializedObject = this.serializedObject.fork(true);
            } else {
                this.serializedObject.acquire();
            }
            this.serializedObjectAcquired = true;
        }
        if (this.object != null) {
            this.object.acquire();
            this.objectAcquired = true;
        }
        return this;
    }

    public final void dispose() {
        if (this.serializedObjectAcquired) {
            this.serializedObject.dispose();
            this.serializedObjectAcquired = false;
        }
        if (this.objectAcquired && this.object != null) {
            this.object.dispose();
            this.objectAcquired = false;
        }
    }

    public final void fin() {
        this.object = null;
        this.serializedObject = null;
        this.serializedMetadata = null;
        this.serializedPersisterMetadata.setLength(0);
    }
}

