/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.blog.test.unit;

import com.neeve.blog.Blogger;
import com.neeve.blog.test.Factory;
import com.neeve.blog.test.TestObject;
import com.neeve.rog.IRogNode;
import java.io.File;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public final class BloggerTest {
    private Blogger _blogger;
    @Rule
    public TestName _name = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Tailer startTailing() throws Exception {
        Tailer tailer = new Tailer(new TailListener());
        tailer.start();
        Tailer tailer2 = tailer;
        synchronized (tailer2) {
            while (!tailer._started) {
                tailer.wait();
            }
        }
        return tailer;
    }

    private final void log(int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            TestObject object = TestObject.create();
            object.setVal(i);
            this._blogger.log(object);
        }
    }

    private final void logAndWait(int count, TailListener listener) throws Exception {
        this.log(count);
        listener.waitUntil(count - 1);
    }

    @Before
    public void before() {
        this._blogger = Blogger.create(UUID.randomUUID().toString()).registerFactory(new Factory());
    }

    @After
    public void after() {
        if (this._blogger != null) {
            this._blogger.close();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testSetLocationOnOpenBlogger() throws Exception {
        this._blogger.open();
        this._blogger.setLocation("test");
    }

    @Test(expected=IllegalStateException.class)
    public void testSetMaxLogSizeOnOpenBlogger() throws Exception {
        this._blogger.open();
        this._blogger.setMaxLogSize(100);
    }

    @Test(expected=IllegalStateException.class)
    public void testOpenOnOpenBlogger() throws Exception {
        this._blogger.open();
        this._blogger.open();
    }

    @Test
    public void testSetMaxLogSize() throws Exception {
        Assert.assertEquals((long)1024L, (long)this._blogger.getMaxLogSize());
        Assert.assertEquals((long)100L, (long)this._blogger.setMaxLogSize(100).getMaxLogSize());
    }

    @Test
    public void testSetLocation() throws Exception {
        Assert.assertNull((Object)this._blogger.getLocation());
        this._blogger.setLocation("test");
        this._blogger.open();
        Assert.assertTrue((boolean)new File("test" + File.separator + this._blogger.getName() + ".log").exists());
    }

    @Test
    public void testLogAndTail() throws Exception {
        this._blogger.open();
        Tailer tailer = this.startTailing();
        this.logAndWait(100, tailer._listener);
    }

    @Test
    public void testOpenCloseOpen() throws Exception {
        this._blogger.open();
        Tailer tailer = this.startTailing();
        this.logAndWait(2, tailer._listener);
        this._blogger.close();
        this._blogger.open();
        tailer = this.startTailing();
        this.logAndWait(2, tailer._listener);
        tailer._listener.waitUntil(2);
    }

    @Test
    public void testCloseShutsDownTailing() throws Exception {
        this._blogger.open();
        Tailer tailer = this.startTailing();
        Thread.sleep(100L);
        this._blogger.close();
        tailer.join(5000L);
        Assert.assertFalse((boolean)tailer.isAlive());
    }

    private final class TailListener
    implements Blogger.TailListener {
        int count;

        private TailListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitUntil(int expectedCount) {
            try {
                TailListener tailListener = this;
                synchronized (tailListener) {
                    long remaining;
                    long ts = System.currentTimeMillis();
                    while (this.count < expectedCount && (remaining = 5000L - (System.currentTimeMillis() - ts)) > 0L) {
                        this.wait(remaining);
                    }
                }
            }
            catch (Throwable e) {
                System.err.println("Error waiting: " + e.getMessage());
            }
            Assert.assertEquals((long)expectedCount, (long)this.count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onObject(IRogNode object) {
            TailListener tailListener = this;
            synchronized (tailListener) {
                ++this.count;
                this.notifyAll();
            }
        }
    }

    private final class Tailer
    extends Thread {
        final TailListener _listener;
        boolean _started;

        Tailer(TailListener listener) {
            this._listener = listener;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                Tailer tailer = this;
                synchronized (tailer) {
                    this._started = true;
                    this.notifyAll();
                }
                BloggerTest.this._blogger.tail(this._listener);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

