/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit;

import com.neeve.adm.test.unit.AdmGeneratedCodeTest;
import com.neeve.adm.test.unit.proto.Child1;
import com.neeve.adm.test.unit.proto.Child3;
import com.neeve.adm.test.unit.proto.Factory;
import com.neeve.adm.test.unit.proto.Message;
import com.neeve.ci.XRuntime;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.test.UnitTest;
import java.util.Properties;
import java.util.Random;
import org.junit.Ignore;
import org.junit.Test;

public class AdmLargeMessageTest
extends UnitTest {
    @Test
    public void testLargeEntityProtobuf() {
        Random random = new Random();
        byte[] largeArray = new byte[0x8000000];
        int[] probeOffsets = new int[]{0, 1, 10, largeArray.length - 1};
        for (int i = 0; i < probeOffsets.length; ++i) {
            largeArray[probeOffsets[i]] = (byte)random.nextInt();
        }
        Child1 entity = Child1.create();
        entity.setByteArrayField(largeArray);
        entity.sync();
        long start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from PktPacket doesn't match.", largeArray, Factory.createChild1FromSerializedProtoMessage(entity.serialize()).getByteArrayField(), probeOffsets);
        System.out.println("Tested PktPacket in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from byte [] doesn't match.", largeArray, Factory.createChild1FromSerializedProtoMessage(entity.serializeToByteArray()).getByteArrayField(), probeOffsets);
        System.out.println("Tested byte [] in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from ByteBuffer doesn't match.", largeArray, Factory.createChild1FromSerializedProtoMessage(entity.serializeToByteBuffer()).getByteArrayField(), probeOffsets);
        System.out.println("Tested ByteBuffer in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from proto doesn't match.", largeArray, Factory.createChild1FromProtoMessage(entity.serializeToProtobuf()).getByteArrayField(), probeOffsets);
        System.out.println("Tested protobuf in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from json doesn't match.", largeArray, Factory.createChild1FromJson(entity.serializeToJson()).getByteArrayField(), probeOffsets);
        System.out.println("Tested json in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from raw json doesn't match.", largeArray, Factory.createChild1FromRawJson(entity.serializeToRawJson()).getByteArrayField(), probeOffsets);
        System.out.println("Tested raw json in " + (System.currentTimeMillis() - start) + "ms.");
    }

    @Test
    public void testLargeEmbeddedEntityProtobuf() {
        Random random = new Random();
        byte[] largeArray = new byte[0x8000000];
        int[] probeOffsets = new int[]{0, 1, 10, largeArray.length - 1};
        for (int i = 0; i < probeOffsets.length; ++i) {
            largeArray[probeOffsets[i]] = (byte)random.nextInt();
        }
        Child3 entity = Child3.create();
        entity.setByteArrayField(largeArray);
        entity.sync();
        long start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from byte [] doesn't match.", largeArray, Child3.createFromSerializedProtoMessage(entity.serializeToByteArray()).getByteArrayField(), probeOffsets);
        System.out.println("Tested byte [] in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from ByteBuffer doesn't match.", largeArray, Child3.createFromSerializedProtoMessage(entity.serializeToByteBuffer()).getByteArrayField(), probeOffsets);
        System.out.println("Tested ByteBuffer in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from proto doesn't match.", largeArray, Child3.createFromProtoMessage(entity.message()).getByteArrayField(), probeOffsets);
        System.out.println("Tested protobuf in " + (System.currentTimeMillis() - start) + "ms.");
    }

    @Test
    @Ignore(value="Too slow")
    public void testLargeMessageXbuf() {
        Random random = new Random();
        byte[] largeArray = new byte[0x8000000];
        int[] probeOffsets = new int[]{0, 1, 10, largeArray.length - 1};
        for (int i = 0; i < probeOffsets.length; ++i) {
            largeArray[probeOffsets[i]] = (byte)random.nextInt();
        }
        com.neeve.adm.test.unit.xbuf.Message message = com.neeve.adm.test.unit.xbuf.Message.create();
        message.setByteArrayField(largeArray);
        message.sync();
        long start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from byte [] doesn't match.", largeArray, com.neeve.adm.test.unit.xbuf.Factory.createMessageFromSerializedXbufContainer(message.serializeToByteArray()).getByteArrayField(), probeOffsets);
        System.out.println("Tested byte [] in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from ByteBuffer doesn't match.", largeArray, com.neeve.adm.test.unit.xbuf.Factory.createMessageFromSerializedXbufContainer(message.serializeToByteBuffer()).getByteArrayField(), probeOffsets);
        System.out.println("Tested ByteBuffer in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from json doesn't match.", largeArray, com.neeve.adm.test.unit.xbuf.Factory.createMessageFromJson(message.serializeToJson()).getByteArrayField(), probeOffsets);
        System.out.println("Tested json in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from raw json doesn't match.", largeArray, com.neeve.adm.test.unit.xbuf.Factory.createMessageFromRawJson(message.serializeToRawJson()).getByteArrayField(), probeOffsets);
        System.out.println("Tested raw json in " + (System.currentTimeMillis() - start) + "ms.");
    }

    @Test
    public void testLargeMessageProtobuf() {
        Random random = new Random();
        byte[] largeArray = new byte[0x8000000];
        int[] probeOffsets = new int[]{0, 1, 10, largeArray.length - 1};
        for (int i = 0; i < probeOffsets.length; ++i) {
            largeArray[probeOffsets[i]] = (byte)random.nextInt();
        }
        Message message = Message.create();
        message.setByteArrayField(largeArray);
        message.sync();
        long start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from PktPacket doesn't match.", largeArray, Factory.createMessageFromSerializedProtoMessage(message.serialize()).getByteArrayField(), probeOffsets);
        System.out.println("Tested PktPacket in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from byte [] doesn't match.", largeArray, Factory.createMessageFromSerializedProtoMessage(message.serializeToByteArray()).getByteArrayField(), probeOffsets);
        System.out.println("Tested byte [] in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from ByteBuffer doesn't match.", largeArray, Factory.createMessageFromSerializedProtoMessage(message.serializeToByteBuffer()).getByteArrayField(), probeOffsets);
        System.out.println("Tested ByteBuffer in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from proto doesn't match.", largeArray, Factory.createMessageFromProtoMessage(message.serializeToProtobuf()).getByteArrayField(), probeOffsets);
        System.out.println("Tested protobuf in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from json doesn't match.", largeArray, Factory.createMessageFromJson(message.serializeToJson()).getByteArrayField(), probeOffsets);
        System.out.println("Tested json in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from raw json doesn't match.", largeArray, Factory.createMessageFromRawJson(message.serializeToRawJson()).getByteArrayField(), probeOffsets);
        System.out.println("Tested raw json in " + (System.currentTimeMillis() - start) + "ms.");
        start = System.currentTimeMillis();
        AdmGeneratedCodeTest.compareByteArrayValues("Large deserialized array from PktPacket doesn't match.", largeArray, Factory.createMessageFromSerializedProtoMessage(message.serialize()).getByteArrayField(), probeOffsets);
        System.out.println("Tested PktPacket in " + (System.currentTimeMillis() - start) + "ms.");
    }

    static {
        System.setProperty("nv.msg.latency.stats", "true");
        System.getProperties().setProperty("nv.packet.sto.defaultbuffersize", "102400");
        System.getProperties().setProperty("nv.optimizefor", "latency");
        System.getProperties().setProperty("nv.conservecpu", "true");
        Factory factory = new Factory();
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(factory);
        XRuntime.updateProps((Properties)System.getProperties());
    }
}

