/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufReferenceTypeField;

public abstract class XbufVariableLengthField<T>
extends XbufReferenceTypeField<T> {
    protected XbufVariableLengthField(XbufField.Type type, short id, String name) {
        super(type, id, name, false);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        T val = this.getValue();
        if (val == null) {
            throw new InternalError("attempt to sync null variable content!");
        }
        return this.serialize(buffer, offset, val);
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length >= 0) {
            if (this.type.wireType != XbufField.WireType.HASLEN) {
                throw new InternalError("attempt to desync non length delimited field using length >= 0");
            }
            this.container.setValue(this, this.deserialize(buffer, offset, length));
            return length;
        }
        if (this.type.wireType == XbufField.WireType.HASLEN) {
            throw new InternalError("attempt to desync length delimited field using length < 0");
        }
        this.container.setValue(this, this.deserialize(buffer, offset, length));
        return this.varintDesyncLength.value;
    }

    @Override
    protected final int contentLength() {
        return this.serializedLength(this.getValue());
    }

    @Override
    protected final String contentAsString() {
        T val = this.getValue();
        return val != null ? this.toString(val) : "null";
    }

    @Override
    protected final boolean contentClear() {
        return this.container.clearValue(this);
    }

    @Override
    public final void setReferenceValue(T val) {
        this.setValue(val);
    }

    @Override
    public final T getReferenceValue() {
        return this.getValue();
    }

    public final void setValue(T val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (this.type.wireType != XbufField.WireType.HASLEN && val == null) {
            throw new IllegalArgumentException("field value cannot be null");
        }
        this.container.setValue(this, val);
    }

    public final void setValueFrom(XbufVariableLengthField<T> field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final T getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.framed[this.index]) {
            Object val = this.container.fieldValues[this.index];
            if (val == null) {
                val = this.deserialize(this.buffer, this.contentOffset, this.contentLength);
                this.container.setValue(this, val, false);
            }
            return (T)val;
        }
        return (T)this.container.fieldValues[this.index];
    }
}

