/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufBooleanField
extends XbufField {
    private final Value value = new Value();

    private XbufBooleanField(short id, String name, boolean pinned) {
        super(XbufField.Type.BOOLEAN, id, name, pinned);
    }

    public static XbufBooleanField create(short id, String name, boolean pinned) {
        return new XbufBooleanField(id, name, pinned);
    }

    public static final byte toByte(boolean val) {
        return (byte)(val ? 1 : 0);
    }

    public static final boolean fromByte(byte val) {
        return val > 0;
    }

    private final void serialize(PktBuffer buffer, int offset, boolean val) {
        buffer.put(offset, XbufBooleanField.toByte(val));
    }

    private final boolean deserialize(PktBuffer buffer, int offset) {
        return XbufBooleanField.fromByte(buffer.get(offset));
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        this.serialize(buffer, offset, this.getValue());
        return 1;
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length != 1) {
            throw new InternalError("request to deserialize boolean with length != 1 (length=" + length + ")");
        }
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return 1;
    }

    @Override
    protected final int contentLength() {
        return 1;
    }

    @Override
    protected final String contentAsString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, false);
            return true;
        }
        this.value.val = false;
        return this.container.clearValue(this);
    }

    public final void setValue(boolean val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, val);
        } else {
            this.value.val = val;
            this.container.setValue(this, this.value);
        }
    }

    public final void setValueFrom(XbufBooleanField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final boolean getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.pinned || this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : false;
    }

    private final class Value {
        boolean val;

        private Value() {
        }
    }
}

