/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmPooledString;
import com.neeve.adm.AdmXMLParser;
import com.neeve.adm.EAdmException;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AdmTool {
    private final InteractiveTool tool = new InteractiveTool("ADM Interactive Tool", null, ManifestProductInfo.loadProductInfo((String)"nvx-rumi-adm"));

    private AdmTool() throws Exception {
        this.tool.registerAnnotatedCommands((Object)this);
    }

    private final void run() throws Exception {
        Thread.currentThread().setName("X-AdmTool");
        this.tool.run();
    }

    public static void main(String[] args) {
        try {
            new AdmTool().run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @AnnotatedCommand.Command(keywords={"convert"}, hidden=true, description="Converts a model to different model version")
    public class ModelConvert
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=116, longForm="targetVersion", validOptions={"1.8"}, required=true, description="The target version to convert to")
        String targetVersion = null;
        @AnnotatedCommand.Argument(name="input", position=0, description="The model to convert or directory containing models to convert")
        File source = null;
        @AnnotatedCommand.Argument(name="output", position=1, description="The target model file or target directory to write the converted models")
        File target = null;

        public void execute() throws Exception {
            if (this.source.isDirectory()) {
                if (this.target.isFile()) {
                    throw new IllegalArgumentException("Output must be a directory if input is a directory: " + this.target);
                }
                for (File sourceFile : this.source.listFiles()) {
                    if (!sourceFile.getName().endsWith(".xml")) continue;
                    this.convertModel(sourceFile, new File(this.target, sourceFile.getName()), this.targetVersion);
                }
            } else if (this.target.isDirectory()) {
                this.convertModel(this.source, new File(this.target, this.source.getName()), this.targetVersion);
            } else {
                this.convertModel(this.source, this.target, this.targetVersion);
            }
        }

        private void convertModel(File input, File output, String targetVersion) throws EAdmException, IOException {
            AdmModel model = AdmXMLParser.parse(input);
            if (!targetVersion.equals("1.8")) {
                throw new IllegalArgumentException("Unsupported target version: " + targetVersion);
            }
            this.writeModelTo18(model, output);
        }

        public void writeModelTo18(AdmModel model, File target) throws IOException {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(target)));
            pw.println("<?xml version=\"1.0\"?>");
            pw.println("<model xmlns=\"http://www.neeveresearch.com\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" namespace=\"" + model.getNamespace() + "\">");
            Document document = model.getModelDocument();
            NodeList imports = document.getElementsByTagName("import");
            for (int i = 0; i < imports.getLength(); ++i) {
                Element element = (Element)imports.item(i);
                pw.println("    <import model=\"" + element.getAttributes().getNamedItem("model").getNodeValue() + "\"/>");
            }
            pw.println("  <factories>");
            for (AdmFactory admFactory : model.getFactories()) {
                pw.println("    <factory name=\"" + admFactory.getName() + "\" id=\"" + admFactory.getId() + "\"/>");
            }
            pw.println("  </factories>");
            pw.println("  <enumerations>");
            for (AdmEnumeration admEnumeration : model.getEnumerations()) {
                pw.println("    <enum name=\"" + admEnumeration.getName() + "\" type=\"" + AdmEnumeration.CodeType.toIDLEnumType(admEnumeration.getCodeType()) + "\">");
                Iterator<AdmEnumeration.ConstEntry> consts = admEnumeration.constIterator();
                while (consts.hasNext()) {
                    AdmEnumeration.ConstEntry c = consts.next();
                    if (c.code != null) {
                        pw.println("      <const name=\"" + c.name + "\" value=\"" + c.code + "\"/>");
                        continue;
                    }
                    pw.println("      <const name=\"" + c.name + "\" value=\"" + c.value + "\"/>");
                }
                pw.println("    </enum>");
            }
            pw.println("  </enumerations>");
            pw.println("  <messages>");
            for (AdmMessage admMessage : model.getMessages()) {
                pw.println("    <message name=\"" + admMessage.getName() + "\" factoryid=\"" + admMessage.getFactory().getId() + "\" id=\"" + admMessage.getId() + "\">");
                for (AdmField f : admMessage.fields().values()) {
                    if (model.getPooledString(f.getType().getFullName()) != null || f.getType() instanceof AdmPooledString) {
                        pw.println("      <field name=\"" + f.getName() + "\" type=\"String\" id=\"" + f.getId() + "\"/>");
                        continue;
                    }
                    pw.println("      <field name=\"" + f.getName() + "\" type=\"" + f.getType().getQualifiedName(model) + "\" id=\"" + f.getId() + "\"/>");
                }
                pw.println("    </message>");
            }
            pw.println("  </messages>");
            pw.println("  <entities>");
            for (AdmEntity admEntity : model.getEntities()) {
                pw.println("    <entity name=\"" + admEntity.getName() + "\" factoryid=\"" + admEntity.getFactory().getId() + "\" id=\"" + admEntity.getId() + "\"" + (admEntity.isEmbedded() ? " asField=\"true\"" : "") + ">");
                for (AdmField f : admEntity.fields().values()) {
                    if (model.getPooledString(f.getType().getFullName()) != null || f.getType() instanceof AdmPooledString) {
                        pw.println("      <field name=\"" + f.getName() + "\" type=\"String\" id=\"" + f.getId() + "\"/>");
                        continue;
                    }
                    pw.println("      <field name=\"" + f.getName() + "\" type=\"" + f.getType().getQualifiedName(model) + "\" id=\"" + f.getId() + "\"/>");
                }
                pw.println("    </entity>");
            }
            pw.println("  </entities>");
            pw.println("  <collections>");
            for (AdmCollection admCollection : model.getCollections()) {
                pw.println("    <collection name=\"" + admCollection.getName() + "\" is=\"" + admCollection.getType().name() + "\" of=\"" + admCollection.getContains().getQualifiedName(model) + "\"factoryid=\"" + admCollection.getFactory().getId() + "\" + id=\"" + admCollection.getId() + "\"/>");
            }
            pw.println("  </collections>");
            pw.println("</model>");
            pw.flush();
            pw.close();
        }
    }
}

