/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmObject;
import com.neeve.adm.EAdmException;
import java.io.File;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class AdmXMLWriter
extends AdmObject {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeModel(AdmModel model, File file) throws EAdmException {
        if (model == null) {
            throw new IllegalArgumentException("'model' cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("'file' cannot be null");
        }
        Document document = model.getModelDocument();
        if (document == null) {
            throw new IllegalArgumentException("Missing XML Document. Only models loaded from XML can be persisted to XML");
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            try (FileOutputStream os = new FileOutputStream(file);){
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
            }
        }
        catch (Exception ex) {
            throw new EAdmException("Unable to persist model " + model.getFullName(), ex);
        }
    }

    public static void writeModelToDir(AdmModel model, File dir) throws EAdmException {
        if (model == null) {
            throw new IllegalArgumentException("'model' cannot be null");
        }
        if (dir == null) {
            throw new IllegalArgumentException("'dir' cannot be null");
        }
        if (!dir.exists() || !dir.isDirectory()) {
            throw new EAdmException("Path does not exist or is not a directory: " + dir.getName());
        }
        File modelDir = new File(dir, model.getNamespace().replace(".", File.separator));
        modelDir.mkdirs();
        File modelFile = new File(dir, model.getFullName(true).replace('.', File.separatorChar) + ".xml");
        AdmXMLWriter.writeModel(model, modelFile);
    }
}

