/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.mapdb.AsyncWriteEngine;
import org.mapdb.BTreeMap;
import org.mapdb.Caches;
import org.mapdb.DB;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Fun;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.StoreAppend;
import org.mapdb.StoreDirect;
import org.mapdb.StoreHeap;
import org.mapdb.StoreWAL;
import org.mapdb.TxEngine;
import org.mapdb.TxMaker;
import org.mapdb.Volume;

public class DBMaker<DBMakerT extends DBMaker<DBMakerT>> {
    protected final String TRUE = "true";
    protected Properties props = new Properties();

    protected DBMaker() {
    }

    protected DBMaker(File file) {
        this.props.setProperty("file", file.getPath());
    }

    public static DBMaker newHeapDB() {
        return new DBMaker()._newHeapDB();
    }

    public DBMakerT _newHeapDB() {
        this.props.setProperty("store", "heap");
        return this.getThis();
    }

    public static DBMaker newMemoryDB() {
        return new DBMaker()._newMemoryDB();
    }

    public DBMakerT _newMemoryDB() {
        this.props.setProperty("volume", "byteBuffer");
        return this.getThis();
    }

    public static DBMaker newMemoryDirectDB() {
        return new DBMaker()._newMemoryDirectDB();
    }

    public DBMakerT _newMemoryDirectDB() {
        this.props.setProperty("volume", "directByteBuffer");
        return this.getThis();
    }

    protected static DBMaker newAppendFileDB(File file) {
        return new DBMaker()._newAppendFileDB(file);
    }

    protected DBMakerT _newAppendFileDB(File file) {
        this.props.setProperty("file", file.getPath());
        this.props.setProperty("store", "append");
        return this.getThis();
    }

    public static <K, V> BTreeMap<K, V> newTempTreeMap() {
        return ((DBMaker)((DBMaker)((DBMaker)DBMaker.newTempFileDB().deleteFilesAfterClose()).closeOnJvmShutdown()).transactionDisable()).make().getTreeMap("temp");
    }

    public static <K, V> HTreeMap<K, V> newTempHashMap() {
        return ((DBMaker)((DBMaker)((DBMaker)DBMaker.newTempFileDB().deleteFilesAfterClose()).closeOnJvmShutdown()).transactionDisable()).make().getHashMap("temp");
    }

    public static <K> NavigableSet<K> newTempTreeSet() {
        return ((DBMaker)((DBMaker)((DBMaker)DBMaker.newTempFileDB().deleteFilesAfterClose()).closeOnJvmShutdown()).transactionDisable()).make().getTreeSet("temp");
    }

    public static <K> Set<K> newTempHashSet() {
        return ((DBMaker)((DBMaker)((DBMaker)DBMaker.newTempFileDB().deleteFilesAfterClose()).closeOnJvmShutdown()).transactionDisable()).make().getHashSet("temp");
    }

    public static DBMaker newTempFileDB() {
        try {
            return DBMaker.newFileDB(File.createTempFile("mapdb-temp", "db"));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static <K, V> HTreeMap<K, V> newCacheDirect(double size) {
        return ((DBMaker)DBMaker.newMemoryDirectDB().transactionDisable()).make().createHashMap("cache").expireStoreSize(size).counterEnable().make();
    }

    public static <K, V> HTreeMap<K, V> newCache(double size) {
        return ((DBMaker)DBMaker.newMemoryDB().transactionDisable()).make().createHashMap("cache").expireStoreSize(size).counterEnable().make();
    }

    public static DBMaker newFileDB(File file) {
        return new DBMaker(file);
    }

    public DBMakerT _newFileDB(File file) {
        this.props.setProperty("file", file.getPath());
        return this.getThis();
    }

    protected DBMakerT getThis() {
        return (DBMakerT)this;
    }

    public DBMakerT transactionDisable() {
        this.props.put("transactionDisable", "true");
        return this.getThis();
    }

    public DBMakerT cacheDisable() {
        this.props.put("cache", "disable");
        return this.getThis();
    }

    public DBMakerT cacheHardRefEnable() {
        this.props.put("cache", "hardRef");
        return this.getThis();
    }

    public DBMakerT cacheWeakRefEnable() {
        this.props.put("cache", "weakRef");
        return this.getThis();
    }

    public DBMakerT cacheSoftRefEnable() {
        this.props.put("cache", "softRef");
        return this.getThis();
    }

    public DBMakerT cacheLRUEnable() {
        this.props.put("cache", "lru");
        return this.getThis();
    }

    public DBMakerT mmapFileEnable() {
        this.assertNotInMemoryVolume();
        this.props.setProperty("volume", "mmapf");
        return this.getThis();
    }

    public DBMakerT mmapFileEnablePartial() {
        this.assertNotInMemoryVolume();
        this.props.setProperty("volume", "mmapfPartial");
        return this.getThis();
    }

    private void assertNotInMemoryVolume() {
        if ("byteBuffer".equals(this.props.getProperty("volume")) || "directByteBuffer".equals(this.props.getProperty("volume"))) {
            throw new IllegalArgumentException("Can not enable mmap file for in-memory store");
        }
    }

    public DBMakerT mmapFileEnableIfSupported() {
        this.assertNotInMemoryVolume();
        this.props.setProperty("volume", "mmapfIfSupported");
        return this.getThis();
    }

    public DBMakerT cacheSize(int cacheSize) {
        this.props.setProperty("cacheSize", "" + cacheSize);
        return this.getThis();
    }

    public DBMakerT snapshotEnable() {
        this.props.setProperty("snapshots", "true");
        return this.getThis();
    }

    public DBMakerT asyncWriteEnable() {
        this.props.setProperty("asyncWrite", "true");
        return this.getThis();
    }

    public DBMakerT asyncWriteFlushDelay(int delay) {
        this.props.setProperty("asyncWriteFlushDelay", "" + delay);
        return this.getThis();
    }

    public DBMakerT asyncWriteQueueSize(int queueSize) {
        this.props.setProperty("asyncWriteQueueSize", "" + queueSize);
        return this.getThis();
    }

    public DBMakerT deleteFilesAfterClose() {
        this.props.setProperty("deleteFilesAfterClose", "true");
        return this.getThis();
    }

    public DBMakerT closeOnJvmShutdown() {
        this.props.setProperty("closeOnJvmShutdown", "true");
        return this.getThis();
    }

    public DBMakerT compressionEnable() {
        this.props.setProperty("compression", "lzf");
        return this.getThis();
    }

    public DBMakerT encryptionEnable(String password) {
        return this.encryptionEnable(password.getBytes(Charset.forName("UTF8")));
    }

    public DBMakerT encryptionEnable(byte[] password) {
        this.props.setProperty("encryption", "xtea");
        this.props.setProperty("encryptionKey", DBMaker.toHexa(password));
        return this.getThis();
    }

    public DBMakerT checksumEnable() {
        this.props.setProperty("checksum", "true");
        return this.getThis();
    }

    public DBMakerT strictDBGet() {
        this.props.setProperty("strictDBGet", "true");
        return this.getThis();
    }

    public DBMakerT readOnly() {
        this.props.setProperty("readOnly", "true");
        return this.getThis();
    }

    public DBMakerT freeSpaceReclaimQ(int q) {
        if (q < 0 || q > 10) {
            throw new IllegalArgumentException("wrong Q");
        }
        this.props.setProperty("freeSpaceReclaimQ", "" + q);
        return this.getThis();
    }

    public DBMakerT commitFileSyncDisable() {
        this.props.setProperty("commitFileSyncDisable", "true");
        return this.getThis();
    }

    public DBMakerT sizeLimit(double maxSize) {
        long size = (long)(maxSize * 1024.0 * 1024.0 * 1024.0);
        this.props.setProperty("sizeLimit", "" + size);
        return this.getThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB make() {
        boolean strictGet = this.propsGetBool("strictDBGet");
        Engine engine = this.makeEngine();
        boolean dbCreated = false;
        try {
            DB db = new DB(engine, strictGet, false);
            dbCreated = true;
            DB dB = db;
            return dB;
        }
        finally {
            if (!dbCreated) {
                engine.close();
            }
        }
    }

    public TxMaker makeTxMaker() {
        this.props.setProperty("fullTx", "true");
        this.snapshotEnable();
        Engine e = this.makeEngine();
        DB db = new DB(e);
        db.commit();
        return new TxMaker(e, this.propsGetBool("strictDBGet"), this.propsGetBool("snapshots"));
    }

    public Engine makeEngine() {
        String cache;
        Engine engine;
        boolean readOnly = this.propsGetBool("readOnly");
        File file = this.props.containsKey("file") ? new File(this.props.getProperty("file")) : null;
        String volume = this.props.getProperty("volume");
        String store = this.props.getProperty("store");
        if (readOnly && file == null) {
            throw new UnsupportedOperationException("Can not open in-memory DB in read-only mode.");
        }
        if (readOnly && !file.exists() && !"append".equals(store)) {
            throw new UnsupportedOperationException("Can not open non-existing file in read-only mode.");
        }
        if (this.propsGetLong("sizeLimit", 0L) > 0L && "append".equals(store)) {
            throw new UnsupportedOperationException("Append-Only store does not support Size Limit");
        }
        this.extendArgumentCheck();
        if ("heap".equals(store)) {
            engine = this.extendHeapStore();
        } else if ("append".equals(store)) {
            if ("byteBuffer".equals(volume) || "directByteBuffer".equals(volume)) {
                throw new UnsupportedOperationException("Append Storage format is not supported with in-memory dbs");
            }
            engine = this.extendStoreAppend();
        } else {
            Volume.Factory folFac = this.extendStoreVolumeFactory();
            engine = this.propsGetBool("transactionDisable") ? this.extendStoreDirect(folFac) : this.extendStoreWAL(folFac);
        }
        engine = this.extendWrapStore(engine);
        if (this.propsGetBool("asyncWrite") && !readOnly) {
            engine = this.extendAsyncWriteEngine(engine);
        }
        if (!"disable".equals(cache = this.props.getProperty("cache", "hashTable"))) {
            if ("hashTable".equals(cache)) {
                engine = this.extendCacheHashTable(engine);
            } else if ("hardRef".equals(cache)) {
                engine = this.extendCacheHardRef(engine);
            } else if ("weakRef".equals(cache)) {
                engine = this.extendCacheWeakRef(engine);
            } else if ("softRef".equals(cache)) {
                engine = this.extendCacheSoftRef(engine);
            } else if ("lru".equals(cache)) {
                engine = this.extendCacheLRU(engine);
            } else {
                throw new IllegalArgumentException("unknown cache type: " + cache);
            }
        }
        engine = this.extendWrapCache(engine);
        if (this.propsGetBool("snapshots")) {
            engine = this.extendSnapshotEngine(engine);
        }
        engine = this.extendWrapSnapshotEngine(engine);
        if (readOnly) {
            engine = new EngineWrapper.ReadOnlyEngine(engine);
        }
        if (this.propsGetBool("closeOnJvmShutdown")) {
            engine = new EngineWrapper.CloseOnJVMShutdown(engine);
        }
        Fun.Tuple2<Integer, byte[]> check = null;
        try {
            check = (Fun.Tuple2<Integer, byte[]>)engine.get(3L, Serializer.BASIC);
            if (check != null && (Integer)check.a != Arrays.hashCode((byte[])check.b)) {
                throw new RuntimeException("invalid checksum");
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Error while opening store. Make sure you have right password, compression or encryption is well configured.", e);
        }
        if (check == null && !engine.isReadOnly()) {
            byte[] b = new byte[127];
            new Random().nextBytes(b);
            check = Fun.t2(Arrays.hashCode(b), b);
            engine.update(3L, check, Serializer.BASIC);
            engine.commit();
        }
        return engine;
    }

    protected int propsGetInt(String key, int defValue) {
        String ret = this.props.getProperty(key);
        if (ret == null) {
            return defValue;
        }
        return Integer.valueOf(ret);
    }

    protected long propsGetLong(String key, long defValue) {
        String ret = this.props.getProperty(key);
        if (ret == null) {
            return defValue;
        }
        return Long.valueOf(ret);
    }

    protected boolean propsGetBool(String key) {
        String ret = this.props.getProperty(key);
        return ret != null && ret.equals("true");
    }

    protected byte[] propsGetXteaEncKey() {
        if (!"xtea".equals(this.props.getProperty("encryption"))) {
            return null;
        }
        return DBMaker.fromHexa(this.props.getProperty("encryptionKey"));
    }

    protected static boolean JVMSupportsLargeMappedFiles() {
        String prop = System.getProperty("os.arch");
        return prop != null && prop.contains("64");
    }

    protected int propsGetRafMode() {
        String volume = this.props.getProperty("volume");
        if (volume == null || "raf".equals(volume)) {
            return 2;
        }
        if ("mmapfIfSupported".equals(volume)) {
            return DBMaker.JVMSupportsLargeMappedFiles() ? 0 : 2;
        }
        if ("mmapfPartial".equals(volume)) {
            return 1;
        }
        if ("mmapf".equals(volume)) {
            return 0;
        }
        return 2;
    }

    protected Engine extendSnapshotEngine(Engine engine) {
        return new TxEngine(engine, this.propsGetBool("fullTx"));
    }

    protected Engine extendCacheLRU(Engine engine) {
        int cacheSize = this.propsGetInt("cacheSize", 32768);
        return new Caches.LRU(engine, cacheSize, false);
    }

    protected Engine extendCacheWeakRef(Engine engine) {
        return new Caches.WeakSoftRef(engine, true, false);
    }

    protected Engine extendCacheSoftRef(Engine engine) {
        return new Caches.WeakSoftRef(engine, false, false);
    }

    protected Engine extendCacheHardRef(Engine engine) {
        int cacheSize = this.propsGetInt("cacheSize", 32768);
        return new Caches.HardRef(engine, cacheSize, false);
    }

    protected Engine extendCacheHashTable(Engine engine) {
        int cacheSize = this.propsGetInt("cacheSize", 32768);
        return new Caches.HashTable(engine, cacheSize, false);
    }

    protected Engine extendAsyncWriteEngine(Engine engine) {
        return new AsyncWriteEngine(engine, this.propsGetInt("asyncWriteFlushDelay", 100), this.propsGetInt("asyncWriteQueueSize", 32000), null);
    }

    protected void extendArgumentCheck() {
    }

    protected Engine extendWrapStore(Engine engine) {
        return engine;
    }

    protected Engine extendWrapCache(Engine engine) {
        return engine;
    }

    protected Engine extendWrapSnapshotEngine(Engine engine) {
        return engine;
    }

    protected Engine extendHeapStore() {
        return new StoreHeap();
    }

    protected Engine extendStoreAppend() {
        File file = this.props.containsKey("file") ? new File(this.props.getProperty("file")) : null;
        boolean compressionEnabled = "lzf".equals(this.props.getProperty("compression"));
        return new StoreAppend(file, this.propsGetRafMode() > 0, this.propsGetBool("readOnly"), this.propsGetBool("transactionDisable"), this.propsGetBool("deleteFilesAfterClose"), this.propsGetBool("commitFileSyncDisable"), this.propsGetBool("checksum"), compressionEnabled, this.propsGetXteaEncKey(), false);
    }

    protected Engine extendStoreDirect(Volume.Factory folFac) {
        boolean compressionEnabled = "lzf".equals(this.props.getProperty("compression"));
        return new StoreDirect(folFac, this.propsGetBool("readOnly"), this.propsGetBool("deleteFilesAfterClose"), this.propsGetInt("freeSpaceReclaimQ", 5), this.propsGetBool("commitFileSyncDisable"), this.propsGetLong("sizeLimit", 0L), this.propsGetBool("checksum"), compressionEnabled, this.propsGetXteaEncKey(), false, 0);
    }

    protected Engine extendStoreWAL(Volume.Factory folFac) {
        boolean compressionEnabled = "lzf".equals(this.props.getProperty("compression"));
        return new StoreWAL(folFac, this.propsGetBool("readOnly"), this.propsGetBool("deleteFilesAfterClose"), this.propsGetInt("freeSpaceReclaimQ", 5), this.propsGetBool("commitFileSyncDisable"), this.propsGetLong("sizeLimit", -1L), this.propsGetBool("checksum"), compressionEnabled, this.propsGetXteaEncKey(), false, 0);
    }

    protected Volume.Factory extendStoreVolumeFactory() {
        long sizeLimit = this.propsGetLong("sizeLimit", 0L);
        String volume = this.props.getProperty("volume");
        if ("byteBuffer".equals(volume)) {
            return Volume.memoryFactory(false, sizeLimit, 20);
        }
        if ("directByteBuffer".equals(volume)) {
            return Volume.memoryFactory(true, sizeLimit, 20);
        }
        File indexFile = new File(this.props.getProperty("file"));
        File dataFile = new File(indexFile.getPath() + ".p");
        File logFile = new File(indexFile.getPath() + ".t");
        return Volume.fileFactory(indexFile, this.propsGetRafMode(), this.propsGetBool("readOnly"), sizeLimit, 20, 0, dataFile, logFile, this.propsGetBool("asyncWrite"));
    }

    protected static String toHexa(byte[] bb) {
        char[] HEXA_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] ret = new char[bb.length * 2];
        for (int i = 0; i < bb.length; ++i) {
            ret[i * 2] = HEXA_CHARS[(bb[i] & 0xF0) >> 4];
            ret[i * 2 + 1] = HEXA_CHARS[bb[i] & 0xF];
        }
        return new String(ret);
    }

    protected static byte[] fromHexa(String s) {
        byte[] ret = new byte[s.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return ret;
    }

    protected static interface Keys {
        public static final String cache = "cache";
        public static final String cacheSize = "cacheSize";
        public static final String cache_disable = "disable";
        public static final String cache_hashTable = "hashTable";
        public static final String cache_hardRef = "hardRef";
        public static final String cache_softRef = "softRef";
        public static final String cache_weakRef = "weakRef";
        public static final String cache_lru = "lru";
        public static final String file = "file";
        public static final String volume = "volume";
        public static final String volume_raf = "raf";
        public static final String volume_mmapfPartial = "mmapfPartial";
        public static final String volume_mmapfIfSupported = "mmapfIfSupported";
        public static final String volume_mmapf = "mmapf";
        public static final String volume_byteBuffer = "byteBuffer";
        public static final String volume_directByteBuffer = "directByteBuffer";
        public static final String store = "store";
        public static final String store_direct = "direct";
        public static final String store_wal = "wal";
        public static final String store_append = "append";
        public static final String store_heap = "heap";
        public static final String transactionDisable = "transactionDisable";
        public static final String asyncWrite = "asyncWrite";
        public static final String asyncWriteFlushDelay = "asyncWriteFlushDelay";
        public static final String asyncWriteQueueSize = "asyncWriteQueueSize";
        public static final String deleteFilesAfterClose = "deleteFilesAfterClose";
        public static final String closeOnJvmShutdown = "closeOnJvmShutdown";
        public static final String readOnly = "readOnly";
        public static final String compression = "compression";
        public static final String compression_lzf = "lzf";
        public static final String encryptionKey = "encryptionKey";
        public static final String encryption = "encryption";
        public static final String encryption_xtea = "xtea";
        public static final String checksum = "checksum";
        public static final String freeSpaceReclaimQ = "freeSpaceReclaimQ";
        public static final String commitFileSyncDisable = "commitFileSyncDisable";
        public static final String snapshots = "snapshots";
        public static final String strictDBGet = "strictDBGet";
        public static final String sizeLimit = "sizeLimit";
        public static final String fullTx = "fullTx";
    }
}

